#!/usr/bin/nawk -f
#
# 1) get commercial-uses files from alcatel ( Xmosiac )
# 2) save as files and cat together
#        cat faq-1 faq-2 faq-2 > faq
# 3) run this script redirecting stdout to name.html
#       commU2html.awk faq > faq.html




BEGIN   { #template = ARGV[1]    #"../<path>/<name>"
          #ARGV[1] = ""

            print "<HTML>\n"
            count = 0 
            defPrt = 1
            fromCnt = 0
        }


# suck out bits of the mail header 

/^Subject:/ { 
                gsub("Subject:[ 	]*FAQ:[ 	]*comp.lang.tcl ","")
                print  "<TITLE>" $0 "</TITLE>\n"
                print "<H1>" 
                print "  " $0 
                print "</H1>"
            }

/^ *Approved:/ {
                print "<PRE>"
                print maintainer
                print $0
                next
            } 

/^From:/    {
                if ( fromCnt == 0 )   # Maintainer From: field
                {
                    gsub("From:[ 	]","Faq Maintainer: ")
                    maintainer = $0
                # add parsing to make email hyper link 
                
                fromCnt++
                }
            }


/^From:[ 	]*-/ {      # Questions and answers 
                printf("<A NAME=\"Question%d\">", fromCnt )
                fromCnt++
                gsub("From:[ 	]*-[^-]*-", "");
                print $0

                print "<H3> "
                inQ = 1

                getline         # pickup Subject: Line 
                gsub("Subject:[ 	]*-Q[^-]*-", "");
                print $0
                next
            }


/^ *Posting-Frequency:/ {
                print $0
                print "</PRE>"
                defPrt = 1
                next
            }        


/Commercial Uses  *-/ {
                print "<H1>"
                print $0
                print "</H1>"
                next
            }

#Underlines
/^\*\**/ { next }
/^======*/ { next }

# empty lines 
/^[ 	]*$/ {
                if ( EHEAD ) {
                    print "</PRE>"
                    EHEAD=0
                }
                    print
                    printf("<P>")
                    next
             }   

/^-------*/ { 
                print "<HR>"
                next
            }


# Headingish things
/^ *Index  *-  *Part/ {
                print "<H2>"
                print $0
                print "</H2>"
                getline
                next
            }

/^ *ENTRY/ {
                print "<H3>"
                print $0
                print "</H3>"
                getline
                getline
                print "<PRE>"
                EHEAD=1
                next
            }


/^ *[PT][0-9][0-9]*\./ {
            $1=""
            print "<LI>" $0
            next
            }

# the leading 0. 
/^ *0\./ {
            $1=""
            print "<LI>" $0
            next
            }




# ascii bullet list 
/^  *o / {
            $1=""
            print "<LI>" $0
            next
            }


# Otherwise just print it */
defPrt == 1     { print $0 }

END     {   if ( state == 1 ) 
            {
                count++
                print "    </A>"
            }
        }



