# ============================================================================
# Resource related Procs.
# Procs in this file are based on Tk FAQs.
# ============================================================================
# envVal envValName
#  Return value of Enviromnent variable 'envValName', or return nil string.
proc envVal {envValName} {
  global env
  if [info exists env($envValName)] {return $env($envValName)} {return {}}
}

# loadAppDefaults className ?priority?
#   Searches for the app-default files corresponding to className in
#   the order specified by X Toolkit Intrinsics (R5), and loads them with
#   the priority specified (default: startupFile).
proc loadAppDefaults {className {priority startupFile}} {
    set filepath "\
	    /home/usrs1/taguchi/lib/X11/app-defaults \
	    [split [envVal XFILESEARCHPATH] :] \
	    [split [envVal XAPPLRESDIR] :] \
	    [split [envVal XUSERFILESEARCHPATH] :] \
	    "
    foreach i $filepath {
	if {[file exists $i/$className]} {
	    option readfile $i/$className $priority;
	}
    }   
}
