# ======================================================================
# print.tcl
# ======================================================================

proc print:create {maped w {title {Print...}}} {
    upvar #0 $maped data

    # 0) Global Resource definition
    option add *[string trimleft $w*Frame.relief .] raised widgetDefault
    option add *[string trimleft $w*Frame.borderWidth .] 1 widgetDefault
    option add *[string trimleft $w*Label.anchor .] w widgetDefault
    option add *[string trimleft $w*Label.width .] 18 widgetDefault
    option add *[string trimleft $w*Entry.relief .] sunken widgetDefault
    option add *[string trimleft $w*Entry.borderWidth .] 2 widgetDefault

    toplevel $w -class Dialog
    wm title $w $title
    wm iconname $w $title

    option add *[string trimleft $w.top.relief .] raised widgetDefault
    option add *[string trimleft $w.mid.relief .] raised widgetDefault
    option add *[string trimleft $w.bottom.relief .] raised widgetDefault
    frame $w.top
    frame $w.mid
    frame $w.bottom
    pack $w.top $w.mid $w.bottom -side top -fill both -expand true

    frame $w.top.dist
    frame $w.top.cmd
    frame $w.top.file
    pack $w.top.dist $w.top.cmd $w.top.file -side top -fill both -expand true
    
    option add *[string trimleft $w.top.dist.label.text .] \
	    {Print to:} widgetDefault
    label $w.top.dist.label;
    option add *[string trimleft $w.top.dist.prt.text .] \
	    {Printer} widgetDefault
    option add *[string trimleft $w.top.dist.file.text .] \
	    {File} widgetDefault
    radiobutton $w.top.dist.prt -variable [subst $maped](PS.Distination) \
	    -value {printer} -command [list focus $w.top.cmd.entry]
    radiobutton $w.top.dist.file -variable [subst $maped](PS.Distination) \
	    -value {file} -command [list focus $w.top.file.entry]
    pack $w.top.dist.label -side left
    pack $w.top.dist.prt $w.top.dist.file -side left -fill x
    
    option add *[string trimleft $w.top.cmd.label.text .] \
	    {Print Command:} widgetDefault
    label $w.top.cmd.label
    entry $w.top.cmd.entry -textvariable [subst $maped](PS.cmdStr)
    pack $w.top.cmd.label -side left
    pack $w.top.cmd.entry -side left -fill x

    option add *[string trimleft $w.top.file.label.text .] \
	    {File Name:} widgetDefault
    option add *[string trimleft $w.top.file.button.text .] \
	    {Browse...} widgetDefault
    label $w.top.file.label
    entry $w.top.file.entry -textvariable [subst $maped](PS.PostScript)
    button $w.top.file.button -command \
	    [list print:browse $maped $w.top.file.entry]
    pack $w.top.file.label -side left
    pack $w.top.file.entry -side left -fill x
    pack $w.top.file.button -side left

    frame $w.mid.orientation
    frame $w.mid.color
    frame $w.mid.pagesize
    frame $w.mid.pageanchor
    frame $w.mid.font
    pack $w.mid.orientation $w.mid.color $w.mid.pagesize $w.mid.pageanchor \
	    $w.mid.font -side top -fill both -expand true

    option add *[string trimleft $w.mid.orientation.label.text .] \
	    Orientation: widgetDefault
    option add *[string trimleft $w.mid.orientation.portrait.text .] \
	    Portrait widgetDefault
    option add *[string trimleft $w.mid.orientation.landscape.text .] \
	    Landscape widgetDefault
    label $w.mid.orientation.label
    radiobutton $w.mid.orientation.portrait \
	    -variable [subst $maped](PS.Orientation) -value portrait
    radiobutton $w.mid.orientation.landscape \
	    -variable [subst $maped](PS.Orientation) -value landscape
    pack $w.mid.orientation.label -side left
    pack $w.mid.orientation.portrait $w.mid.orientation.landscape \
	    -side left -fill x

    option add *[string trimleft $w.mid.color.label.text .] \
	    Color: widgetDefault
    option add *[string trimleft $w.mid.color.mono.text .] \
	    Mono widgetDefault
    option add *[string trimleft $w.mid.color.greyscale.text .] \
	    Greyscale widgetDefault
    option add *[string trimleft $w.mid.color.color.text .] \
	    Color widgetDefault
    label $w.mid.color.label
    radiobutton $w.mid.color.mono \
	    -variable [subst $maped](PS.Color) -value mono
    radiobutton $w.mid.color.greyscale \
	    -variable [subst $maped](PS.Color) -value greyscale
    radiobutton $w.mid.color.color \
	    -variable [subst $maped](PS.Color) -value color
    pack $w.mid.color.label -side left
    pack $w.mid.color.mono $w.mid.color.greyscale $w.mid.color.color \
	    -side left -fill x

    option add *[string trimleft $w.mid.pagesize.label.text .] \
	    Pagesize: widgetDefault
    option add *[string trimleft $w.mid.pagesize.b.r.letter.text .] \
	    {Letter (8.5x11in)} widgetDefault
    option add *[string trimleft $w.mid.pagesize.b.r.legal.text .] \
	    {Legal (8.5x14in)} widgetDefault
    option add *[string trimleft $w.mid.pagesize.b.l.figure.text .] \
	    {PS Figure} widgetDefault
    option add *[string trimleft $w.mid.pagesize.b.l.a4.text .] \
	    {A4 (210x297mm)} widgetDefault
    option add *[string trimleft $w.mid.pagesize*Frame.relief .] \
	    flat widgetDefault
    label $w.mid.pagesize.label
    frame $w.mid.pagesize.b
    frame $w.mid.pagesize.b.r
    frame $w.mid.pagesize.b.l
    radiobutton $w.mid.pagesize.b.r.letter \
	    -variable [subst $maped](PS.Size) -value letter
    radiobutton $w.mid.pagesize.b.r.legal \
	    -variable [subst $maped](PS.Size) -value legal
    radiobutton $w.mid.pagesize.b.l.figure \
	    -variable [subst $maped](PS.Size) -value figure
    radiobutton $w.mid.pagesize.b.l.a4 \
	    -variable [subst $maped](PS.Size) -value a4
    pack $w.mid.pagesize.label -side left
    pack $w.mid.pagesize.b -side left -fill both -expand true
    pack $w.mid.pagesize.b.l $w.mid.pagesize.b.r \
	    -side left -fill both -expand true
    pack $w.mid.pagesize.b.r.letter -side top -anchor w
    pack $w.mid.pagesize.b.r.legal -side top -anchor w
    pack $w.mid.pagesize.b.l.figure -side top -anchor w
    pack $w.mid.pagesize.b.l.a4 -side top -anchor w

    option add *[string trimleft $w.bottom.fr1.ok.text .] Print widgetDefault
    option add *[string trimleft $w.bottom.Frame.relief .] flat widgetDefault
    frame $w.bottom.fr1
    button $w.bottom.fr1.ok  -command [list canvas:doPrint]
    option add *[string trimleft $w.bottom.fr2.cancel.text .] \
	    Dismiss widgetDefault
    frame $w.bottom.fr2
    button $w.bottom.fr2.cancel -command [list destroy $w]
    pack $w.bottom.fr1.ok $w.bottom.fr2.cancel \
	    -padx 2m -pady 1m -ipadx 1m -ipady 1m
    pack $w.bottom.fr1 $w.bottom.fr2 -side left -expand true

    proc print:browse {maped e} {
	upvar #0 $maped data
	if {[set file [FileSelectionBox $maped .fs {} {PostScript File}]] != \
		{}} {
	    set data(PS.PostScript) $file
	    $e xview moveto [lindex [$e xview] 1]
	}
    }
}
