# ============================================================================
# message.tcl
# one line message widgets for user navigation.
# ============================================================================

# message:create w --
# Args:
#  w - widget name. defaults is .text
# SideEffects:
#  create a message display widget.
# Methods:
#  msg:set bitmap message --- display message.
#    bitmap - is a bitmap name such as @info, @/path/bm.xbm, etc...
#    message - is a text string which will be display.
#  msg:del                --- clear message.
# ##
proc message:create {maped {w .text}} {
    upvar #0 $maped data
    option add *[string trimleft $w*Relief .] {flat} widgetDefault

    label $w.bitmap -padx 0 -pady 0; # label which display bitmap
    label $w.msg -height 1 -anchor w; # lable which display message
    frame $w.pad -height [expr [image height $data(ICON.question)] + \
	    2 * ([$w.bitmap cget -bd] + [$w.bitmap cget -highlightthickness])]
    pack $w.pad $w.bitmap -side left
    pack $w.msg -side left

    # display bitmap and message.
    proc msg:set [list bitmap message \
	    [list maped $maped] [list b $w.bitmap] [list m $w.msg]] {
	upvar #0 $maped data
	$b configure -image $data(ICON.$bitmap)
	$m configure -text $message
	update
    }
    # delete them.
    proc msg:del [list [list b $w.bitmap] [list m $w.msg]] {
	$b configure -image {}
	$m configure -text {}
	update
    }
}
