# ============================================================================
# lineed.tcl
# line editor widget which used for url or alt fields.
# ============================================================================

# lineed:create -- 
# Args -
#  w - parent widget name
#  item - edit item
# SideEfects -
#  (1) set up default resources for line edit windows
#  (2) create and pack them
#  (3) create procs that operate line edit windows.
# Methods -
#  $item:set str --- set str to line edit window.
#  $item:get     --- get contents of line edit window.
#  $item:enable  --- enable window.
#  $item:disable --- disable window.
# ##
proc lineed:create {w item args} {
    # default resources
    option add *[string trimleft $w.label.text .] [subst $item]: widgetDefault
    option add *[string trimleft $w.entry.relief .] {flat} widgetDefault
    option add *[string trimleft $w.entry.borderWidth .] 2 widgetDefault
    option add *[string trimleft $w.entry.highlightThickness .] 0 widgetDefault

    # create widgets ...
    label $w.label
    eval entry $w.entry -state disabled $args

    # and pack them.
    pack $w.label -side left
    pack $w.entry -side right -fill x -expand true

    # $item:set -- display item
    # Args -
    #  str : string which displaied.
    proc $item:set [list str [list w $w.entry]] {
	$w delete 0 end
	$w insert 0 $str
    }
    # $item:get -- return current contents
    proc $item:get [list [list w $w.entry]] {
	return [$w get]
    }
    # $item:enable -- enable edit window
    proc $item:enable [list [list w $w.entry]] {
	$w configure -state normal -relief sunken
    }
    # $item:disable -- disable edit window
    proc $item:disable [list [list w $w.entry]] {
	$w delete 0 end
	$w configure -state disabled -relief flat
    }
}


