# ============================================================================
# icon.tcl
# ============================================================================
# 
# icon:create ---
# args - progName : program name. argv0.
# side effect -
#  1. init following resources
#       *version     (Float)   : versin no.
#       *animateIcon (Boolean) : If True, then use animate icon.
#       *staticIcon  (String)  : Icon path name which used if animateIcon is False.
#       *iconList (StringList) : List of icon path name for animate icon.
proc icon:create {maped progName} {
    upvar #0 $maped data
    wm title . "$progName [option get . version String]"
    set iconPath [option get . defaultIconPath {}]
    option add "*staticIcon" "$iconPath/tkmped.ppm" widgetDefault
    option add "*iconList" [list \
	    $iconPath/earth0.ppm $iconPath/earth1.ppm \
	    $iconPath/earth2.ppm $iconPath/earth3.ppm \
	    $iconPath/earth4.ppm $iconPath/earth5.ppm \
	    $iconPath/earth6.ppm $iconPath/earth7.ppm \
	    $iconPath/earth8.ppm $iconPath/earth9.ppm \
	    $iconPath/earthA.ppm $iconPath/earthB.ppm] widgetDefault
    if {[set bool [option get . animateIcon {}]] == "True" || \
	    $bool == "true" || $bool == 1} {
	msg:set info "Now reading icon files..."
	set imgList {}
	foreach i [option get . iconList StringList] {
	    lappend imgList [image create photo -file $i]
	}
	anicon:setup . .icon $imgList \
		[option get . animateDelay {}] -highlightthickness 0
	msg:del
    } else {
	toplevel .icon
	label .icon.label -image [image create photo -file \
		[option get . $staticIcon String]]
	pack .icon.label
	wm iconwindow . .icon.label
    }
}    

