
# unix/Common.mk.in  --
#
# Common macro definitions used by all include files.
#------------------------------------------------------------------------------
# Copyright 1995-1996 Karl Lehenbauer and Mark Diekhans.
#
# Permission to use, copy, modify, and distribute this software and its
# documentation for any purpose and without fee is hereby granted, provided
# that the above copyright notice appear in all copies.  Karl Lehenbauer and
# Mark Diekhans make no representations about the suitability of this
# software for any purpose.  It is provided "as is" without express or
# implied warranty.
#------------------------------------------------------------------------------
# $Id: Common.mk.in,v 6.0 1996/05/10 16:19:37 markd Exp $
#------------------------------------------------------------------------------
#

SHELL = /bin/sh

#------------------------------------------------------------------------------
# TclX version information extracted from tclExtend.h.
#
TCLX_VERSION       = 7.5.1
TCLX_FULL_VERSION  = 7.5.1
TCLX_SHLIB_VERSION = 75.1

TKX_VERSION        = 4.1.1
TKX_FULL_VERSION   = 4.1.1
TKX_SHLIB_VERSION  = 41.1

#------------------------------------------------------------------------------
# Autoconfig defines that can be overridden in Config.mk.
#
CC           = cc
CFLAGS       = 
RANLIB       = ranlib
srcbasedir   = /u/hops/src/tcl/tclX7.5.1
bldbasedir   = /u/hops/src/tcl/tclX7.5.1
prefix       = /usr/local
exec_prefix  = /usr/local
ARCH         = 

#------------------------------------------------------------------------------
# TclX configuration information determined by configure.
#
BUILD_SHARED = YES
TKX_BUILD    = YES
TCLX_DEFS    =  -DSTDC_HEADERS=1 -DRETSIGTYPE=void 
TCLX_LIBS    = 

#------------------------------------------------------------------------------
# Shared library names if BUILD_SHARED is YES.  Base name is the name of
# the library less the version, for dynamic loading.
#
TCLX_SHLIB_BASE_NAME = libtclx.so
TCLX_SHLIB_NAME      = libtclx.so.75.1
TKX_SHLIB_BASE_NAME  = libtkx.so
TKX_SHLIB_NAME       = libtkx.so.41.1

#------------------------------------------------------------------------------
# Compiler argument required if the objects are going to be placed into a
# shared library.  Empty if shared libraries are not being built.
#
TCLX_USE_SHLIB_CFLAGS = ${TCL_SHLIB_CFLAGS}

#------------------------------------------------------------------------------
# Linker arguments to pick up TclX libraries.
#
TCLX_BUILD_LIB_SPEC  = -L/u/hops/src/tcl/tclX7.5.1/tcl/unix -ltclx
TKX_BUILD_LIB_SPEC   = -L/u/hops/src/tcl/tclX7.5.1/tk/unix -ltkx
TCLX_LD_SEARCH_FLAGS = 

#------------------------------------------------------------------------------
# Configuration information from tclConfig.sh and tkConfig.sh. The
# TCL_USE_SHLIBS_CFLAGS is defined to be either the value of TCL_SHLIB_CFLAGS
# of a non-existant macro to be empty.  We don't want to compile with the
# shared library flags if we are not linking shared libraries, as this breaks
# some systems (Linux).
#
TCL_DEFS             =  -DHAVE_UNISTD_H=1 -DHAVE_SYS_TIME_H=1 -DTIME_WITH_SYS_TIME=1 -DHAVE_TZNAME=1 -DHAVE_TM_TZADJ=1 -DHAVE_TIMEZONE_VAR=1 -DSTDC_HEADERS=1 -DNO_UNION_WAIT=1 -DNEED_MATHERR=1 
TCL_LIBS             =   -lsocket -lm
TCL_EXEC_PREFIX      = /usr/local
TCL_SHLIB_CFLAGS     = -Kpic -belf
TCL_LD_FLAGS         = -belf -Wl,-Bexport
TCL_DL_LIBS          = 
TCL_SHLIB_LD         = ld -G
TCL_BUILD_LIB_SPEC   = -L/u/hops/src/tcl/tcl7.5/unix -ltcl7.5
TCL_LIB_SPEC         = -L/usr/local/lib -ltcl7.5
TCL_LD_SEARCH_FLAGS  = 

TK_DEFS              =  -DHAVE_UNISTD_H=1 -DHAVE_LIMITS_H=1 -DSTDC_HEADERS=1 
TK_LIBS              = -lX11   -lsocket -lm
TK_EXEC_PREFIX       = /usr/local
TK_XINCLUDES         = # no special path needed
TK_XLIBSW            = -lX11
TK_BUILD_LIB_SPEC    = -L/u/hops/src/tcl/tk4.1/unix -ltk4.1
TK_LIB_SPEC          = -L/usr/local/lib -ltk4.1
TK_LD_SEARCH_FLAGS   = 

#------------------------------------------------------------------------------
# Location of directories.
#
TCL_GENERIC_DIR    = ${TCL_SRC}/generic
TCL_UNIX_DIR       = ${TCL_SRC}/unix
TCL_LIBRARY_DIR    = ${TCL_SRC}/library
TK_GENERIC_DIR     = ${TK_SRC}/generic
TK_UNIX_DIR        = ${TK_SRC}/unix

TCLX_GENERIC_DIR   = ${srcbasedir}/tcl/generic
TCLX_UNIX_SRC_DIR  = ${srcbasedir}/tcl/unix
TCLX_UNIX_BLD_DIR  = ${bldbasedir}/tcl/unix
TKX_GENERIC_DIR    = ${srcbasedir}/tk/generic
TKX_UNIX_SRC_DIR   = ${srcbasedir}/tk/unix
TKX_UNIX_BLD_DIR   = ${bldbasedir}/tk/unix
COMPAT_DIR         = ${srcbasedir}/tcl/compat

#------------------------------------------------------------------------------
# Programs run during the build.
#
TCLX_TMP_RUNTIME   = ${bldbasedir}/tcl/unix
TKX_TMP_RUNTIME    = ${bldbasedir}/tk/unix

RUNTCL             = ${bldbasedir}/unix/runtcl
RUNWISHX           = ${bldbasedir}/unix/runwishx
GENTNDX            = ${RUNTCL} ${srcbasedir}/unix/tools/genindex.tcl
BLDMANHELP         = ${RUNTCL} ${bldbasedir}/unix/tools/bldmanhelp
CONVERTLIB         = ${RUNTCL} ${srcbasedir}/unix/tools/libconvert.tcl
INSTCOPY           = ${RUNTCL} ${bldbasedir}/unix/tools/instcopy
CPMANPAGES         = ${RUNTCL} ${bldbasedir}/unix/tools/cpmanpages

