#!/usr/local/bin/wish -f
#
# PORT WINDOW
#
# This procedure allows the user to configure the serial port.
#

proc xPort {} {

    global input_port \
	    serial_port \
	    baud \
	    stopbits \
	    framesize \
	    parity \
	    rbaud \
	    hto \
	    uto \
	    cto \
	    xNet_stopped

    set input_port dumm
    set serial_port dumf
    set title_f -Adobe-helvetica-bold-r-normal--*-120*
    set title_c brown
    set lab_font -Adobe-helvetica-medium-r-normal--*-120*


    catch {destroy .cPort}
    toplevel .cPort
    wm geometry .cPort +400+200
    wm title .cPort "SERIAL PORT CONFIGURATION"
    wm iconname .cPort "PORT"

    message .cPort.msg \
	    -font -Adobe-helvetica-medium-r-normal--*-120* \
	    -aspect 300 \
	    -text "Set serial port parameters. To exit without making changes select \"Cancel\". To save settings, select \"SAVE\"."


    label .cPort.lab \
	    -font -Adobe-helvetica-bold-r-normal--*-120* \
	    -relief raised -bd 2


    frame .cPort.frame -relief flat
    frame .cPort.frame.fport -relief raised -bd 2
    frame .cPort.frame.fbaud -relief raised -bd 2
    frame .cPort.frame.fpar -relief raised -bd 2
    frame .cPort.frame.finput -relief raised -bd 2
    frame .cPort.botframe
    
    pack .cPort.msg .cPort.lab -side top -fill x -expand yes
    pack .cPort.frame -side top -fill x -expand yes -pady 2
    pack .cPort.botframe -side bottom -fill x
    pack .cPort.frame.fport \
	    .cPort.frame.fbaud .cPort.frame.fpar \
	    -side left -expand yes -fill both



    #
    # SELECT SERIAL PORT
    #
    label .cPort.frame.fport.lab \
	    -text "Port" -fg $title_c -font $title_f

    radiobutton .cPort.frame.fport.cua0 -text "/dev/cua0" \
	    -font $lab_font -variable serial_port -relief flat \
	    -value /dev/cua0
    
    radiobutton .cPort.frame.fport.cua1 -text "/dev/cua1" \
	    -font $lab_font -variable serial_port -relief flat \
	    -value /dev/cua1
    
    radiobutton .cPort.frame.fport.cua2 -text "/dev/cua2" \
	    -font $lab_font -variable serial_port -relief flat \
	    -value /dev/cua2
    
    radiobutton .cPort.frame.fport.cua3 -text "/dev/cua3" \
	    -font $lab_font -variable serial_port -relief flat \
	    -value /dev/cua3
    
    radiobutton .cPort.frame.fport.cua4 -text "/dev/cua4" \
	    -font $lab_font -variable serial_port -relief flat \
	    -value /dev/cua4
    
    radiobutton .cPort.frame.fport.cua5 -text "/dev/cua5" \
	    -font $lab_font -variable serial_port -relief flat \
	    -value /dev/cua5
    
    radiobutton .cPort.frame.fport.cua6 -text "/dev/cua6" \
	    -font $lab_font -variable serial_port -relief flat \
	    -value /dev/cua6
    
    radiobutton .cPort.frame.fport.cua7 -text "/dev/cua7" \
	    -font $lab_font -variable serial_port -relief flat \
	    -value /dev/cua7
    
    radiobutton .cPort.frame.fport.cua8 -text "/dev/cua8" \
	    -font $lab_font -variable serial_port -relief flat \
	    -value /dev/cua8
    
    pack .cPort.frame.fport.lab .cPort.frame.fport.cua0 \
	    .cPort.frame.fport.cua1  .cPort.frame.fport.cua2 \
	    .cPort.frame.fport.cua3  .cPort.frame.fport.cua4 \
	    .cPort.frame.fport.cua5 .cPort.frame.fport.cua6\
	    .cPort.frame.fport.cua7 .cPort.frame.fport.cua8\
	    -side top -pady 2 -anchor nw
    


    #
    # SELECT BAUD RATE
    #
    label .cPort.frame.fbaud.lab \
	    -text "Port Baud" -fg $title_c -font $title_f

    radiobutton .cPort.frame.fbaud.300 \
	    -text " 300 bps" \
	    -font $lab_font -variable baud -relief flat -value 300
    
    radiobutton .cPort.frame.fbaud.1200 \
	    -text "1200 bps" \
	    -font $lab_font -variable baud -relief flat -value 1200
    
    radiobutton .cPort.frame.fbaud.2400 \
	    -text "2400 bps" \
	    -font $lab_font -variable baud -relief flat -value 2400
    
    radiobutton .cPort.frame.fbaud.9600 \
	    -text "9600 bps" \
	    -font $lab_font -variable baud -relief flat -value 9600
    
    radiobutton .cPort.frame.fbaud.19200 \
	    -text "19200 bps" \
	    -font $lab_font -variable baud -relief flat -value 19200
    
    pack .cPort.frame.fbaud.lab .cPort.frame.fbaud.300 .cPort.frame.fbaud.1200 \
	    .cPort.frame.fbaud.2400 .cPort.frame.fbaud.9600 \
	    .cPort.frame.fbaud.19200 \
	    -side top -pady 2 -anchor nw




    #
    # SELECT STOP BITS
    #
    label .cPort.frame.fpar.lab1 \
	    -text "Stop Bits" -fg $title_c -font $title_f

    radiobutton .cPort.frame.fpar.sb1 \
	    -text "1" \
	    -font $lab_font -variable stopbits -relief flat -value 1
    
    radiobutton .cPort.frame.fpar.sb2 \
	    -text "2" \
	    -font $lab_font -variable stopbits -relief flat -value 2
    
    pack .cPort.frame.fpar.lab1 .cPort.frame.fpar.sb1 \
	    .cPort.frame.fpar.sb2 \
	    -side top -pady 2 -anchor nw




    #
    # SELECT FRAME SIZE
    # 
    label .cPort.frame.fpar.lab2 \
	    -text "Frame Size" -fg $title_c -font $title_f

    radiobutton .cPort.frame.fpar.fs7 \
	    -text "7 bits" \
	    -font $lab_font -variable framesize -relief flat -value 7
    
    radiobutton .cPort.frame.fpar.fs8 \
	    -text "8 bits" \
	    -font $lab_font -variable framesize -relief flat -value 8
    
    pack .cPort.frame.fpar.lab2 .cPort.frame.fpar.fs7 \
	    .cPort.frame.fpar.fs8 \
	    -side top -pady 2 -anchor nw
    



    #
    # SELECT PARITY
    #
    label .cPort.frame.fpar.lab3 \
	    -text "Parity" -fg $title_c -font $title_f

    radiobutton .cPort.frame.fpar.po \
	    -text "Odd" \
	    -font $lab_font -variable parity -relief flat -value "O"

    radiobutton .cPort.frame.fpar.pe \
	    -text "Even" \
	    -font $lab_font -variable parity -relief flat -value "E"
    

    radiobutton .cPort.frame.fpar.pn \
	    -text "None" \
	    -font $lab_font -variable parity -relief flat -value "N"
    
    pack .cPort.frame.fpar.lab3 .cPort.frame.fpar.pe \
	    .cPort.frame.fpar.po .cPort.frame.fpar.pn \
	    -side top -pady 2 -anchor nw


    
    #
    # SAVE new Preferences to file and exit.
    #
    button .cPort.botframe.save -text "SAVE" -width 12 -command {
	set fp [open prefs w]
	puts $fp $input_port
	puts $fp $serial_port
	puts $fp $baud
	puts $fp $stopbits
	puts $fp $framesize
	puts $fp $parity
	puts $fp $rbaud
	puts $fp $hto
	puts $fp $uto
	puts $fp $cto
	if {! $xNet_stopped} {attn_port_dialog}
	close $fp
	destroy .cPort
    }



    #
    # CANCEL Exit
    #
    button .cPort.botframe.can -text "CANCEL" -width 12 -command {
	destroy .cPort
    }

    pack .cPort.botframe.can .cPort.botframe.save \
	    -side left -fill x -expand yes -pady 2



    #
    # GET PREFERENCES
    #
    set pf [open prefs r]
    gets $pf input_port
    gets $pf serial_port
    gets $pf baud
    gets $pf stopbits
    gets $pf framesize
    gets $pf parity
    gets $pf rbaud
    gets $pf hto
    gets $pf uto
    gets $pf cto
    close $pf


    switch $baud {
	300 {.cPort.frame.fbaud.300 invoke}
	1200 {.cPort.frame.fbaud.1200 invoke}
	2400 {.cPort.frame.fbaud.2400 invoke}
	9600 {.cPort.frame.fbaud.9600 invoke}
	19200 {.cPort.frame.fbaud.19200 invoke}
    }

    switch $stopbits {
	1 {.cPort.frame.fpar.sb1 invoke}
	2 {.cPort.frame.fpar.sb2 invoke}
    }
    
    switch $framesize {
	7 {.cPort.frame.fpar.fs7 invoke}
	8 {.cPort.frame.fpar.fs8 invoke}
    }
    
    switch $parity {
	O {.cPort.frame.fpar.po invoke}
	E {.cPort.frame.fpar.pe invoke}
	N {.cPort.frame.fpar.pn invoke}
    }
    
    switch $serial_port {
	/dev/cua0 {.cPort.frame.fport.cua0 invoke}
	/dev/cua1 {.cPort.frame.fport.cua1 invoke}
	/dev/cua2 {.cPort.frame.fport.cua2 invoke}
	/dev/cua3 {.cPort.frame.fport.cua3 invoke}
	/dev/cua4 {.cPort.frame.fport.cua4 invoke}
	/dev/cua5 {.cPort.frame.fport.cua5 invoke}
	/dev/cua6 {.cPort.frame.fport.cua6 invoke}
	/dev/cua7 {.cPort.frame.fport.cua7 invoke}
	/dev/cua8 {.cPort.frame.fport.cua8 invoke}
    }


    # Set text for serial warning
    if {$input_port == 0} {

	.cPort.lab config -fg blue -text "SERIAL PORT SELECTED"

    } else {

	.cPort.lab config -fg red -text "WARNING, SERIAL PORT NOT SELECTED"
	# (blinking, not used) blink .cPort.lab -bg red black 500
    }


}


# blink procedure
proc blink {w option value1 value2 interval} {

    $w config $option $value1

    after $interval [list blink $w $option $value2 $value1 $interval]
}




proc attn_port_dialog {} {

    toplevel .attn
    wm title .attn "ATTENTION"

    message .attn.msg \
	    -font -Adobe-helvetica-bold-r-normal--*-140* \
	    -width 2i -justify center -fg orange\
	    -text "\n XNET RUNNING \n \n Saved changes used on next re-START."

    frame .attn.frame -relief raised -bd 2
    label .attn.bmap -bitmap warning -fg blue
    button .attn.ok -text "OK" -command {destroy .attn}


    pack .attn.msg -side top -anchor center
    pack .attn.bmap -side top -pady .25i
    pack .attn.ok -side left -expand yes -fill both


    # Wait for user to acknowledge warning dialog
    tkwait visibility .attn
    grab set -global .attn
    tkwait window .attn
    grab release .attn


}


