#!wish -f

set CalDayNames {Sun Mon Tue Wed Thu Fri Sat}

proc CalGetMonth {date} {
    set fp [open "|cal $date" "r"]
    set res [list                        \
            [eval "list [gets $fp]"    ]        \
            [eval "list [gets $fp]"    ]        \
            [list                    \
                [eval "list [gets $fp]"    ]    \
                [eval "list [gets $fp]"    ]    \
                [eval "list [gets $fp]"    ]    \
                [eval "list [gets $fp]"    ]    \
                [eval "list [gets $fp]"    ]    \
            ]                    \
        ]
    close $fp
    return $res
}

proc Calendar {date} {
    global CalDayNames
    set ntop [CalGetId]
    set month [CalGetMonth $date]
    set name [lindex [lindex $month 0] 0]
    set year [lindex [lindex $month 0] 1]
    set weeks [lindex $month 2]

    toplevel ".t$ntop"
    wm title ".t$ntop" "$name $year"

    frame    ".t$ntop.cmds"
    pack append ".t$ntop" ".t$ntop.cmds" top

    button    ".t$ntop.cmds.next" -text ">" -command "Calendar [CalNext $date]"
    pack append ".t$ntop.cmds" ".t$ntop.cmds.next" right
    button   ".t$ntop.cmds.b2" -text "Close"   -command "destroy .t$ntop"
    pack append ".t$ntop.cmds" ".t$ntop.cmds.b2" right

    label   ".t$ntop.cmds.title" -text "$name $year"
    pack append ".t$ntop.cmds" ".t$ntop.cmds.title" {right expand}
    button    ".t$ntop.cmds.prev" -text "<" -command "Calendar [CalPrev $date]"
    pack append ".t$ntop.cmds" ".t$ntop.cmds.prev" right

    frame    ".t$ntop.days"
    pack append ".t$ntop" ".t$ntop.days" top

    set n 0
    foreach day [lindex $month 1] {
    set dname [lindex $CalDayNames $n]
        button ".t$ntop.days.$n" -text "$day" -width 3 -text $dname -command "CalEdit {} {} {} $dname"
        pack append ".t$ntop.days" ".t$ntop.days.$n" left
    set n [expr "$n + 1"]
    }

    set frameit "ne"
    regexp "..." $name nam
    set n 0
    foreach week "$weeks" {
        frame    ".t$ntop.week$n"
        pack append ".t$ntop" ".t$ntop.week$n" "top frame $frameit"

        set frameit "sw"

	set dow 0
        foreach day "$week" {
            button ".t$ntop.week$n.$day" -text "$day" -width 3\
        -command "CalEdit $year $nam $day [lindex $CalDayNames $dow]"
            pack append ".t$ntop.week$n" ".t$ntop.week$n.$day" left
	    incr dow
        }

        set n [expr "$n + 1"]
    }
}

proc CalNext {date} {
	set month [lindex $date 0]
	set year [lindex $date 1]
	incr month
	if { $month == 13 } {
		set month 1
		incr year
	}
	return "\{$month $year\}"
}

proc CalPrev {date} {
	set month [lindex $date 0]
	set year [lindex $date 1]
	set  month [expr $month - 1]
	if { $month == 0 } {
		set month 12
		set  year [expr $year - 1]
	}
	return "\{$month $year\}"
}

set Calid 0

proc CalGetId {} {
    global Calid
    incr Calid
    return $Calid
}

proc CalEdit {year nam day dname} {
    set fnum [CalGetId]
    toplevel ".file$fnum"
    wm title  ".file$fnum" "$dname $day $nam $year"

    button ".file$fnum.close" -text "Close" -command "destroy .file$fnum"
    pack append ".file$fnum" ".file$fnum.close" top  
    if { $year != {} } {
    	CalAddFile .file$fnum "~/Calendar/xy$year/xc$day$nam$year" 60 10 "Daily"
    }
    CalAddFile .file$fnum "~/Calendar/xw$dname" 60 10 "Weekly"
}

proc CalAddFile { w filename x y sort} {

    set id [CalGetId]
    frame $w.f$id
    pack append $w $w.f$id top
    set w $w.f$id
    
    label  "$w.filename" -text "$sort Events from $filename"
    button "$w.save" -text "Save" -command "\
         set fd \[open $filename w\] ;        \
         puts \$fd \[ $w.text get 1.0 end \] ;  \
         close \$fd"
    text "$w.text" -relief sunken -height $y -borderwidth 1 -width $x
    if {[file exists $filename] } {
        set fd [open $filename "r"]
        while { {} != [set line [gets $fd]] } {
            $w.text insert end "$line\n"
        }
        close $fd
    }
    pack append "$w"  $w.filename top "$w.text" left  "$w.save" {left frame nw}
}

proc CalGetToday {} {
	set fd [open {|date "+%m %Y"} "r"]
	set res [gets $fd]
	close $fd
	return $res
}
