#
# Makefile for Zircon
#
# Lindsay F. Marshall (Lindsay.Marshall@newcastle.ac.uk)
# 		Hacked from Makefile for TkMail which was
# 		hacked from Makefile for TkMan from Tom Phelps
#

# This Makefile includes the most critical and site specific
# settings needed to run Zircon.
#

# # # SITE SETTINGS # # #

WISH = /usr/local/bin/wish4.1

# directory to put *.tk support scripts plugins
LIBDIR = /usr/local/lib/zircon

# directory to put zircon executable script
BINDIR = /usr/local/bin

CC=cc -belf
LIBS=-lsocket
SHELL=/bin/sh

#--------------------------------------------------
#
# you shouldn't modify anything below here
#
#--------------------------------------------------

version = 1.16
srcs = zircon dccget.c dccsend.c crypt.c
objs = dccget.o dccsend.o crypt.o zping.o
execs = dccget dccsend crypt zping
libs = lib
index = lib/tclIndex
aux = zircon.ad rc
others = FAQ README CHANGES COPYRIGHT DOTzirconrc MANUAL Makefile TODO
help	= help lang look scripts plugins
images	= bitmaps gifs
sounds	= sounds
distrib	= $(index) $(srcs) $(libs) $(help) $(images) $(sounds) $(aux) $(others)

CFLAGS = -O

all: zircon $(execs)

zircon: $(index)
	mv zircon zircon.src
	echo '#!$(WISH) -f' > zircon
	echo 'set zircon(lib) $(LIBDIR)' >> zircon
	tail +3 zircon.src >> zircon
	chmod a+rx zircon
	rm -f zircon.src

zping: zping.c
	$(CC) -o zping -s $(CFLAGS) zping.c

crypt: crypt.c
	$(CC) -o crypt -s $(CFLAGS) crypt.c

dccget:	dccget.c
	$(CC) -o dccget -s $(CFLAGS) dccget.c $(LIBS)

dccsend:	dccsend.c
	$(CC) -o dccsend -s $(CFLAGS) dccsend.c $(LIBS)

$(index): lib
	cd lib ;  echo 'auto_mkindex . *.tcl ; exit' | $(WISH) -notk

install: all $(libs) $(help) $(images) $(sounds) $(aux)
	@if [ -d $(BINDIR) ]; then set +x; \
	else (set -x; mkdir $(BINDIR)); fi
	cp zircon $(BINDIR)
	@if [ -d $(LIBDIR) ]; then set +x; \
	else (set -x; mkdir $(LIBDIR)); fi
	cp -r $(execs) $(libs) $(help) $(images) $(sounds) $(LIBDIR)
	@if [ ! -f $(LIBDIR)/rc ]; then cp rc $(LIBDIR); \
	echo Remember to configure $(LIBDIR)/rc; fi
	@if [ ! -f $(LIBDIR)/zircon.ad ]; then cp zircon.ad $(LIBDIR); fi
	chmod a+rx $(LIBDIR) $(LIBDIR)/lib $(LIBDIR)/lib/interp $(LIBDIR)/help $(LIBDIR)/bitmaps $(LIBDIR)/gifs $(LIBDIR)/lang $(LIBDIR)/look $(LIBDIR)/scripts $(LIBDIR)/plugins
	chmod a+r $(LIBDIR)/lib/interp/* $(LIBDIR)/* $(LIBDIR)/*/* $(LIBDIR)/lib/interp/*
	chmod a+x $(LIBDIR)/dccget $(LIBDIR)/dccsend $(LIBDIR)/crypt $(LIBDIR)/zping

clean:
	rm -fr $(objs) core errs zircon-$(version) $(execs)
