/* 
 * Copyright (c) 1994 Open Software Foundation, Inc.
 * 
 * Permission is hereby granted to use, copy, modify and freely distribute
 * the software in this file and its documentation for any purpose without
 * fee, provided that the above copyright notice appears in all copies, and
 * that both the copyright notice and this permission notice appear in
 * supporting documentation.  Further, provided that the name of Open
 * Software Foundation, Inc. ("OSF") not be used in advertising or
 * publicity pertaining to distribution of the software without prior
 * written permission from OSF.  OSF makes no representations about the
 * suitability of this software for any purpose.  It is provided "AS IS"
 * without express or implied warranty.
 */ 

/*
 * OT 3.0.2
 */

/*
 *	otRCS.c
 *
 */


/*
#include <stdlib.h>
*/
#include <string.h>
#include <ctype.h>
#include <stdio.h>
#include <sys/types.h>
#include <sys/stat.h>
#include <tcl.h>
#include <tclInt.h>
#include "ot.h"
#include "otInt.h"


#ifndef LINT
static char RCSid_otRCS[] =
    "$RCSfile: otRCS.c,v $ $Revision: 1.1.7.4 $ $Date: 1994/01/19 18:10:10 $";

#endif


/*
 *		List of functions defined in the otRCS.c
 *
 *	otUnlockObject()
 *	rcsCmdPath()
 *	otDeltaCRFile()
 *
 */

void    rcsCmdPath();       /* check RCS commands accessibility */
char	* doRCSOperation();


/*
 *      Remove RCS lock on file on a server
 */
bool
otUnlockObject()
{
    register char * result;
    char request[COMMAND];
    char editname[NAMELEN];
    OTErr errCode;

    sprintf(editname, "%s%s", gotCRfile, ".edit");

    sprintf(request, "(cd %s; %%s/rcs -u -q %s; rm -f %s %s*; %%s/co -q %s) </dev/null 2> /dev/null\n",
	gotCRdir, gotCRfile, gotCRfile, editname, gotCRfile);

    result = doRCSOperation(otCB->cb_pcb->pcb_uName, request, 2);

    /*
     * clear RCS lock filename
     */
    if ( strspn(result, "ok") == 2 ) {
	strcpy(gotCRdir, "");
	strcpy(gotCRfile, "");
    }

    return (strspn(result, "ok") == 2);

}


/* rcsCmdPath() -- check RCS commands accessibility
 *
 *      look for "co" and "ci" commands in the PATH and in the
 *      /usr/local/bin directory.
 *
 *  Return:    FALSE   if RCS commands not found
 *             TRUE    if found, otCB->cb_pcb->pcb_rcsCmd will contain the path
 */

void
rcsCmdPath()
{
    char *envpath, *cp;
    char copath[PATHLEN];
    char cipath[PATHLEN];

    memset(copath, 0, PATHLEN);
    memset(cipath, 0, PATHLEN);

    if (envpath = getenv("PATH"))	{
	locateCmd("co", envpath, copath);
	locateCmd("ci", envpath, cipath);
	if (copath[0] && cipath[0] && !strcmp(copath, cipath))
	    strcpy(otCB->cb_pcb->pcb_rcsCmd, copath);
    }

    if (!otCB->cb_pcb->pcb_rcsCmd[0]) {
	copath[0] = 0;
	locateCmd("co", "/usr/local/bin", copath);
	strcpy(otCB->cb_pcb->pcb_rcsCmd, copath);
    }
    return;
}



/*  locateCmd()  --  look for a command
 *
 */

void
locateCmd(name, allpath, retpath)
char    *name, *allpath, *retpath;
{
    char *dir;
    struct stat stat_buf;
    char path[LONGVALUE], cmd_path[LONGVALUE];

    memset(path, 0, LONGVALUE);
    memset(cmd_path, 0, LONGVALUE);

    if (allpath)
	strcpy(path,allpath);

    for (dir=strtok(path, ":");  dir;  dir=strtok(0, ":")) {

	sprintf(cmd_path, "%s/%s", dir, name);

	DBUG_MED((stderr, "locateCmd testing file '%s'\n", cmd_path));

	if ((stat(cmd_path, &stat_buf) == 0) && (stat_buf.st_mode & S_IFREG))
	    break;

	DBUG_MED((stderr, "locateCmd test of file '%s' failed\n", cmd_path));
    }

    if ( dir )
	strcpy(retpath, dir);
    return;
}



/*
 *                           o t L o c k C R F i l e
 *
 * Get edit version of CR file.
 *
 * Arguments:
 *  CRFile      = CR file to lock for editing
 *  proj        = ptr to project definition structure.
 */
OTErr
otLockCRFile(cb, proj, CRFile)
OTControlBlock * cb;
OTProject *proj;
OTFilen CRFile;
{
    register char * result;
    char request[COMMAND];

    OTErr errCode = OT_SUCCESS;

    sprintf(request, "(cd %s; if [ -z \"`%%s/rlog -R -L %s 2> /dev/null`\" ] ; then %%s/co -l -p -q %s > %s.edit; chmod 666 %s.edit; else /bin/false ; fi) 2> /dev/null\n",
	CRFile.dir, CRFile.name, CRFile.name, CRFile.name, CRFile.name);

    result = doRCSOperation(cb->cb_pcb->pcb_uName, request, 2);

    if (strspn(result, "ok") == 2)    {     /* save locked CR name */
	strcpy(gotCRfile, CRFile.name);
	strcpy(gotCRdir, CRFile.dir);
    }
    else {
	otPutPostedMessage(OT_RCS_CO, proj->object_name, CRFile.name);
	errCode =  OT_RCS_CO;
    }

    return errCode;
}



OTErr
otDeltaCRFile(CRFile, file, message, create, proj)
OTFilen * CRFile;	/* CR file that holds delta */
OTFilen file;	/* template file -- content to delta */
char * message;	/* message for source control comment */
bool create;	/* is this a create or update? */
OTProject *proj;
{
    register int i, j;
    register char * result, * cp;
    char realFn[NAMELEN];
    char request[LONGVALUE];
    char command[COMMAND];

    OTErr errCode = OT_SUCCESS;

    if (strcmp(CRFile->dir, file.dir) || strcmp(CRFile->name, file.name))    {

    /* copy temporary template to the right place */

	if (otCB->cb_operation == ENTER)
	    sprintf(command, "(cp %s%s %s%s; chmod 666 %s%s) 2> /dev/null", file.dir, 
	       file.name, CRFile->dir, CRFile->name, CRFile->dir, CRFile->name);
	else
	    sprintf(command, "(cp %s%s %s/%s) 2> /dev/null", file.dir, file.name, 
		    	    CRFile->dir, CRFile->name);
	if (system(command)) {
	    otPutPostedMessage(OT_TEMPLATE_COPY_DB, 
	    		file.dir, file.name, CRFile->dir, CRFile->name);
	    return OT_TEMPLATE_COPY_DB;
	}
    }

    strcpy(realFn, CRFile->name);	/* get filename as we know it */

    for (i=strlen(realFn)-1, cp="tide.", j=0;
		(i >= 0) && (realFn[i] == cp[j]);  i--, j++)
	;			/* skip trailing ".edit" */
    realFn[i+1] = 0;

    if (strlen(message) > (LONGVALUE-500) ) {
        message[LONGVALUE-500] = 0;
	strcat(message, 
	        ".....  (list of changed fields is too long --> truncated)");
    }

    sprintf(request,
	"(cd %s; mv -f %s %s; %%s/ci -u -q -f -m'%s' -t/dev/null %s; rm -f %s*) 2> /dev/null\n",
            CRFile->dir, CRFile->name, realFn, message, realFn, CRFile->name);

    DBUG_MED((stderr, ">requesting deltaRCS operation: %s\n", request));

    result = doRCSOperation(otCB->cb_pcb->pcb_uName, request, 1);

    strcpy(CRFile->name, realFn);	/* put the real name back */

    if (strspn(result, "ok") == 2)    {

	/* clear RCS lock filename */
	strcpy(gotCRdir, "");
	strcpy(gotCRfile, "");

	return errCode;
    }

    return OT_RCS_CI;
}



OTErr
otDeleteCRFile()
{
    register char * result;
    char request[COMMAND];

    OTErr errCode = OT_SUCCESS;
    OTFilen * fname = otCB->cb_ecb->ecb_fname;
    OTProject * proj = otCB->cb_pcb->pcb_project;


/* Form the request for the deletion */

    sprintf(request, "(cd %s; if [ -z \"`%%s/rlog -R -L %s 2> /dev/null`\" ] ; then rm -f %s; chmod 000 RCS/%s,v ; else /bin/false ; fi) 2> /dev/null\n",
	fname->dir, fname->name, fname->name, fname->name);
    
    DBUG_MIN((stderr, ">requesting deleteRCS operation: %s\n", request));

/* Do the RCS delete operation */

    result = doRCSOperation(otCB->cb_pcb->pcb_uName, request, 1);

    if (strspn(result, "ok") == 2) {
	otPutPostedMessage(OT_OBJECT_DELETED, proj->object_name, 
			    otCB->cb_CRNumber);
	errCode = OT_OBJECT_DELETED;
    }
    else {
	otPutPostedMessage(OT_RCS_DELETE, proj->object_name, otCB->cb_CRNumber);
	errCode = OT_RCS_DELETE;
    }

    return errCode;
}


/*
 *                          d o R C S O p e r a t i o n
 *
 *  perform an RCS operation and return the result
 */


char *
doRCSOperation(who, msg, num)
char *  who;    /* who made the request */
char *  msg;    /* request sent by client -- command to execute for benefit of c
lient */
int    num;    /* number of RCS commands */
{
    register int result;
    char command[LONGVALUE];

/* Check RCS commands accessibility */

    if (!otCB->cb_pcb->pcb_rcsCmd[0])
        rcsCmdPath();		/* try to find RCS commands */

    if (!otCB->cb_pcb->pcb_rcsCmd[0])
	logWarn("RCS commands not in the server's path\n", "");

/* put location of RCS commands into command */

    if (num == 1) 		/* one RCS command */
	sprintf(command, msg, otCB->cb_pcb->pcb_rcsCmd);	    
    else
				/* two RCS commands  */
	sprintf(command, msg, otCB->cb_pcb->pcb_rcsCmd, 
		otCB->cb_pcb->pcb_rcsCmd);

/* do RCS operation */

    if ((result = system(command)) != 0)    {
	logWarn("doRCSop: command failed with %d\n", result);
	return BADRESPONSE;
    }

    return OKRESPONSE;
}
