#
# This applet adds a window which continually scrolls a message
# across it.
#

# Enter the message here:
set msg "Welcome to SurfIt!"

set latest "SurfIt! 0.4alpha"
set old 0

if {[info commands applet] == ""} {
    set msg "You are running SurfIt! 0.3alpha... upgrade to $latest NOW!!!"
    set main [Applet_window]
    set old 1
} elseif {[applet browserversion] != $latest} {
    set msg "You are running [applet browserversion]... upgrade to $latest NOW!!!"
    set main [applet embedwindow]
} else {
    set main [applet embedwindow]
}

wm withdraw .

proc set_size {w} {
    global xpos startpos outside_frame
    $outside_frame configure -width [expr $w - 20]
    set startpos [winfo reqwidth $outside_frame]
    if {$xpos > $startpos} {set xpos $startpos}
}

set outside_frame [frame $main.scrolled -borderwidth 5 -background black]
set xpos 9999
set_size [winfo width $main]
set l [label $outside_frame.text -text $msg -background black -foreground white -border 0]
set winlist {$l $outside_frame}
$outside_frame configure -height [expr [winfo reqheight $l] + 10]

$main window create 0.0 -window $outside_frame
if {!$old} {
    bind applet <Configure> "set_size %w"
    bindtags $main "applet [bindtags $main]"
}

proc scrolltext {win} {
    global xpos startpos
    incr xpos -5
    if {$xpos + [winfo width $win] < 0} {set xpos $startpos}
    place $win -x $xpos -y 0 -anchor nw
    after 100 scrolltext $win
}

after 100 scrolltext $l

proc terminate {} {
    global main winlist

    foreach win $winlist {
	destroy $win
    }

    # Remove the bind tag
    set b [bindtags $main]
    if {[set idx [lsearch $b applet]] != -1} {
	bindtags $main [lreplace $b $idx $idx {}]
    }
}
