# autopilot.tcl emulates the Java applet of the same name.
# The applet automatically loads a new URL after a 
# certain (configurable) interval.

# The following array contains the sites which are 
# used to generate a random URL

array set URLsites {
    PASTIME http://pastime.anu.edu.au:7777/cgi-bin/pastime/rand.pl
    URoulette http://lark.cc.ukans.edu:8000/cgi-bin/surf_o_matic
    {Web Autopilot} http://www.netgen.com/cgi/autopilot
    Yahoo http://www.cen.uiuc.edu/cgi-bin/ryl
}
set site {Web Autopilot}	;# the default

# Change to the hyperwindow level to avoid being destroyed
# by a page load

applet level hyperwindow

# Create the user interface

wm title . "WWW Autopilot"

set p [frame .controls]
button $p.stop -text "stop" -command {
    .feedback configure -text "Stopped"
    set state "stopped"
    catch {after cancel $surfID}
}
button $p.go -text "go" -command {
    .feedback configure -text "Running"
    set state "running"
    randomURL
}
button $p.quit -text "quit" -command {destroy .}
pack $p.stop $p.go $p.quit -side left -padx 5
pack $p -side top -anchor n -fill x

set p [frame .configuration]
label $p.sitelab -text "Site: "
# Can't use the -textvariable switch, so use a workaround
menubutton $p.site -menu $p.site.m -indicatoron true	;# -textvariable site
$p.site configure -text $site
menu $p.site.m
foreach s [array names URLsites] {
    $p.site.m add command -label $s -command "setVar site $p.site $s"
}
proc setVar {v win s} {
    upvar #0 $v var

    set var "$s"
    $win configure -text "$s"
}

$p.site.m add command -label "all" -command "setVar site $p.site all"

# Delay between loading hyperdocuments
set delay 15	;# In seconds
label $p.delaylab -text "Delay: "
menubutton $p.delay -menu $p.delay.m -indicatoron true ;#-textvariable delay
$p.delay configure -text $delay
menu $p.delay.m
foreach t {5 10 15 20 30 45 60} {
    $p.delay.m add command -label $t -command "setVar delay $p.delay $t"
}

pack $p.sitelab $p.site $p.delaylab $p.delay -side left
pack $p -side top

# Feedback window
label .feedback -text "Stopped"
pack .feedback -side top -fill both
set state "stopped"

# This procedure loads the random URL
# It actually just uses one or more of the random URL
# services on the Web.

proc randomURL {} {
    global site URLsites delay surfID state

    if {$site == "all"} {
	# Special case where a site is chosen at random
	set s [lindex [array names URLsites] [random [llength [array names URLsites]]]]
    } else {set s $site}

    # Make sure we make a fresh connection to the server
    applet flush $URLsites($s)
    applet loadurl $URLsites($s)
    .feedback configure -text "Page Loading"
    set state "loading"
}

# We need to keep track of when the browser finishes loading the page
# Only when the page has finished loading do we schedule another random page

proc pageloaded {args} {
    global surfID delay state

    if {$state == "stopped"} return;	# Ignore normal pageloads
    if {$state == "waiting"} {.controls.stop invoke}	;# Let the user browse
    set surfID [after [expr $delay * 1000] randomURL]
    .feedback configure -text "Waiting"
    set state "waiting"
}
