/*
 * @(#)Surfomatic.java	Patrick Chan
 *
 * Copyright (c) 1994-1995 Sun Microsystems, Inc. All Rights Reserved.
 *
 * Permission to use, copy, modify, and distribute this software
 * and its documentation for NON-COMMERCIAL or COMMERCIAL purposes and
 * without fee is hereby granted. 
 * Please refer to the file http://java.sun.com/copy_trademarks.html
 * for further important copyright and trademark information and to
 * http://java.sun.com/licensing.html for further important licensing
 * information for the Java (tm) Technology.
 * 
 * SUN MAKES NO REPRESENTATIONS OR WARRANTIES ABOUT THE SUITABILITY OF
 * THE SOFTWARE, EITHER EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED
 * TO THE IMPLIED WARRANTIES OF MERCHANTABILITY, FITNESS FOR A
 * PARTICULAR PURPOSE, OR NON-INFRINGEMENT. SUN SHALL NOT BE LIABLE FOR
 * ANY DAMAGES SUFFERED BY LICENSEE AS A RESULT OF USING, MODIFYING OR
 * DISTRIBUTING THIS SOFTWARE OR ITS DERIVATIVES.
 * 
 * THIS SOFTWARE IS NOT DESIGNED OR INTENDED FOR USE OR RESALE AS ON-LINE
 * CONTROL EQUIPMENT IN HAZARDOUS ENVIRONMENTS REQUIRING FAIL-SAFE
 * PERFORMANCE, SUCH AS IN THE OPERATION OF NUCLEAR FACILITIES, AIRCRAFT
 * NAVIGATION OR COMMUNICATION SYSTEMS, AIR TRAFFIC CONTROL, DIRECT LIFE
 * SUPPORT MACHINES, OR WEAPONS SYSTEMS, IN WHICH THE FAILURE OF THE
 * SOFTWARE COULD LEAD DIRECTLY TO DEATH, PERSONAL INJURY, OR SEVERE
 * PHYSICAL OR ENVIRONMENTAL DAMAGE ("HIGH RISK ACTIVITIES").  SUN
 * SPECIFICALLY DISCLAIMS ANY EXPRESS OR IMPLIED WARRANTY OF FITNESS FOR
 * HIGH RISK ACTIVITIES.
 */

import awt.*;
import net.www.html.*;
import browser.*;

/**
 * @author 	Patrick Chan
 * @version 	1.0
 */

class StpButton extends Button {
    ControlDialog dialog;
    public StpButton(Window p, ControlDialog d) {
	super("Stop", null, p);
        dialog = d;
    }
    public void selected(Component c, int pos) {
        dialog.stop(true);
    }
}

class GoButton extends Button {
    ControlDialog dialog;
    public GoButton(Window p, ControlDialog d) {
	super("Go", null, p);
        dialog = d;
    }
    public void selected(Component c, int pos) {
        dialog.stop(false);
    }
}

class HmButton extends Button {
    ControlDialog dialog;
    public HmButton(Window p, ControlDialog d) {
	super("Home", null, p);
        dialog = d;
    }
    public void selected(Component c, int pos) {
        dialog.document.pushURL(dialog.home);
    }
}

class QuitButton extends Button {
    ControlDialog dialog;
    public QuitButton(Window p, ControlDialog d) {
	super("Quit", null, p);
        dialog = d;
    }
    public void selected(Component c, int pos) {
        dialog.quit();
    }
}

class DelayOptionMenu extends OptionMenu {
    /* number of seconds to delay */
    public int delay = 20;
    Timer timer;

    DelayOptionMenu(Container p, Timer t) {
        super(p, null, "Delay");
        timer = t;
        timer.setInterval(delay * 1000);
        addItem("20");
        addItem("30");
        addItem("45");
        addItem("60");
        addItem("90");
        addItem("120");
    }
    
    public void selected(int pos) {
        String delayString = itemAt(pos);

        delay = Integer.parseInt(delayString);
        timer.setInterval(delay * 1000);
    }
}

class SiteOptionMenu extends OptionMenu {
    /* Don't want to be unfair, do we? */
    int siteNum = (int)Math.floor(Math.random() * 3);

    /* The count is appended on most url to avoid some kind of cacheing
       problem.  Without it, HotJava keeps serving up the
       same page.  Not sure which end the problem exists. */
    int count = 0;

    String urls[] = {
	"http://lark.cc.ukans.edu:8000/cgi-bin/surf_o_matic",
	"http://www.netgen.com/cgi/autopilot",
	"http://www.cen.uiuc.edu/cgi-bin/ryl"
    };
            //"http://www.netcreations.com/nc-cgi/random.pl";

    SiteOptionMenu(Container p) {
        super(p, null, "Site");
        addItem("URoulette");
        addItem("Web Autopilot");
        addItem("Yahoo");
        addItem("All");
        select(siteNum);
    }
    
    public URL getURL() {
        String result = null;

        ++count;
        switch(siteNum) {
        case 0: 
        case 1:
        case 2:
            result = urls[siteNum] + "?" + count;
            break;
        case 3:
            result = urls[(int)Math.floor(Math.random() * 3)] 
                + "?" + count;
        }
        return new URL(null, result);
    }

    public void selected(int pos) {
        siteNum = pos;
    }

}

class ControlDialog extends Frame implements Timeable {
    Applet applet;
    Label statusBar;
    Label memoryLabel;
    DelayOptionMenu delayMenu;
    SiteOptionMenu siteMenu;
    Timer timer;
    Timer memoryTimer;
    URL home;
    WRWindow document;

    public ControlDialog(WServer server, Applet applet) {
	super(server, true, null, 350, 250, Color.lightGray);
        this.applet = applet;

        document = (WRWindow)applet.item.parent;
        home = applet.documentURL;
	setTitle("Surf-o-matic Control Panel");
	Window cw = new Window(this, "North", background, 350, 30);

	new StpButton(cw, this);
	new GoButton(cw, this);
	//new HmButton(cw, this);
        // This causes the applet to be reloaded; need to figure
        // out how to prevent this.
	new QuitButton(cw, this);
    
	cw = new Window(this, "Center", background, 250, 50);
        Row r = new Row(cw, null, true);

        new Label("Site:", null, r, 
            server.fonts.getFont("Helvetica", Font.PLAIN, 14));
        siteMenu = new SiteOptionMenu(r);

        timer = new Timer(this, 0);
        new Label("Delay (sec):", null, r, 
            server.fonts.getFont("Helvetica", Font.PLAIN, 14));
        delayMenu = new DelayOptionMenu(r, timer);

        memoryLabel = new Label("", "memory", cw, 
            server.fonts.getFont("Helvetica", Font.PLAIN, 14));
        memoryLabel.setHFill(true);
        memoryTimer = new Timer(this, 5000);

	cw = new Window(this, "South", background, 250, 20);
        statusBar = new Label("", "status", cw, 
            server.fonts.getFont("Helvetica", Font.BOLD, 14));
        statusBar.setHFill(true);
        map();
        
        memoryTimer.cont();
        stop(true);
    }

    public void handleQuit() {
        quit();
    }

    public void setStatusMessage(String msg) {
        statusBar.setText(msg);
    }

    /* Stops and kills the dialog and all timers. */
    public synchronized void quit() {
        unMap();
        memoryTimer.stop();
        stop(true);
        dispose();
    }

    /* Stops or starts the fetching timer. */
    public synchronized void stop(boolean b) {
        if (b) {
	    timer.stop();
	    setStatusMessage("Stopped.");
        } else {
            timer.setRemainingTime(0);
	    timer.cont();
	    setStatusMessage("Running...");
        }
    }

    /* Processes timer ticks. */
    public synchronized void tick(Timer t) {
        if (t == timer) {
            // The reason why we use WRWindow.pushURL instead
            // of Applet.showDocument is because Applet.showDocument
            // checks whether or not the current page 
	    document.pushURL(siteMenu.getURL());
	    if (System.freeMemory() < 10000) {
		stop(true);
	    }
        } else if (t == memoryTimer) {
	    memoryLabel.setText("Memory usage: "+
		(System.totalMemory() - System.freeMemory()) 
		+ " bytes   (out of " +
		System.totalMemory() + ")");
        }
    }
}

class Surfomatic extends Applet {
    /**
     * Initialize the applet. Resize and load images.
     */
    public void init() {
	new ControlDialog(item.parent.wServer, this);
	resize(0, 0);
    }
}