.\" Copyright (c) 1994 Allan Brighton (allan@piano.sta.sub.org)
.so man.macros
.HS TableList itcl
.BS
'\" Note:  do not modify the .SH NAME line immediately below!
.SH NAME
TableList \- An [incr Tcl] Table Widget based on a Tk Listbox
.SH SYNOPSIS
\fBTableList\fI \fIpathName \fR?\fIoptions\fR?
.ta 4c
.SH "WIDGET-SPECIFIC OPTIONS"
.LP
.nf
\fB\-title\fR \fItitle\fB
.fi
.IP
Specifies a title for the table. The default is no title.
.LP
.nf
\fB\-show_menubutton\fR \fIboolean\fB
.fi
.IP
If show_menubutton is 1, the table will display a menubutton with entries for 
sorting, configuring and printing the table (default is off).
.LP
.nf
\fB\-menubar\fR \fIwidgetname\fB
.fi
.IP
This is optional and if specified, the name of the menubar widget (frame) in which to
pack the table menubutton. The default is to pack it in the table's frame.
.LP
.nf
\fB\-headings\fR \fIlist\fB
.fi
.IP
Specifies a tcl list of table headings. This list must be of
the same length as the table rows and must also be specified before
\fB\-info\fR.
.LP
.nf
\fB\-heading_lines\fR \fI1or2\fB
.fi
.IP
The number of lines to display for the table headings (default 1, max 2).
For 2 line headings, each column heading may be a single string or a list
of 2 strings (one for each heading line).
.LP
.nf
\fB\-row_lines\fR \fInumlines\fB
.fi
.IP
This specifies the height of the table in lines (or rows).
.LP
.nf
\fB\-sizes\fR \fIlist\fB
.fi
.IP
Specifies the maximum table column widths in characters as a tcl list
of integers.  If this option is not specified, the TableList widget
will calculate the maximum column widths by scanning the table
data. This option must precede the \fB\-info\fR option.
.LP
.nf
\fB\-static_col_sizes\fR \fIbool\fB
.fi
.IP
If true (default false), the table only calculates the column widths once and
then assumes they will not changes. This might improve performance if you
know that the same layout will always be used.
.LP
.nf
\fB\-info\fR \fIlist of list\fB
.fi
.IP
Specifies the contents of the table as a tcl list of rows, where each
row is a tcl list of column values.  If \fB\-sizes\fR was not
specified, the widget calculates the column widths by scanning for the
largest items in a column.
.LP
.nf
\fB\-use_regexp\fR \fIboolean\fB
.fi
.IP
If use_regexp is 1, the table configuration popup will use grep style
regular expressions for matching table items, otherwise shell style
wildcards are used.
.BE
.SH DESCRIPTION
.PP
The \fBTableList\fR command creates a new window (actually a frame with the same name as the
\fIpathName\fR argument) and makes it into an Itcl ([incr Tcl]) TableList widget.
An Itcl widget is actually a combination of Tk widgets and other Itcl widgets,
so many of the standard Tk X resources also apply here. 
As with Tk widgets, the \fBTableList\fR command returns its
\fIpathName\fR argument.
.PP
A TableList widget is used to display tabular data, such as the result
of a select in a database or the contents of a data file. Built-in
functions include sorting the table's contents by one or more search
keys, selecting a set of rows based on wildcards or regular
expressions, hiding specified columns, left and right alignment of
rows and user defined column separators. You can also save and load 
table configurations via menu.

.SH "WIDGET COMMAND"
.PP
The \fBTableList\fR command creates a new Tcl command whose
name is \fIpathName\fR.  This
command may be used to invoke various
operations on the widget.  It has the following general form:
.DS C
\fIpathName subcmd \fR?\fIargs\fR?
.DE
\fISubcmd\fR and the \fIargs\fR
determine the exact behavior of the command.  
The following subcommands are available for TableList widgets:
.TP
\fIpathName \fBconfig\fR \fIoption\fR \fIvalue ?option value ...\fR?
Modify the configuration options of the widget.
\fIOption\fR may have any of the values accepted by the \fBTableList\fR
command. Note that the order of the options is important in some cases,
as described above.
You can also use the Itcl \fIinfo\fR command to query the widget's public 
and protected variables (see the source files for more information).
.TP
\fIpathName \fBappend_rows\fR \fIlist of rows\fR
Append the given rows to the table. 
.TP
\fIpathName \fBappend_row\fR \fIlist\fR
Append a single row to the table. 
Note that you will need to call \fIpathName \fBnew_info\fR 
when you are done appending rows if you want any further matching, 
sorting or formatting to occur.
.TP
\fIpathName \fBnew_info\fR
This command recalculates the column widths if necessary and
handles any sorting and matching of rows as needed. It is called
automatically when you specify the \fB\-info\fR switch.  Otherwise,
you only need to use this method if you modified the table info in 
some other way, such as by adding or deleting rows manually.
.TP
\fIpathName \fBset_row\fR \fIoldrow newrow\fR
Replace the contents of the given row with the new row.
The old and new rows are spcified by their contents.
This assumes that the rows specified with the \fI-info\fR option
are unique.
.TP
\fIpathName \fBclear\fR
Makes the table empty.
.TP
\fIpathName \fBget_selected\fR
Returns a list of the selected rows in the table.
.TP
\fIpathName \fBremove_selected\fR
Removes the selected rows from the table and returns them as a list of lists.
.TP
\fIpathName \fBselect_row\fR \fIrowindex\fR
Select the given row in the table.
.TP
\fIpathName \fByview\fR \fIrowindex\fR
Scroll to the the given row in the table.
.TP
\fIpathName \fBshow_last_row\fR
Scroll to the end of the table and place the last row at the end of the table.
.TP
\fIpathName \fBsave_yview\fR
Save the current scroll position.
.TP
\fIpathName \fBrestore_yview\fR
Restore the previous scroll position.
.TP
\fIpathName \fBsave_selection\fR
Save a list of the currently selected rows so they can be restored
later.
.TP
\fIpathName \fBrestore_selection\fR
Restore the previously saved row selection.
.TP
\fIpathName \fBset_option\fR \fIname option value\fR
Set the \fIoption value\fR for the given column heading \fIname\fR.
\fIoption\fR may be one \fBShow\fR, \fBAlign\fR, \fBSeparator\fR, 
\fBWildcard\fR or \fBPrecision\fR.
The value for \fBShow\fR may be 1 (default) to display that column, or 0
to hide it.  The value for \fBAlign\fR may be "Left" or "Right".  
The value for \fBSeparator\fR is any string that should be used as a 
column separator for (after) that column.
The value for \fBWildcard\fR should be a glob expression or a regular expression,
depending of the value of the \fI-use_regexp\fR flag. Only rows matching
this expression in that column are displayed.
\fBPrecision\fR is the number of places after the decimal for floating point values.
.TP
\fIpathName \fBset_options\fR \fIheadings option value\fR
This is the same as \fIset_option\fR, except that a list of column heading names
may be specified and the options will be set for each of the columns.
.TP
\fIpathName \fBlayout_dialog\fR
Pops up a window to change the layout of the table.
.TP
\fIpathName \fBsort_dialog\fR
Pops up a dialog to sort the contents of the table.
.TP
\fIpathName \fBprint_dialog\fR
Pops up a dialog to print the contents of the table to a printer or file.
.TP
\fIpathName \fBprint\fR \fIfd\fR
Print the contents of the table to the given file descriptor.
.TP
\fIpathName \fBget_contents\fR
Returns the contents of the table as a list of rows.

.SH "DEFAULT BINDINGS"
.PP
The TableList widget automatically creates bindings that give it
the following default behavior:
.IP [1]
A row is selected by pressing mouse button 1.
.IP [2]
The view in the TableList can be adjusted by dragging with mouse button 2.
.PP
The behavior of TableLists can be changed by defining new bindings for
the widgets composing the table or by redefining class bindings for these
widgets. For example, if your TableList widget is called $table, you can
access the widget used to display the table headings as $table.headbox, 
the title as $table.title and the main list as $table.listbox.
See the TableList sources for more detailed information.

.SH AUTHOR
.TP 0
Allan Brighton - Free-lance Software Engineer (near Munich)
.sp 0
E-mail: allan@piano.sta.sub.org
.sp 0
Snail-Mail: Zaissing 3, 85643 Steinhoering, Germany
.SH KEYWORDS
TableList, widget
