# LabelNumber.tcl - Itcl widget displaying a label, a number
# and buttons to increment and decrement the number
#
# Author: Allan Brighton


itcl_class LabelNumber {
    inherit LabelMessage

    # increment the value by the specified amount

    method increment {{amount 1}} {
	set v [expr [get_]+$amount]
	if {$v >= $min && $v <= $max} {
	    $this.message config -text $v
	    if {"$changecmd" != ""} {
		set cmd $changecmd
		lappend cmd $v
		eval $cmd
	    }
	}
    }


    #  constructor: create a new LabelNumber

    constructor {config} {
	LabelMessage::constructor
	global bitmaps

	pack [frame $this.f] -side left
	pack [button $this.incr \
		  -bitmap @$bitmaps/incr.xbm  \
		  -command "$this increment $increment"] \
	    [button $this.decr \
		 -bitmap @$bitmaps/decr.xbm  \
		 -command "$this increment [expr -($increment)]"] \
	    -side top 
	$this.message config -justify $justify -relief $relief

	#  Explicitly handle config's that may have been ignored earlier
	foreach attr $config {
	    config -$attr [set $attr]
	}

	if {"$value" == ""} {
	    config -value $min
	}
    }


    # -- public variables -- 


    # maximum value
    public max {100}

    # minimum value
    public min {0}

    # set the message relief 
    public relief {groove} {
	if {$initialized_} {
	    $this.message config -relief $relief
	}
    }
    
    # set the state of the incr/decr buttons (normal, disabled)
    public state {normal} {
	if {$initialized_} {
	    $this.incr config -state $state
	    $this.decr config -state $state
	}
    }
    
    # set the message relief 
    public justify {right} {
	if {$initialized_} {
	    $this.message config -justify $justify
	}
    }

    # amount to add or subtract for each button push
    public increment 1
    
    # commands to evaluate whenever the entry value changes
    public changecmd {}
}

