# pvm.tcl --
#
# Initialization script normally executed in the interpreter for each
# Tkpvm-based application.
#

# Insist on running with compatible versions of Tcl
package require Tcl 7.5
package require Pvm 1.0

# Add Tkpvm's directory to the end of the auto-load search path, if it
# isn't already on the path:

if {($pvm_library != "") &&([lsearch -exact $auto_path $pvm_library] < 0)} {
    lappend auto_path $pvm_library
}

# Rename "bind" to "tk_bind",
#        "kill" to "tclx_kill",
#        "send" to "tk_send", and
#
if [string compare [info command bind] "bind"] {
    proc bind {args} {
	error "expected integer or one of the keywords\
\"any\" or \"kill\" but got \"[lindex $args 1]\""
    }
}
if [string compare [info command kill] "kill"] {
    proc kill {args} {
	error "invalid command name \"kill\""
    }
}
if [string compare [info command send] "send"] {
    proc send {args} {
	error "expected integer but got \"[lindex $args 1]\""
    }
}
if [string compare [info command tk_bind] "tk_bind"] {
    rename bind tk_bind
}
if [string compare [info command tclx_kill] "tclx_kill"] {
    rename kill tclx_kill
}
if [string compare [info command tk_send] "tk_send"] {
    rename send tk_send
}

# Replacements for bind, kill, and send.
#
proc bind {args} {
    set msgtag [lindex $args 1]
    if {$msgtag=="any" || $msgtag=="kill" || [regexp {^[0-9]+$} $msgtag]} {
	return [eval pvm bind $args]
    } else {
	return [eval tk_bind $args]
    }
}

proc kill {args} {
    catch {[eval tclx_kill $args]}
    return [eval pvm kill $args]
}

proc send {args} {
    set msgtag [lindex $args 1]
    if [regexp {^[0-9]+$} $msgtag] {
	return [eval pvm send $args]
    } else {
	return [eval tk_send $args]
    }
}
