#include "tcl.h"

extern void PvmSetInitScript _ANSI_ARGS_((char  **script));

#ifdef TCL_STANDALONE

static char *script[] = {
#include "../library/pvm.c"
#include "../library/console.c"
#include "../library/obsolete.c"
(char *) NULL
};

int
Pvm_InitStandAlone(interp)
    Tcl_Interp *interp;
{
    PvmSetInitScript(script);
    return Pvm_Init(interp);
}

#else

int
Pvm_InitStandAlone(interp)
    Tcl_Interp *interp;
{
    Tcl_AppendResult(interp,
	"The function \"Pvm_InitStandAlone\" is not implemented in\n",
	"the shared Pvm library. Link your standalone application\n",
	"with the static Pvm library (libPvm",TCL_VERSION,
	".a) explicitely",(char *) NULL);
    return TCL_ERROR;
}

#endif
