proc dppatAnmelden {user port} {
  global userPorts
  set user [string tolower $user]
  set userPorts($user) $port
}
proc dppatAbmelden {user port} {
  global userPorts
  set user [string tolower $user]
  catch {unset userPorts($user)}
}
proc dppatPortVon {user} {
  global userPorts
  set user [string tolower $user]
  if {[info exists userPorts($user)]} {
    return $userPorts($user)
  } else {
    return 0
  }
}
proc dppatDebug {} {
  global userPorts
  set logFile [open "/tmp/dppat[pid].log" w]
  foreach user [array names userPorts] {
    puts $logFile "debug: $user at $userPorts($user)"
  }
  close $logFile
}
proc checkIt {cmd args} {
  if {[string match dppat* $cmd]} return
  return -code break
}
catch {wm withdraw .}
if {![info exists dp_version]} {
  puts "Dppatd: Not interpreted by Tcl-DP"
  exit 0
}
set daemonPort 4567
if {[llength $argv] == 1  && [regexp {^[0-9]*$} $argv]} {
  set daemonPort $argv
}
if {[catch {dp_MakeRPCServer $daemonPort dp_CheckHost checkIt} msg]} {
  puts "Dppatd: $msg."
  exit 0
} else {
  puts "Dppatd: successfully started."
}
