#!/net/bin/wish4.1
# This package is free software. Redistribution and use of this file
# are permitted without restrictions.
#
# THIS SOFTWARE IS PROVIDED ``AS IS'' AND WITHOUT ANY EXPRESS OR
# IMPLIED WARRANTIES, INCLUDING, WITHOUT LIMITATION, THE IMPLIED
# WARRANTIES OF MERCHANTIBILITY AND FITNESS FOR A PARTICULAR PURPOSE.
#
#	Picasso 4.1a3
#
#	Frank Mangin
#	Frank.Mangin@ceram.fr  -  Frank.Mangin@sophia.inria.fr
#
## Find out where things are:
##    picLibDir  is where the picasso tcl auxiliary files live
##    picPrefDir is where user definable preference files live
set cvstag {$Id: picasso.tcl,v 4.20 1996/05/21 17:44:19 mangin Rel $}
set Debug [expr {"[lindex $cvstag 6]" == "Exp"}]

puts -nonewline "Initializing..."

switch -- $tcl_platform(platform) {
  macintosh {
    set picPrefFile [file join "$env(PREF_FOLDER)" "Picasso prefs"]
    set picLibDir [file join "$tk_library" "Picasso"]
  }
  unix {
    set picPrefFile [file join "$env(HOME)" ".picassorc"]
    if {[info exists env(PICASSO_LIBRARY)]} {
      set picLibDir "$env(PICASSO_LIBRARY)"
    } elseif {[file exists "<<INSTALL-LIB>>"]} {
      set picLibDir "<<INSTALL-LIB>>"
   } else {
      set picLibDir [file join "$tk_library" "picasso"]
    }
  }
  default {
    puts stderr "Sorry, this platform isn't supported!"
    exit 1
  }
}

if {$Debug} {
  #set picLibDir "Macintosh HD:Desktop Folder:Frank:picasso"
  set picLibDir "$env(HOME)/src/picasso"
}

##
## Load bootstrap libraries, 
##   user preferences, and a first set of libraries
##

set savedWD "[pwd]"
if {[catch {cd "$picLibDir"}]} {
	puts "Couldn't cd to library directory: \n$errorInfo"
}

# All picasso global variables appear there
# ... almost true for 4.1a1
# source globalVars.tcl

if ($Debug) { puts "Sourcing pictclX" }
source pictclX.tcl

if ($Debug) { puts "Sourcing picbind" }
source picbind.tcl

# Default preference file
if ($Debug) { puts "Sourcing picprefs" }
source picprefs.tcl
initPrefs

# Variable initializations
if ($Debug) { puts "Sourcing picrc" }
source picrc.tcl

# User preferences

if ($Debug) { puts "Sourcing user prefs";  }

if {[file readable "$picPrefFile"]} {
  if {[catch {source "$picPrefFile"}]} {
    MessageBox "Error sourcing your preference file:\n $errorInfo"
  }
}

setupFonts

# Libs required to have the GUI show up on the screen

foreach file {picutil picbuild picconfig picfsbox picproc picgeom \
  picobj pictext picimage } {
    if {$Debug} { puts stderr "Sourcing ${file}.tcl" }
    update; update idletasks
    if {[catch {source ${file}.tcl}]} {
      MessageBox "Error sourcing ${file}.tcl (in [pwd]) :\n $errorInfo"
    }
  }
  
##
## GUI setup
##

if {[catch {
ShowTopWindow
update
waitCursor
sayHello
}]} {
  puts stderr "Sorry, an internal error occured:\n $errorInfo"
}

if {$Debug} { puts stderr "GUI setup done" }
# scrollbar management
if {[catch scbarSetup]} {
  puts "Error in scbarSetup: $errorInfo"
}

# mouse bindings  #
if {[catch mouseBind]} {
  puts "Error in mouseBind: $errorInfo"
}

##
## source remaining libs
##
foreach file { picgrid picgroup picio pichelp} {
  if {[catch {source $file.tcl}]} {
    error "Error sourcing $file.tcl : $errorInfo"
  }
}

##
## Finish GUI setup
##

# build control widgets
if {[catch optionBuildText]} {
  puts stderr "Error in optionBuildText: $errorInfo"
}
if {[catch optionBuildImage]} {
  puts stderr "Error in optionBuildImage: $errorInfo"
}

# controls setup
if {[catch styleSetup]} {
  puts stderr "Error in styleSetup: $errorInfo"
}

focus .
if {[catch globalBindings]} {
  puts stderr "Error in globalBindings: $errorInfo"
}

cd "$savedWD"

# User defined hook
if {[catch SetupEndHook]} {
  puts stderr "Error in SetupEndHook: $errorInfo"
}

restoreCursor  
puts "done."
