# rcsid {$Id: pictext.tcl,v 4.8 1996/05/21 11:50:30 mangin Rel $}
# This package is free software. Redistribution and use of this file
# are permitted without restrictions.
#
# THIS SOFTWARE IS PROVIDED ``AS IS'' AND WITHOUT ANY EXPRESS OR
# IMPLIED WARRANTIES, INCLUDING, WITHOUT LIMITATION, THE IMPLIED
# WARRANTIES OF MERCHANTIBILITY AND FITNESS FOR A PARTICULAR PURPOSE.
#
#	Frank Mangin
#	Frank.Mangin@ceram.fr  -  Frank.Mangin@sophia.inria.fr

################################################################
####       Usefull procedures for handling text items       ####
################################################################


################################################################
####		    basic procedures                        ####
################################################################

proc ct_move_to_char {index} {
  .f2.f22.cv icursor [.f2.f22.cv focus] $index
}

proc ct_cursor_position_in_line {} {
  set focus [.f2.f22.cv focus]
  set sxx [ct_search_backward_char "\n"]
  set cxx [.f2.f22.cv index $focus insert]
  return ([expr $cxx - $sxx])
}

proc ct_search_forward_char {char} {

  # search forward from the current insertion cursor position
  
  if {[set focus [.f2.f22.cv focus]] != ""} {
    set text [lindex [.f2.f22.cv itemconfigure $focus -text] 4]
    for {set i [.f2.f22.cv index $focus insert]} \
      {$i < [.f2.f22.cv index $focus end]} \
      {incr i} {
	if {$char == [string index $text $i]} {
	  return $i
	}
      }
    return [.f2.f22.cv index $focus end]
  }
  return -1
}

proc ct_search_backward_char {char} {

  # search backward from the current insertion cursor position
  
  if {[set focus [.f2.f22.cv focus]] != ""} {
    set text  [lindex [.f2.f22.cv itemconfigure $focus -text] 4]
    for {set i [expr "[.f2.f22.cv index $focus insert] - 1"]} \
      {$i > 0} {incr i -1} {
	if {$char == [string index $text $i]} {
	  return $i
	}
      }
  }
  return -1
}

proc ct_move_forward_orEnd {n} {

  set focus [.f2.f22.cv focus]
  set start [.f2.f22.cv index $focus insert]
  set end [expr $start + $n]
  set text  [lindex [.f2.f22.cv itemconfigure $focus -text] 4]

  for { set pos $start } {[expr {$pos < $end}]} {incr pos 1} {
    if { [string index $text $pos] != "\n" } {
      ct_forward_char 1
    } else {
      return
    }
  }
}

################################################################
####		   moving in the text                       ####
################################################################

proc ct_insert_char {char} {
  .f2.f22.cv insert [.f2.f22.cv focus] insert $char
}

proc ct_beginning_of_text {} {
  .f2.f22.cv icursor [.f2.f22.cv focus] 0
}

proc ctEnd_of_text {} {
  .f2.f22.cv icursor [.f2.f22.cv focus] end
}

proc ct_forward_char {n} {
  set focus [.f2.f22.cv focus]
  set position [.f2.f22.cv index $focus insert]
  .f2.f22.cv icursor $focus [expr $position + $n]
}

proc ct_backward_char {n} {
  set focus [.f2.f22.cv focus]
  set position [.f2.f22.cv index $focus insert]
  .f2.f22.cv icursor $focus [expr $position - $n]
}

proc ct_delete_char {} {
  set focus [.f2.f22.cv focus]
  set position [.f2.f22.cv index $focus insert]
  .f2.f22.cv dchar $focus [expr $position]
}

proc ct_backward_delete_char {} {
  set focus [.f2.f22.cv focus]
  set position [.f2.f22.cv index $focus insert]
  .f2.f22.cv dchars $focus [expr $position - 1]
}

proc ct_kill_line {} {
  set text [lindex [.f2.f22.cv itemconfigure [.f2.f22.cv focus] -text] 4]
  set ins [.f2.f22.cv index [.f2.f22.cv focus] insert]
  if {[string index $text $ins] == "\n"} {
    .f2.f22.cv dchars [.f2.f22.cv focus] $ins
  } else {
    .f2.f22.cv dchars [.f2.f22.cv focus] $ins [expr "[ct_search_forward_char "\n"] - 1"]
  }
}

proc ct_beginning_of_line {} {
  set nindex [ ct_search_backward_char "\n" ]
  ct_move_to_char [expr {[expr $nindex] + 1}]
}

proc ctEnd_of_line {} {
  set nindex [ ct_search_forward_char "\n" ]      
  ct_move_to_char [expr $nindex]
}

proc ct_next_line {} {
  set offset [ct_cursor_position_in_line]
  ctEnd_of_line
  ct_forward_char 1
  ct_move_forward_orEnd [expr $offset -1]
}

proc ct_previous_line {} {
  set offset [expr [ct_cursor_position_in_line] - 1]
  ct_beginning_of_line
  ct_backward_char 1
  ct_beginning_of_line
  ct_move_forward_orEnd $offset
}

################################################################
####	 emacs-like bindings for the text items             ####
################################################################

proc bind_item_emacs_like { item } {

  #  Abort object creation  #
  .f2.f22.cv bind $item <Control-g>  {
    .f2.f22.cv dchars inCreation 0 end
    switch $CurrentMode {
      TextMode { createEnd_hook }
    }
  }
  
  .f2.f22.cv bind $item <KeyPress>   { ct_insert_char %A }
  .f2.f22.cv bind $item <Control-d>  { ct_delete_char }
  .f2.f22.cv bind $item <Delete>     { ct_backward_delete_char }
  .f2.f22.cv bind $item <BackSpace>  { ct_backward_delete_char }
  .f2.f22.cv bind $item <Control-k>  { ct_kill_line }
  .f2.f22.cv bind $item <Control-n>  { ct_next_line }
  .f2.f22.cv bind $item <Control-p>  { ct_previous_line }
  .f2.f22.cv bind $item <Control-a>  { ct_beginning_of_line }
  .f2.f22.cv bind $item <Control-e>  { ctEnd_of_line }
  .f2.f22.cv bind $item <Control-f>  { ct_forward_char 1 }
  .f2.f22.cv bind $item <Control-b>  { ct_backward_char 1 }
  .f2.f22.cv bind $item <Meta-a>     { ct_beginning_of_text }
  .f2.f22.cv bind $item <Meta-e>     { ctEnd_of_text }
  .f2.f22.cv bind $item <Return>     { ct_insert_char "\n" }
  
  # Macintosh like bindings
  .f2.f22.cv bind $item <Right>		{ ct_forward_char 1 }
  .f2.f22.cv bind $item <Left>		{ ct_backward_char 1 }
  .f2.f22.cv bind $item <Down>		{ ct_next_line }
  .f2.f22.cv bind $item <Up>			{ ct_previous_line }
}
