# rcsid {$Id: pictclX.tcl,v 4.8 1996/05/17 14:16:51 mangin Rel $}
#
# This package is free software. Redistribution and use of this file
# are permitted without restrictions.
#
# THIS SOFTWARE IS PROVIDED ``AS IS'' AND WITHOUT ANY EXPRESS OR
# IMPLIED WARRANTIES, INCLUDING, WITHOUT LIMITATION, THE IMPLIED
# WARRANTIES OF MERCHANTIBILITY AND FITNESS FOR A PARTICULAR PURPOSE.
#
#	Frank Mangin
#	Frank.Mangin@ceram.fr  -  Frank.Mangin@sophia.inria.fr

##
##  Picasso
##
##  Various little extensions
##  Once written in C, now in tcl for Mac portability
##

##
## Returns the portion of a string following
## the first occurence of a given character.
##

proc ctail {c s} {
  return [string range $s [expr 1 + [string first $c $s]] end]
}

##
## Builds a list made of elt repeated num times
##
proc mklist {elt num} {
  set l {}
  while {$num > 0} {
    lappend l "$elt"
    incr num -1
  }
  return $l
}

##
## Remove matching elements from a variable
##

proc lvarrm {l re} {
  upvar $l loclist
  set oldlist $loclist
  set loclist {}
  set removed {}
  foreach elt $oldlist {
    if {[string match $re $elt]} {
      lappend removed $elt
    } else {
      lappend loclist $elt
    }
  }
  return $removed
}


##
## Remove duplicate elements of a list
##

proc lrmdups {l} {
  set res {}
  foreach elt $l {
    if {[lsearch -exact $res $elt] < 0} {
      lappend res $elt
    }
  }
  return $res
}

##
## From tclX
##
proc abs {val} {
  set res [expr $val]
  if {$res >= 0}{
    return $res
  } else {
    return [expr - $res]
  }
}

proc lfind {l re} {
  set res {}
  foreach elt $l {
    if {[string match $re "$elt"]} {
      lappend res "$elt"
    }
  }
  return $res
}


##
## From tclX
##
proc lvarpop {var args} {
  upvar $var varloc
  if {[llength $args] == 0} {
    set idx 0
  } else {
    set idx [lindex $args 0]
  }
  set res [lindex $varloc $idx]
  if {[llength $args] == 2} {
    set varloc [lreplace $varloc $idx $idx [lindex $args 1]]
  } else {
    set varloc [lreplace $varloc $idx $idx]
  }
  return $res
}

##
## From tclX
##
proc lassign {list args} {
  set i 0
  foreach var $args {
    upvar $var loc
    set loc [lindex $list $i]
    incr i
  }
}


##
## From tclX
##
proc translit {c1 c2 str} {
  set l [split $str $c1]
  return [join $l $c2]
}

##
## Extends the "canvas find withtag" mechanism
##   to find items with all the specified tags
##
proc findwtags {canvas args} {
  if {[llength $args] == 0} {
    return [$canvas find withtag all]
  }
  set ids1 [$canvas find withtag [lvarpop args]]
  set okids {}
  foreach id $ids1 {
    set idok 1
    set idtags [$canvas gettags $id]
    foreach tag $args {
      if {[lsearch -exact $idtags $tag] < 0} {
	set idok 0
	break
      }
    }
    if {$idok} { lappend okids $id }
  }
  
  return $okids
}

