# rcsid {$Id: picrc.tcl,v 4.18 1996/05/21 17:06:22 mangin Rel $}
# This package is free software. Redistribution and use of this file
# are permitted without restrictions.
#
# THIS SOFTWARE IS PROVIDED ``AS IS'' AND WITHOUT ANY EXPRESS OR
# IMPLIED WARRANTIES, INCLUDING, WITHOUT LIMITATION, THE IMPLIED
# WARRANTIES OF MERCHANTIBILITY AND FITNESS FOR A PARTICULAR PURPOSE.
#
#	Frank Mangin
#	Frank.Mangin@ceram.fr  -  Frank.Mangin@sophia.inria.fr

################################################################
####	       Picasso customization file                   ####
################################################################

######## READ THIS -- READ THIS -- READ THIS ########

# This file contains tcl variable assignments, i.e. lines of the
# following pattern:
#     set <varname> <value>
# This pattern can be splitted across several lines provided newlines
# are escaped
# All you should modify is the <value> part. <value> is a list of
#   space-separated elements, enclosed in braces.
# You can change the number of elements of lists. For further
#   details, see the tcl manual.

# To override the value of a variable:

####   DON'T FORGET THIS   ####
# - uncomment the lines concerning this variable by removing leading '#'
#     characters

# - modify the value as you like.

# You will have to restart Picasso to have your
# changes take effect

####   MORE CUSTOMIZATION   ####

# This file is a tcl source file, read by picasso using the "source"
# command (see Tcl documentation). You are free to include in this
# file as much tcl code as you want.
# This file is sourced at the very
#   start of the application, before widget creation.

# The procedure "SetupEndHook" is called once setup has been
#   performed, just before starting event loop processing

################################
####    Global variables    ####
################################
# The following variables are used to configure picasso. They can't be
#   modified interactively.

########  Size of the drawing area  ########
# These variables specify the dimensions of the drawing area
# Dimension are floating-point numbers followed by an optional letter
#   (no white space allowed) specifying the unit, e.g.:
# 123  ==  123 pixels
# 10.5i ==  1.5 inch
# Known units are pixels (no letter) millimeters (letter m),
#   centimeters (letter c), inches (letter i), and printer points
#   (letter p).

set drawAreaWidth   21.0c
set drawAreaHeight  29.7c

########  Temporary file directory  ########

switch -- $tcl_platform(platform) {
  macintosh { set TmpDir [file join "$env(SYS_FOLDER)" ":Temporary Folder"] }
  unix { set TmpDir "/tmp" }
}

########  List of directories to search for bitmap files  ########

set bitmapPath {bitmaps}

########  Line widths  ########
# Available line widths in pixels

set theLineWidth {1 2 3 4}

########  Stipple bitmaps  ########
#  for each <name> in the list below,  
#  each dir in bitmapPath defined above is searched 
#  for a bitmap file <name> or <name>.xbm  

set theStipples {stipple0 stipple1 stipple2 stipple3 stipple4 \
  stipple5 stipple6 stipple7}

option add *highlightThickness 0 startupFile 

################################
####    Key Bindings        ####
################################

# Each binding line is composed of three elements:
# - an event specification (see Tk manual)
# - a Tcl command to execute
# - A mnemonics to display in menus
#
# Procedures that can be used here include:
#    LoadDrawing
#    SaveDrawing
#    SaveDrawingAs
#    WritePostscript
#    Quit
#    Undo
#    Delete
#    Duplicate
#    Configure
#    AlignToGrid
#    SelectAll
#    Group
#    Ungroup
#    Raise
#    Lower

if {$tcl_platform(platform) == "macintosh"} {
  
  set theBindings {
    #  General bindings  #
    {	<Mod1-Z>		{ Undo }		{Z}}
    {	 <Mod1-period>		{ Abort }		{.}}
    {    <Mod1-x>		{ Cut }			{X}}
    {    <Mod1-c>		{ Copy }		{C}}
    {    <Mod1-v>		{ Paste }		{V}}
    {    <Mod1-q>		{ Quit }		{Q}}
    {    <Mod1-s>	      	{ SaveDrawing } 	{S}  }
    #<Control-w>      	{ SaveDrawingAs } 	{^w}
    {    <Mod1-o>	      	{ LoadDrawing }		{O}  }
    #<Control-i>	      	{ IncludeDrawing }	{^i}
    #  Edit bindings  #
    #<Control-r>      	{ Raise }			{^r}
    #<Control-l>		{ Lower }		{^l}
    {    <Mod1-d> 	 	{ Duplicate }		{D}}
    {    <Mod1-a>      	{ SelectAll }		{A}}
    {    <BackSpace>      	{ Delete }		{DEL}}
    {    <Mod1-g>      	{ Group }		{G}}
    {    <Mod1-u>      	{ Ungroup }		{U}}
    #<Control-p>      	{ Configure }		{^p}
    #<Control-period>	{ AlignToGrid }		{^.}
    #  Move  #
    {    <KeyPress-Up>    	{ Move  0 -1 }		{}}
    {    <KeyPress-Down>  	{ Move  0  1 }		{}}
    {    <KeyPress-Right> 	{ Move  1  0 }     	{}}
    {    <KeyPress-Left>  	{ Move -1  0 }		{}}
    #  Mode switching  #
    {    <s>              	{ ChangeMode SelectMode }	{s}}
    {    <j>              	{ ChangeMode ScaleMode }	{j}}
    {    <x>              	{ ChangeMode StretchMode }	{x}}
    {    <t>              	{ ChangeMode TextMode }	{t}}
    {    <l>              	{ ChangeMode LineMode }	{l}}
    {    <r>              	{ ChangeMode RectangleMode}	{r}}
    {    <o>              	{ ChangeMode OvalMode }	{o}}
    {    <c>              	{ ChangeMode CurveMode }	{c}}
    {    <a>              	{ ChangeMode ArcMode }	{a}}
  }
} else {
  set theBindings {
    { <Control-underscore>	{ Undo }		{^_}}
    { <Control-g>		{ Abort }	        {^c}}
    {    <Mod1-x>		{ Cut }			{}}
    {    <Mod1-c>		{ Copy }		{}}
    {    <Mod1-v>		{ Paste }		{}}
    {    <Control-q>      	{ Quit } 		{^q}}
    {    <Control-s>      	{ SaveDrawing } 	{^s}}
    {    <Control-w>      	{ SaveDrawingAs } 	{^w}}
    {    <Control-f>      	{ LoadDrawing }		{^f}}
    {    <Control-i>	{ IncludeDrawing }	{^i}}
    #  Edit bindings  #
    {    <Control-r>      	{ Raise }		{^r}}
    {    <Control-l>  	{ Lower }		{^l}}
    {    <Control-Key-2>  	{ Duplicate }		{^2}}
    {    <Control-a>      	{ SelectAll }		{^a}}
    {    <Control-d>      	{ Delete }		{^d}}
    {    <Control-g>      	{ Group }		{^g}}
    {    <Control-u>      	{ Ungroup }		{^u}}
    {    <Control-p>      	{ Configure }		{^p}}
    {    <Control-period>	{ AlignToGrid }		{^.}}
    {    <Control-w>      	{ Shadow }		{^w}}
    #  Move  #
    {    <KeyPress-Up>    	{ Move  0 -1 }      {}}
    {    <KeyPress-Down>  	{ Move  0  1 }      {}}
    {    <KeyPress-Right> 	{ Move  1  0 }     	{}}
    {    <KeyPress-Left>  	{ Move -1  0 }		{}}
    #  Mode switching  #
    {    <s>              	{ ChangeMode SelectMode }	{s}}
    {    <j>              	{ ChangeMode ScaleMode }	{j}}
    {    <x>              	{ ChangeMode StretchMode }	{x}}
    {    <t>              	{ ChangeMode TextMode }		{t}}
    {    <l>              	{ ChangeMode LineMode }		{l}}
    {    <r>              	{ ChangeMode RectangleMode}	{r}}
    {    <o>              	{ ChangeMode OvalMode }		{o}}
    {    <c>              	{ ChangeMode CurveMode }	{c}}
    {    <a>              	{ ChangeMode ArcMode }		{a}}
  }
}

##################################
########  Mouse bindings  ########
##################################

# First some conventions for portability:
# Picasso needs three distinct mouse event types; 
#   on Unix platforms, we use buttons 1, 2 and 3 
#   on Mac platforms (one-button mouse), we use
#    button, button with Option down, button with Control-Option down
#    Shift is reserved for picasso, don't use here

switch -- $tcl_platform(platform) {
  macintosh {
    set BTypes(Press.1) "ButtonPress-1"
    set BTypes(Press.2) "Mod2-ButtonPress-1"
    #      set BTypes(Press.2) "Double-ButtonPress-1"
    set BTypes(Press.3) "Control-Mod2-ButtonPress-1"
    set BTypes(Release.1) "ButtonRelease-1"
    set BTypes(Release.2) "Mod2-ButtonRelease-1"
    set BTypes(Mod.1) "Button1"
    set BTypes(Mod.2) "Mod2-Button1"
  }
  unix {
    set BTypes(Press.1) "ButtonPress-1"
    set BTypes(Press.2) "ButtonPress-2"
    set BTypes(Press.3) "ButtonPress-3"
    set BTypes(Release.1) "ButtonRelease-1"
    set BTypes(Release.2) "ButtonRelease-2"
    set BTypes(Mod.1) "Button1"
    set BTypes(Mod.2) "Button2"
  }
  default {
    puts stderr "Sorry, this platform isn't supported!"
    exit 1
  }
}

# The procedure defineMouse expects 4 arguments:
#   - the mode in which the binding should apply
#       ("Any" means all modes)
#   - the state in which the binding should apply
#       (see mode dependent definition of state below)
#   - The type of the event
#   - The action to take
#
# Be careful while modifying mouse bindings, it's quite easy to break
#   things here...

####  Bindings common to all modes  ####

defineMouse Any 0 \
  $BTypes(Press.2) \
  { imoveStart $x $y }

defineMouse Any 0 \
  [set BTypes(Mod.2)]-Motion \
  { imoveMotion $x $y }

defineMouse Any 0 \
  $BTypes(Release.2) \
  { imoveEnd }

defineMouse Any 0 \
  Shift-$BTypes(Press.1) \
  { iselectAugment }

defineMouse Any 0 \
  $BTypes(Press.3) \
  { help .f2.f22.cv }

####  Select mode  ####

defineMouse SelectMode 0 \
  $BTypes(Press.2) \
  { imoveSelectionStart $x $y }

defineMouse SelectMode 0 \
  $BTypes(Press.1) \
  { iselect $x $y }

defineMouse SelectMode 0 \
  $BTypes(Mod.1)-Motion \
  { iselectRegion $x $y }

defineMouse SelectMode 0 \
  $BTypes(Release.1) \
  { iselectRegionEnd }

####  Symetry mode  ####

defineMouse SymetryMode 0 \
  $BTypes(Press.1) \
  { symaxeStart $x $y }

defineMouse SymetryMode 0 \
  $BTypes(Mod.1)-Motion \
  { symaxeMotion $x $y }

defineMouse SymetryMode 0 \
  $BTypes(Release.1) \
  { symaxeEnd $x $y }

####  Stretch mode  ####

defineMouse StretchMode 0 \
  $BTypes(Press.1) \
  { iresizeStart $x $y }

defineMouse StretchMode 0 \
  $BTypes(Mod.1)-Motion \
  { iresizeMotion $x $y }

defineMouse StretchMode 0 \
  $BTypes(Release.1) \
  { iresizeEnd }

####  Scale mode  ####

defineMouse ScaleMode 0 \
  $BTypes(Press.1) \
  { iscaleStart $x $y}

defineMouse ScaleMode 0 \
  $BTypes(Mod.1)-Motion \
  { iscaleMotion $x $y }

defineMouse ScaleMode 0 \
  $BTypes(Release.1) \
  { iscaleEnd $x $y }

####  Reshape mode  ####

##  State 0 <==> no handles drawn ##
##  State 1 <==> handles drawn for an object, but no handle is being dragged  ##
##  State 2 <==> a handle is being dragged  ##

defineMouse ReshapeMode {0 1} \
  $BTypes(Press.1) \
  { ishapeTake $x $y }

defineMouse ReshapeMode 2 \
  $BTypes(Press.1) \
  { ishapeAdd $x $y }

defineMouse ReshapeMode 2 \
  $BTypes(Press.2) \
  { ishapeEnd }

defineMouse ReshapeMode 2 \
  $BTypes(Press.3) \
  { ishapeDelete }

defineMouse ReshapeMode 2 \
  Any-Motion \
  { ishapeMotion $x $y }

defineMouse ReshapeMode 2 \
  Motion \
  { ishapeMotion $x $y }

##  Filled and outlined rectangle creation mode  ##

defineMouse {RectangleMode} 0 \
  $BTypes(Press.1) \
  { eval "crectangleStart [pgrid $x $y]" }

defineMouse {RectangleMode} 0 \
  $BTypes(Mod.1)-Motion \
  { eval "crectangleMotion [pgrid $x $y]" }

defineMouse {RectangleMode} 0 \
  $BTypes(Release.1) \
  { csimpleEnd }

####  Oval and circle creation mode  ####

defineMouse OvalMode 0 \
  $BTypes(Press.1) \
  { eval "covalStart [pgrid $x $y]" }

defineMouse OvalMode 0 \
  $BTypes(Mod.1)-Motion \
  { eval "csimpleMotion [pgrid $x $y]" }

defineMouse OvalMode 0 \
  $BTypes(Release.1) \
  { csimpleEnd }

defineMouse OvalMode 0 \
  Shift-$BTypes(Press.1) \
  { eval "ccircleStart [pgrid $x $y]" }

defineMouse OvalMode 0 \
  Shift-$BTypes(Mod.1)-Motion \
  { eval "ccircleMotion [pgrid $x $y]" }

defineMouse OvalMode 0 \
  Shift-$BTypes(Release.1) \
  { csimpleEnd }


####  Arc and Pie slice creation mode  ####
# State 0 <==> no arc is being created
# State 1 <==> arc center has been set
# State 2 <==> first extremity has been set

defineMouse {PieMode ArcMode} {0 1 2} \
  $BTypes(Press.1) \
  { eval "carcStart [pgrid $x $y]" }

defineMouse {PieMode ArcMode} {1 2} \
  Motion \
  { eval "carcMotion [pgrid $x $y]" }

defineMouse {PieMode ArcMode} {1 2} \
  Any-Motion \
  { eval "carcMotion [pgrid $x $y]" }

####  Polyline and spline creation mode  ####
# State 0 <==> no line is being created
# State 1 <==> a line is being created

defineMouse {CurveMode LineMode} {0 1} \
  $BTypes(Press.1) \
  { eval "cpolylineStart [pgrid $x $y]" }

defineMouse {CurveMode LineMode} 1 \
  Motion \
  { eval "cpolylineMotion [pgrid $x $y]" }

defineMouse {CurveMode LineMode} 1 \
  Any-Motion \
  { eval "cpolylineMotion [pgrid $x $y]" }

defineMouse {CurveMode LineMode} 1 \
  $BTypes(Press.2) \
  { cpolylineEnd }

defineMouse {CurveMode LineMode} 1 \
  $BTypes(Press.3) \
  { eval "cpolylineDelete [pgrid $x $y]" }

####  Polygon and closed curve creation mode  ####
# State 0 <==> no polygon is being created
# State 1 <==> a polygon is being created

defineMouse {CloseLineMode CloseCurveMode} {0 1} \
  $BTypes(Press.1) \
  { eval "cpolygonStart [pgrid $x $y]" $CurrentMode }

defineMouse {CloseLineMode CloseCurveMode} 1 \
  $BTypes(Press.2) \
  { cpolygonEnd }

defineMouse {CloseLineMode CloseCurveMode} 1 \
  $BTypes(Press.3) \
  { eval "cpolygonDelete [pgrid $x $y]" $CurrentMode }

defineMouse {CloseLineMode CloseCurveMode} 1 \
  Motion \
  { eval "cpolygonMotion [pgrid $x $y]" }

defineMouse {CloseLineMode CloseCurveMode} 1 \
  Any-Motion \
  { eval "cpolygonMotion [pgrid $x $y]" }

####  Text object creation mode  ####

defineMouse TextMode 0 \
  $BTypes(Press.1) \
  { ctextStart [.f2.f22.cv canvasx $x] [.f2.f22.cv canvasy $y] }

defineMouse TextMode 0 \
  $BTypes(Press.2) \
  { createEnd_hook; imoveStart $x $y }

#######################################
####    Hook called after setup    ####
#######################################

proc SetupEndHook {} {

}
