# rcsid {$Id: picprefs.tcl,v 4.5 1996/05/21 12:20:21 mangin Rel $}
# This package is free software. Redistribution and use of this file
# are permitted without restrictions.
#
# THIS SOFTWARE IS PROVIDED ``AS IS'' AND WITHOUT ANY EXPRESS OR
# IMPLIED WARRANTIES, INCLUDING, WITHOUT LIMITATION, THE IMPLIED
# WARRANTIES OF MERCHANTIBILITY AND FITNESS FOR A PARTICULAR PURPOSE.
#
#	Frank Mangin
#	Frank.Mangin@ceram.fr  -  Frank.Mangin@sophia.inria.fr

##
## Set default preferences, before user preference file is loaded
##

proc initPrefs {} {
  initFontPrefs
}

##
##  Pops up a preference dialog 
##
  
proc editPrefs {} {
  global picPrefFile prefsSButton

  catch {destroy .prefs}
  toplevel .prefs -borderwidth 0
  wm title .prefs {Picasso Preferences}
  wm maxsize .prefs [winfo screenwidth .] [winfo screenheight .]
  wm minsize .prefs 100 100
  set x [expr "20 + [winfo rootx .]"]
  set y [expr "20 + [winfo rooty .]"]
  wm geometry .prefs "+$x+$y"
  
  frame .prefs.ctrlFr
  frame .prefs.sepFr -relief raised -borderwidth 3
  frame .prefs.editFr \
  -width 580 -height 380
  
  ## Fonts
  global fontPref fontAvail
  
  radiobutton .prefs.ctrlFr.fontRd \
  -text "Fonts" \
  -value Fonts -variable prefsSButton \
  -command {
    catch {eval "pack forget [winfo children .prefs.editFr]"}
    pack append .prefs.editFr .prefs.editFr.fontsFr {top expand fill}
  }
  
  frame .prefs.editFr.fontsFr
  label .prefs.editFr.fontsFr.titleLb \
  -text "Choose font to use in:"
  frame .prefs.editFr.fontsFr.f
  frame .prefs.editFr.fontsFr.barFr
  
  foreach class {{mbt "Buttons:"} {menu "Menus:" } {other "Others:"}} {
    lassign $class tag label
    
    label .prefs.editFr.fontsFr.f.${tag}Lb \
    -text $label -anchor e
    foreach attrib {Name Size Weight Slant} {
      menubutton .prefs.editFr.fontsFr.f.${tag}${attrib} \
      -textvariable fontPref(${tag}${attrib}) \
      -menu .prefs.editFr.fontsFr.f.${tag}${attrib}.m
    }
    
    grid .prefs.editFr.fontsFr.f.${tag}Lb \
    .prefs.editFr.fontsFr.f.${tag}Name .prefs.editFr.fontsFr.f.${tag}Size \
    .prefs.editFr.fontsFr.f.${tag}Weight .prefs.editFr.fontsFr.f.${tag}Slant
    grid .prefs.editFr.fontsFr.f.${tag}Lb -sticky e
  }

  pack append .prefs.editFr.fontsFr \
    .prefs.editFr.fontsFr.titleLb {top frame w} \
    .prefs.editFr.fontsFr.f {top fill} \
    .prefs.editFr.fontsFr.barFr {top expand fillx frame s}
  
  button .prefs.editFr.fontsFr.barFr.applyBt \
    -text {Apply} -relief raised \
    -command { applyFontPrefs }
  button .prefs.editFr.fontsFr.barFr.saveBt \
    -text {Save} -relief raised \
    -command { SavePrefs }
  button .prefs.editFr.fontsFr.barFr.doneBt \
    -text {Done} -relief raised \
    -command { destroy .prefs }

  pack append .prefs.editFr.fontsFr.barFr \
    .prefs.editFr.fontsFr.barFr.applyBt {left expand} \
    .prefs.editFr.fontsFr.barFr.saveBt {left expand} \
    .prefs.editFr.fontsFr.barFr.doneBt {left expand}
  
  # Font attributes menus

  foreach attrib {Name Size Weight Slant} {
    foreach class {mbt menu other} {
      menu .prefs.editFr.fontsFr.f.${class}${attrib}.m
      foreach item $fontAvail($attrib) {
        .prefs.editFr.fontsFr.f.${class}${attrib}.m add \
        radiobutton -variable fontPref(${class}${attrib}) \
        -value "$item" -indicatoron 0 \
        -label "$item"
      }
    }
  }

  pack append .prefs.ctrlFr \
    .prefs.ctrlFr.fontRd {top}
  
  pack propagate .prefs.editFr 0
  pack append .prefs \
  .prefs.ctrlFr {left fill} \
  .prefs.sepFr {left fill padx 6 } \
  .prefs.editFr  {left expand fill}
  
  .prefs.ctrlFr.fontRd invoke
}

#############################
##
##  Font preferences handling
##
#############################

##
## Fonts default preferences
##

proc initFontPrefs {} {
  global fontPref fontAvail tcl_platform

  findAvailableFonts

  if {[lsearch -exact $fontAvail(Name) "Espy Sans"] >= 0} {
    set name "Espy Sans"
  } else {
    set name "Helvetica"
  }

  if {$tcl_platform(platform) == "unix"} {
    set size 12
  } else {
    set size 10
  }

  array set fontPref {
    menuClass Menu
    menuOption {*Menu.Font}
    mbtClass  Menubutton
    mbtOption {*Menubutton.Font *Button.Font}
    otherClass *
    otherOption {*Font}
  }    

  foreach class {menu mbt other} {
    array set fontPref [list \
      ${class}Name "$name" \
      ${class}Size $size \
      ${class}Slant roman ]
  }

  array set fontPref {
    menuWeight medium
    otherWeight medium
    mbtWeight bold
  }
}

##
## After preferences have been loaded
##

proc setupFonts {} {
  global fontPref currentFont
  
  ## Store prefs in option database
  foreach class {other menu mbt} {
    foreach opt $fontPref(${class}Option) {
      option add $opt \
      "-*-$fontPref(${class}Name)-$fontPref(${class}Weight)-[string range $fontPref(${class}Slant) 0 0]-normal--$fontPref(${class}Size)-*-*-*-*-*-*-*" startupFile
    }
  }

  set currentFont "-*-$fontPref(otherName)-$fontPref(otherWeight)-[string range $fontPref(otherSlant) 0 0]-normal--$fontPref(otherSize)-*-*-*-*-*-*-*"

  update
}

##
## Find all available fonts on this system,
##   and split by Family, size, weight, and slant
##

proc findAvailableFonts {} {
  global fontAvail tcl_platform

  if {$tcl_platform(platform) == "macintosh"} {
    set fontAvail(Name)   {"Espy Sans" times helvetica symbol }
  } else {
    set fontAvail(Name)   {times helvetica symbol }
  }
  
  set fontAvail(Size)   { 9 10 12 14 18 24 34 }
  set fontAvail(Weight) { medium bold }
  set fontAvail(Slant)  { roman italic }
}

##
##  Apply prefs dialog settings to widget hierarchy
##

proc applyFontPrefs {} {
  global fontPref

  waitCursor
  foreach tag {mbt menu other} {
    set fontSpec($tag) "-*-$fontPref(${tag}Name)-$fontPref(${tag}Weight)-[string range $fontPref(${tag}Slant) 0 0]-*-*-$fontPref(${tag}Size)-*-*-*-*-*-*-*"
    foreach opt $fontPref(${tag}Option) {
      option add $opt "$fontSpec($tag)"
    }
  }

  rsetFontPrefs [list [list Menu "$fontSpec(menu)"] \
    [list Menubutton "$fontSpec(mbt)"] [list * "$fontSpec(other)"]] .

  update
  restoreCursor
}

##
##  Recursively change font on widgets whose class name matches specs
##

proc rsetFontPrefs {specs args} {
  foreach w $args {
    foreach spec $specs {
      if {[string match [lindex $spec 0] [winfo class $w]]} {
	catch {$w configure -font [lindex $spec 1]}
	break;
      }
    }
    eval "rsetFontPrefs [list $specs] [winfo children $w]"
  }
}

##
##  Saving font preferences
##

proc writeFontPrefs {} {
  global fontPref

  set res "
##
## Font preferences
##
"
  append res "array set fontPref {
"
  foreach class {menu mbt other} {
    foreach attrib {Name Size Weight Slant} {
    append res "  ${class}${attrib}	\"$fontPref(${class}${attrib})\"
"
    }
  }
  append res "}
"
  return $res
}

#########################
##
##  Saving preferences
##
#########################

##
## Open the user preference file for writing
##   then call each section save proc in turn
##

proc SavePrefs {} {
  global picPrefFile

  if {[catch {open "$picPrefFile" w} stout]} {
    MessageBox "Couldn't open your preference file \n\"$picPrefFile\" for writing:\n\n $errorInfo\n"
    return
  }

  puts $stout [writeFontPrefs]
  close $stout
}
