# rcsid {$Id: picobj.tcl,v 4.11 1996/05/21 16:15:05 mangin Rel $}
# This package is free software. Redistribution and use of this file
# are permitted without restrictions.
#
# THIS SOFTWARE IS PROVIDED ``AS IS'' AND WITHOUT ANY EXPRESS OR
# IMPLIED WARRANTIES, INCLUDING, WITHOUT LIMITATION, THE IMPLIED
# WARRANTIES OF MERCHANTIBILITY AND FITNESS FOR A PARTICULAR PURPOSE.
#
#	Frank Mangin
#	Frank.Mangin@ceram.fr  -  Frank.Mangin@sophia.inria.fr

################################################################
####		    Object creation                         ####
################################################################

####  Start Creation Hook  ####

proc createStart_hook {} {
  focus .f2.f22.cv
  grab set .f2.f22.cv
}

####  End creation hook  ####

proc createEnd_hook {} {

  grab release .f2.f22.cv
  .f2.f22.cv focus {}

  foreach item [.f2.f22.cv find withtag inCreation] {
    
    ##  Minimal size checking  ##
    switch [.f2.f22.cv type $item] {
      text {
	if {[.f2.f22.cv index $item 0] == [.f2.f22.cv index $item end]} {
	  .f2.f22.cv delete $item
	  continue
	}	
      }
      default {
	lassign [.f2.f22.cv bbox $item] x1 y1 x2 y2
	if {([expr "abs($x1-$x2)"] < 4) && ([expr "abs($y1-$y2)"] < 4)} {
	  .f2.f22.cv delete $item
	  continue
	}
      }
    }
     
    ##  init group tags  ##
    set tags [.f2.f22.cv gettags $item]
    if {[lsearch -glob $tags tGr*] < 0} {
      lappend tags "tGr.$item" "Gr.$item"
      .f2.f22.cv itemconfigure $item -tags $tags
    }
  }

  ## Prepare undo
  global undoCommand
  set undoCommand ".f2.f22.cv delete [.f2.f22.cv find withtag inCreation]"

  ##  Select created objects  ##
  .f2.f22.cv dtag all s
  .f2.f22.cv dtag all sOfr
  .f2.f22.cv addtag s withtag inCreation
  .f2.f22.cv addtag sOfr withtag inCreation
  .f2.f22.cv dtag all inCreation
  redrawFrames
  focus .
  canUndo
}

####  Generic functions for line, rectangle, oval and such  ####

proc csimpleMotion {x y} {
  dragMotion inCreation $x $y
}

proc csimpleEnd {} {
  createEnd_hook
}

################################################################
####			  Text                              		####
################################################################

set FontStyle [option get . font Font]
set FontSize  10

proc setFontStyle {style} {
  global FontStyle FontSize

  set FontStyle $style
  regsub {<SIZE>} "$FontStyle" "$FontSize" name
  SetStyle font $name
}

proc setFontSize {size} {
  global FontStyle FontSize

  set FontSize $size
  regsub {<SIZE>} "$FontStyle" "$FontSize" name
  SetStyle font $name
}

proc ctextStart {x y} {

  global currentStyle
  
  set inc [.f2.f22.cv find withtag inCreation]
  set cur [.f2.f22.cv find withtag current]
  
  if {($inc != "") && ($inc != $cur)} {
    # an item is in creation and user clicked elsewhere #
    # => end creation #
    createEnd_hook
    return
  }

  if {($inc != "") && ($inc == $cur)} {
    # user clicked in the text item he's creating #
    .f2.f22.cv icursor $cur @$x,$y
    return
  }

  ##  No item was being created  ##

  if {[.f2.f22.cv type $cur] == "text"} {
    #  user wants to modify an old item  #
    deselect_all
    .f2.f22.cv addtag inCreation withtag $cur
    createStart_hook
    # in case item comes from a loaded drawing #
    bind_item_emacs_like $cur
    .f2.f22.cv focus $cur
    .f2.f22.cv icursor $cur @$x,$y
    return
  }
  
  ## New item creation ##

  createStart_hook
  deselect_all
  focus .f2.f22.cv
  set created [eval ".f2.f22.cv create text $x $y $currentStyle(text) \
		 -tags {inCreation}"]
  
  .f2.f22.cv focus $created
  bind_item_emacs_like $created
}

####  Rectangle  ####

proc crectangleStart {x y} {
  global currentStyle
  global CurrentMode
  global xdragOrigin ydragOrigin

  set xdragOrigin $x
  set ydragOrigin $y

  createStart_hook
  deselect_all
  eval ".f2.f22.cv create rectangle \
  $x $y $x $y \
  $currentStyle(rectangle) \
  -tags {inCreation}"
}

proc crectangleMotion {x y} {
  global CurrentMode
  global xdragOrigin ydragOrigin
  
  set id [.f2.f22.cv find withtag inCreation]
  .f2.f22.cv coords $id \
    $xdragOrigin $ydragOrigin $x $y
}

####  Generic functions for polygons and closed curves  ####

set ModeState 0
set NumPoints 0

proc cpolygonStart {x y type} {
  global ModeState NumPoints currentStyle
  
  switch $NumPoints {
    0 {
      #  create a temporary line  #
      createStart_hook
      deselect_all
      set ModeState 1
      set NumPoints 2
      eval ".f2.f22.cv create line $x $y $x $y \
            -fill red \
            -tags {inCreation}"
    }
    1 {
      error "Bug..."
    }
    2 {
      #  replace the temporary line by the polygon  #
      incr NumPoints
      set coords [.f2.f22.cv coords inCreation]
      .f2.f22.cv delete withtag inCreation
      eval ".f2.f22.cv create polygon \
              $coords [lrange $coords 2 3] \
              $currentStyle(polygon) \
              -tags {inCreation}"
      if {$type == "CloseCurveMode"} {
	.f2.f22.cv itemconfigure inCreation -smooth 1
      }
    }
    default {
      incr NumPoints
      set it [.f2.f22.cv find withtag inCreation]
      set cc [.f2.f22.cv coords $it]
      set last [expr "[llength $cc] - 5"]
      eval ".f2.f22.cv coords $it [lrange $cc 0 $last] $x $y $x $y"
    }
  }
}

proc cpolygonDelete {x y type} {
  global ModeState NumPoints currentStyle
  
  if {$NumPoints > 3} {
    incr NumPoints -1
    set it [.f2.f22.cv find withtag inCreation]
    set cc [.f2.f22.cv coords $it]
    set last [expr "[llength $cc] - 5"]
    eval ".f2.f22.cv delete $it"
    eval ".f2.f22.cv create polygon \
            [lrange $cc 0 $last] \
            $currentStyle(polygon) \
            -tags {inCreation}"
    if {$type == "CloseCurveMode"} {
      .f2.f22.cv itemconfigure inCreation -smooth 1
    }
    update
    cpolygonMotion $x $y
  } else {
    if {$ModeState} {
      set ModeState 0
      set NumPoints 0
      .f2.f22.cv delete inCreation
      createEnd_hook
    }
  }
}

proc cpolygonMotion {x y} {
  global ModeState NumPoints
  
  if {$ModeState} {
    set it [.f2.f22.cv find withtag inCreation]
    set cc [.f2.f22.cv coords $it]
    set last [expr "[llength $cc] - 3"]
    
    ##  polygon automatically adds start coordinates  ##
    ##  at the end of the coord list  ##
    if {$NumPoints > 2} {
      incr last -2
    }
    eval ".f2.f22.cv coords $it [lrange $cc 0 $last] $x $y"
  }
}

proc cpolygonEnd {} {
  global ModeState NumPoints

  if {$NumPoints <= 2} {
    .f2.f22.cv delete inCreation
  } else {
    createEnd_hook
  }
  set ModeState 0
  set NumPoints 0
}

####  Generic functions for polylines and curves  ####

set ModeState 0
set NumPoints 0

proc cpolylineStart {x y} {
  global ModeState NumPoints
  global currentStyle CurrentMode

  if {$ModeState == 0} {
    createStart_hook
    deselect_all
    set ModeState 1
    set  NumPoints 2
    eval ".f2.f22.cv create line $x $y $x $y \
            $currentStyle(line) \
            -tags {inCreation}"
  } else {
    incr NumPoints
    set it [.f2.f22.cv find withtag inCreation]
    if {$CurrentMode == "CurveMode"} {
      .f2.f22.cv itemconfigure $it -smooth 1
    }
    set cc [.f2.f22.cv coords $it]
    set last [expr "[llength $cc] - 2"]
    eval ".f2.f22.cv coords $it [lreplace $cc $last end $x $y $x $y]"
  }
}

proc cpolylineDelete {x y} {
  global ModeState NumPoints CurrentMode

  if {$NumPoints > 2} {
    incr NumPoints -1
    set it [.f2.f22.cv find withtag inCreation]
    set cc [.f2.f22.cv coords $it]
    set last [expr "[llength $cc] - 3"]
    eval ".f2.f22.cv coords $it [lrange $cc 0 $last]"
    if {($NumPoints == 2) &&
      ($CurrentMode == "CurveMode")} {
	.f2.f22.cv itemconfigure $it -smooth 0
      }
  } else {
    if {$ModeState == 1} {
      set ModeState 0
      set NumPoints 0
      .f2.f22.cv delete inCreation
      createEnd_hook
    }
  }
}

proc cpolylineMotion {x y} {
  global ModeState CurrentMode
  
  if {$ModeState > 0} {
    set it [.f2.f22.cv find withtag inCreation]
    set cc [.f2.f22.cv coords $it]
    set last [expr "[llength $cc] - 2"]
    eval ".f2.f22.cv coords $it [lreplace $cc $last end $x $y]"
  }
}

proc cpolylineEnd {} {
  global ModeState NumPoints CurrentMode
  
  if {$CurrentMode == "CurveMode"} {
    .f2.f22.cv itemconfigure inCreation -smooth 1
  }
  set ModeState 0
  set NumPoints 0
  createEnd_hook
}

####  Oval  ####

proc covalStart {x y} {
  global x1fixed y1fixed
  global currentStyle
  global CurrentMode

  createStart_hook
  deselect_all
  set x1fixed 1
  set y1fixed 1
  
  set item [eval ".f2.f22.cv create oval $x $y $x $y \
                    $currentStyle(oval) \
                    -tags {inCreation}"]
}

####  Circles  ####

#  Only the motion function is changing  #

proc ccircleStart {x y} {
  return [covalStart $x $y]
}

proc ccircleMotion {x y} {
  global x1fixed y1fixed
  ##  Get the smallest from dx and dy  ##
  set bb [.f2.f22.cv coords inCreation]
  if {$x1fixed} {
    set xbase [lindex $bb 0]
  } else {
    set xbase [lindex $bb 2]
  }
  if {$y1fixed} {
    set ybase [lindex $bb 1]
  } else {
    set ybase [lindex $bb 3]
  }
  if {[expr "(abs($x - $xbase)) > (abs($y - $ybase))"]} {
    dragMotion inCreation $x [expr "$ybase + $x - $xbase"]
  } else {
    dragMotion inCreation [expr "$xbase + $y - $ybase"] $y
  }
}

####  Arc  ####

##  Arcs are created by <1> once to set the center, second <1>  ##
##  to set first extremity, and third <1> to set second extremity  ##

set ModeState 0
set rad2deg [expr "180 / 3.14159"]

##  Utils  ##

proc angle {x1 y1 x2 y2} {
  global rad2deg
  ##  retourne l'angle en degre du vecteur M1M2  ##
  return \
    [expr "$rad2deg * atan2(-$y2+$y1,$x2-$x1)"]
}

proc computeArcCoords {id} {
  #  given id config, computes circle center and  #
  #  first arc extremity coords  #

  global ArcCoords rad2deg
  lassign [.f2.f22.cv coords $id] bbx1 bby1 bbx2 bby2
  set rayon [abs [expr 0.5 * ($bbx2 - $bbx1)]]
  set xc [expr 0.5 * ($bbx2 + $bbx1)]
  set yc [expr 0.5 * ($bby2 + $bby1)]
  set alpha [expr [lindex [.f2.f22.cv itemconfigure $id -start] 4] / $rad2deg]
  set x1 [expr $xc + $rayon * [cos $alpha]]
  set y1 [expr $yc - $rayon * [sin $alpha]]

  set ArcCoords($id) "$rayon $xc $yc $x1 $y1"
  return $ArcCoords($id)
}

##  Creation  ##

proc carcStart {x y} {
  global currentStyle
  global ModeState CurrentMode
  
  switch $ModeState {
    0 {
      saveMsg
      msg "Set first extremity with mouse button 1"
      createStart_hook
      deselect_all
      ##  set center ##
      .f2.f22.cv create line $x $y $x $y \
	-width 1 -fill red \
	-tags {carcl1 ctl}
      incr ModeState
    }
    1 {
      ##  set first arc extremity  ##
      msg "Set second extremity with mouse button 1"
      lassign [.f2.f22.cv coords carcl1] xc yc
      incr ModeState
      
      .f2.f22.cv create line $xc $yc $x $y \
	-width 1 -fill red \
	-tags {carcl2 ctl}
      
      set dx [expr "$x - $xc"]
      set dy [expr "$y - $yc"]
      set rayon [expr "sqrt($dx*$dx + $dy*$dy)"]
      
      switch $CurrentMode {
	ArcMode {
	  set id [eval ".f2.f22.cv create arc \
	         [expr "$xc - $rayon"] [expr "$yc - $rayon"] \
	         [expr "$xc + $rayon"] [expr "$yc + $rayon"] \
	         -style arc \
                 -start [angle $xc $yc $x $y] \
	         -extent 0 \
                 $currentStyle(arc) \
                 -tags {inCreation}"]
	}
	PieMode {
	  set id [eval ".f2.f22.cv create arc \
	         [expr "$xc - $rayon"] [expr "$yc - $rayon"] \
	         [expr "$xc + $rayon"] [expr "$yc + $rayon"] \
	         -style pieslice \
                 -start [angle $xc $yc $x $y] \
	         -extent 0 \
                 $currentStyle(pieslice) \
                 -tags {inCreation}"]
	}
      }

      global ArcCoords
      set ArcCoords($id) "$rayon $xc $yc $x $y"
    }
    2 {
      ## set second extremity and terminate creation ##
      restoreMsg
      set id [.f2.f22.cv find withtag inCreation]

      lassign [.f2.f22.cv coords carcl1] xc yc x1 y1

      .f2.f22.cv delete carcl1
      .f2.f22.cv delete carcl2
      
      .f2.f22.cv itemconfigure $id \
	-extent [expr "[angle $xc $yc $x $y]-[angle $xc $yc $x1 $y1]"]
      
      set ModeState 0
      createEnd_hook
    }
  }
}

proc carcMotion {x y} {
  global ModeState
  
  switch $ModeState {
    0 {}
    1 {
      eval ".f2.f22.cv coords carcl1 \
        [lrange [.f2.f22.cv coords carcl1] 0 1] \
        $x $y"
    }
    2 {
      
      set bb [.f2.f22.cv coords carcl1]
      if {$bb == ""} {
	set ModeState 0
	.f2.f22.cv delete inCreation
	.f2.f22.cv delete carcl1
	.f2.f22.cv delete carcl2
	return
      }
      
      lassign $bb xc yc x1 y1
      
      eval ".f2.f22.cv coords carcl2  \
            [lrange [.f2.f22.cv coords carcl2] 0 1] $x $y"
      .f2.f22.cv itemconfigure inCreation \
	-extent [expr "[angle $xc $yc $x $y]-[angle $xc $yc $x1 $y1]"]
    }
  }
}

