# rcsid {$Id: picimage.tcl,v 4.21 1996/05/21 16:15:02 mangin Rel $}
# This package is free software. Redistribution and use of this file
# are permitted without restrictions.
#
# THIS SOFTWARE IS PROVIDED ``AS IS'' AND WITHOUT ANY EXPRESS OR
# IMPLIED WARRANTIES, INCLUDING, WITHOUT LIMITATION, THE IMPLIED
# WARRANTIES OF MERCHANTIBILITY AND FITNESS FOR A PARTICULAR PURPOSE.
#
#	Frank Mangin
#	Frank.Mangin@ceram.fr  -  Frank.Mangin@sophia.inria.fr

proc cimage_dialog { type } {
  global TmpDir
  
  if {$type == "photo"} {
    set formats "GIF or PPM/PGM"
  } else {
    set formats "X bitmap"
  }
    
  ## Get a filename from the user
  
  set file [fsbox 0 "Select an image file\n  ($formats):"]
  if {"$file" == ""} { return }

  waitCursor
  set imname [newImname "$file"]
  
  ## For bitmaps, make our own copy of the file
  if {$type == "bitmap"} {
    if {[catch {open "$file" r} stin]} {
      MessageBox "Couldn't open \"$file\" for reading:\n $stin"
      return
    }
    set data [read $stin]
    close $stin
    set datafile [file join "$TmpDir" "picasso.$imname.xbm"]
    if {[catch {open "$datafile" w} stout]} {
      MessageBox "Couldn't open \"$datafile\" for writing:\n $stout"
      return
    }
    puts $stout $data
    close $stout; unset data
    set file $datafile
  }
  
  ## Create the image

  if {[catch {image create $type "$imname" -file "$file"} err]} {
    MessageBox "$type image creation failed:\n  $err"
    restoreCursor
    update
    return
  }

  ## Compute the image position (center of canvas window)
  lassign [.f2.f22.cv xview] p1 p2
  set x [expr "[.f2.f22.cv cget -width] * 0.5 * ($p1 + $p2)"]
  lassign [.f2.f22.cv yview] p1 p2
  set y [expr "[.f2.f22.cv cget -height] * 0.5 * ($p1 + $p2)"]

  ## Create the canvas image item
  createStart_hook
  .f2.f22.cv create image $x $y -image "$imname" -tags {inCreation}
  
  restoreCursor
  createEnd_hook
  update
  ChangeMode SelectMode
}

##
##  Choose a new, unused image name
##
proc newImname { filename } {

  set base [file tail "$filename"]
  regexp -nocase -- {^[a-z][- a-z_0-9]*} $base imname
  regsub -all -- { } $imname {_} imname
  if {[string length $imname] < 2} {
    set imname image
  }

  set i 1
  while {[lsearch -exact [image names] "$imname"] >= 0} {
    set imname $imname$i
    incr i
  }

  return $imname
}

##
## Returns the list of image names
##   used in the drawing
##

proc getImnames { {types "bitmap photo"} } {
  set names {}
  foreach id [.f2.f22.cv find withtag all] {
    if {[.f2.f22.cv type $id] == "image"} {
      set name [.f2.f22.cv itemcget $id -image]
      if {[lsearch -exact $types [image type $name]] >= 0} {
        if {[lsearch -exact $names $name] < 0} {
          lappend names $name
        }
      }
    }
  }
  return $names
}
      
################################################################
####		   Control functions                        ####
################################################################

proc setSelectionGamma {gamma} {

  global undoCommand; set undoCommand ""
  
  ## Set gamma for selected images
  waitCursor
  foreach id [.f2.f22.cv find withtag s] {
    if {[.f2.f22.cv type $id] == "image"} {
      set name [.f2.f22.cv itemcget $id -image]
      if {[image type $name] == "photo"} {
	append undoCommand "$name config -gamma [$name cget -gamma];"
        $name configure -gamma $gamma
      }
    }
  }
  restoreCursor
  update
  canUndo
}

##
## Zoom the currently select images
##

proc zoomSelection { xratio yratio } {
  # make sure we didn't leave the image option frame
  set ids [.f2.f22.cv find withtag sreal]
  if {$ids == {}} {
    set ids [.f2.f22.cv find withtag s]
  }
  
  # find out selected images
  set ims {}
  foreach id $ids {
    if {[.f2.f22.cv type $id] == "image"} {
      set im [.f2.f22.cv itemcget $id -image]
      if {[image type $im] == "photo"} {
        if {[lsearch -exact $ims $im] < 0} {
          lappend ims $im
        }
      }
    }
  } 
  
  if {[regexp {/([0-9]+)$} $xratio foo xratio]} {
    ## x Subsample
    set xaction "-shrink -subsample"
    set xdir -1
  } elseif {$xratio == 1} {
    set xaction ""; set xdir 0
  } else {
    set xaction "-zoom"; set xdir 1
  }
  
  if {[regexp {/([0-9]+)$} $yratio foo yratio]} {
    ## y Subsample
    set yaction "-shrink -subsample"
    set ydir -1
  } elseif {$yratio == 1} {
    set yaction $xaction; set ydir 0
  } else {
    set yaction "-zoom"; set ydir 1
  }
  
  if {$xaction == ""} { set xaction $yaction }
  if {$xaction == ""} { return }
  
  if {[expr "$xdir * $ydir"] >= 0} {
    # One operation
    foreach im $ims {
      image create photo zoomBuf
      zoomBuf copy $im
      $im blank
      eval "$im copy zoomBuf $xaction $xratio $yratio"
      image delete zoomBuf
    }
  } else {
    # Two step operation
    foreach im $ims {
      image create photo zoomBuf
      eval "zoomBuf copy $im $xaction $xratio 1"
      $im blank
      eval "$im copy zoomBuf $yaction 1 $yratio"
      image delete zoomBuf
    }
  }
  redrawFrames green
  update
  cantUndo
}

    
##
## Show items affected by option settings
##

proc showSelectedIms { {type photo} } {
  set ids [.f2.f22.cv find withtag s]
  .f2.f22.cv addtag sreal withtag s
  .f2.f22.cv dtag all s
  
  set ims {}
  foreach id $ids {
    if {[.f2.f22.cv type $id] == "image"} {
      set im [.f2.f22.cv itemcget $id -image]
      if {[image type $im] == $type} {
        if {[lsearch -exact $ims $im] < 0} {
          lappend ims $im
        }
      }
    } elseif {$type == "bitmap"} {
      .f2.f22.cv addtag s withtag $id
    }
  }
  
  foreach id [.f2.f22.cv find all] {
    if {[.f2.f22.cv type $id] == "image" &&
        [lsearch -exact $ims [.f2.f22.cv itemcget $id -image]] >= 0} {
      .f2.f22.cv addtag s withtag $id
    }
  }
  redrawFrames green 2
  update
}

proc unshowSelectedIms {} {
  if {[.f2.f22.cv find withtag sreal] == {}} {
    return
  }
  
  .f2.f22.cv dtag all s
  .f2.f22.cv addtag s withtag sreal
  .f2.f22.cv dtag all sreal
  redrawFrames
  update
}
