# rcsid {$Id: pichelp.tcl,v 4.8 1996/05/20 07:39:48 mangin Rel $}
# This package is free software. Redistribution and use of this file
# are permitted without restrictions.
#
# THIS SOFTWARE IS PROVIDED ``AS IS'' AND WITHOUT ANY EXPRESS OR
# IMPLIED WARRANTIES, INCLUDING, WITHOUT LIMITATION, THE IMPLIED
# WARRANTIES OF MERCHANTIBILITY AND FITNESS FOR A PARTICULAR PURPOSE.
#
#	Frank Mangin
#	Frank.Mangin@ceram.fr  -  Frank.Mangin@sophia.inria.fr


########  Main Window  ########

set HelpEntries(top) {{Picasso Help} {

  Picasso is an object oriented drawing tool in the style of idraw.

  Besides basic object types like lines or rectangles, Picasso is able to 
  load and manipulate 
  image objects. Supported image formats are those of the Tk photo image type,
  currently GIF and PPM/PGM

  Picasso drawings may be saved and restored, and may also be written in 
  Encapsulated Postscript format, suitable for inclusion by latex.

  ****  Help  ****

  Pressing mouse button 3 anywhere in the application provides help 
  information related to the widget you clicked over. For example, help 
  concerning text objects can be obtained by pressing button 3 over the 
  "text" mode button.

  ****  Global bindings  ****

  Control q     Quit Picasso
  Control s     Save current drawing
  Control w     Save current drawing in specified file
  Control f     Load a new drawing

  Control d 	Delete selected objects
  Control 2 	Duplicate selected objects
  Control p 	Set selected object parameters
  Control a		Select all
  Control g 	Group selected objects together
  Control u 	Ungroup selected groups
  Control r		Raise selected objects
  Control l 	Lower selected objects

  Key UpArrow     Move selected objects 1 pixel upwards
  Key DownArrow   Move selected objects 1 pixel downwards
  Key RightArrow  Move selected objects 1 pixel to the right
  Key LeftArrow   Move selected objects 1 pixel to the left

  **** Group tags resetting ****

  If selection doesn't work normally (e.g. there is an item you can't 
				      select), picasso probably got lost with group tags management. You can 
  reset group tags using the "Group Reset" action in the Edit menu.
  Resetting group tags will also be necessary when loading a drawing saved 
  with picasso version 3.5 or earlier, due to a bug in group tag management.
}}

########  Edit Button  ########

set HelpEntries(top_frame1_editBt) {{Edit Menu Shortcuts} {

  Delete			Control d
  Duplicate			Control 2
  Object Parameters Control p
  Select all		Control a
  Group				Control g
  Ungroup			Control u
  Raise				Control r
  Lower				Control l
}}

########  Image mode button  ########

set entry {{Image Objects} {

  Image objects are created from image files in PPM/PGM or GIF format.
  Once created, an image object is 
  independent of the source image file used to create it.

  ****  Image object control  ****

  zoom & subsampling"

  See the Tk photo image type documentation.

  gamma:
  
  See the Tk photo image type documentation.
}}

set HelpEntries([translit {.} {_} "top[SN ImageMode]"]) $entry
set HelpEntries(top_imloadDg) $entry
set ModeHelp(ImageMode) $entry

########  Control Frame  ########

set HelpEntries(top_optionFr) {{Control Panel} {

  Options set via the control panel are immediately applied to 
  the set of selected objects, and remain in effect for future object 
  creations.
}}

########  Control Button  ########

set HelpEntries(top_optionFr_btf) {{Option set display control} {

  As many option sets as possible are simultaneously displayed in the 
  control panel. Selecting an option set from the "Control" menu causes this 
  set to be displayed first in the panel.
}}

########  Modes  ########

set ModeHelp(SelectMode) {{Select Mode} {

  Select mode bindings:

  ButtonPress-1       	On an object, select this object alone,
  						otherwise deselect all and start region selection

  Shift-ButtonPress-1 	Adds object under the pointer to the
						set of selected objects

  Button-2            	Move the set of selected objects. If over an object,
						moves it along with selected objects.  

  ButtonPress-3			Help

  **** Note ****

  If selection doesn't work normally (e.g. there is an item you can't
	select), picasso probably got lost with group tags management.
  You can reset group tags using the "Group Reset" action in the Edit
  menu.
  Resetting group tags will also be necessary when loading a drawing
    saved with picasso version 3.5 or earlier, due to a bug in group
    tag management.
  
}}

set HelpEntries([translit {.} {_} "top[SN SelectMode]"]) \
  $ModeHelp(SelectMode)

################################################################
####		   Help Box procedure                       ####
################################################################

#  Retrieves the first help entry in the widget hierarchy, starting  #
#  with passed widget in ascending order, and displays it in a popup box  #

proc help {widget} {
  global HelpEntries helpUpList helpDownList

  if {$widget == ""} { set widget {top} }

  set helpUpList [split "top$widget" {.}]
  set helpDownList {}
  
  while {! [info exists HelpEntries([join $helpUpList {_}])]} {
    set helpDownList [linsert $helpDownList 0 [lvartail helpUpList]]
  }
  
  set hentry $HelpEntries([join $helpUpList {_}])
  
  catch {destroy .helpBox}
  toplevel .helpBox -borderwidth 0
  wm geometry .helpBox \
    [expr int(0.6*[winfo screenwidth .])]x[expr int(0.4*[winfo screenheight .])]
  wm title .helpBox {Help box}
  wm maxsize .helpBox [winfo screenwidth .] [winfo screenheight .]
  wm minsize .helpBox 100 100

  label .helpBox.titleLb \
    -relief raised \
    -borderwidth 2 \
    -text "[lindex $hentry 0]"
  
  frame .helpBox.textFr -borderwidth 0

  scrollbar .helpBox.textFr.scrollbar \
    -command {.helpBox.textFr.text yview} \
    -relief raised \
    -borderwidth 2

  text .helpBox.textFr.text \
    -borderwidth 2 \
    -relief raised \
    -wrap word \
    -yscrollcommand {.helpBox.textFr.scrollbar set}

  .helpBox.textFr.text insert 1.0 "[lindex $hentry 1]"
  .helpBox.textFr.text configure -state disabled
  
  pack append .helpBox.textFr \
    .helpBox.textFr.scrollbar {left frame center filly} \
    .helpBox.textFr.text      {top frame center expand fill}

  frame .helpBox.butFr -borderwidth 0

  frame .helpBox.butFr.updownFr -borderwidth 0

  button .helpBox.butFr.updownFr.upBt \
    -relief raised \
    -borderwidth 2 \
    -text {Up} \
    -command { helpUp }

  button .helpBox.butFr.updownFr.downBt \
    -relief raised \
    -borderwidth 2 \
    -text {Down} \
    -command { helpDown }

  pack append .helpBox.butFr.updownFr \
    .helpBox.butFr.updownFr.upBt {left expand fill} \
    .helpBox.butFr.updownFr.downBt {left expand fill}
  
  button .helpBox.butFr.dismissBt \
    -relief raised \
    -borderwidth 2 \
    -text {Dismiss} \
    -command { destroy .helpBox }

  pack append .helpBox.butFr \
    .helpBox.butFr.updownFr {left expand fill} \
    .helpBox.butFr.dismissBt {left expand fill}
  
  pack append .helpBox \
    .helpBox.titleLb {top fill} \
    .helpBox.textFr {top expand fill} \
    .helpBox.butFr {top fill}
}


proc helpUp {} {
  global HelpEntries helpUpList helpDownList

  if {$helpUpList == {top}} { return }

  set helpDownList [linsert 0 $helpDownList [lvartail helpUpList]]

  while {! [info exists HelpEntries([join $helpUpList {_}])]} {
    set helpDownList [linsert $helpDownList 0 [lvartail helpUpList]]
  }

  set hentry $HelpEntries([join $helpUpList {_}])
  .helpBox.titleLb configure -text "[lindex $hentry 0]"

  .helpBox.textFr.text configure -state normal
  .helpBox.textFr.text delete 1.0 end
  .helpBox.textFr.text insert 1.0 "[lindex $hentry 1]"
  .helpBox.textFr.text configure -state disabled
  update
}

proc helpDown {} {
  global HelpEntries helpUpList helpDownList

  if {$helpDownList == ""} { return }

  lappend helpUpList [lvarpop helpDownList]

  while {! [info exists HelpEntries([join $helpUpList {_}])]} {
    if {$helpDownList == ""} { return }
    lappend helpUpList [lvarpop helpDownList]
  }
  set hentry $HelpEntries([join $helpUpList {_}])

  .helpBox.titleLb configure -text "[lindex $hentry 0]"

  .helpBox.textFr.text configure -state normal
  .helpBox.textFr.text delete 1.0 end
  .helpBox.textFr.text insert 1.0 "[lindex $hentry 1]"
  .helpBox.textFr.text configure -state disabled
  update
}

