# rcsid {$Id: picgroup.tcl,v 4.9 1996/05/21 16:15:01 mangin Rel $}
# This package is free software. Redistribution and use of this file
# are permitted without restrictions.
#
# THIS SOFTWARE IS PROVIDED ``AS IS'' AND WITHOUT ANY EXPRESS OR
# IMPLIED WARRANTIES, INCLUDING, WITHOUT LIMITATION, THE IMPLIED
# WARRANTIES OF MERCHANTIBILITY AND FITNESS FOR A PARTICULAR PURPOSE.
#
#	Frank Mangin
#	Frank.Mangin@ceram.fr  -  Frank.Mangin@sophia.inria.fr

set nextGroupId 0

################################################################
####    Bug workaround: the following command allows to     ####
####    reinitialize group tags, ungrouping all objects     ####
################################################################

proc UngroupAll {} {

  .f2.f22.cv delete sFr

  foreach id [.f2.f22.cv find withtag all] {
    set tags [.f2.f22.cv gettags $id]
    lvarrm tags Gr*
    lvarrm tags tGr*
    .f2.f22.cv itemconfigure $id \
      -tags "$tags Gr.$id tGr.$id"
  }
}

################################################################
####  groups selected items, i.e. update the groupList tag  ####
################################################################

proc Group {} {
  global nextGroupId

  set toptags [getTopGroupTags s]
  if {$toptags == ""} {
    warn "No items selected" 2000
    return
  }
  
  set toptags [lrmdups $toptags]
  
  if {[llength $toptags] == 1} {
    warn "Can't group a single item" 2000
    return
  }
  
  ##  add the new group id on head of groupList tag  ##
  ##  for each selected item  ##
  
  set newgid "g[incr nextGroupId]"

  foreach toptag $toptags {
    foreach it [.f2.f22.cv find withtag $toptag] {
      set tags [.f2.f22.cv gettags $it]
      set glist [ctail "." [lvarrm tags "Gr*"]]
      lvarrm tags tGr*
      .f2.f22.cv itemconfigure $it \
	-tags "$tags Gr.$newgid.$glist tGr.$newgid"
    }
  }

  ##  Update selectFrames  ##
  .f2.f22.cv delete sFr
  putFrame "tGr.$newgid"
  ## Prepare undo
  global undoCommand
  set undoCommand "deselect_all;\
    .f2.f22.cv addtag s withtag tGr.$newgid; .f2.f22.cv addtag sOfr withtag tGr.$newgid;\
    Ungroup"
  canUndo
}

##
##  Select  each item in args, the groups them
##

proc selectAndGroup {args} {
  deselect_all
  foreach id $args {
    .f2.f22.cv addtag s withtag $id
    .f2.f22.cv addtag sOfr withtag $id
  }
  Group
}

##################################################################
####  ungroups selected items, i.e. update the groupList tag  ####
##################################################################

proc Ungroup {} {

  set items [.f2.f22.cv find withtag s]
  if {$items == ""} {
    warn "No items selected" 2500
    return
  }

  ##  delete topgroup from groupList tag,  ##
  ##  update topGroup tag,  ##
  ##  and store new top groups  ##
  set newgids {}
  foreach it $items {
    set tags [.f2.f22.cv gettags $it]
    set gid [lfind $tags Gr*]
    set gid [split [ctail . $gid] "."]
    if {[llength $gid] > 1} {
      lvarrm tags Gr*
      lvarrm tags tGr*
      lvarpop gid
      .f2.f22.cv itemconfigure $it \
	-tags "$tags Gr.[join $gid "."] tGr.[lindex $gid 0]"
    }
    lappend newgids [lindex $gid 0]
  }

  ##  put a frame around new top groups  ##
  .f2.f22.cv delete sFr
  foreach gid [lrmdups $newgids] {
    putFrame "tGr.$gid"
  }
  ## Prepare undo
  global undoCommand
  set undoCommand "selectAndGroup $items"
  canUndo
}

##
##  Update group tags, i.e. reset the base gtag to item id, 
##    and generate unique group numbers using nextGroupId   
##  Take care of bound objects (e.g. frame)

proc updateGroupTags {tagOrId} {
  global nextGroupId

  foreach id [.f2.f22.cv find withtag $tagOrId] {
    set tags [.f2.f22.cv gettags $id]
    lvarrm tags tGr*
    set glist [lvarrm tags Gr*]
    set glist [split [ctail . $glist] "."]
    set lastgid [lvartail glist]

    #  First deal with group ids  #
    set newGlist {}
    foreach gid $glist {
      if {[info exists gidLookup($gid)]} {
	set  newGid $gidLookup($gid)
      } else {
	set newGid "g[incr nextGroupId]"
	array set gidLookup [list $gid $newGid]
      }
      lappend newGlist $newGid
    }

    #  Treat the last id  #
    if {[array exists idLookup] && [info exists idLookup($lastgid)]} {
      set newGid $idLookup($lastgid)
    } else {
      set newGid $id
      array set idLookup [list $lastgid $newGid]
    }
    
    lappend newGlist $newGid

    .f2.f22.cv itemconfigure $id \
      -tags "tGr.[lindex $newGlist 0] Gr.[join $newGlist .] $tags"
  }
}

################################################################
####	 Return various group tag infos                     ####
################################################################

proc getGroupListTag {item} {
  return [lfind [.f2.f22.cv gettags $item] Gr*]
}

proc getTopGroupTags {tagOrId} {
  set gtags {}
  foreach it [.f2.f22.cv find withtag $tagOrId] {
    set tags [.f2.f22.cv gettags $it]
    lappend gtags [lfind $tags "tGr*"]
  }
  return [lrmdups $gtags]
}

proc setTopGroup {item gid} {
  set tags [.f2.f22.cv gettags $item]
  set gtag [lfind $tags "tGr*"]
  .f2.f22.cv dtag $item $gtag
  .f2.f22.cv addtag "tGr.$gid" withtag $item
}

