# rcsid {$Id: picgrid.tcl,v 4.11 1996/05/21 16:15:00 mangin Rel $}
# This package is free software. Redistribution and use of this file
# are permitted without restrictions.
#
# THIS SOFTWARE IS PROVIDED ``AS IS'' AND WITHOUT ANY EXPRESS OR
# IMPLIED WARRANTIES, INCLUDING, WITHOUT LIMITATION, THE IMPLIED
# WARRANTIES OF MERCHANTIBILITY AND FITNESS FOR A PARTICULAR PURPOSE.
#
#	Frank Mangin
#	Frank.Mangin@ceram.fr  -  Frank.Mangin@sophia.inria.fr

# $Id: picgrid.tcl,v 4.11 1996/05/21 16:15:00 mangin Rel $
set GridSpacing 5
set GridUnit {mm}
set UnitSuffix(pixel) {}
set UnitSuffix(mm) {m}
set UnitSuffix(cm) {c}
set UnitSuffix(inch) {i}
set UnitSuffix(pica) {p}

#  Third arg to pass to canvas<x|y>  #
set GridSpec ""

set gridEntryVar $GridSpacing

################################################################
####	Returns canvas coordinates according to             ####
####	     gridding mode and grid spacing                 ####
################################################################

proc pgrid {args} {
  global GridSpec

  set res [eval ".f2.f22.cv canvasx [lindex $args 0] $GridSpec"]
  if {![catch {lindex $args 1} y]} {
    lappend res [eval ".f2.f22.cv canvasy $y $GridSpec"]
  }

  return $res
}

################################################################
####		  Toggles grid showing                      ####
################################################################

set ShowingGrid 0

proc toggleShowGrid {} {
  global ShowingGrid

  if {$ShowingGrid} {
    set ShowingGrid 0
    .optionFr.gridFr.showBt configure \
      -text {Show Grid}
    hideGrid
  } else {
    .optionFr.gridFr.showBt configure \
      -text { Hide Grid }
    showGrid
    set ShowingGrid 1 }
}

################################################################
####      Hide grid, i.e. destroys the ruler canvases       ####
################################################################

proc hideGrid {} {
  destroy .f2.frame21
  destroy .f2.f22.gcv
  update
}

################################################################
####       Show grid, i.e. create the rulers canvases       ####
################################################################

proc showGrid {} {

  frame .f2.frame21 -borderwidth 0
  
  frame .f2.frame21.dummy \
    -borderwidth 0 \
    -width 12

  canvas .f2.frame21.gcv \
    -height 12
  
  canvas .f2.f22.gcv \
    -width 12
  
  pack append .f2.frame21 \
    .f2.frame21.dummy {left fill} \
    .f2.frame21.gcv    {left expand fill}

  pack .f2.f22.gcv \
    -before .f2.f22.cv \
    -side left -fill y

  pack .f2.frame21 \
    -before .f2.f22 \
    -side top -fill x

  update
  drawTicks
}

################################################################
####	 Draws the ticks in the ruler canvases              ####
################################################################

proc drawTicks {} {

  .f2.frame21.gcv delete all
  .f2.f22.gcv delete all

  if {[catch {readGridSpacing} gspec]} {
    warn $gspec
  } else {
    set x 0
    set index 0
    .f2.frame21.gcv create line \
      $x 0 $x 9
    while {$x < [.f2.f22.cv cget -width]} {
      incr index
      if {[expr "($index % 5) == 0"]} {
	set len 9
      } else {
	set len 6
      }
      set item [.f2.frame21.gcv create line \
		$x 0 $x $len]
      .f2.frame21.gcv move $item \
	$gspec 0
      set x [lindex [.f2.frame21.gcv coords $item] 0]
    }
    
    set y 0
    set index 0
    .f2.f22.gcv create line \
      0 $y 9 $y
    while {$y < [.f2.f22.cv cget -height]} {
      incr index
      if {[expr "($index % 5) == 0"]} {
	set len 9
      } else {
	set len 6
      }
      set item [.f2.f22.gcv create line \
		0 $y $len $y]
      .f2.f22.gcv move $item \
	0 $gspec
      set y [lindex [.f2.f22.gcv coords $item] 1]
    }
  }

  .f2.frame21.gcv lower \
    [.f2.frame21.gcv create polygon \
     -4 0 4 0 0 11 -fill red -tags {pointerPos}]
  
  .f2.f22.gcv lower \
    [.f2.f22.gcv create polygon \
     0 -4 0 4 11 0 -fill red -tags {pointerPos}]
}

################################################################
####		    Canvas bindings:                        ####
####	    - move cursors on pointer moves                 ####
####		- redraw ticks on resize                    ####
################################################################

proc GridSetBindings {} {
  bind .f2.f22.cv <Motion>                 {+ GridHandle motion %x %y}
  bind .f2.f22.cv <Button1-Motion>         {+ GridHandle motion %x %y}
  bind .f2.f22.cv <Button2-Motion>         {+ GridHandle motion %x %y}
  bind .f2.f22.cv <Button3-Motion>         {+ GridHandle motion %x %y}
  bind .f2.f22.cv <ButtonPress-1>          {+ GridHandle press %x %y}
  bind .f2.f22.cv <ButtonPress-2>          {+ GridHandle press %x %y}
  bind .f2.f22.cv <ButtonPress-3>          {+ GridHandle press %x %y}
  bind .f2.f22.cv <ButtonRelease-1>        {+ GridHandle release %x %y}
  bind .f2.f22.cv <ButtonRelease-2>        {+ GridHandle release %x %y}
  bind .f2.f22.cv <ButtonRelease-3>        {+ GridHandle release %x %y}
}

proc GridHandle {type x y} {
  global ShowingGrid

  if { $ShowingGrid } {
    switch $type {
      motion {
	##  mv the position arrows  ##
	lassign [pgrid $x $y] x y

	set oldx [lindex [.f2.frame21.gcv coords pointerPos] 0]
	.f2.frame21.gcv move pointerPos \
	  [expr $x - 4 - ($oldx)] 0

	set oldy [lindex [.f2.f22.gcv coords pointerPos] 1]
	.f2.f22.gcv move pointerPos \
	  0 [expr $y - 4 - ($oldy)]
      }
      press {
	##  create the start-drag arrows  ##
	lassign [pgrid $x $y] x y

	.f2.frame21.gcv lower \
	  [.f2.frame21.gcv create polygon \
	   [expr $x - 4] 0 [expr $x + 4] 0 $x 11 \
	     -fill {blue} -tags {forDrag}]

	.f2.f22.gcv lower \
	  [.f2.f22.gcv create polygon \
	   0 [expr $y - 4] 0 [expr $y + 4] 11 $y \
	     -fill {blue} -tags {forDrag}]
      }
      release {
	##  delete the start-drag arrows  ##
	.f2.frame21.gcv delete forDrag
	.f2.f22.gcv delete forDrag
      }
    }
  }
}

################################################################
####			 Dialog                             ####
################################################################

proc gridShowDialog {} {
}

proc gridSpacingUpdate {} {
  global ShowingGrid GriddingMode
  global GridSpacing GridSpec UnitSuffix GridUnit
  
  if {[catch {readGridSpacing} GridSpec]} {
    warn $GridSpec
    set GridSpec ""
  } else {
    focus .
    if {$GriddingMode} {
      set GridSpec "$GridSpacing$UnitSuffix($GridUnit)"
    } else {
      set GridSpec ""
    }
    if {$ShowingGrid} {
      drawTicks
    }
  }
}

proc readGridSpacing {} {
  global gridEntryVar
  global GridSpacing UnitSuffix GridUnit
  
  scan $gridEntryVar {%f} value
  if { $value == [string trim $gridEntryVar] } {
    set GridSpacing $value
    return "$GridSpacing$UnitSuffix($GridUnit)"
  } else {
    error "Floating point value required"
  }
}

##
##  gridObject:
##  
##    Tries to arrange for object vertices to
##      fall on grid points -> object type dependent
##

proc gridObject {tagOrId} {
  
  foreach id [.f2.f22.cv find withtag $tagOrId] {
    
    set coords [.f2.f22.cv coords $id]
    set newcoords {}
    for {set i 0} {$i < [llength $coords]} {incr i 2} {
      set newcoords \
	"$newcoords [eval "pgrid [lrange $coords $i [expr $i + 1]]"]"
    }
    eval ".f2.f22.cv coords $id $newcoords"
  }
}



