# rcsid {$Id: picconfig.tcl,v 4.10 1996/05/21 16:14:57 mangin Rel $}
# This package is free software. Redistribution and use of this file
# are permitted without restrictions.
#
# THIS SOFTWARE IS PROVIDED ``AS IS'' AND WITHOUT ANY EXPRESS OR
# IMPLIED WARRANTIES, INCLUDING, WITHOUT LIMITATION, THE IMPLIED
# WARRANTIES OF MERCHANTIBILITY AND FITNESS FOR A PARTICULAR PURPOSE.
#
#	Frank Mangin
#	Frank.Mangin@ceram.fr  -  Frank.Mangin@sophia.inria.fr

##  Returns user settable options for an item : {{name1 value1} ... }  ##

proc getOptions {itemid} {
  set options {}
  foreach cf [.f2.f22.cv itemconfigure $itemid] {
    set name [string range [lindex $cf 0] 1 end]
    if {$name == "tags"} { continue }
    lappend options [list $name [lindex $cf 4]]
  }
  return $options
}	

proc getSwitches {itemid} {
  set switches {}

  foreach cf [.f2.f22.cv itemconfigure $itemid] {
    if {[lindex $cf 4] == ""} { continue }
    
    set name [lindex $cf 0]
    if {$name == "-tags"} { continue }
    lappend switches $name [lindex $cf 4]
  }
  return $switches
}	

##########################

proc Configure {} {
  set items [.f2.f22.cv find withtag s]
  switch [llength $items] {
    0 { warn "No item selected" }
    1 { buildConfigDialog $items }
    default { warn "Select one single item" }
  }
}

proc buildConfigDialog {item} {

  toplevel .configDg
  
  # Window manager configurations
  global tkVersion
  wm positionfrom .configDg ""
  wm sizefrom .configDg ""
  wm maxsize .configDg [winfo screenwidth .] [winfo screenheight .]
  wm minsize .configDg 10 10
  wm title .configDg {Picasso Load}

  #### Title  ####

  label .configDg.titleLb \
    -text "Object Type : [.f2.f22.cv type $item]"

  pack append .configDg \
    .configDg.titleLb {top pady 10 frame n}

  ####  Config options  ####

  set options [getOptions $item]
  
  set entries {}
  foreach opt $options {
    set name [lindex $opt 0]
    
    frame .configDg.opt${name}Fr -borderwidth 0

    label .configDg.opt${name}Fr.optLb \
      -relief flat \
      -width 10 \
      -anchor e \
      -text "${name}:"

    entry .configDg.opt${name}Fr.optEn \
      -relief sunken \
      -width 40

    .configDg.opt${name}Fr.optEn insert 0 [lindex $opt 1]

    pack append .configDg.opt${name}Fr \
      .configDg.opt${name}Fr.optLb {left frame w padx 8} \
      .configDg.opt${name}Fr.optEn {left expand fill padx 4}

    pack .configDg.opt${name}Fr \
      -expand 1 -fill x -side top

    lappend entries .configDg.opt${name}Fr.optEn
  }

  ####  Buttons frame  ####

  frame .configDg.butFr -borderwidth 0

  button .configDg.butFr.applyBt \
    -text {Apply} \
    -command "setConfigFromDialog $item" \
    -relief raised

  button .configDg.butFr.doneBt \
    -text {Done} \
    -command "setConfigFromDialog $item; focus .; destroy .configDg" \
    -relief raised

  button .configDg.butFr.cancelBt \
    -text {Cancel} \
    -command { focus .; destroy .configDg } \
    -relief raised

  #  packing  #
  pack append .configDg.butFr \
    .configDg.butFr.applyBt {left fill expand} \
    .configDg.butFr.doneBt {left fill expand} \
    .configDg.butFr.cancelBt {left fill expand}

  pack append .configDg \
    .configDg.butFr {top fillx pady 10 frame s}

  #  focus  #
  focus [lindex $entries 0]
  circEntryBind {<Return> <Tab> <Control-n>} {<Control-p>} \
    $entries
}

proc setConfigFromDialog {item} {

  set options {}
  set widgets [winfo children .configDg]

  foreach child [winfo children .configDg] {
    if {[regexp {configDg[.]opt([^.]+)Fr} $child foo name]} {
      lappend options "-$name"
      lappend options [.configDg.opt${name}Fr.optEn get]
    }
  }
  ## Prepare undo
  saveObjects $item
  
  if {[catch ".f2.f22.cv itemconfigure $item $options" err]} {
    warn $err 2000
  }
  update
  redrawFrames
  canUndo
}
