# rcsid {$Id: picbuild.tcl,v 4.21 1996/05/21 17:44:20 mangin Rel $}
# This package is free software. Redistribution and use of this file
# are permitted without restrictions.
#
# THIS SOFTWARE IS PROVIDED ``AS IS'' AND WITHOUT ANY EXPRESS OR
# IMPLIED WARRANTIES, INCLUDING, WITHOUT LIMITATION, THE IMPLIED
# WARRANTIES OF MERCHANTIBILITY AND FITNESS FOR A PARTICULAR PURPOSE.
#
#	Frank Mangin
#	Frank.Mangin@ceram.fr  -  Frank.Mangin@sophia.inria.fr

##
## Hello message
##

proc sayHello {} {
  global cvstag PicassoVersion
  
  set date [lindex $cvstag 3]
  msg "Picasso Release 4.1a3"
  set PicassoVersion "4.1a3 $date"
}

##
## Scrollbar display management
##

proc scbarSetup {} {

  # visible or not?
  lassign [.f2.f22.bottomSc get] x1 x2

  if { ($x1 > 0) || ($x2 < 1) } {
    pack .f2.f22.bottomSc \
      -before .f2.f22.cv \
      -side bottom -fill x
  }
  
  update
  
  lassign [.f2.f22.rightSc get] y1 y2
  if { ($y1 > 0) || ($y2 < 1)} {
    pack .f2.f22.rightSc \
      -before .f2.f22.cv \
      -side right -fill y
  }

  # bindings

  bind .f2.f22 <Configure> {
    update
    lassign [.f2.f22.bottomSc get] x1 x2
    if {($x1 <= 0) && ($x2 >= 1)} {
      pack forget .f2.f22.bottomSc
    } else {
      pack .f2.f22.bottomSc \
      -before .f2.f22.cv \
      -side bottom -fill x
    }
    update
    lassign [.f2.f22.rightSc get] y1 y2
    if { ($y1 <= 0) && ($y2 >= 1) } {
      pack forget .f2.f22.rightSc
    } else {
      pack .f2.f22.rightSc \
      -before .f2.f22.cv \
      -side right -fill y
    }
  }
}


################################################################
####		  Build the main window                     ####
################################################################

proc ShowTopWindow {} {
  # Window manager configurations
  global font
  
  wm positionfrom . ""
  wm sizefrom . ""
  
  set scw [winfo screenwidth .]
  set sch [winfo screenheight .]
  set scw1 [expr int($scw * 0.75)]
  set sch1 [expr int($sch * 0.75)]
  wm geometry . ${scw1}x${sch1}
  wm maxsize . $scw $sch
  wm minsize . 0 0
  wm title . Picasso
  wm iconname . {Picasso}
  
  # build widget .frame0
  frame .frame0 \
    -borderwidth {2}\
    -relief {raised}
  
  frame .frame0.modeFr0 \
    -borderwidth 0
  frame .frame0.modeFr1 \
    -borderwidth 0

  global symbolicName ModeFancyNames CurrentMode
  set CurrentMode SelectMode

  set i 0
  set y 0
  
  foreach mode {
    {SelectMode     {-image [mkimage select]}}
    {ScaleMode      {-image [mkimage scale]}}
    {StretchMode    {-image [mkimage stretch]}}
    {ReshapeMode    {-image [mkimage reshape]}}
    {LineMode       {-image [mkimage polyline]}}
    {RectangleMode  {-image [mkimage rect]}}
    {OvalMode	    {-image [mkimage oval]}}
    {ArcMode	    {-image [mkimage arc]}}
    {PieMode        {-image [mkimage farc]}}
    {CurveMode      {-image [mkimage curve]}}
    {CloseLineMode  {-image [mkimage polygon]}}
    {CloseCurveMode {-image [mkimage patate]}}
    {TextMode       {-image [mkimage alpha]}}
    {ImageMode      {-image [mkimage image]}}
    {BitmapMode		{-image [mkimage bitmap]}}
  } {
    set column [expr "$i % 2"]
    eval "button .frame0.modeFr${column}.mode${i}Bt \
    -command [list "ChangeMode  [lindex $mode 0]"] \
    [lindex $mode 1] -relief flat -activebackground #c00 \
    -bd 0 -highlightthickness 0 -padx 0 -pady 0"
    
    set symbolicName([lindex $mode 0]) .frame0.modeFr${column}.mode${i}Bt

    pack .frame0.modeFr${column}.mode${i}Bt
#    bind .frame0.modeFr${column}.mode${i}Bt \
#    <Enter> "+ msg \"$ModeFancyNames([lindex $mode 0])\""
    incr i
  }

  ################################################################
  ####		    packing .frame0                         ####
  ################################################################
  
  pack .frame0.modeFr0 -side left -anchor nw
  pack .frame0.modeFr1 -side left -anchor nw -after .frame0.modeFr0
  
  ################################################################
  ####		  La barre superieure                       ####
  ################################################################
  
  # build widget .frame1
  frame .frame1 \
    -borderwidth {2}\
    -relief {raised}
  
  # build widget dummy
  label .frame1.name \
    -relief flat -borderwidth 0 \
    -width 10
  
  ####  File button  ####
  menubutton .frame1.fileBt \
  -padx 0 -pady 0 \
    -text {File} \
    -menu .frame1.fileBt.m \
    -relief raised

  ####  File button menu  ####
  menu .frame1.fileBt.m

  .frame1.fileBt.m add command \
    -label {  Load drawing  } \
    -command {LoadDrawing} \
    -accelerator [getAccel LoadDrawing]
  
  .frame1.fileBt.m add command \
    -label {  Include drawing  } \
    -command {IncludeDrawing} \
    -accelerator [getAccel IncludeDrawing]
  
  .frame1.fileBt.m add command \
    -label {  Save drawing  } \
    -command {SaveDrawing} \
    -accelerator [getAccel SaveDrawing]

  .frame1.fileBt.m add command \
    -label {  Save drawing as ...  } \
    -command {SaveDrawingAs} \
    -accelerator [getAccel SaveDrawingAs]

  .frame1.fileBt.m add command \
    -label {  Write Postcript  } \
    -command {WritePostscript} \
    -accelerator [getAccel WritePostscript]

  .frame1.fileBt.m add sep

  .frame1.fileBt.m add command \
    -label {  Quit  } \
    -command {Quit} \
    -accelerator [getAccel Quit]
  
  label .frame1.warnLb
  
  ####  Edit button  ####
  menubutton .frame1.editBt \
  -padx 0 -pady 0 \
    -text {Edit} \
    -menu .frame1.editBt.m \
    -relief raised

  menu .frame1.editBt.m

  .frame1.editBt.m add command \
    -label {  Undo} \
    -command { Undo } \
    -accelerator [getAccel Undo] \
    -state disabled
    
  .frame1.editBt.m add command \
    -label {  Abort } \
    -command {Abort} \
    -accelerator [getAccel Abort]

  .frame1.editBt.m add command \
    -label {  Cut  } \
    -command { Cut } \
    -accelerator [getAccel Cut]

  .frame1.editBt.m add command \
    -label {  Copy } \
    -command {Copy} \
    -accelerator [getAccel Copy]

  .frame1.editBt.m add command \
    -label {  Paste  } \
    -command { Paste } \
    -accelerator [getAccel Paste]

  .frame1.editBt.m add command \
    -label {  Delete  } \
    -command { ApplyOnSelection delete } \
    -accelerator [getAccel Delete]

  .frame1.editBt.m add command \
    -label {  Duplicate  } \
    -command {Duplicate} \
    -accelerator [getAccel Duplicate]

  .frame1.editBt.m add separator 

  .frame1.editBt.m add command \
    -label {  Object Parameters  } \
    -command { Configure } \
    -accelerator [getAccel Configure]

  .frame1.editBt.m add command \
    -command { AlignToGrid } \
    -label {  Align to grid } \
    -accelerator [getAccel AlignToGrid]

  .frame1.editBt.m add command \
    -command {SelectAll} \
    -label {  Select All  } \
    -accelerator [getAccel SelectAll]
  
  .frame1.editBt.m add separator 
  
  .frame1.editBt.m add command \
    -command { Group } \
    -label {  Group  } \
    -accelerator [getAccel Group]

  .frame1.editBt.m add command \
    -command { Ungroup } \
    -label {  Ungroup  } \
    -accelerator [getAccel Ungroup]

  .frame1.editBt.m add command \
    -command { UngroupAll } \
    -label {  Group Reset }

  .frame1.editBt.m add command \
    -label {  Raise  } \
    -command {  ApplyOnSelection raise  } \
    -accelerator [getAccel Raise]

  .frame1.editBt.m add command \
    -label {  Lower  } \
    -command { ApplyOnSelection lower } \
    -accelerator [getAccel Lower]

  .frame1.editBt.m add separator
  .frame1.editBt.m add command \
    -label {  Preferences... } \
    -command {editPrefs}
  
  # pack widget .frame1
  pack append .frame1 \
    .frame1.name  {left fill} \
    .frame1.fileBt {padx 60 pady 6 left fill} \
    .frame1.editBt {padx 60 pady 6 left fill} \
    .frame1.warnLb {left fill expand}
  
  # build widget .f2
  frame .f2 \
    -borderwidth {2}
  
  frame .f2.f22 -borderwidth 0

  global drawAreaWidth drawAreaHeight
  
  canvas .f2.f22.cv \
    -highlightthickness 0 \
    -insertofftime {600}\
    -selectborderwidth {1}\
    -background white \
    -closeenough 2.0 \
    -width $drawAreaWidth \
    -height $drawAreaHeight \
    -scrollregion "0 0 $drawAreaWidth $drawAreaHeight" \
    -xscrollcommand {.f2.f22.bottomSc set} \
    -yscrollcommand {.f2.f22.rightSc set}

  scrollbar .f2.f22.bottomSc \
    -orient horizontal \
    -troughcolor {#8ba3ce} \
    -width 15 \
    -command {.f2.f22.cv xview}

  scrollbar .f2.f22.rightSc \
    -troughcolor {#8ba3ce} \
    -orient vertical \
    -width 15 \
    -command {.f2.f22.cv yview}
  
  pack append .f2.f22 \
    .f2.f22.cv {left} 

  # pack widget .f2
  pack append .f2 \
    .f2.f22 {bottom expand fill}  
  
  
  ################################################################
  ####	The option area : right vertical area in              ####
  ####       application, contains a button and frames.       ####
  ####      Each frame displays one option group (style,      ####
  ####      alignment, gridding, ...). As much frames as      ####
  ####      possible are displayed given the main window      ####
  ####			 size.                                ####
  ################################################################

  frame .optionFr \
    -width 74

  ########  Option button  ########
  frame .optionFr.btf -borderwidth 0
  menubutton .optionFr.btf.optionBt \
    -relief raised -borderwidth 2 \
    -menu .optionFr.btf.optionBt.m \
    -text {Control}
  
  pack append .optionFr.btf \
    .optionFr.btf.optionBt {top fill expand padx 2 pady 2}
  
  ##  menu  entries ##
  global optionIsVisible
  
  menu .optionFr.btf.optionBt.m

  .optionFr.btf.optionBt.m add checkbutton \
  -label "styles" \
  -variable optionIsVisible(.optionFr.styleFr) \
  -command {optionViewRaise .optionFr.styleFr}
  
  .optionFr.btf.optionBt.m add checkbutton \
  -label "align" \
  -variable optionIsVisible(.optionFr.alignFr) \
  -command {optionViewRaise .optionFr.alignFr}
  
  .optionFr.btf.optionBt.m add checkbutton \
  -label "grid" \
  -variable optionIsVisible(.optionFr.gridFr) \
  -command {optionViewRaise .optionFr.gridFr}
  
  .optionFr.btf.optionBt.m add checkbutton \
  -label "fonts" \
  -variable optionIsVisible(.optionFr.fontFr) \
  -command {optionViewRaise .optionFr.fontFr}
  
  .optionFr.btf.optionBt.m add checkbutton \
  -label "photos" \
  -variable optionIsVisible(.optionFr.photoFr) \
  -command {optionViewRaise .optionFr.photoFr}

  ## Build only the first option frames
  
  optionBuildStyle 
  optionBuildAlign 
  optionBuildGrid
  
  ## Pack optionFr with three initial option frames
  
  pack propagate .optionFr 0
  pack append .optionFr \
  .optionFr.btf      {top fill} \
  .optionFr.styleFr  {top fillx} \
  .optionFr.alignFr  {top fillx} \
  .optionFr.gridFr   {top fillx}
  
  set optionIsVisible(.optionFr.styleFr) 1
  set optionIsVisible(.optionFr.alignFr) 1
  set optionIsVisible(.optionFr.gridFr) 1
  
  # pack widget .
  pack append . \
    .frame1 {top fillx} \
    .frame0 {left frame n filly} \
    .optionFr {right frame n fill} \
    .f2 {right frame center expand fill}
}

################################################################
####		 Building option frames                     ####
################################################################

##
## Image Frame
## Settings here affect all canvas items whose associated image
##   is used by one of the selected canvas items ->
##   show which items will be affected: showSelectedIms
##

proc optionBuildImage {} {
  
  frame .optionFr.photoFr \
  -borderwidth 3 \
  -relief sunken
  
  bindtags .optionFr.photoFr .optionFr.photoFr
  bind .optionFr.photoFr <Enter> { unshowSelectedIms; showSelectedIms}
  bind .f2.f22.cv <Enter> unshowSelectedIms
  
  ## Label
  
  label .optionFr.photoFr.label \
  -relief flat \
  -text {Photo}
  
  frame .optionFr.photoFr.ctrlFr -borderwidth 0
  
  ## Gamma
  
  menubutton .optionFr.photoFr.ctrlFr.gammaMb \
  -menu .optionFr.photoFr.ctrlFr.gammaMb.m \
  -text {g}
  menu .optionFr.photoFr.ctrlFr.gammaMb.m \
  -postcommand showSelectedIms
  
  set g 0.1
  while {$g < 2.0} {
    .optionFr.photoFr.ctrlFr.gammaMb.m \
    add command -label $g \
    -command "setSelectionGamma $g"
    set g [expr "$g + 0.1"]
  }
  
  ## zooming and subsampling

  menubutton .optionFr.photoFr.ctrlFr.xzoomMb \
  -menu .optionFr.photoFr.ctrlFr.xzoomMb.m \
  -bitmap [mkbitmap rlarrow]
  menubutton .optionFr.photoFr.ctrlFr.yzoomMb \
  -menu .optionFr.photoFr.ctrlFr.yzoomMb.m \
  -bitmap [mkbitmap tdarrow]
  
  menu .optionFr.photoFr.ctrlFr.xzoomMb.m \
  -postcommand showSelectedIms
  menu .optionFr.photoFr.ctrlFr.yzoomMb.m \
  -postcommand showSelectedIms

  foreach z {1/10 1/9 1/8 1/7 1/6 1/5 1/4 1/3 1/2 1 2 3 4 5 6 7 8 9 10} {
    .optionFr.photoFr.ctrlFr.xzoomMb.m \
    add command -label "$z" \
    -command "zoomSelection $z 1"
    .optionFr.photoFr.ctrlFr.yzoomMb.m \
    add command -label "$z" \
    -command "zoomSelection 1 $z"
  }
  
  ## packing
  
  pack append .optionFr.photoFr.ctrlFr \
  .optionFr.photoFr.ctrlFr.xzoomMb {left expand padx 0 pady 0} \
  .optionFr.photoFr.ctrlFr.yzoomMb {left expand padx 0 pady 0} \
  .optionFr.photoFr.ctrlFr.gammaMb {left expand padx 0 pady 0}
  
  pack append .optionFr.photoFr \
    .optionFr.photoFr.label {top frame n fillx pady 2} \
    .optionFr.photoFr.ctrlFr {fillx top pady 0}
}
        
########  Style frame: displays a small canvas showing  ########
########  the effect of current style settings  ########

proc optionBuildStyle {} {

  frame .optionFr.styleFr \
  -borderwidth 3 \
  -relief sunken
  bindtags .optionFr.styleFr .optionFr.styleFr
  bind .optionFr.styleFr <Enter> {unshowSelectedIms; showSelectedIms bitmap}
  bind .f2.f22.cv <Enter> unshowSelectedIms

  ########  Style object  ########
  
  canvas .optionFr.styleFr.object \
    -relief raise \
    -width 36 -height 46\
    -background {#8ba3ce}

  ####  button bars  ####
  frame .optionFr.styleFr.barsFr -borderwidth 0

  frame .optionFr.styleFr.barsFr.bar1Fr -borderwidth 0
  frame .optionFr.styleFr.barsFr.bar2Fr -borderwidth 0

  ####  menu buttons  ####

  menubutton .optionFr.styleFr.barsFr.bar1Fr.lineBt \
    -width 24 -height 12 \
    -menu {.optionFr.styleFr.barsFr.bar1Fr.lineBt.m} \
    -relief raised

  menubutton .optionFr.styleFr.barsFr.bar2Fr.arrowBt \
    -relief raised \
    -width 24 -height 12 \
    -menu {.optionFr.styleFr.barsFr.bar2Fr.arrowBt.m}

  label .optionFr.styleFr.barsFr.bar1Fr.fgBt \
    -relief raised \
    -width 24 -height 12 \
    -image [mkimage rect.16.8]
  
  label .optionFr.styleFr.barsFr.bar2Fr.bgBt \
    -relief raised \
    -width 24 -height 12 \
    -image [mkimage fill.16.8]

  [mkimage fill.16.8] configure -foreground white

  menubutton .optionFr.styleFr.barsFr.bar2Fr.stippleBt \
    -relief raised \
    -menu {.optionFr.styleFr.barsFr.bar2Fr.stippleBt.m}

  ####  packing the menu button bars  ####

  pack append .optionFr.styleFr.barsFr.bar1Fr \
    .optionFr.styleFr.barsFr.bar1Fr.lineBt   {top pady 2 fill} \
    .optionFr.styleFr.barsFr.bar1Fr.fgBt     {top pady 2 fill}

  pack append .optionFr.styleFr.barsFr.bar2Fr \
    .optionFr.styleFr.barsFr.bar2Fr.arrowBt   {top pady 2 fill} \
    .optionFr.styleFr.barsFr.bar2Fr.bgBt      {top pady 2 fill} \
    .optionFr.styleFr.barsFr.bar2Fr.stippleBt {top pady 2 fill}

  ####  Menus  ####

  #  line menu  #

  menu .optionFr.styleFr.barsFr.bar1Fr.lineBt.m

  global lineMenuVar
  set lineMenuVar 1

  global theLineWidth
  foreach width $theLineWidth {
    set im [mkbitmap width $width]
    .optionFr.styleFr.barsFr.bar1Fr.lineBt.m add radiobutton \
      -bitmap  $im \
      -variable {lineMenuVar} \
      -indicatoron 0 \
      -value $width \
      -command ".optionFr.styleFr.barsFr.bar1Fr.lineBt configure -bitmap $im;
                SetStyle lineWidth $width"
  }
  .optionFr.styleFr.barsFr.bar1Fr.lineBt \
  configure -bitmap [mkbitmap width [lindex $theLineWidth 0]]
  
  #  arrow menu  #
  
  menu .optionFr.styleFr.barsFr.bar2Fr.arrowBt.m

  global arrowMenuVar
  set arrowMenuVar none

  .optionFr.styleFr.barsFr.bar2Fr.arrowBt configure -bitmap [mkbitmap width 1]

  .optionFr.styleFr.barsFr.bar2Fr.arrowBt.m add radiobutton \
    -bitmap [mkbitmap width 1]  \
    -variable {arrowMenuVar} \
    -value none \
    -indicatoron 0 \
    -command ".optionFr.styleFr.barsFr.bar2Fr.arrowBt configure \
              -bitmap [mkbitmap width 1]
              SetStyle arrow none"

  .optionFr.styleFr.barsFr.bar2Fr.arrowBt.m add radiobutton \
    -bitmap [mkbitmap rlinearrow]  \
    -variable {arrowMenuVar} \
    -indicatoron 0 \
    -value last \
    -command ".optionFr.styleFr.barsFr.bar2Fr.arrowBt configure \
              -bitmap [mkbitmap rlinearrow]
              SetStyle arrow last"
  
  .optionFr.styleFr.barsFr.bar2Fr.arrowBt.m add radiobutton \
    -bitmap [mkbitmap llinearrow]  \
    -variable {arrowMenuVar} \
    -indicatoron 0 \
    -value first \
    -command ".optionFr.styleFr.barsFr.bar2Fr.arrowBt configure \
              -bitmap [mkbitmap llinearrow]
              SetStyle arrow first"
  
  .optionFr.styleFr.barsFr.bar2Fr.arrowBt.m add radiobutton \
    -bitmap [mkbitmap rllinearrow]  \
    -variable {arrowMenuVar} \
    -indicatoron 0 \
    -value both \
    -command ".optionFr.styleFr.barsFr.bar2Fr.arrowBt configure \
              -bitmap [mkbitmap rllinearrow]
              SetStyle arrow both"

  ## foreground & background color menus

  toplevel .colorPicker -borderwidth 0
  wm overrideredirect .colorPicker 1
  wm transient .colorPicker .
  wm withdraw .colorPicker
  catch {.colorPicker config -cursor arrow}
  label .colorPicker.f -borderwidth 0 \
    -image [mkimage chooser]
  pack append .colorPicker .colorPicker.f {top}

  foreach button {.optionFr.styleFr.barsFr.bar1Fr.fgBt \
  .optionFr.styleFr.barsFr.bar2Fr.bgBt } {
    bind $button <ButtonRelease-1> "$button config -relief raised"
    
    bind $button <ButtonPress-1> "set b $button"
    bind $button \
    <ButtonPress-1> {+
      $b config -relief sunken
      set x [expr "[winfo rootx $b] + [winfo width $b] - [winfo reqwidth .colorPicker.f]"]
      set y [expr "[winfo rooty $b] + [winfo height $b]"]
      wm geometry .colorPicker "+$x+$y"

      wm deiconify .colorPicker
      raise .colorPicker
      update
      grab set .colorPicker.f
      global pickerButton; set pickerButton $b
      update
    }
  }
   
  bind .colorPicker.f \
    <ButtonRelease-1> {pickerHandle %x %y %X %Y}

  ## stipple menu

  menu .optionFr.styleFr.barsFr.bar2Fr.stippleBt.m

  global theStipples
  foreach st $theStipples {
    set bitmap [mkbitmap $st]
    .optionFr.styleFr.barsFr.bar2Fr.stippleBt.m add command \
      -bitmap $bitmap  \
      -command ".optionFr.styleFr.barsFr.bar2Fr.stippleBt \
                configure -bitmap $bitmap
                SetStyle stipple $bitmap"
  }
  .optionFr.styleFr.barsFr.bar2Fr.stippleBt config \
      -bitmap [mkbitmap [lindex $theStipples 0]]  
  
  ####  pack bars frame  ####

  pack append .optionFr.styleFr.barsFr \
    .optionFr.styleFr.barsFr.bar1Fr {left fill expand} \
    .optionFr.styleFr.barsFr.bar2Fr {left fill expand}
  
  ########  Packing style frame  ########
  
  pack append .optionFr.styleFr \
    .optionFr.styleFr.object    {top fill} \
    .optionFr.styleFr.barsFr    {top fill}
}

##
##  Handle color chooser button releases
##

proc pickerHandle {x y X Y} {
  global pickerButton

  ## Do nothing if release in buttons
  set bX [winfo rootx $pickerButton]
  set bY [winfo rooty $pickerButton]
  if {$X >= $bX && $Y >= $bY &&
    $X <= [expr "$bX + [winfo width $pickerButton]"] &&
    $Y <= [expr "$bY + [winfo height $pickerButton]"]} {
      return
    }
    
  grab release .colorPicker.f
  $pickerButton config -relief raised
  if {! [catch {[.colorPicker.f cget -image] get $x $y} color]} {
    lassign $color r g b
    set color [format "#%02x%02x%02x" $r $g $b]
    [$pickerButton cget -image] config \
    -foreground $color
    if {[string first "fgBt" $pickerButton] >= 0} {
      SetStyle lineColor $color
    } else {
      SetStyle fillColor $color
    }
  }
  wm withdraw .colorPicker
  update
}

########  Align options frame  ########
########  displays vert. and horiz. button modes  ########
########  and 3 little objects showing the effect  ########
########  of current settings  ########

proc optionBuildAlign {} {
  frame .optionFr.alignFr \
  -borderwidth 3 \
  -relief sunken
  
  bind .optionFr.alignFr <Enter> {
    global alignDx alignDy
    catch {unset alignDx alignDy}
  }
  
  ####  Label  ####
  label .optionFr.alignFr.label \
    -text {Align} \
    -relief flat
  
  ####  control buttons and canvas  ####
  frame .optionFr.alignFr.f -borderwidth 0
  
  ####  vertical bar  ####
  frame .optionFr.alignFr.f.vbarFr -borderwidth 0

  button .optionFr.alignFr.f.vbarFr.none \
    -bitmap [mkbitmap tdarrow]  \
    -command {alignSelection vnone}
    
  button .optionFr.alignFr.f.vbarFr.top \
    -bitmap [mkbitmap uparrow]  \
    -command {alignSelection vtop}

  button .optionFr.alignFr.f.vbarFr.center \
    -bitmap [mkbitmap vcarrow]  \
    -command {alignSelection vcenter}

  button .optionFr.alignFr.f.vbarFr.bottom \
    -bitmap [mkbitmap darrow]  \
    -command {alignSelection vbottom}

  pack append .optionFr.alignFr.f.vbarFr \
  .optionFr.alignFr.f.vbarFr.none {top fill} \
  .optionFr.alignFr.f.vbarFr.top {top fill} \
  .optionFr.alignFr.f.vbarFr.center {top fill} \
  .optionFr.alignFr.f.vbarFr.bottom {top fill}
  
  ## horizontal bar
  frame .optionFr.alignFr.f.hbarFr -borderwidth 0
  
  button .optionFr.alignFr.f.hbarFr.none \
  -bitmap [mkbitmap rlarrow]  \
  -command {alignSelection hnone}
  
  button .optionFr.alignFr.f.hbarFr.left \
  -bitmap [mkbitmap larrow]  \
  -command {alignSelection hleft}
  
  button .optionFr.alignFr.f.hbarFr.center \
  -bitmap [mkbitmap hcarrow]  \
  -command {alignSelection hcenter}
  
  button .optionFr.alignFr.f.hbarFr.right \
  -bitmap [mkbitmap rarrow]  \
  -command {alignSelection hright}
  
  # pack widget .optionFr.alignFr.f.hbarFr
  pack append .optionFr.alignFr.f.hbarFr \
  .optionFr.alignFr.f.hbarFr.none {top fill} \
  .optionFr.alignFr.f.hbarFr.left {top fill} \
  .optionFr.alignFr.f.hbarFr.center {top fill} \
  .optionFr.alignFr.f.hbarFr.right {top fill}
  
  ####  pack h&v bars
  pack append .optionFr.alignFr.f \
  .optionFr.alignFr.f.vbarFr {left frame center expand} \
  .optionFr.alignFr.f.hbarFr {left frame center expand}
  
  ####  pack alignFr  ####
  pack append .optionFr.alignFr \
  .optionFr.alignFr.label {top fill} \
  .optionFr.alignFr.f {top frame s pady 8}
}

## Grid options frame:
##   one entry for grid spacing,
##   and radiobuttons for grid unit

proc optionBuildGrid {} {
  global GridUnit GridSpacing gridEntryVar

  frame .optionFr.gridFr \
  -borderwidth 3 \
  -relief sunken

  ####  Label  ####
  label .optionFr.gridFr.label \
    -relief flat \
    -text {Grid}
  
  ####  show grid button  ####
  button .optionFr.gridFr.showBt \
  -padx 2 -pady 2 \
  -command { toggleShowGrid } \
  -text { Show }
  
  ####  Gridding button  ####
  global GriddingMode
  set GriddingMode 0
  
  checkbutton .optionFr.gridFr.griddingBt \
  -variable GriddingMode \
  -text {gridding} \
  -command { gridSpacingUpdate }
  
  
  frame .optionFr.gridFr.dimFr -borderwidth 0
  
  ####  Grid spacing  ####
  
  entry .optionFr.gridFr.dimFr.entry2 \
  -borderwidth {1} \
    -relief {sunken} \
    -textvariable {gridEntryVar} \
    -width {4}
  
  ####  Grid unit  ####
  
  menubutton .optionFr.gridFr.dimFr.unitMb \
    -menu {.optionFr.gridFr.dimFr.unitMb.m} \
    -relief raised \
    -width 2 \
    -text {mm}
  
  #  unit popup menu  #
  menu .optionFr.gridFr.dimFr.unitMb.m
  
  global GridUnit
  .optionFr.gridFr.dimFr.unitMb.m add radiobutton \
    -label { pixels } \
    -variable GridUnit \
    -value {pixel} \
    -command {
      .optionFr.gridFr.dimFr.unitMb configure -text {px}
      gridSpacingUpdate
    }
  
  .optionFr.gridFr.dimFr.unitMb.m add radiobutton \
    -label { centimeters } \
    -variable GridUnit \
    -value {cm} \
    -command {
      .optionFr.gridFr.dimFr.unitMb configure -text {cm}
      gridSpacingUpdate
    }
  
  .optionFr.gridFr.dimFr.unitMb.m add radiobutton \
    -label { millimeters } \
    -variable GridUnit \
    -value {mm} \
    -command {
      .optionFr.gridFr.dimFr.unitMb configure -text {mm}
      gridSpacingUpdate
    }
  
  .optionFr.gridFr.dimFr.unitMb.m add radiobutton \
    -label { inches } \
    -variable GridUnit \
    -value {inch} \
    -command {
      .optionFr.gridFr.dimFr.unitMb configure -text {in}
      gridSpacingUpdate
    }
  
  .optionFr.gridFr.dimFr.unitMb.m add radiobutton \
    -label { picas } \
    -variable GridUnit \
    -value {pica} \
    -command {
      .optionFr.gridFr.dimFr.unitMb configure -text {pc}
      gridSpacingUpdate
    }
  
    # pack widget .optionFr.gridFr
    
    pack append .optionFr.gridFr.dimFr \
    .optionFr.gridFr.dimFr.entry2 {left expand fillx} \
    .optionFr.gridFr.dimFr.unitMb {left fillx}
    
    pack append .optionFr.gridFr \
    .optionFr.gridFr.label  {top frame n pady 6} \
    .optionFr.gridFr.showBt {top pady 6 frame n} \
    .optionFr.gridFr.griddingBt {top pady 2 frame n} \
    .optionFr.gridFr.dimFr {top frame center}
    
    bind .optionFr.gridFr.dimFr.entry2 <Key-Return> \
    { gridSpacingUpdate }
  }
  

################################################################
####	    Font Selection for text objects                 ####
################################################################

set currentFName [lindex $fontAvail(Name) 0]
set currentFSize [lindex $fontAvail(Size) 0]
set currentFWeight [lindex $fontAvail(Weight) 0]
set currentFSlant [lindex $fontAvail(Slant) 0]

proc optionBuildText {} {
  global fontAvail
  global currentFName
  global currentFont
  
  frame .optionFr.fontFr \
  -relief sunken  -borderwidth 3

  #### show ####
  canvas .optionFr.fontFr.showCv \
    -relief raised \
    -width 10 -height 36 \
    -background {#8ba3ce}

  ####  font button  ####

  button .optionFr.fontFr.fontBt \
    -relief raised \
    -text {font}

  bind .optionFr.fontFr.fontBt <ButtonPress-1> {
    if {[winfo ismapped .optionFr.fontFr.fontBt.m]} {
      .optionFr.fontFr.fontBt.m unpost
      grab release .optionFr.fontFr.fontBt
    } else {
      .optionFr.fontFr.fontBt.m post \
	[winfo rootx .optionFr.fontFr.fontBt] \
	[expr "[winfo rooty .optionFr.fontFr.fontBt]+[winfo height .optionFr.fontFr.fontBt]"]
      grab -global .optionFr.fontFr.fontBt
    }
  }

  menu .optionFr.fontFr.fontBt.m

  set i 0
  foreach name $fontAvail(Name) {
    foreach weight $fontAvail(Weight) {
      foreach slant $fontAvail(Slant) {
	set font [getFontName $name 18 $weight $slant]
	if {$font != ""} {
	  button .optionFr.fontFr.fontBt.m.b${i}Bt \
	    -text "$name $weight $slant" \
	    -font $font

	  pack append .optionFr.fontFr.fontBt.m \
	    .optionFr.fontFr.fontBt.m.b${i}Bt {top fill}

	  bind .optionFr.fontFr.fontBt.m.b${i}Bt <ButtonRelease-1> " \
              %W configure -relief raised
              .optionFr.fontFr.fontBt.m unpost
	      grab release .optionFr.fontFr.fontBt
              set currentFName $name
	      set currentFWeight $weight
	      set currentFSlant $slant
	      setCurrentFont name weight slant
	      SetStyle font \$currentFont
              .optionFr.fontFr.showCv itemconfigure all \
                -text \$currentFName
	    "
	  incr i
	}
      }
    }
  }

  ####  buttons  ####

  menubutton .optionFr.fontFr.nameBt \
    -relief raised \
    -text {name} \
    -menu .optionFr.fontFr.nameBt.m

  menu .optionFr.fontFr.nameBt.m
  
  foreach name $fontAvail(Name) {
    .optionFr.fontFr.nameBt.m add radiobutton \
      -label $name \
      -variable {currentFName} \
      -value $name \
      -command "
        setCurrentFont name
	SetStyle font \$currentFont
	.optionFr.fontFr.showCv itemconfigure all \
	  -text \$currentFName
      "
  }

  menubutton .optionFr.fontFr.sizeBt \
    -relief raised \
    -text {size} \
    -menu .optionFr.fontFr.sizeBt.m

  menu .optionFr.fontFr.sizeBt.m
  
  foreach size $fontAvail(Size) {
    .optionFr.fontFr.sizeBt.m add radiobutton \
      -label $size \
      -variable {currentFSize} \
      -value $size \
      -command "
        setCurrentFont size
	SetStyle font \$currentFont
	.optionFr.fontFr.showCv itemconfigure all \
	  -text \$currentFName
      "
  }

  menubutton .optionFr.fontFr.weightBt \
    -relief raised \
    -text {weight} \
    -menu .optionFr.fontFr.weightBt.m

  menu .optionFr.fontFr.weightBt.m
  
  foreach weight $fontAvail(Weight) {
    .optionFr.fontFr.weightBt.m add radiobutton \
      -label $weight \
      -variable {currentFWeight} \
      -value $weight \
      -command "
        setCurrentFont weight
	SetStyle font \$currentFont
	.optionFr.fontFr.showCv itemconfigure all \
	  -text \$currentFName
      "
  }

  menubutton .optionFr.fontFr.slantBt \
    -relief raised \
    -text {slant} \
    -menu .optionFr.fontFr.slantBt.m

  menu .optionFr.fontFr.slantBt.m
  
  foreach slant $fontAvail(Slant) {
    .optionFr.fontFr.slantBt.m add radiobutton \
      -label $slant \
      -variable {currentFSlant} \
      -value $slant \
      -command "
        setCurrentFont slant
	SetStyle font \$currentFont
	.optionFr.fontFr.showCv itemconfigure all \
	  -text \$currentFName
      "
  }

  ####  packing  ####
  
  pack append .optionFr.fontFr \
  .optionFr.fontFr.showCv {top fill} \
  .optionFr.fontFr.fontBt {top fill} \
  .optionFr.fontFr.nameBt {top fill} \
  .optionFr.fontFr.sizeBt {top fill} \
  .optionFr.fontFr.weightBt {top fill} \
  .optionFr.fontFr.slantBt {top fill}
  
  ####  Show text object  ####
  update
  .optionFr.fontFr.showCv create text 10 10 \
    -text $currentFName

  bind .optionFr.fontFr.showCv <Configure> {
    .optionFr.fontFr.showCv coords all \
      [expr "[winfo width .optionFr.fontFr.showCv]/2"] \
      [expr "[winfo height .optionFr.fontFr.showCv]/2"]
  }
}
