proc busy {} {
  # Commented out: MUCH too slow
  #forAllWindows setBusy
  foreach w [winfo children .] { setBusy $w }
  after 100 unbusy
}

proc unbusy {} {
  #forAllWindows setUnbusy
  foreach w [winfo children .] { setUnbusy $w }
}

proc setBusy {w} {
  global oldCursor
  if {$w != "."} {
    set oldCursor($w) [lindex [$w config -cursor] 4]
    $w config -cursor watch
  }
}

proc setUnbusy {w} {
  global oldCursor
  if {$w != "."} {
    if {[info exists oldCursor($w)]} {
       $w config -cursor $oldCursor($w)
    }
  }
}

proc dpos {w} {
  wm geometry $w +300+300
}

proc inform { msg {aspect 1500}} {
  set w [genName .info]
  toplevel $w
  dpos $w
  wm title $w "Information"
  frame $w.m
  pack append $w $w.m {top expand fill}

  message $w.m.l -text "$msg" -aspect $aspect
  button $w.m.b -command "destroy $w" -text "Dismiss"

  pack append $w.m $w.m.l top $w.m.b top
  waitFor $w
  grab $w
  return $w
}

proc waitFor {w} {
  global $w.iHaveBeenExposed
  set $w.iHaveBeenExposed 0
  bind $w <Expose> "set $w.iHaveBeenExposed 1"
  #tkwait variable $w.iHaveBeenExposed
  bind $w <Expose> ""
  update
}
proc genName {{var var}} {
  global nameCount
  if [info exists nameCount($var)] { incr nameCount($var)
  } else { set nameCount($var) 0 }
  return "$var$nameCount($var)"
}

proc frameMultChoice {frame msg choices default} {
  frame $frame
  subMultChoice $frame $msg $choices $default
}

proc multChoice {title msg choices default} {
  set w [genName .mult]
  toplevel $w
  dpos $w
  wm title $w $title
  subMultChoice $w $msg $choices $default
  grab $w
}

proc subMultChoice {w msg choices default} {
  set var [genName]
  frame $w.m -relief raised -border 1
  frame $w.b -relief raised -border 1
  set style {top fill expand}
  if {$msg != ""} { pack append $w $w.m $style }
  pack append $w $w.b $style
  label $w.m.l -text $msg
  pack append $w.m $w.m.l top
  foreach i $choices {
    set text [lindex $i 0]
    set command [lindex $i 1]
    set style1 {left expand padx 40 pady 20}
    if {$text == $default} {
      set style2 {expand padx 5 pady 5}
      set button default
    } {
      set style2 {expand}
      set button [genName button]
    }
    frame $w.b.$button -relief sunken -border 1
    pack append $w.b $w.b.$button $style1
    button $w.b.$button.b -text $text -command "destroy $w; $command"
    pack append $w.b.$button $w.b.$button.b $style2
    bind $w.b.$button <Enter> "$w.b.$button.b activate"
    bind $w.b.$button <Leave> "$w.b.$button.b deactivate"
    bind $w.b.$button <Return> "$w.b.$button.b invoke"
    bind $w.b.$button.b <Return> "$w.b.$button.b invoke"
  }
  bind $w.m <Enter>	"$w.b.default.b activate"
  bind $w.m.l <Enter>	"$w.b.default.b activate"
  bind $w.b <Enter>	"$w.b.default.b activate"
  bind $w.m <Leave>	"$w.b.default.b deactivate"
  bind $w.m.l <Leave>	"$w.b.default.b deactivate"
  bind $w.b <Leave>	"$w.b.default.b deactivate"
  bind $w.m <Return>	"$w.b.default.b invoke"
  bind $w.m.l <Return>	"$w.b.default.b invoke"
  bind $w.b <Return>	"$w.b.default.b invoke"
  eval [list proc $w.invoke_default {} [list $w.b.default.b invoke]]
}

proc yesNo { title msg yesAction noAction default} {
  multChoice $title $msg [list "Yes [list $yesAction]" "No [list $noAction]"] $default
}

proc quit { prog {confirm 1}} {
  if $confirm {
    yesNo "Quit" "Are you sure you want to quit $prog?" "quit $prog 0" "noop" No
  } else {
    destroy .
    exit
  }
}

proc noop {} {
}  
