# util.tcl - utility routines for demos
# -*-Tcl-*-
#
# Author: Allan Brighton (abrighto@eso.org) 

 
# create a canvas with horizontal and verical scrollbars in the 
# given frame with the given name

proc MakeCanvas {frame canvas} {
    set vscroll [scrollbar $frame.vscroll -command "$canvas yview"]
    set hscroll [scrollbar $frame.hscroll -orient horiz -command "$canvas xview"]
    set canvas [canvas $canvas \
		    -xscrollcommand "$hscroll set" \
		    -yscrollcommand "$vscroll set"] 
    pack $vscroll -side right -fill y
    pack $hscroll -side bottom -fill x
    pack $canvas -fill both -expand 1
    bind $canvas <ButtonPress-2> "$canvas scan mark %x %y"
    bind $canvas <B2-Motion> "$canvas scan dragto %x %y"

    return $canvas
}

    

# layout the components of the given node depending on whether
# the tree is vertical or horizontal

proc LayoutNode {canvas tree dir} {
    set text $dir:text
    set bitmap $dir:bitmap
    
    if {[$tree cget -layout] == "horizontal"} {
        scan [$canvas bbox $text] "%d %d %d %d" x1 y1 x2 y2
	$canvas itemconfig $bitmap -anchor se
	$canvas coords $bitmap $x1 $y2
    } else {
        scan [$canvas bbox $bitmap] "%d %d %d %d" x1 y1 x2 y2
	$canvas itemconfig $text -anchor n
	$canvas coords $text [expr "$x1+($x2-$x1)/2"] $y2
    }
}


# add the directories under $dir to the tree (recursive)
 
proc ListDirsRec {canvas tree dir} {
    foreach i [exec ls $dir] {
	if {[file isdir $dir/$i]} {
	    AddDir $canvas $tree $dir $dir/$i $i
	    ListDirsRec $canvas $tree $dir/$i
	}
    }
}


# add the directories under $dir to the tree (non-recursive)
 
proc ListDirs {canvas tree dir} {
    foreach i [exec ls $dir] {
	if {[file isdir $dir/$i]} {
	    AddDir $canvas $tree $dir $dir/$i $i
	}
    }
}
