use metabase
go

drop table numbers
go

create table numbers
        (
        tablename       varchar(30),
        nserial int,
        uid     smallint        NULL,
        stamp   smalldatetime   NULL,
        )
go

grant select,update on numbers to public
go

sp_primarykey numbers,tablename
go

drop procedure get_new_no
go
create procedure get_new_no @arg1 varchar(40), @arg2 int output
as begin
select @arg2 = (select nserial from numbers holdlock
                where tablename = @arg1)
update numbers set nserial = @arg2 + 1
                where tablename = @arg1
end

go

create trigger t_nums_i on numbers for insert
as
begin
declare @tablename varchar(30)

select @tablename = tablename from inserted

if (select count(*) from numbers where tablename = @tablename) > 1 begin
        print "ERROR Tablename already exists : %1!" , @tablename
        rollback transaction
end
else begin
        update numbers set uid = suser_id(), stamp = getdate() where tablename = @tablename
end
end

go

create trigger t_nums_u on numbers for update
as
begin
/* Will not let you do an update unless you are dbo or from a trigger */
if ((select suser_id()) != 1) and (@@nestlevel <= 1) begin
        print "ERROR You do not have permission to change this table"
        rollback transaction
end
end


go

insert into numbers values ('fassists',10,NULL,NULL)
insert into numbers values ('forms',100,NULL,NULL)
insert into numbers values ('data_dict',100,NULL,NULL)

go
