use metabase
go

/* 	create table of form types.  the master forms startup window 	*/
/*	will have one menu for each type of form			*/

drop table formtypes
go
create table formtypes
        (
        formtype        char(2),
        menudesc        char(10),
        description     char(255)       NULL,
        )
go

sp_primarykey formtypes, formtype
go

grant select on formtypes to public
go

/*	create table for widget type definitions.  this table documents */
/*	the meanings of the attributes in forms table for each widget	*/
/*	type.	Do not alter the contents of this table unless you	*/
/*	want to create new widget types or alter the characteristics	*/
/*	of existing widget types.					*/

drop table fwidgets
go
create table fwidgets
        (
        wtype   char(2),
        field   char(10),
        meaning char(15),
        srt     tinyint NULL,
        help    char(10)        NULL,
        )
go

grant select on fwidgets to public
go

/*	create the table that defines the popup "assist lists" which	*/
/*	assist the user in choosing a value to enter into a widget	*/

drop table fassists 
go
create table fassists
        (
        fid     int,
        sqlcmd  varchar(255),
        resindex        smallint,
        ident   varchar(20)     NULL,
        width   int     NULL,
        inswid  varchar(40)     NULL,
        )
go

grant select on fassists to public
go

sp_primarykey fassists, fid
go


/*	create the primary table that drives the forms application	*/
/*	each record in this table defines a widget on a form, or	*/
/*	is the master (GN) record for a form				*/

drop table forms
go
create table forms
        (
        fid     int,
        fname   char(10)        NULL,
        ftype   char(2) NULL,
        levid   tinyint NULL,
        item    smallint        NULL,
        area    char(1) NULL,
        wtype   char(2) NULL,
        tbln    varchar(40)     NULL,
        fldn    varchar(40)     NULL,
        wname   char(10)        NULL,
        labx    float   NULL,
        laby    float   NULL,
        labs    smallint        NULL,
        labf    varchar(40)     NULL,
        labt    varchar(40)     NULL,
        laba    char(2) NULL,
        entx    float   NULL,
        enty    float   NULL,
        ents    smallint        NULL,
        entf    varchar(40)     NULL,
        enta    char(2) NULL,
        cmd     varchar(255)    NULL,
        next    smallint        NULL,
        prev    smallint        NULL,
        help    varchar(30)     NULL,
        dflt    varchar(40)     NULL,
        cmd2    varchar(255)    NULL,
        echo    int     NULL,
        )
go

grant select on forms to public
go

sp_primarykey forms,fid
go

create trigger t_form_i on forms for insert
as
begin
declare @newnum int,		@newitem int,
        @fy int,		@fid int,
	@fname char(10),	@ftype char(2),
	@levid tinyint,		@item smallint,
	@area char(1),		@wtype char(2),
	@tbln varchar(40),	@fldn varchar(40),
	@wname char(10),	@labx float,
	@laby float,		@labs smallint,
	@labf varchar(40),	@labt varchar(40),
	@laba char(2),		@entx float,
	@enty float,		@ents smallint,
	@entf varchar(40),	@enta char(2),
	@cmd varchar(255),	@next smallint,
	@prev smallint,		@help varchar(30),
	@dflt varchar(40),	@cmd2 varchar(255),
	@echo int

select @newnum = 0
select @fid = fid, @fname = fname, @ftype = ftype, @levid = levid, @item = item,
	@area = area, @wtype = wtype, @tbln = tbln, @fldn = fldn, @wname = wname,
	@labx = labx, @laby = laby, @labs = labs, @labf = labf, @labt = labt,
	@laba = laba, @entx = entx, @enty = enty, @ents = ents, @entf = entf,
	@enta = enta, @cmd = cmd, @next = next, @prev = prev, @help = help,
	@dflt = dflt, @cmd2 = cmd2, @echo = echo
	from inserted

select @newitem = (select max(item) from forms where fname = @fname and levid = @levid)
if @newitem is NULL begin
	select @newitem = 0
end else begin

	select @newitem = @newitem + 1
end
if (select count(*) from forms where fname = @fname and levid = @levid
	and wname = @wname) > 1 begin
	print "ERROR Widget %1! already exists in %2! levid %3!:",
	@fname,@wname,@levid
	rollback transaction
end
else if (@wtype = 'GN') and ((select count(*) from forms where fname = @fname
	and levid = @levid and wtype = 'GN') > 1) begin
	print "ERROR Already exist a GN record with fname and levid : %1!, %2!",
		@fname,@levid
	rollback transaction
end
else begin
	rollback transaction
	if @wtype not in ('EN', 'TX', 'LB') begin
		select @prev = null, @next = null
	end
/* will get the next number and insert a new record with new number */
	execute metabase..get_new_no 'forms',@newnum output
	insert forms values(@newnum,@fname,@ftype,@levid,@newitem,@area,@wtype,
		@tbln,@fldn,@wname,@labx,@laby,@labs,@labf,@labt,@laba,@entx,@enty,
		@ents,@entf,@enta,@cmd,@next,@prev,@help,@dflt,@cmd2,@echo) 
 
	print '%1! %2! ARE THE NEW form ID and item',@newnum,@newitem
end
end
go
