/*
 * turndialInit.c --
 *
 *	This module provides an init function for the turndial widget.
 *	It is part of the tkTurndial package.
 *
 *
 * Copyright (c) 1995 Marco Beijersbergen (beijersb@rulhm1.leidenuniv.nl)
 * 
 * See the file "license.terms" for copyright information.
 *
 */

static char sccsid[] = "@(#) turndialInit.c 1.06 95/06/22 23:05:21";

#include "tk.h"
#include "tkTurndial.h"

extern int Tk_TurndialCmd _ANSI_ARGS_((ClientData clientData,
	Tcl_Interp *interp, int argc, char **argv));

/*
 *----------------------------------------------------------------------
 *
 * Turndial_Init --
 *
 *	This procedure performs initialization for the turndial widget.
 *	It registers the "turndial" command.
 *
 * Results:
 *	A standard Tcl return value, with a message in interp->result
 *	if an error occurs.
 *
 * Side effects:
 *	Creates the turndial command.
 *
 *----------------------------------------------------------------------
 */

int
Turndial_Init(interp)
    Tcl_Interp *interp;
{

  Tk_Window main;
  main = Tk_MainWindow(interp);

  /*
   * Create the "turndial" command.
   */
  
  Tcl_CreateCommand(interp, "turndial", Tk_TurndialCmd, (ClientData) main,
		    (void (*)()) NULL);
  
  
return TCL_OK;
}
