#!/opt/tcl/bin/sywish
#!/opt/tcl/bin/wishx
#
#-------------------------------------------------------------------------
# initialize interp
#-------------------------------------------------------------------------
# first build your interp with all necessary extensions.
# always start with a sybtcl/tclX equipped wish!
#
global env
set tcllib /opt/tcl/lib
set tclroot /opt/share/tcl
set ucodb $tclroot/lib/ucodb
set bitmapdir $ucodb/bitmaps
#
# use the tkmail bindings, with whatever hacks we add locally
# if the enhanced bindxtnd.tcl is not the default, source it
        if {[info proc tkBindDefVar]==""} {
          foreach key [bind Text] { bind Text $key {} }
          foreach key [bind Entry] { bind Entry $key {} }
          source $ucodb/tkbind/bindxtnd.tcl
          source $ucodb/tkbind/text.tcl
          source $ucodb/tkbind/entry.tcl
          # source additional packages here
        }
#
loadlibindex $ucodb/ucodb.tlib
loadlibindex $ucodb/etcha.tlib
# loadlibindex etcha.tlib
#
puts stderr "Loaded all libs, ready to roll."
#
set helpdir $tclroot/lib/ucodb/help
# set helpdir /u/de/cvs/tcldb/memes/etcha/help
#
proc tellTale {{n1 {}} {n2 {}} op} {
	puts stderr "Warning, $op to $n1..."
}
set tcl_precision 17
trace variable tcl_precision w tellTale
#
set cvs(Id) {$Id: etcha,v 1.8 1997/06/21 00:18:58 de Exp $}
set cvs(Revision) {$Revision: 1.8 $}
scan $cvs(Revision) "%*s %s" Version
puts stderr "Version $Version"
#
# shortcut:  if you have a file with names of procs, and you launch
# etcha with name of file as sole arg, it will peel apart its own tlib
# and write each proc out to the ./Tlib dir.
#if {$argv != ""} {
#	saveProcs $argv
#	exit 0
#}
#-------------------------------------------------------------------------
# initialize globals
#-------------------------------------------------------------------------
#
#
global sybmsg
set uname ktl
set base keck
set server UCO-SCIDB
set pass NOYB
# 
set err [catch {set dbpipe1 [sybOpen $base $uname $pass $server]} res]
if {!$err} {
set dbpipe2 [sybOpen $base $uname $pass $server]
} else {
	puts stderr "NO SYBASE CONNECTION $res"
}
#
#
set memtbl keck.dbo.Memes
set agntbl keck.dbo.Agents
set agttbl keck.dbo.AgentTypes
set pattbl keck.dbo.Mpaths
set pactbl keck.dbo.Pcontexts
set fortbl keck.dbo.Formats
set medtbl keck.dbo.Media
set timtbl keck.dbo.Timing
#
set pkey(rectangle) agentid
set pkey(line) mpid
#
set field(AgentId) agentid
set field(AgentName) aname
set field(AgentType) atype
set field(Author) author
set field(Language) lang
set field(Summary) adesc
set field(URL) URI
#
set field(PathId) mpid
set field(AgentSends) sendr
set field(AgentRcvs) rcvr
set field(AgentCtrls) ctrlr
set field(AgentOwns) owner
set field(Medium) medid
set field(Format) formid
set field(Timing) timid
set field(comment) pcomment
set field(PathElaps) elaps
# set field(KW) name
set field(KWid) mid
#
set table(rectangle) $agntbl
set table(line) $pattbl
set table(Medium) $medtbl
set table(Format) $fortbl
set table(Timing) $timtbl
set table(AgentSends) $agntbl
set table(AgentRcvs) $agntbl
set table(AgentCtrls) $agntbl
set table(AgentOwns) $agntbl
set table(AgentId) $agntbl
set table(KWid) $memtbl
set table(AgentType) $agttbl
#
set sortem($agntbl) "ref aname"
set sortem($memtbl) name
set sortem($medtbl) medium
set sortem($fortbl) format
set sortem($agttbl) atype
#
set selectem($agntbl) "agentid ref aname atype author lang adesc"
set selectem($memtbl) "mid name"
set selectem($medtbl) "medid medium"
set selectem($fortbl) "formid format"
set selectem($agttbl) "atype atdesc"
#
set LayoutFile ETCHAlayout.dat
set MenuFont "-Adobe-Helvetica-Bold-R-Normal--*-180-*-*-*-*-*-*"
set Orient ""
#
# Message area background colour rotates among this list, so as
# to attract your attention when the message changes
set MsgColours(0) linen
set MsgColours(1) honeydew
set MsgColours(2) papayawhip
set MsgColours(3) azure
set MsgColours(4) lemonchiffon
set MsgColours(5) lavender
set MsgColours(6) bisque
set MsgColours(7) mistyrose
#
set OwnerCt 0
set OwnColours(1) red
set OwnColours(2) blue
set OwnColours(3) green
set OwnColours(4) yellow
set OwnColours(5) purple
set OwnColours(6) orange
set OwnColours(7) cyan
#
set findstay 0
#
set Halo 20
#
set GraphicTypes "line rectangle text pie chord arc oval polygon"
#
set GraphicId 0
#
set Start [clock seconds]
set FStart [clock format $Start]
#
set lfp [open etcha.log a]
# set tfp [open etcha.trace w]
# cmdtrace on $tfp
#
puts $lfp "\n\n\n***-------------------------------------------------------------***"
puts $lfp "ETCHA LOG START [clock format [clock seconds]] ... "
puts $lfp "***-------------------------------------------------------------***\n\n"
#
#-------------------------------------------------------------------------
# initialize main window and go
#-------------------------------------------------------------------------
#
#
set Mode make
#
mkEtcha
#
focus $Canvas
#
mkMsg "Ready to go.  You can draw now."
#
