
SQL statements mined out of the ancient sunos (syb 4.9) resql exe

Nov 1998

**  Create a temporary table where we can build up a translation of 
**  the device status bits. 
create table #spdevinfo 
	name varchar(30), 
	physname varchar(127), 
	phys_enabled bit , 
	mirror_name varchar(127) null, 
	mir_enabled bit , 
	vdevno tinyint null, 
	size int null, /*in MB or pages as appropriate*/ 
	controller_type int , 
	controller_desc char(30) null, 
	status varchar(30) null, 
	device_type varchar(4) null, 
	skip bit  , 
	serial_write bit , 
	read_mirrored bit , 
	contiguous bit ,  
	mirroring_enabled bit  

set nocount on 

insert into #spdevinfo(name, physname,  phys_enabled, mirror_name,  
	mir_enabled, controller_type, skip, serial_write, read_mirrored, 
	contiguous,  mirroring_enabled) values ( select name, phyname,0, 
	mirrorname, 0, cntrltype, 0,0,0,0,0 from master.dbo.sysdevices )

**  Now figure out what kind of controller type it is.  The type are 
**  COMPLETELY machine dependent and are for UNIX. 
**  cntrltype = 0

special 
        2
disk 
      3-8
tape 

update #spdevinfo 
set controller_desc = "special" 
from master.dbo.sysdevices d, #spdevinfo 
where d.cntrltype = 0 
and #spdevinfo.name = d.name 

update #spdevinfo  
set controller_desc = "disk" 
from master.dbo.sysdevices d, #spdevinfo 
where d.cntrltype = 2 
and #spdevinfo.name = d.name 

update #spdevinfo 
set controller_desc = "tape" 
from master.dbo.sysdevices d, #spdevinfo 
where d.cntrltype >= 3 and d.cntrltype <= 8 
and #spdevinfo.name = d.name 

**  If a tape device, also figure out the tape capacity which is listed 
**  in sysdevices.high in number of 32k blocks. 
if exists (select * 
from master.dbo.sysdevices d, #spdevinfo 
where d.cntrltype         
 >= 3 and d.cntrltype <= 8 
and d.high > 0 
and #spdevinfo.name = d.name) 
begin 
update #spdevinfo 
set size = convert(int, 
round((d.high * convert(float, 32768)) / 1048576, 0)) 
from master.dbo.sysdevices d, #spdevinfo 
where d.cntrltype >= 3 and d.cntrltype <= 8 
and d.high > 0 
and #spdevinfo.name = d.name 
end 

update #spdevinfo 
set status = "UNKNOWN" 
from master.dbo.sysdevices d, #spdevinfo 
where d.cntrltype > 8 
and #spdevinfo.name = d.name 

**  this is a big chunk
**  Now check out the status bits and turn them into english. 
**  The mirror status bits are >= 32. 

if exists (select * from master.dbo.sysdevices d, master.dbo.spt_values v, 
	#spdevinfo where v.type = "V" and v.number > -1 and d.status >= 32 and 
	#spdevinfo.name = d.name) begin 
**  Check to see if the mirror is enabled. 0x200 (512) bit in status. 

	if exists (select * from master.dbo.sysdevices d, #spdevinfo where d.status & 512 = 512 and #spdevinfo.name = d.name) begin 

		update #spdevinfo set mirroring_enabled = 1 /*mirror enabled*/  
		from master.dbo.sysdevices d, #spdevinfo where 
		d.status & 512 = 512 and #spdevinfo.name = d.name 

	end 
	if exists (select * from master.dbo.sysdevices d, #spdevinfo where 
		d.status & 512 != 512 and d.status >= 32 and 
		#spdevinfo.name = d.name) begin 

		update #spdevinfo set mirroring_enabled = 0  /*mirror disabled*/ 
		from master.dbo.sysdevices d, #spdevinfo 
		where d.status & 512 != 512 and d.status >= 32 and 
		#spdevinfo.name = d.name 

		end 

	update #spdevinfo set status = v.name from master.dbo.sysdevices d, 
		master.dbo.spt_values v, #spdevinfo where v.type = "V" and 
		v.number > -1 and d.status >= 32  and #spdevinfo.name = d.name 

end        

**  Check to see if there is a mirrorname entry but mirroring not enabled. 
**  If so, then one side of the mirror is off-line. 

else if exists (select * from master.dbo.sysdevices d, #spdevinfo where #spdevinfo.name = d.name and d.mirrorname != null) begin 

**  Figure out which side of the mirror is disabled. 
**  If 0x100 is on, then phyname is disabled and mirrorname is enabled. 

	if exists (select * from master.dbo.sysdevices d, master.dbo.spt_values v, 
		#spdevinfo where v.type = "V" and v.number > -1 and 
		d.status & v.number = 256 and #spdevinfo.name = d.name) begin 

		update #spdevinfo set phys_enabled = 0, /* physical disabled, mirrored on*/ 
		mir_enabled = 1 from  master.dbo.sysdevices d, master.dbo.spt_values v, 
		#spdevinfo where v.type = "V" and v.number > -1 and 
		d.status & v.number = 256 and #spdevinfo.name = d.name 

	end else if exists (select * from master.dbo.sysdevices d,  
		master.dbo.spt_values v, #spdevinfo where v.type = "V" and 
		v.number > -1 and d.status & v.number = 64 and 
		#spdevinfo.name = d.name) begin 

	update #spdevinfo set phys_enabled = 1, /*physical enabled, mirrored not*/  
 		mir_enabled = 0 from master.dbo.sysdevices d, master.dbo.sysdevices e, 
		master.dbo.spt_values v, #spdevinfo where v.type = "V" and 
		v.number > -1 and d.status & v.number = 64 and 
		#spdevinfo.name = d.name and e.status & 256   != 256 and 
		#spdevinfo.name = e.name 

	end 

end 

if exists (select * from master.dbo.sysdevices d, master.dbo.spt_values v, 
	#spdevinfo where v.type = "V" and v.number > -1 and d.status  & 
	v.number = 32 and #spdevinfo.name = d.name) begin 

	update #spdevinfo set serial_write = 1 /*serial writes VMS only*/  
	from master.dbo.sysdevices d, master.dbo.spt_values v, #spdevinfo 
	where v.type = "V" and v.number > -1 and d.status & v.number = 32  and 
	#spdevinfo.name = d.name 

end 

**  Status of 0x80 is "reads mirrored" for mirrored disks. 

if exists (select * from master.dbo.sysdevices d, master.dbo.spt_values v, #spdevinfo 
	where v.type = "V" and v.number > -1 and d.status & v .number = 128 and 
	#spdevinfo.name = d.name) begin 

	update #spdevinfo set read_mirrored =  1 from master.dbo.sysdevices d, 
	master.dbo.spt_values v, #spdevinfo where v.type = "V" and v.number > -1 and 
	d.status & v.number = 128 and #spdevinfo.name = d.name 

end 

**  Now check out the status bits and turn them into english. 
**  Status of 0x10 is a dump device. 

if exists (select * from master.dbo.sysdevices d, master.dbo.spt_values v, 
	#spdevinfo where v.type = "V" and v.number > -1 and 
	d.status & v.number = 16 and #spdevinfo.name = d.name) begin 

	update #spdevinfo set status = v.name from master.dbo.sysdevices d, 
		master.dbo.spt_values v, #spdevinfo where v.type = "V" and 
		v.number > -1 and d.status & v.number = 16 and #spdevinfo.name = d.name 

end 

**  Now check out the status bits and turn them into english. 
**  Status of 0x01 is a default disk. 

if exists (select * from master.dbo.sysdevices d, master.dbo.spt_values v, #spdevinfo 
	where v.type = "V" and v.number > -1 and d.status & v.number = 1 and 
	#spdevinfo.name = d.name) begin 

	update #spdevinfo set status =  v.name from master.dbo.sysdevices d, 
	master.dbo.spt_values v, #spdevinfo where v.type = "V" and v.number > -1 and 
	d.status & v.number = 1 and #spdevinfo.name = d.name 

end 

**  Now check out the status bits and turn them into english. 
**  Status of 0x02 is a physical disk. 

if exists (select * from master.dbo.sysdevices d, master.dbo.spt_values v, #spdevinfo 
	where v.type = "V" and v.number > -1 and d.status & v.number = 2 and 
	#spdevinfo.name = d.name) begin 

	update #spdevinfo set status = v.name from master.dbo.sysdevices d, 
	master.dbo.spt_values v, #spdevinfo where v.type = "V" and v.number > -1 and 
	d.status & v.number = 2 and #spdevinfo.name = d.name 

**  Add in it's size in PAGES. 
	update #spdevinfo  set size = d.high - d.low from master.dbo.sysdevices d, 
	#spdevinfo, master.dbo.spt_values v where d.status & 2 = 2 and 
	#spdevinfo.name = d.name and v.number = 1 and v.type = "E" 

end 

**  Now check out the status bits and turn them into english. 
**  Status of 0x04 is a logical disk. 

if exists (select * from master.dbo.sysdevices d, master.dbo.spt_values v, #spdevinfo 
	where v.type = "V" and v.number > -1 and d.status & v.number = 4 and 
	#spdevinfo.name = d.name) begin 

	update #spdevinfo set status = v.name from master.dbo.sysdevices d, 
	master.dbo.spt_values v, #spdevinfo where v.type = "V" and v.number > -1 and 
	d.status & v.number = 4 and #spdevinfo.name = d.name 

end 

**  Now check out the status bits and turn them into english. 
**  Status of 0x08 is a skip tape header. 

if exists (select * from master.dbo.sysdevices d, master.dbo.spt_values v, #spdevinfo 
	where v.type = "V" and v.number > -1 and d.status & v.number = 8 and 
	#spdevinfo.name = d.name) begin 

	update #spdevinfo set status = v.name from master.dbo.sysdevices d, 
	master.dbo.spt_values v, #spdevinfo where v.type = "V" and v.number > -1 and 
	d.status & v.number = 8 and #spdevinfo.name = d.name 

end 

set nocount off 

**  The device number is in the high byte of sysdevices.low so 
**  spt_values tells us which byte to pick out. 

update #spdevinfo set vdevno = 
	convert(tinyint, substring(convert(binary(4), d.low), v.low, 1)) from 
	master.dbo.sysdevices d, #spdevinfo, master.dbo.spt_values v where 
	d.name = #spdevinfo.name and v.type = "E" and v.number = 3 


** Now report on what you found  (need to read output to figure out this stretch)

select * from #spdevinfo 
master
print "The master device was "
print  "
%d pages long"
disk init
name = "
physname = "
vdevno = 
, size = 
, contiguous
exec sp_addumpdevice "
, skip
, noskip
disk mirror 
name = "
mirror = "
, writes = serial
, contiguous
disk unmirror 
 name = "
", side = 
primary
secondary

print 'Caution:'
print 'This script will create disk devices and databases:'
print ' '
print 'Devices are: '
print 'Name: %s
Location: %s
Size(Pages): %d'
print ' '
print ' '
print 'Databases: '
print 'Name: %s
Location: %s
size(MB): %d
Log size: %d
Log: %s'
print 'Type Control c now to abort. You have 30 seconds.'
waitfor delay "00:00:30"
master
tempdb
model
print 'Creating database %s size %dMB'
create database %s on %s = %d
log on %s = %d
print 'Altering database %s size %dMB'
alter database %s on %s = %d
alter database %s on 
 %s = %d
sp_logdevice %s, %s
master
tempdb
model
print "Changing ownership of %s"
use %s
sp_changedbowner %s
use master

** add languages

select * from syslanguages 
exec sp_addlanguage %s
, %s, %s, %s, %s, %s, %d

**  create users

select name, dbname, password
, language
, locked = (status & 0x2)
 from syslogins 
where name != "probe" 
order by suid 
exec sp_password null, %s
exec sp_addlogin "%s"
, "%s"
, %s
null
, %s
, %s

** roles

select l.name, role_name = s.name, r.status
 from syslogins l, sysloginroles r, syssrvroles s
 where l.suid = r.suid and r.srid = s.srid
 order by l.name 
exec sp_role "grant" , "%s", %s

**  servers and remote logins

select * from sysservers
exec sp_addserver %s
, local
, null
, %s
select server = s.srvname, 
    remote_user_name = 
        r.remoteusername,  
    local_user_name = suser_name(r.suid), 
    options = v.name 
        from master.dbo.sysservers s, master.dbo.sysremotelogins r, 
            master.dbo.spt_values v 
    where s.srvid = r.remoteserverid 
        and s.srvid > 0 
        and v.type = "F" 
        and v.number = r.status 
exec sp_addremotelogin %s

** what the heck is this doing?

select name, config_value = c.value, run_value = cc.value from 
	master.dbo.spt_values, master.dbo.sysconfigures c, master.dbo.syscurconfigs cc
	where type = 'C' and number *= c.config and number *= cc.config and 
	number >= 0 and c.config != 123 

exec sp_configure "..."

** 

select User_type_name = s.name, s.usertype, User_name = user_name(s.uid), 
	Storage_type = st.name, Length = s.length, Default_name=object_name(s.tdefault), 
	Rule_name= object_name(s.domain), Nulls = s.allownulls from dbo.systypes s, 
	dbo.systypes st where s.type = st.type and s.usertype > 99 /*it is a user type*/
	and st.usertype != 18 /* it is not sysnames */
	and st.usertype < 100

select User_type_name = s.name, s.usertype, User_name = user_name(s.uid), 
	Storage_type = st.name, Length = s.length, Default_name=object_name(s.tdefault), 
	Rule_name= object_name(s.domain), Nulls = s.allownulls, s.prec, s.scale, 
	s.ident from dbo.systypes s, dbo.systypes st where s.type = st.type and 
	s.usertype > 99 /*it is a user type*/
	and st.usertype != 18 /* it is not sysnames */
	and st.usertype < 100 and s.uid = user_id("
??
 			      and s.uid = user_id()  

			      order by s.name 
			      order by s.usertype

**

select o.id, c.colid, name, user_name(o.uid), text from dbo.syscomments c,
	dbo.sysobjects o where o.id = c.id and o.type = "D"

select o.id, c.colid, name, user_name(o.uid), text from dbo.syscomments c,
	dbo.sysobjects o where o.id = c.id and o.type = "D" and 
	o.id not in (select id from syscomments where substring(text,1,7) = "DEFAULT")
 	and o.uid = user_id("
        and o.uid = user_id()

 	order by name, c.id, 

 	order by c.id, 

??
c.colid2, c.colid 
c.colid
default

**

select o.id, c.colid, name, user_name(o.uid), text from dbo.syscomments c,
	dbo.sysobjects o where o.id = c.id and o.type = "D" and o.id in 
	(select id from syscomments where substring(text,1,7) = "DEFAULT") order by 
	c.id, c.colid2, c.colid 

select o.id, c.colid, name, user_name(o.uid), text from dbo.syscomments c,
	dbo.sysobjects o where o.id = c.id and o.type = "R" 

select o.id, c.colid, name, user_name(o.uid), text from dbo.syscomments c,
	dbo.sysobjects o where o.id = c.id and o.type = "R" and o.id not in 
	(select constrid from sysconstraints) and o.uid = user_id("
 					      and o.uid = user_id()
 				order by name, c.id, 
 				order by c.id, 

				c.colid2, c.colid 
				c.colid

rule

** wow... what the heck does this do?

select constrid, object_name(constrid), indexid, frgndbid, 
	db_name(frgndbid), tableid,object_name(tableid, frgndbid), 
	pmrydbid, db_name(pmrydbid), reftabid, object_name(reftabid, pmrydbid),
	keycnt,
	col_name(tableid, fokey1, frgndbid),
	col_name(tableid, fokey2, frgndbid),
	col_name(tableid, fokey3, frgndbid),
	col_name(tableid, fokey4, frgndbid),
	col_name(tableid, fokey5, frgndbid),
	col_name(tableid, fokey6, frgndbid),
	col_name(tableid, fokey7, frgndbid),
	col_name(tableid, fokey8, frgndbid),
	col_name(tableid, fokey9, frgndbid),
	col_name(tableid, fokey10, frgndbid),
	col_name(tableid, fokey11, frgndbid),
	col_name(tableid, fokey12, frgndbid),
	col_name(tableid, fokey13, frgndbid),
	col_name(tableid, fokey14, frgndbid),
	col_name(tableid, fokey15, frgndbid),
	col_name(tableid, fokey16, frgndbid),
	col_name(reftabid, refkey1, pmrydbid),
	col_name(reftabid, refkey2, pmrydbid),
	col_name(reftabid, refkey3, pmrydbid),
	col_name(reftabid, refkey4, pmrydbid),
	col_name(reftabid, refkey5, pmrydbid),
	col_name(reftabid, refkey6, pmrydbid),
	col_name(reftabid, refkey7, pmrydbid),
	col_name(reftabid, refkey8, pmrydbid),
	col_name(reftabid, refkey9, pmrydbid),
	col_name(reftabid, refkey10, pmrydbid),
	col_name(reftabid, refkey11, pmrydbid),
	col_name(reftabid, refkey12, pmrydbid),
	col_name(reftabid, refkey13, pmrydbid),
	col_name(reftabid, refkey14, pmrydbid),
	col_name(reftabid, refkey15, pmrydbid),
	col_name(reftabid, refkey16, pmrydbid)
from sysreferences

**

select name, proc_name, free_space from systhresholds t, syssegments s 
	where s.segment = t.segment and t.status != 1

**

select error, error, user_name(uid), description, name 
from sysusermessages m, master..syslanguages l where m.langid *= l.langid

** zowie!  it's getting deep!

select constrid, tableid, sysconstraints.colid, object_name(constrid), error, 
	status, text from sysconstraints, syscomments where 
	sysconstraints.constrid *= syscomments.id order by tableid, 
	sysconstraints.colid, syscomments.colid2, syscomments.colid 

select o.id, o.name, owner_name = user_name(o.uid), s.name, s.segment, 
	isnull(c.name, "null"), t.name, c.type, c.length, 
	convert(int, convert(bit, (c.status & 8))), 
	default_name = object_name(c.cdefault), 
	Rule_name = object_name(c.domain) from dbo.syscolumns c,
 	dbo.systypes t, dbo.sysobjects o, dbo.sysindexes i, dbo.syssegments s 
	where c.usertype *= t.usertype and o.id = i.id and 
	i.segment = s.segment and  c.id = o.id and o.sysstat & 7 = 3 and 
	i.indid in (1,0)

** get something to do with master

select o.id, o.name, owner_name = user_name(o.uid), s.name, s.segment, c.colid, 
	isnull(c.name, "null"), t.name, c.type, c.length, c.prec, c.scale, 
	Ident = convert(int,convert (bit, (c.status & 0x80))), 
	convert(int, convert(bit, (c.status & 8))), c.cdefault, 
	default_name = object_name(c.cdefault), c.domain, 
	Rule_name = object_name(c.domain) from dbo.syscolumns c, 
	dbo.systypes t, dbo.sysobjects o, dbo.sysindexes i, dbo.syssegments s where 
	c.usertype *= t.usertype and o.id = i.id and i.segment = s.segment and  
	c.id = o.id and o.sysstat & 7 = 3 and i.indid in (1,0) and 
?		o.uid = user_id("
? 		o.uid = user_id()

? master

? and o.name not in ( "spt_values", "spt_committab", "spt_monitor" )

? order by o.name, c.id, c.colid
? order by o.id, c.colid

** what does that lone string "trigger" mean, I wonder.  a comment?

** get triggers

select o.id, c.colid, name, user_name(o.uid), isnull(text, " ") from dbo.syscomments c,
	dbo.sysobjects o where o.id = c.id and o.type = "TR"
 	and o.uid = user_id("
?	and o.uid = user_id()
 	order by name, c.id, 
? 	order by c.id, 
	c.colid2, c.colid 
	c.colid
? trigger

** get procs

select o.id, c.colid, name, user_name(o.uid), isnull(text, " ") from dbo.syscomments c,
	dbo.sysobjects o where o.id = c.id and o.type = "P" and 
	o.userstat & -32768 != -32768 and 
	o.uid = user_id("
? 	o.uid = user_id()
 	order by name, c.id, 
? 	order by c.id, 
	c.colid2, c.colid 
?	c.colid

? proc

** get views

select o.id, c.colid, name, user_name(o.uid), text from dbo.syscomments c,
	dbo.sysobjects o where o.id = c.id and o.type = "V" and 
	o.uid = user_id("
?	o.uid = user_id()
 	order by name, c.id, 
? 	order by c.id, 
	c.colid2, c.colid 
?	c.colid
? view

** get indices?

select indid, i.name, o.id, user_name(o.uid), o.name, i.status, keycnt, 
	s.name, s.segment from dbo.sysindexes i, dbo.sysobjects o, 
	dbo.syssegments s where i.id = o.id and i.segment = s.segment and 
	o.sysstat & 7 = 3 and i.indid > 0 and i.indid != 255 and 
	o.uid = user_id("
? 	o.uid = user_id()
?? master
	and o.name not in ( "spt_values", "spt_committab" ) 
	order by i.name, o.uid
?	order by o.id


** where does %d come from?

declare @keycount int
select @keycount = 1
while @keycount <= %d begin
	select index_col("%s.%s.%s", %d, @keycount) 
	select @keycount = @keycount + 1 
end 

select keytype = substring(v.name, 1, 10), user_name(o.uid), o.id, o.name,
	related_object = k.depid, r_object_name = object_name(k.depid),
	col_name(k.id, key1),col_name(k.id, key2),col_name(k.id, key3),
	col_name(k.id, key4),col_name(k.id, key5),col_name(k.id, key6),
	col_name(k.id, key7),col_name(k.id, key8),col_name(k.depid, depkey1),
	col_name(k.depid, depkey2),col_name(k.depid, depkey3),
	col_name(k.depid, depkey4),col_name(k.depid, depkey5),
	col_name(k.depid, depkey6),col_name(k.depid, depkey7),
	col_name(k.depid, depkey8) from dbo.syskeys k, master.dbo.spt_values v, 
	dbo.sysobjects o where k.type = v.number and
 	k.id = o.id and (o.type = 'U'  or o.type = 'V')and v.type = 'K' and 
	o.uid = user_id("
?	o.uid = user_id()
 	order by keytype desc, o.name
? 	order by keytype desc, o.id

** get users

select u.uid, login_name = m.name, user_name = u.name, group_name = g.name from 
	dbo.sysusers u, dbo.sysusers g, master.dbo.syslogins m where 
	u.suid *= m.suid and u.gid *= g.uid and u.uid > 1 and u.uid not in 
	(select lrid from sysroles) order by u.uid desc

** 

select suser_name(a.suid), user_name(u.uid) from dbo.sysalternates a, sysusers u where 
	a.altsuid = u.suid order by suser_name(a.suid) 

select p.protecttype, b.name, a.name, user_name(p.uid) from dbo.sysprotects p, 
	master.dbo.spt_values a, master.dbo.spt_values b where a.type = "T" and 
	a.number = p.action and b.type = "T" and b.number = p.protecttype and 
	p.uid between 0 and 32767 and p.id = 0 

select p.protecttype, NULL, a.name, user_name(p.uid) from dbo.sysprotects p, 
	master.dbo.spt_values a where a.type = "T" and a.number = p.action and 
	p.uid between 0 and 32767 and p.id = 0 order by user_name(p.uid),  a.name

select p.protecttype, type =b.name, action = a.name, grantee = user_name(p.uid), 
	p.uid,  p.id, owner = user_name(o.uid),  object = o.name, p.columns , 
	preced = 10 into #makeperms from sysprotects p, sysobjects o, 
	master.dbo.spt_values b, master.dbo.spt_values a where 
	o.id = p.id and a.type = "T" and a.number = p.action and b.type = "T" and  
	b.number = p.protecttype and p.uid between 0 and 32767 and 
	o.type in ("U","V","P") group by o.id

select column_count = count(*), o.id into #makeperms2 from sysobjects o, 
	syscolumns c where o.id = c.id and o.type in ("U","V","P") group by o.id

update #makeperms set preced = 1 where grantee = 'public' 

update #makeperms set preced = 2 where grantee = 'guest' /*all groups */ 

update #makeperms set preced = 3 where uid >= 16384 /*roles are groups but have higher precedence*/ 

update #makeperms set preced =0 where grantee like '%_role' 

select distinct p.protecttype, p.type, action, grantee, p.id, owner, object, 
	column = isnull(col_name(p.id, c.number), "All") from #makeperms p , 
	master.dbo.spt_values c, #makeperms2 p2 where 
	convert(tinyint, substring(isnull(p.columns, 0x1), c.low, 1)) & c.high != 0 and 
	c.number <= p2.column_count and p.id = p2.id and action != "Execute" 
	order by object, owner, preced, grantee, action, p.type, column

select protecttype, type, action, grantee, id, owner, object, column = NULL 
	from #makeperms where action = "Execute" order by 
	preced, grantee, action, object, owner

select p.protecttype, type = '', action = a.name, grantee = user_name(p.uid), 
	p.id, p.uid, owner = user_name(o.uid), object = o.name, p.columns , 
	preced = 10 into #makeperms from sysprotects p, sysobjects o,  
	master.dbo.spt_values a where  o.id = p.id and  a.type = 'T' and  
	a.number = p.action and  p.uid between 0 and 32767 and  
	o.type in ('U','V','P') 

select column_count = count(*), o.id into #makeperms2  from sysobjects o, 
	syscolumns c where o.id = c.id  and o.type in ("U","V","P")
	group by o.id

update #makeperms set preced = 1 where grantee = 'public' 

update #makeperms set preced = 2 where grantee = 'guest' /*all groups */ 

update #makeperms set preced = 3 where uid >= 16384 /*roles are groups but have higher precedence*/ 

update #makeperms set preced =0 where grantee like '%_role' 

select distinct p.protecttype, p.type, action, grantee, p.id, owner, object, 
	column = isnull(col_name(p.id, c.number), 'All') from 
	#makeperms p, master.dbo.spt_values c, #makeperms2 p2 where 
	convert(tinyint, substring(isnull(p.columns, 0x1) , c.low, 1))  & c.high != 0  and
	c.number <= p2.column_count and p.id = p2.id and action != 'Execute' 
	order by object, preced, owner, column, grantee, p.protecttype 

select protecttype, type, action, grantee, id, owner, object, column = NULL from 
	#makeperms where action = 'Execute' order 
	by preced, grantee, action, object, owner

drop table #makeperms

drop table #makeperms2

##

select segment, segbit = 0, name into #segments from syssegments 

update #segments set segbit = power(2, segment) 

select distinct device = d.name, u.segmap into #fragments from 
	master.dbo.sysdevices d,  master.dbo.sysusages u where 
	u.dbid = db_id() and d.status & 2 = 2 and d.low <= u.vstart and 
	d.high >= (u.vstart +u.size-1) 

select s.name, device ,  action = "a" from #fragments f,  #segments s where 
	f.segmap & s.segbit = s.segbit and segbit > 4 order by 
	s.name 

select s.name, device, action = "d" from #fragments f, #segments s where 
	f.segmap & s.segbit != s.segbit and s.name in ("system", "default") and 
	f.segmap != 4 /*log only*/ 

drop table #segments 

drop table #fragments 


##

select name = b.name, b.dbid, owner_name = suser_name(suid), user_id(), b.status, 
	device   = d.name ,  usage = y.number , 
	segsize = (x.low * u.size) / (1024*1024) , pagesize = x.low from 
	master.dbo.sysdatabases b ,master.dbo.sysusages u , master.dbo.sysdevices d ,
	master.dbo.spt_values  x ,master.dbo.spt_values  y where   
	b.dbid   = u.dbid and d.low   <= u.size + u.vstart and 
	d.high  >= u.size + u.vstart - 1 and d.status & 2 = 2 and 
	x.type   = "E" and x.number = 1 and y.type   = "S" and 
	u.segmap & 7 = y.number order by b.dbid 

##  here follow two version of what looks like the same code.  version diff?

declare @pages int 
declare @ipages int 
declare @reserved int 


select @pages = sum(dpages) from dbo.sysindexes i where 
	(i.id not in (select distinct id from dbo.sysobjects where type = "S") 
	or i.id = object_id("syscomments")) and indid  < 2 

select @ipages =  isnull(sum(used),0) from dbo.sysindexes i where indid = 255 

select @reserved = sum(reserved) from dbo.sysindexes where indid in (0, 1, 255) 

select  @pages, @ipages, @reserved, db_id() 

##

declare @pages int 
declare @ipages int 
declare @reserved int 

select @pages = sum(data_pgs(id, doampg)) from dbo.sysindexes i where 
	(i.id not in (select distinct id from dbo.sysobjects where type = "S") 
	or i.id = object_id("syscomments")) and indid  < 2 

select @ipages =  isnull(sum(data_pgs(id, ioampg)),0) from dbo.sysindexes i 
	where indid = 255 

select @reserved = sum(reserved_pgs(id,doampg)+reserved_pgs(id, ioampg)) from 
	dbo.sysindexes where indid in (0, 1, 255) 

select  @pages, @ipages, @reserved, db_id() 

##  not sure what's going on here.

use master
	select into/bulkcopy
	trunc. log on chkpt
	no chkpt on recovery
	read only
	dbo use only
	single user

use %s
checkpoint
sp_dboption %s, "%s", true

use master
sp_dboption 
, bulkcopy, false
use 
checkpoint
ignore_dup_key
unique
ignore_dup_row
allow_dup_row
clustered
nonclustered
dbsizeaquery
setuser "%s"
master
model

##  Looks like we're setting up a database here.

if exists (select * from sysobjects 
where name = "%s")
begin
drop %s %s
%-255s
setuser "dbo"
execute sp_droptype dummytype
setuser "dbo"
execute sp_addtype dummtype
, int
setuser  "
execute sp_addtype 
", "identity
, null
setuser  "
execute sp_addmessage 
setuser  "dbo"
execute sp_addthreshold 
execute sp_addgroup 
guest
execute sp_adduser guest
print "Caution: missing login for user 
execute sp_adduser "
public
, NULL 
execute sp_addalias 
setuser  "
setuser  "dbo"

##

select indid, status, keycnt from %s where indid >= 1 and id = OBJECT_ID('%s') order by
 indid, keycnt 

##

