/*
**
**		DATABASE: metabase
**
**		CONTENTS: Indexes, Viewes, Stored Procs, Triggers, etc.- Part Two
**
**		CREATED: Nov 23 1998 11:04PM
**
**		by resql 
**
**		Copyright Oct 4, 1989
**
**		Elmwood Information Systems
**
**		(510) 548-2722
**		(510) 841-4616 (fax)
**
**		lance@dbo.com
**
*/
if exists (select * 
	from master.dbo.sysdatabases
	where name = "metabase")
begin
	print 'Rebuilding the database metabase '
end
else
begin
	print 'The database metabase does not exist!'
	print 'You have 30 seconds to abort.'
	print 'Type Control c or metabase objects will be created in your default database.'
end
go
if exists (select * 
	from master.dbo.sysdatabases
	where name = "metabase")
use metabase

else
waitfor delay "00:00:30"
go

					/**** start of reset bulkcopy ****/ 

print "creating reset bulkcopy"
go

					/****   end of reset bulkcopy ****/ 

					/**** start of indexes ****/ 

print "creating indexes"
go

go

					/****   end of indexes ****/ 

					/**** start of views ****/ 

print "creating views"
go

go

					/****   end of views ****/ 

					/**** start of stored procedures ****/ 

print "creating stored procedures"
go

create procedure get_new_no @arg1 varchar(40), @arg2 int output
as begin
select @arg2 = (select nserial from numbers holdlock
                where tablename = @arg1)
update numbers set nserial = @arg2 + 1
                where tablename = @arg1
end

   
                                                                                                                                                                                                                                                              
go

					/****   end of stored procedures ****/ 

					/**** start of triggers ****/ 

print "creating triggers"
go

create trigger t_cata_i on catalogs for insert
as
begin
declare @newnum int

select @newnum = 0

/* will get the next number and update the new record with new number */

        execute metabase..get_new_no 'catalogs',@newnum output
        update catalogs

     set catalogs.catid = @newnum
          from catalogs, inserted
          where catalogs.catid = inserted.catid

        print '%1! IS THE NEW catalogs ID',@newnum
end

                                                                             
                                                                                                                                                                                                                                                              
go

create trigger t_ddict_i on data_dict for insert
as
begin
declare @newnum int

select @newnum = 0

/* will get the next number and update the new record with new number */
        execute metabase..get_new_no 'data_dict',@newnum output
        update data_dict

     set data_dict.ddid = @newnum, uid = suser_id(),
                stamp = getdate()
          from data_dict, inserted
          where data_dict.ddid = inserted.ddid

        print '%1! IS THE NEW data_dict ID',@newnum
end

                    
                                                                                                                                                                                                                                                              
go

create trigger t_form_i on forms for insert
as
begin
declare @newnum int,		@newitem int,
        @fy int,		@fid int,
	@fname char(10),	@ftype char(2),
	@levid tinyint,		@item smallint,
	@area char(1),		@wtype char(2),
	@tbln varchar(40),	@fldn varchar(40),
	@wname char(10),	@labx float,
	@laby float,		@labs smallint,
	@labf varchar(40),	@labt varchar(40),
	@laba char(2),		@entx float,
	@enty float,		@ents smallint,
	@entf varchar(40),	@enta char(2),
	@cmd varchar(255),	@next smallint,
	@prev smallint,		@help varchar(30),
	@dflt varchar(40),	@cmd2 varchar(255),
	@echo int

select @newnum = 0
select @fid = fid, @fname = fname, @ftype = ftype, @levid = levid, @item = item,
	@area = area, @wtype = wtype, @tbln = tbln, @fldn = fldn, @wname = wname,
	@labx = labx, @laby = laby, @labs = labs, @labf = labf, @labt = labt,
	@laba = laba, @entx = entx, @enty = enty, @ents = ents, @entf = entf,
	@enta = enta, @cmd = cmd, @next = next, @prev = prev, @help = help,
	@dflt = dflt, @cmd2 = cmd2, @echo = echo
	from inserted

select @newitem = (select max(item) from forms where fname = @fname and levid = @levid)
if @newitem is NULL begin
	select @newitem = 0
end else begin

	select @newitem = @newitem + 1
end
if (select count(*) from forms where fname = @fname and levid =@levid
	and wname = @wname) > 1 begin
	print 'ERROR Widget %1! already exists in %2! levid %3!:',
	@fname,@wname,@levid
	rollback transaction
end
else if (@wtype = 'GN') and ((select count(*) from forms where fname = @fname
	and levid = @levid and wtype = 'GN') > 1) begin
	print 'ERROR Already exist a GN record with fname and levid : %1!, %2!',
		@fname,@levid
	rollback transaction
end
else begin
	rollback transaction
	if @wtype not in ('EN', 'TX', 'LB') begin
		select @prev = null, @next = null
	end
/* will get the next number and insert a new record with new number */
	execute metabase..get_new_no 'forms',@newnum output
	insert forms values(@newnum,@fname,@ftype,@levid,@newitem,@area,@wtype,
		@tbln,@fldn,@wname,@labx,@laby,@labs,@labf,@labt,@laba,@entx,@enty,
		@ents,@entf,@enta,@cmd,@next,@prev,@help,@dflt,@cmd2,@echo) 
 
	print '%1! %2! ARE THE NEW form ID and item',@newnum,@newitem
end
end

                                                                                                               
                                                                                                                                                                                                                                                              
go

create trigger t_nums_i on numbers for insert
as
begin
declare @tablename varchar(30)

select @tablename = tablename from inserted

if (select count(*) from numbers where tablename = @tablename) > 1 begin
        print "ERROR Tablename already exists : %1!",@tablename
        rollback transaction
end
else begin
        update numbers
          set uid = suser_id(), stamp = getdate()
          from numbers
          where tablename = @tablename
end
end

                                                    
                                                                                                                                                                                                                                                              
go

create trigger t_nums_u on numbers for update
as
begin
/* Will not let you do an update unless you are dbo or from a trigger */
if ((select suser_id()) != 1) and (@@nestlevel <= 1) begin
        print "ERROR You do not have permission to change this table"
        rollback transaction
end
end


                                                                                                                                                                                                                     
                                                                                                                                                                                                                                                              
go

					/****   end of triggers ****/ 

					/**** start of object permissions ****/ 

print "creating object permissions"
go

Grant Select on catalogs to public
Grant Select on data_dict to public
Grant Select on datapaths to public
Grant Select on fassists to public
Grant Select on forms to public
Grant Select on formtypes to public
Grant Select on fwidgets to public
Grant Select on hrefs to public
Grant Select on numbers to public
Grant Update on numbers to public
go

					/****   end of object permissions ****/ 

					/**** start of keys ****/ 

print "creating keys"
go

execute sp_primarykey catalogs, catid
go

execute sp_primarykey data_dict, ddid
go

execute sp_primarykey fassists, fid
go

execute sp_primarykey forms, fid
go

execute sp_primarykey formtypes, formtype
go

execute sp_primarykey numbers, tablename
go

execute sp_primarykey spstates, state
go

dump tran metabase with truncate_only

go

					/**** end of script ****/ 
