/*
**
**		DATABASE: metabase
**
**		CONTENTS: Users, Groups, Defaults, Rules & Tables - Part One
**
**		CREATED: Nov 23 1998 11:04PM
**
**		by resql 
**
**		Copyright Oct 4, 1989
**
**		Elmwood Information Systems
**
**		(510) 548-2722
**		(510) 841-4616 (fax)
**
**		lance@dbo.com
**
*/
if exists (select * 
	from master.dbo.sysdatabases
	where name = "metabase")
begin
	print 'Rebuilding the database metabase '
end
else
begin
	print 'The database metabase does not exist!'
	print 'You have 30 seconds to abort.'
	print 'Type Control c or metabase objects will be created in your default database.'
end
go
if exists (select * 
	from master.dbo.sysdatabases
	where name = "metabase")
use metabase

else
waitfor delay "00:00:30"
go

					/**** start of dboptions ****/ 

print "creating dboptions"
go
use master
go
sp_dboption metabase, "select into/bulkcopy", true
go
use metabase
go
checkpoint
go

					/****   end of dboptions ****/ 

					/**** start of groups users ****/ 

print "creating groups users"
go

execute sp_adduser "mykland"
execute sp_adduser "jim"
execute sp_adduser "ktl"
execute sp_adduser "will"
execute sp_adduser guest
execute sp_adduser "sutin"
execute sp_adduser "kibrick"
execute sp_adduser "sla"
execute sp_adduser "tucker"
execute sp_adduser "drew"
go

					/****   end of groups users ****/ 

					/**** start of aliases ****/ 

print "creating aliases"
go

go

					/****   end of aliases ****/ 

					/**** start of action permissions ****/ 

print "creating action permissions"
go

go

					/****   end of action permissions ****/ 

					/**** start of segments ****/ 

print "creating segments"
go

					/****   end of segments ****/ 

					/**** start of datatypes ****/ 

print "creating datatypes"
go

					/****   end of datatypes ****/ 

					/**** start of defaults ****/ 

print "creating defaults"
go

					/****   end of defaults ****/ 

					/**** start of rules ****/ 

print "creating rules"
go

					/****   end of rules ****/ 

					/**** start of tables ****/ 

print "creating tables"
go
create table catalogs
	(
	catid	int,
	tbln	varchar(40),
	catname	varchar(40)	NULL,
	author	varchar(40)	NULL,
	reference	varchar(40)	NULL,
	catdate	smalldatetime	NULL,
	numrec	int	NULL,
	numcol	smallint	NULL,
	loaded	smalldatetime	NULL,
	comments	varchar(255)	NULL,
	)
go
create table data_dict
	(
	ddid	int,
	dbase	char(20)	NULL,
	owner	char(20)	NULL,
	tbln	varchar(40),
	fldn	varchar(40),
	ddesc	varchar(255)	NULL,
	xref	int	NULL,
	uid	int	NULL,
	stamp	datetime	NULL,
	)
go
create table datapaths
	(
	fqtn	varchar(80),
	fldn	varchar(40),
	href	varchar(255),
	lref	varchar(255),
	htyp	char(1)	NULL,
	)
go
create table fassists
	(
	fid	int,
	sqlcmd	varchar(255),
	resindex	smallint,
	ident	varchar(20)	NULL,
	width	int	NULL,
	inswid	varchar(40)	NULL,
	)
go
create table forms
	(
	fid	int,
	fname	char(10)	NULL,
	ftype	char(2)	NULL,
	levid	tinyint	NULL,
	item	smallint	NULL,
	area	char(1)	NULL,
	wtype	char(2)	NULL,
	tbln	varchar(40)	NULL,
	fldn	varchar(40)	NULL,
	wname	char(10)	NULL,
	labx	float	NULL,
	laby	float	NULL,
	labs	smallint	NULL,
	labf	varchar(40)	NULL,
	labt	varchar(40)	NULL,
	laba	char(2)	NULL,
	entx	float	NULL,
	enty	float	NULL,
	ents	smallint	NULL,
	entf	varchar(40)	NULL,
	enta	char(2)	NULL,
	cmd	varchar(255)	NULL,
	next	smallint	NULL,
	prev	smallint	NULL,
	help	varchar(30)	NULL,
	dflt	varchar(40)	NULL,
	cmd2	varchar(255)	NULL,
	echo	int	NULL,
	)
go
create table formtypes
	(
	formtype	char(2),
	menudesc	char(10),
	description	char(255)	NULL,
	)
go
create table fwidgets
	(
	wtype	char(2),
	field	char(10),
	meaning	char(15),
	srt	tinyint	NULL,
	help	char(10)	NULL,
	)
go
create table hrefs
	(
	fqtn	varchar(80),
	pkfv	varchar(40),
	hfil	varchar(40),
	htxt	varchar(255),
	)
go
create table numbers
	(
	tablename	varchar(30),
	nserial	int,
	uid	smallint	NULL,
	stamp	smalldatetime	NULL,
	)
go
create table spstates
	(
	state	char(3),
	stdesc	char(25),
	)
go

					/****   end of tables ****/ 

					/**** start of binds ****/ 

print "creating binds"
go

dump tran metabase with truncate_only

go

					/**** end of script ****/ 
