/*
**
**		DATABASE: master
**
**		CONTENTS: Indexes, Viewes, Stored Procs, Triggers, etc.- Part Two
**
**		CREATED: Nov 24 1998  1:31PM
**
**		by resql 
**
**		Copyright Oct 4, 1989
**
**		Elmwood Information Systems
**
**		(510) 548-2722
**		(510) 841-4616 (fax)
**
**		lance@dbo.com
**
*/
print 'You are about to alter the master database'
print 'Do not do this unless :'
print '	 1) you have read this script.'
print '	 2) you understand it.'
print 'You have 30 seconds to abort.'
print 'Type Control c now if you are nervous'
go
use master
go

waitfor delay "00:00:30"
go

					/**** start of reset bulkcopy ****/ 

print "creating reset bulkcopy"
go

					/****   end of reset bulkcopy ****/ 

					/**** start of indexes ****/ 

print "creating indexes"
go

go

					/****   end of indexes ****/ 

					/**** start of views ****/ 

print "creating views"
go

go

					/****   end of views ****/ 

					/**** start of stored procedures ****/ 

print "creating stored procedures"
go

go
if exists (select * from sysobjects 
where name = "sp_validlang")
begin
	drop proc sp_validlang
end
go

/* Sccsid = "@(#) generic/sproc/src/validlang 52.1 8/12/92" */
/*	4.8	1.1	06/14/90	sproc/src/serveroption */
create procedure sp_validlang
@name	varchar(30)
as

/* Check to see if this language is in Syslanguages. */
if exists (select *
		from master.dbo.syslanguages
		where name = @name)
begin
	return 0
end
return 1
                                                                                                                                                                                              
go

go
if exists (select * from sysobjects 
where name = "sp_getmessage")
begin
	drop proc sp_getmessage
end
go

/* generic/sproc/getmessage	52.1	8/12/92 */

/* Messages from sysmessages
** 17200, "Message number must be greater than or equal to 17000."
** 17201, "'%1!' is not an official language name from Syslanguages."
** 17202, "Message number %1! does not exist in the %2! language."
*/

create procedure sp_getmessage
@message_num int,
@result varchar(255) output,
@language varchar(30) = NULL
as

	declare @lang_id smallint 
	declare @msg varchar(255)
	declare @returncode smallint

	/* 
	** Use default language if none specified, 
	** and initialize result 
	*/
	select @lang_id = @@langid, @result = NULL

	/* Only retrieve external errors */
	if @message_num < 17000
	BEGIN
 		/* 17200   "Message number must be greater than or equal to 17000." */
		 select @msg = description from master.dbo.sysmessages
				    where error = 17200
		 print @msg
		 return (1)
	END

	/*
	** Check that language is valid.
	*/
	if @language is not NULL
	BEGIN
	    execute @returncode = sp_validlang @language
	    if @returncode != 0
	    begin
		    /* Us_english is always valid */
		    if @language != "us_english"
		    BEGIN
			    /* 
			    ** 17201, "'%1!' is not an official language
			    **	name from Syslanguages."
			    */
			    select @msg = description from master.dbo.sysmessages
						where error = 17201
						and langid = @@langid

			    /* Get english if the current language is missing */
			    if @msg is null
				select @msg = description from master.dbo.sysmessages
						where error = 17201
						and langid = NULL

			    print @msg, @language
			    return @returncode
		    END

		    /* set to us_english */
		    select @lang_id = NULL
	    end

	    else
	    select @lang_id = langid from syslanguages
			where @language = name

	END

	/* Get message from the proper place */
	/* System messages */
	if @message_num < 20000
	BEGIN
		select @result = description from master.dbo.sysmessages
			   where  langid = @lang_id 
			     and   error = @message_num 

		/* Get english if the current language is missing */
		if @result is null
			select @result = description from master.dbo.sysmessages
                                        where error = @message_num
                                        and langid = NULL
	END
	else
	/* User messages */
	BEGIN
		/* There is no proper alternate language for user messages */
		select @result = description from sysusermessages
			   where  langid = @lang_id 
			     and   error = @message_num 
	END

	/* Warn the user if the message can't be found */
	if @result is null
	begin
		/* 17202, "Message number %1! does not exist in the %2! language." */
		select @msg = description from master.dbo.sysmessages
			where error = 17202
			and langid = @@langid

		if @language is null
			select @language = @@language

		if @msg is null
			select @msg = "Message number %1! does not exist in the %2! language."

		print @msg, @message_num, @language

		return (1)
	end

return (0)
                                                                                                                   
go

go
if exists (select * from sysobjects 
where name = "sp_addmessage")
begin
	drop proc sp_addmessage
end
go

/* generic/sproc/addmessage	52.1	8/12/92 */

/* 
** Messages from sysmessages
**
** 17210, "Message number must be at least 20000."
** 17211, "Cannot add message until Sysusermessages system table is created properly by Upgrade."
** 17201, "'%1!' is not an official language name from Syslanguages."
** 17212, "A message with number %1! in the specified language already exists."
** 17213, "Drop the old message first if you still wish to add this one."
** 17214, "The message has been inserted."
*/
create procedure sp_addmessage
@message_num int,
@message_text varchar(255),
@language varchar(30) = NULL
as

    declare @msg varchar(255)
    declare @returncode int

    /* Use the default language by default */
    declare @lang_id smallint 
    select @lang_id = @@langid

    if @message_num < 20000
    BEGIN
	/* 17210, "Message number must be at least 20000." */
        exec sp_getmessage 17210, @msg output
        print @msg
        return (1)
    END

    /*
    ** Check to be sure Sysusermessages exists
    */
    if not exists (select * from sysobjects
    			where name = "sysusermessages"
    			and type = 'S')
    BEGIN
        /* 
	** 17211, "Cannot add message until Sysusermessages system table is
	**		created properly by Upgrade."
        */
        exec sp_getmessage 17211, @msg output
        print @msg
        return (1)
    END

    /*
    ** Check that language is valid.
    */
    if @language is not NULL
    BEGIN
        execute @returncode = sp_validlang @language
        if @returncode != 0
        begin
                /* Us_english is always valid */
                if @language != "us_english"
		BEGIN
		    	/* 
			** 17201, "'%1!' is not an official language
			**	name from Syslanguages."
			*/
		    	exec sp_getmessage 17201, @msg output
		    	print @msg, @language
		    	return @returncode
		END

		/* set to us_english */
		select @lang_id = NULL
        end

	else
	select @lang_id = langid from syslanguages
		    where @language = name
    END

    /*
    ** Make sure the message doesn't already exist.
    */
    if exists (select *
    		from sysusermessages 
    	where error = @message_num and langid = @lang_id)
    BEGIN
	/* 17212, "A message with number %1! in the specified language already exists." */
        exec sp_getmessage 17212, @msg output
        print @msg, @message_num

	/* 17213, "Drop the old message first if you still wish to add this one." */
        exec sp_getmessage 17213, @msg output
        print @msg
        return (1)
    END

    /*
    ** Check that the message is a valid one.
    */
    print @message_text, "<arg1>", "<arg2>", "<arg3>", "<arg4>",
    		    "<arg5>", "<arg6>", "<arg7>", "<arg8>",
    		    "<arg9>", "<arg10>", "<arg11>", "<arg12>",
    		    "<arg13>", "<arg14>", "<arg15>", "<arg16>",
    		    "<arg17>", "<arg18>", "<arg19>", "<arg20>"
    /*
    ** If there was an error, @@error will be non-zero
    */
    if @@error != 0
           return (1)

    /* Now, insert the message */
    insert into sysusermessages
    	    values(@message_num, suser_id(), @message_text, @lang_id)
    if @@error != 0
	return(1)
    else
    begin
    	/* 17214, "The message has been inserted." */
	exec sp_getmessage 17214, @msg output
        print @msg
    end
    return (0)
                                
go

go
if exists (select * from sysobjects 
where name = "sp_dropmessage")
begin
	drop proc sp_dropmessage
end
go

/* generic/sproc/dropmessage		52.1		8/12/92 */

/* 
** Messages from sysmessages
**
** 17201, "'%1!' is not an official language name from Syslanguages."
** 17210, "Message number must be at least 20000."
** 17220, "Message number %1! does not exist."
** 17202, "Message number %1! does not exist in the %2! language."
** 17221, "Message deleted."
** 17222, "User '%1!' does not have permission to drop message number %2!."
** 17223, "User '%1!' does not have permission to drop message number %2! in the %3! language."
*/     

create procedure sp_dropmessage
@message_num int, 
@language varchar(30) = NULL
as

    declare @msg varchar(255)
    declare @msg2 varchar(30)
    declare @lang_id smallint
    declare @returncode smallint

    /*
    ** Check that language is valid.
    */
    if @language is null
		select @lang_id = -1		/* (all) */
    else
    BEGIN
        execute @returncode = sp_validlang @language
        if @returncode != 0
        begin
                /* Us_english is always valid */
                if @language != "us_english"
		BEGIN
			/* 
			** 17201, "'%1!' is not an official language
			**		name from Syslanguages."
			*/
			exec sp_getmessage 17201, @msg output
			print @msg, @language
			return @returncode
		END

		/* set to us_english */
		select @lang_id = NULL
        end

	else
	select @lang_id = langid from syslanguages
			where @language = name
    END

    if @message_num < 20000
    begin
	/* 17210, "Message number must be at least 20000." */
        exec sp_getmessage 17210, @msg output
        print @msg
        return (1)
    end

    /*
    ** Check that message exists 
    */
    if not exists (select * from sysusermessages
			    where error = @message_num)
    begin
	/* 17220, "Message number %1! does not exist." */
	exec sp_getmessage 17220, @msg output
	print @msg, @message_num
	return (1)
    end

    /*
    ** ... In the Proper language
    */
    if @lang_id != -1 and not exists (select * from sysusermessages
		    where error = @message_num and langid = @lang_id)
    begin
	/* 17202, "Message number %1! does not exist in the %2! language." */
	exec sp_getmessage 17202, @msg output
	print @msg, @message_num, @language
	return (1)
    end

    /*
    ** Check permissions, existence
    ** If the SA or DBO is running this - then allow delete all
    */
    if suser_id() = 1 or user_id() = 1
    BEGIN
	/*
	** Do they want to delete all the messages?
	*/
	if @lang_id = -1
	begin
		delete sysusermessages
				where error = @message_num
		/* 17221, "Message deleted." */
		exec sp_getmessage 17221, @msg output
		print @msg
	end		
	/*
	** If not, delete only the message with the
	** specific language
	*/
	else
	begin
		delete sysusermessages 
			where error = @message_num and
					langid = @lang_id
		/* 17221, "Message deleted." */
		exec sp_getmessage 17221, @msg output
		print @msg
	end
     END
    else
    /* Only delete the user's specific messages */
     BEGIN
	/*
	** Do they want to delete all the messages?
	*/
	if @lang_id = -1
	begin
		if exists (select * from sysusermessages
			    where error = @message_num
					and uid = suser_id())
		begin
			delete sysusermessages
			where error = @message_num
					and uid = suser_id()
			/* 17221, "Message deleted." */
			exec sp_getmessage 17221, @msg output
			print @msg
		end
		else
		begin
			/* 
			** 17222 "User '%1!' does not have permission to 
			** 		drop message number %2!"
			*/
			exec sp_getmessage 17222, @msg output
			select @msg2 = user_name()
			print @msg, @msg2
		end
	end		
	/*
	** If not, delete only the message with the
	** specific language
	*/
       else
	if exists (select * from sysusermessages
			where error = @message_num
					and langid = @lang_id
					and uid = suser_id())
	begin
		delete sysusermessages 
				where error = @message_num
						and langid = @lang_id
						and uid = suser_id()
		/* 17221, "Message deleted." */
		exec sp_getmessage 17221, @msg output
		print @msg
	end
       else
	begin
		/* 
		** 17223 "User '%1!' does not have permission to 
		** 		drop message number %2! in the %3! language."
		*/
		exec sp_getmessage 17223, @msg output
		select @msg2 = user_name()
		print @msg, @msg2, @message_num, @language
		return (1)
	end
    END		

    return (0)
                                                                               
go

go
if exists (select * from sysobjects 
where name = "sp_validaltlang")
begin
	drop proc sp_validaltlang
end
go

/* Sccsid = "@(#) generic/sproc/src/validaltlang 52.1 8/12/92" */
/*	4.8	1.1	06/14/90	sproc/src/serveroption */
create procedure sp_validaltlang
@name	varchar(30)
as

/* Check to see if this alias is in Syslanguages. */
if exists (select *
		from master.dbo.syslanguages
		where alias = @name)
begin
	return 0
end
return 1
                                                                                                                                                                                          
go

go
if exists (select * from sysobjects 
where name = "sp_chklangparam")
begin
	drop proc sp_chklangparam
end
go

/* Sccsid = "@(#) generic/sproc/src/chklangparam 52.1 8/12/92" */
/*	4.8	1.1	06/14/90	sproc/src/chklangparam */
/*
** sp_checklangparam is called by sp_addlanguage to check the lists of
** full month names, short month names, and day names.  It returns a status
** indicating whether any errors were found:
**	0 - name list is valid
**	1 - spaces were found, which are not allowed
**	2 - not enough names in the list (must be exactly @numnames of them)
**	3 - too many names in the list (must be exactly @numnames of them)
**	4 - some name(s) are too long
**	5 - some name(s) have non-aphabetic characters
*/

/*
** Messages for "sp_chklangparam"       17373
**
** %1! is either "month" or "day" 
** 17373, "List of %1! names contains spaces, which are not allowed."
** 17374, "List of %1! names has too few names."
** 17375, "List of %1! names has too many names."
** 17376, "List of %1! names has name(s) which are too long."
** 17377, "List of %1! names contains name(s) which have '%2!' non-alphabetic characters."
** %2! is the character set name 
*/

create procedure sp_chklangparam
@namelist varchar(251),		/* month or day name list */
@msgparam varchar(30),		/* name of list, for error messages */
@numnames int,			/* correct number of names in the list */
@maxnamelen int			/* maximum length of any name in list */
as

	declare @totallen		int
	declare @mthlen			int
	declare @mthname		varchar(251)
	declare @msg			varchar(255)
        declare @csid                   tinyint
        declare @csname                 varchar(30)

        /* Get the Character Set id (csid) */
	/* (Up to the version 4.2)
	   select @csid = csid from master..syscharsets
                where id = (select value from master..sysconfigures
                        where config = 123)
	*/
	/* (After 4.9) */
	select @csid = value from master..sysconfigures 
			where config = 131

        /* Get the Character Set Name (csname) */
        select @csname = name from master..syscharsets
                where id = @csid and type < 2000

	/* Make sure the list has no blanks. */
	if ( charindex( " ", @namelist ) != 0 )
	begin
		/*
		** 17373, "List of %1! names contains spaces, which are not allowed."
		*/
		exec sp_getmessage 17373, @msg output
		print @msg, @msgparam
		return 1
	end

	/* Keep track of number of *CHARACTERS* */
	select @totallen = char_length( @namelist )
	/* select @totallen = datalength( @namelist ) */
	while ( @totallen > 0 )
	begin
		/* Move to the next name in the list. */
		select @namelist = right( @namelist, @totallen )

		/* If this is not the last name in the list then there must
		** be another comma.
		*/
		if ( @numnames > 1 )
		begin
			select @mthlen = charindex( ",", @namelist ) - 1
			if ( @mthlen < 0 )
			begin
				/*
				** 17374, "List of %1! names has too few names."
				*/
				exec sp_getmessage 17374, @msg output
				print @msg, @msgparam
				return 2
			end
		end

		/* This is the last name in the list, so there cannot be
		** another comma.  This name is all remaining characters
		** in the list.
		*/
		else
		begin
			if ( charindex( ",", @namelist ) != 0 )
			begin
				/*
				** 17375, "List of %1! names has too many names."
				*/
				exec sp_getmessage 17375, @msg output
				print @msg, @msgparam
				return 3
			end
			select @mthlen = @totallen
		end

		/* Check the name length. */
		if ( @mthlen > @maxnamelen )
		begin
			/*
			** 17376, "List of %1! names has name(s) which are too long."
			*/
			exec sp_getmessage 17376, @msg output
			print @msg, @msgparam
			return 4
		end

		/*
		** Check to see that the names contain only valid
		** P_ALPHA characters; not even DIGITs should be allowed.
		** Note that valid_name() returns a bit-mask of the lexical
		** values found in the string passed to it, where P_ALPHA
		** is 0x01.
		*/
		if (valid_name(substring(@namelist, 1, @mthlen)) != 1)
		begin
      			/*
			** 17377, "List of %1! names contains name(s) which have 
			** '%2!' non-alphabetic characters."
			*/
			exec sp_getmessage 17377, @msg output
			print @msg, @msgparam, @csname
			return 5
		end

		/* Move to the next name in the list. */
		select @numnames = @numnames - 1
		select @totallen = @totallen - @mthlen - 1
	end

	/* No problems were found with the name list. */
	return 0
                                                                    
go

go
if exists (select * from sysobjects 
where name = "sp_namecrack")
begin
	drop proc sp_namecrack
end
go

/* Sccsid = "@(#) generic/sproc/src/namecrack 52.1 8/12/92" */
/*	4.8	1.1	06/14/90	sproc/src/lock */
create procedure sp_namecrack
@name	varchar(123),
@site	varchar(30) = null output,
@db	varchar(30) = null output,
@owner	varchar(30) = null output,
@object	varchar(30) = null output
as

select @site = null, @db = null, @owner = null, @object = null

/*
**  Is there a site name?
*/
if @name like "%.%.%.%"
begin
	select @site = substring(@name, 1, charindex(".", @name) - 1)
	select @name = substring(@name, charindex(".", @name) + 1, 125)
end

/*
**  Is there a database name?
*/
if @name like "%.%.%"
begin
	select @db = substring(@name, 1, charindex(".", @name) - 1)
	select @name = substring(@name, charindex(".", @name) + 1, 125)
end

/*
**  Is there a owner?
*/
if @name like "%.%"
begin
	select @owner = substring(@name, 1, charindex(".", @name) - 1)
	select @name = substring(@name, charindex(".", @name) + 1, 125)
end

select @object = @name

return (0)
                                                       
go

go
if exists (select * from sysobjects 
where name = "sp_addalias")
begin
	drop proc sp_addalias
end
go

/* Sccsid = "@(#) generic/sproc/src/addalias 52.1 8/12/92" */
/*	4.8	1.1	06/14/90	sproc/src/addalias */

/*
** Messages for "sp_addalias"           17230
**
** 17230, "You must be the System Administrator (SA) or the Database Owner (dbo) to execute this procedure."
** 17231, "No login with the specified name exists."
** 17232, "No user with the specified name exists in the current database."
** 17233, "'%1!' is already a user in the current database."
** 17234, "The specified user name is already aliased."
** 17235, "Alias user added."
*/
create procedure sp_addalias
@loginame varchar(30),		/* the name of the pretender */
@name_in_db varchar(30)		/* who the pretender wants to pretend to be */
as

declare @suid int		/* the suid of the pretender */
declare @asuid int		/* the suid of the person to impersonate */
declare @msg    varchar(250)
declare @name   varchar(30)

/*
**  You must be SA or the dbo to execute this sproc.
*/
if suser_id() != 1 and user_id() != 1
begin
	/*
	** 17230, "You must be the System Administrator (SA) or the Database
	** Owner (dbo) to execute this procedure." 
	*/
	exec sp_getmessage 17230, @msg output
	print @msg
	return (1)
end

/*
**  Make sure that the pretender has an account.
*/
select @suid = suid
	from master.dbo.syslogins
where name = @loginame

if @suid is NULL
begin
	/* 17231, "No login with the specified name exists." */
	exec sp_getmessage 17231, @msg output
	print @msg
	return (1)
end

/*
**  Get the suid of the person we want to pretend to be.
**  All user ids are <= 16383 and group ids are > 16383.
*/
select @asuid = suid
	from sysusers
where name = @name_in_db
	and uid <= 16383

/*
**  Does the user to be impersonated exist in the current database?
*/
if @asuid is NULL
begin
	/* 
	** 17232, "No user with the specified name exists in the
	** current database." 
	*/
	exec sp_getmessage 17232, @msg out
	print @msg
	return (1)
end

/*
**  Does the login to do the impersonating already a user in the current db?
*/
if exists (select *
		from sysusers
			where suid = @suid)
begin
	/* 17233, "'%1!' is already a user in the current database." */
        select @name = name
                from sysusers
                        where suid = @suid
	exec sp_getmessage 17233, @msg out
        print @msg, @name
        return (1)
end

/*
** Is the person already aliased to a user?
*/
if exists (select *
		from sysalternates
	where suid = @suid)
begin
	/* 17234, "The specified user name is already aliased." */
	exec sp_getmessage 17234, @msg out
	print @msg
	return (1)
end

/*
**  Add the alias.
*/
insert into sysalternates (suid, altsuid)
	values (@suid, @asuid)

/* 17235, "Alias user added." */
exec sp_getmessage 17235, @msg out
print @msg

return (0)
                                                                             
go

go
if exists (select * from sysobjects 
where name = "sp_addgroup")
begin
	drop proc sp_addgroup
end
go

/* Sccsid = "@(#) generic/sproc/src/addgroup 52.1 8/12/92" */
/*	4.2	28.1	05/14/90	sproc/src/addgroup */

/*
** Messages for "sp_addgroup"           17240
**
** 17230, "You must be the System Administrator (SA) or the 
** 	  Database Owner (dbo) to exec** ute this procedure." 
** 17240, "'%1!' is not a valid name."
** 17241, "A user with the specified group name already exists."
** 17242, "A group with the specified name already exists."
** 17243, "New group added."  
*/

create procedure sp_addgroup
@grpname varchar(30)			/* new group name */
as

declare @gid int			/* group id */
declare @msg varchar(250)

/*
**  You must be SA or the dbo to execute this sproc.
*/
if suser_id() != 1 and user_id() != 1
begin
	/*
	** 	17230, "You must be the System Administrator (SA) or the 
	** 	  Database Owner (dbo) to exec** ute this procedure." 
	*/
	exec sp_getmessage 17230,  @msg out
	print @msg
	return (1)
end

/*
**  Check to see that the @grpname is valid.
*/
if valid_name(@grpname) = 0
begin

	/*
	** 17240, "'%1!' is not a valid name."
	*/ 
	exec sp_getmessage 17240,  @msg out
	print @msg, @grpname
	return 1
end

/*
**  See if the new group name is already being used as a user or group name.
*/
select @gid = uid
	from sysusers
where name = @grpname

/*
**  User ids are >0 and  <= 16383 and group ids are > 16383.
*/
if @gid is not null
begin

	if @gid > 0 and @gid <= 16383
	begin
		/*
		** 17241, "A user with the specified group name already exists."
		*/
		exec sp_getmessage 17241,  @msg out
		print @msg
	end
	else
	begin
		/*
		** 17242, "A group with the specified name already exists."
		*/
		exec sp_getmessage 17242,  @msg out
		print @msg
	end
	return (1)
end

/*
**  Now get the group id for the new group.  It is the current maximum group
**  number + 1.  If this is the first group use the lowest possible group id
**  -- 16384.
*/
select @gid = max(uid)+1
	from sysusers

/*
**  This is the first group.
*/
if @gid < 16384 or @gid = NULL
	select @gid = 16384

/*
**  Create the group.
*/
insert into sysusers (uid, suid, gid, name, environ)
values (@gid, -@gid, @gid, @grpname, "")

/*
** 17243, "New group added."  
*/
exec sp_getmessage 17243,  @msg out
print @msg

return (0)
                                                                                      
go

go
if exists (select * from sysobjects 
where name = "sp_addlogin")
begin
	drop proc sp_addlogin
end
go

/* Sccsid = "@(#) generic/sproc/src/addlogin 52.1 8/12/92" */
/*	4.8	1.1	06/14/90	sproc/src/addlogin */

/*
** Messages for "sp_addlogin"           17260
**
** 17240, "'%1!' is not a valid name." 
** 17201, "'%1!' is not an official language name from Syslanguages." 
** 17260, "Can't run %1! from within a transaction."
** 17261, "Only the System Administrator (SA) may execute this procedure."
** 17262, "A user with the specified login name already exists."
** 17263, "Database name not valid -- login not added."
** 17264, "New login created."
*/

create procedure sp_addlogin
@loginame varchar(30),			/* login name of the new user */
@passwd varchar(30) = NULL,		/* password of the new user */
@defdb varchar(30) = "master",		/* default db for the new user */
@deflanguage varchar(30) = NULL		/* default language for the new user */
as

declare @msg varchar(250)

/*
**  If we're in a transaction, disallow this since it might make recovery
**  impossible.
*/
if @@trancount > 0
begin
	/*
	** 17260, "Can't run %1! from within a transaction."
	*/
	exec sp_getmessage 17260, @msg output
	print @msg, "sp_addlogin"
	return (1)
end

/*
**  Only the system administrator (sa) can run this command.
**  Check to make sure the executor is the sa.
*/
if suser_id() != 1
begin
	/*
	** 17261, "Only the System Administrator (SA) may execute this procedure."
	*/
	exec sp_getmessage 17261, @msg output
	print @msg
	return (1)
end

/*
**  Check to see that the @loginame is valid.
*/
declare @returncode	int
if valid_name(@loginame) = 0
begin
	/*
	** 17240, "'%1!' is not a valid name." 
	*/
	exec sp_getmessage 17240, @msg output
	print @msg, @loginame
	return 1
end

/* 
**  Check to see that the @deflanguage is valid.
*/
if @deflanguage is not null
begin
	select @returncode = 0
	execute @returncode = sp_validlang @deflanguage
	if @returncode != 0
	begin
		/* Us_english is always valid */
		if @deflanguage != "us_english"
		begin
			/*
			** 17201, "'%1!' is not an official language name from Syslanguages." 
			*/
			exec sp_getmessage 17201, @msg output
			print @msg, @deflanguage
			return @returncode
		end
	end
end

/*
**  Make sure the login doesn't already exist.
*/
if exists (select *
		  from syslogins
          where name = @loginame)
begin
	/*
	** 17262, "A user with the specified login name already exists."
	*/
	exec sp_getmessage 17262, @msg output
	print @msg
	return (1)
end

/*
**  Check that the database name is valid.
*/
if not exists (select *
			from sysdatabases
		where name = @defdb)
begin
	/*
	** 17263, "Database name not valid -- login not added."
	*/
	exec sp_getmessage 17263, @msg output
	print @msg
	return (1)
end

/*
**  Create the login.
*/
insert into syslogins(suid, status, accdate, totcpu, totio,
	spacelimit, timelimit, resultlimit, dbname, name, password, language)
select max(suid)+1, 0, getdate(), 0, 0,
	0, 0, 0, @defdb, @loginame, @passwd, @deflanguage
from syslogins

/*
** 17264, "New login created."
*/
exec sp_getmessage 17264, @msg output
print @msg
return (0)
                                          
go

go
if exists (select * from sysobjects 
where name = "sp_addtype")
begin
	drop proc sp_addtype
end
go

/* Sccsid = "@(#) generic/sproc/src/addtype 52.1 8/12/92" */
/*	4.8	1.1	06/14/90	sproc/src/addtype */

/*
** Messages for "sp_addtype"            17300
**
** 17300, "Usage: sp_addtype name, 'datatype' [,null | nonull]"
** 17301, "'%1!' is not a valid type name."
** 17302, "A type with the specified name already exists."
** 17303, "Physical datatype does not exist."
** 17304, "User-defined datatypes based on the 'timestamp' datatype are not allowed."
** 17305, "Physical datatype does not allow nulls."
** 17306, "Physical type is fixed length. You cannot specify the length."
** 17307, "You must specify a length with this physical type.
** 17308, "Illegal length specified -- must be between 1 and 255."
** 17309, "Type added."
*/

create procedure sp_addtype
@typename varchar(30),		/* name of user-defined type */
@phystype varchar(30),		/* physical system type of user-defined type */
@nulltype varchar(8) = "1"	/* default is NO NULLs */
as

declare @len int		/* length of user type */
declare @type tinyint		/* typeid of physical type */
declare @tlen tinyint		/* length of physical type */
declare @typeid smallint	/* user typeid of physical type */
declare @var bit		/* is physical type variable length? */
declare @nonull bit		/* default is to allow NO NULLs */
declare @nullegal bit		/* does physical type allow NULLs? */
declare @msg varchar(250)


/*
**  Does the user type allow NULLs?  The default is to NOT allow NULLs.
**  this is the same default the create table statement uses.
*/
if lower(@nulltype) = "null" or @nulltype = null
	select @nonull = 0
else if lower(@nulltype) in ("not null" , "nonull")
	or @nulltype = "1"
	select @nonull = 1
else
begin
	/*
	** 17300, "Usage: sp_addtype name, 'datatype' [,null | nonull]"
	*/
	exec sp_getmessage 17300, @msg output
	print @msg
	return (1)
end

/*
**  Check to see that the @typename is valid.
*/
if valid_name(@typename) = 0
begin
	/*
	** 17301, "'%1!' is not a valid type name."
	*/
	exec sp_getmessage 17301, @msg output
	print @msg, @typename
	return (1)
end

/*
**  Check to see if the type already exists.
*/
if exists (select *
		from systypes
   	where name = @typename)
begin
	/*
	** 17302, "A type with the specified name already exists."
	*/
	exec sp_getmessage 17302, @msg output
	print @msg
	return (1)
end

/*
**  If a length was given with the user datatype, extract it.
*/
if @phystype like "_%(%)"
begin
	select @len = convert(int, substring(@phystype,
		charindex("(",@phystype) + 1,
		charindex(")",@phystype) - 1 - charindex("(",@phystype)))

	/*
	** Extract the physical type name
	*/
	select @phystype = substring(@phystype, 1,
		   charindex("(", @phystype) - 1)
end

/*
**  Make sure that the physical type exists and get its characteristics.
**  DataServer physical types have a usertype < 100 and are owned by the
**  dbo (userid = 1).
*/
select @type = type, @tlen = length, @typeid = usertype,
	@var = variable, @nullegal = allownulls
from systypes
	where usertype < 100 and name = @phystype and uid = 1

if @type = NULL
begin
	/*
	** 17303, "Physical datatype does not exist."
	*/
	exec sp_getmessage 17303, @msg output
	print @msg
	return (1)
end

/*
**  Disallow user-defined datatypes on timestamps.  This is done because
**  a timestamp is not a basic type but is really a binary.  There is,
**  therefore, no way to tell if a user-defined datatype is mapped to
**  a binary or a timestamp.  Timestamps can't have rules or defaults.
*/
if @phystype = "timestamp"
begin
	/*
	** 17304, "User-defined datatypes based on the 'timestamp' datatype are not allowed."
	*/
	exec sp_getmessage 17304, @msg output
	print @msg
	return (1)
end

/*
**  Check if the NULL status of the user type is consistent with the NULL status
**  of the physical type.  Here are the possible cases.
**
**		   physical type
**		  NULLs	  NONULLs
**	        -----------------
** user	NULLs	|  ok	|  no
** type NONULLs	|  ok	|  ok
*/
if @nonull = 0 and @nullegal = 0
begin
	/*
	** 17305, "Physical datatype does not allow nulls."
	*/
	exec sp_getmessage 17305, @msg output
	print @msg
	return (1)
end

/*
**  We'll use the variable @nullegal when we update the systypes table
**  so we need to set it to reflect if NULLs are allowed (@nonull = 0)
**  or NO NULLs are allowed (@nonull = 1).
*/
if @nonull = 0
begin
	select @nullegal = 1
end
else
begin
	select @nullegal = 0
end

/*
**  Typeids 1 (char), 2 (varchar), 3 (binary), 4 (varbinary) 
**  24 (nchar) and 25 (nvarchar) are the
**  only ones which allow a length to be specified.
*/
if @typeid > 4 and @typeid not in (24, 25) 
begin
	/*
	**  We can't use a length and we got one.
	*/
	if @len > 0
	begin
		/*
		** 17306, "Physical type is fixed length. You cannot specify the length."
		*/
		exec sp_getmessage 17306, @msg output
		print @msg
	   	return (1)
	end

	/*
	**  Use the fixed length of the physical type.
	*/
	select @len = @tlen
end
else
begin
	/*
	**  We need a length and we didn't get one.
	*/
	if @len = NULL
	begin
		/*
		** 17307, "You must specify a length with this physical type. 
		*/
		exec sp_getmessage 17307, @msg output
		print @msg
		return (1)
	end

	/*
	** If the typeid is "nchar" or "nvarchar", caluculate the real length
	*/

	if @typeid = 24 or @typeid = 25
		select @len = @len * @@ncharsize

	if @len <= 0 or @len > 255
	begin
		/*
		** 17308, "Illegal length specified -- must be between 1 and 255."
		*/
		exec sp_getmessage 17308, @msg output
		print @msg
		return (1)
	end


end


/*
**  Finally, get the maximum existing user type so we use it + 1 for this
**  new type.
*/
select @typeid = max(usertype)
	from systypes

/*
**  There are no user defined types yet so use the first number (101).
*/
if @typeid < 100
	select @typeid = 100

insert systypes (uid, variable, type, length, tdefault,
	domain, name, usertype, allownulls)
select user_id(), @var, @type, @len, 0, 0, @typename, @typeid + 1, @nullegal

/*
** 17309, "Type added."
*/
exec sp_getmessage 17309, @msg output
print @msg

return (0)
                                                                                                                                                   
go

go
if exists (select * from sysobjects 
where name = "sp_addumpdevice")
begin
	drop proc sp_addumpdevice
end
go

/* Sccsid = "@(#) generic/sproc/addumpdevice 52.1 8/12/92" */
/*	4.8	1.1	06/14/90	sproc/src/addumpdevice */

/*
** Messages for "sp_addumpdevice"       17310
**
** 17260, "Can't run %1! from within a transaction." 
** 17261, "Only the System Administrator (SA) may execute this procedure." 
** 17240, "'" + @logicalname + "' is not a valid name." 
** 17310, "Unknown device type.  Use 'disk' or 'tape'."
** 17311, "@logicalname may not be NULL."
** 17312, "@physicalname may not be NULL."
** 17313, "@cntrltype may not be NULL."
** 17314, "Device with same logical name already exists."
** 17315, "For disk devices, controller number parameter must be 2."
** 17316, "For tape devices, controller number parameter must be between 3 and 8." 
** 17317, "Please specify media capacity in megabytes (1 MB minimum)."
** 17318, "The only legal option for a tape device is 'skip' or 'noskip'."
** 17319, "'Disk' device added."
** 17320, "'Tape' device added."
** 17321, "WARNING: physical device name '%1!' is not unique." 
** 17322, "Unknown device type.  Use 'disk' or 'tape' or 'channel'." 
** 17323, "For channel devices, controller number parameter must be between 9 and 14."
** 17324, "'Channel' device added." 
*/

create procedure sp_addumpdevice
@devtype	varchar(10),		/* disk, tape, or special */
@logicalname	varchar(30),		/* logical name of the device */
@physicalname	varchar(127),		/* physical name of the device */
@cntrltype	smallint,		/* controller number */
@devstatus	varchar(40) = "noskip",	/* device characteristics */
@tapesize	int = null		/* capacity of tape in MB */
as

declare @status smallint		/* status bits for device */
declare @msg varchar(250)
declare @tapeblocksize int
declare @name varchar(30)
declare @channels_supported	int	/* 1 means channels supported, 0 not */

/*
**  If we're in a transaction, disallow this since it might make recovery
**  impossible.
*/
if @@trancount > 0
begin
	/*
	** 17260, "Can't run %1! from within a transaction." 
	*/
	select @name = "sp_addumpdevice"
	exec sp_getmessage 17260, @msg output
	print @msg, @name
	return (1)
end

/*
**  You must be SA to execute this sproc.
*/
if suser_id() != 1 
begin
	/*
	** 17261, "Only the System Administrator (SA) may execute this procedure." 
	*/
	exec sp_getmessage 17261, @msg output
	print @msg
	return (1)
end

/*
**  Check to see that the @logicalname is valid.
*/
if valid_name(@logicalname) = 0
begin
	/*
	** 17240, "'" + @logicalname + "' is not a valid name." 
	*/
	exec sp_getmessage 17240, @msg output
	print @msg, @logicalname
	return (1)
end

/*
**  The rules for updating sysdevices are as follows:
**	devtype - may be disk, tape, or channel.  If disk then
**			cntrltype will be 2,
**		if tape then 3-8 depending on
**			whether there have already been tapes added.
**		if channel then 9-14 depending on
**			whether there have already been channel devices added
**		NOTE:  These are completely host dependent.  They probably
**		need to be changed for each DataServer host type.
**	logicalname - may be any identifier but must be unique
**	physicalname - may be anything and doesn't have to be unique
**		If it contains illegal id characters, e.g., '/', then
**		it must be in quotes.
**	status - for a tape device it may be 'skip'.  The default is 'noskip'.
**		For disk and channel devices it is ignored.
**	tapesize - for a tape device, this is the tape capacity in MB.  It
**		is ignored on VMS.
*/

/*
** Determine whether channel devices are supported.
*/
if exists (select * from spt_values where type = "G" and number = 0 and low = 1)
	select @channels_supported = 1
else
	select @channels_supported = 0

/*
**  Check out the @devtype.
*/
select @devtype = lower(@devtype)
if (@devtype not in ("disk", "tape", "channel")) or
	(@devtype = "channel" and @channels_supported = 0)
begin
	if (@channels_supported = 0)
		/*
		** 17310, "Unknown device type.  Use 'disk' or 'tape'."
		*/
		exec sp_getmessage 17310, @msg output
	else
		/*
		** 17322, "Unknown device type.  Use 'disk' or 'tape' or 'channel'."
		*/
		exec sp_getmessage 17322, @msg output
	print @msg
	return (1)
end

/*
**  Check the args are not NULL.
*/
if @logicalname = null
begin
	/*
	** 17311, "@logicalname may not be NULL."
	*/
	exec sp_getmessage 17311, @msg output
	print @msg, @logicalname
	return
end
if @physicalname = null
begin
	/*
	** 17312, "@physicalname may not be NULL."
	*/
	exec sp_getmessage 17312, @msg output
	print @msg, @physicalname
	return
end
if @cntrltype = null
begin
	/*
	** 17313, "@cntrltype may not be NULL."
	*/
	exec sp_getmessage 17313, @msg output
	print @msg, @cntrltype
	return
end

/*
**  Make sure that a device with @logicalname doesn't already exist.
*/
if exists (select *
		from master.dbo.sysdevices
			where name = @logicalname)
begin
	/*
	** 17314, "Device with same logical name already exists."
	*/
	exec sp_getmessage 17314, @msg output
	print @msg
	return (1)
end

/*
**  Check @cntrltype.  On UNIX, it must be 2 if @devtype = disk,
**  between 3 and 8 for @devtype = tape, and between 9 and 14 for
**  @devtype = channel.  For other hosts, it will undoubtedly be different.
*/
if @devtype = "disk" and @cntrltype != 2
begin
	/*
	** 17315, "For disk devices, controller number parameter must be 2."
	*/
	exec sp_getmessage 17315, @msg output
	print @msg
	return (1)
end

/*  @devtype = "tape" */
else if @devtype = "tape" and @cntrltype not between 3 and 8
begin
	if @devtype = "tape" and @cntrltype not between 3 and 8
	begin
		/*
		** 17316, "For tape devices, controller number parameter must be between 3 and 8." 
		*/
		exec sp_getmessage 17316, @msg output
		print @msg
		return (1)
	end
end

/*  @devtype = "channel" */
else if @devtype = "channel" and @cntrltype not between 9 and 14
begin
	/*
	** 17323, "For channel devices, controller number parameter must be between 9 and 14."
	*/
	exec sp_getmessage 17323, @msg output
	print @msg
	return (1)
end


/*
**  Always turn on the dump status bit.
*/
select @status = 16

/*
**  If @devtype is a tape then check to see if devstatus is 'skip'.
*/
if @devtype = "tape"
begin
	/*
	**  If this is not VMS, then @tapesize is required.
	*/
	if not exists (select *
			from master.dbo.spt_values
				where type = "E"
					and name = "vms")
	begin
		if @tapesize = null or @tapesize < 1
		begin
			/*
			** 17317, "Please specify media capacity in megabytes (1 MB minimum)."
			*/
			exec sp_getmessage 17317, @msg output
			print @msg
			return (1)
		end

		/*
		**  @tapesize is given in MB but sysdevices expects number
		**  of 32k blocks so do the conversion.
                **
                **  But first get the size of a tape block. Default to 32k.
		*/
                select @tapeblocksize = low
                        from master.dbo.spt_values
                                where type = "E"
                                        and number = 4
                if @tapeblocksize = NULL
                begin
                        select @tapeblocksize = 32768
                end

                select  @tapesize =
                        convert(int, ((@tapesize * 1048576.)
                                + @tapeblocksize -1) / @tapeblocksize)
	end
	else
	begin
		select @tapesize = 0
	end

	select @devstatus = lower(@devstatus)

	if @devstatus != "noskip" and @devstatus != "skip"
	begin
		/*
		** 17318, "The only legal option for a tape device is 'skip' or 'noskip'."
		*/
		exec sp_getmessage 17318, @msg output
		print @msg
		return (1)
	end
	if @devstatus = "skip"
		select @status = @status | 8
end
else select @tapesize = 0

/* Tell the server about the device by inserting into sysdevices */
insert into sysdevices (low, high, status, cntrltype, name, phyname)
	values (0, @tapesize, @status, @cntrltype, @logicalname, @physicalname)

if @devtype = "disk"
	/*
	** 17319, "'Disk' device added."
	*/
	exec sp_getmessage 17319, @msg output
else if @devtype = "tape"
	/*
	** 17320, "'Tape' device added."
	*/
	exec sp_getmessage 17320, @msg output
else
	/* Must be a channel device */
	/*
	** 17324, "'Channel' device added."
	*/
	exec sp_getmessage 17324, @msg output

print @msg

/*
**  Warn about duplicate physical names.
*/
if (select count(*)
	from master.dbo.sysdevices
		where phyname = @physicalname) > 1
begin
	/*
	** 17321, "WARNING: physical device name '%1!' is not unique."   
	*/
	exec sp_getmessage 17321, @msg output
	print @msg, @physicalname
end

return (0)
                 
go

go
if exists (select * from sysobjects 
where name = "sp_adduser")
begin
	drop proc sp_adduser
end
go

/* Sccsid = "@(#) generic/sproc/src/adduser 52.1 8/12/92" */
/*	4.8	1.1	06/14/90	sproc/src/adduser */

/*
** Messages for "sp_adduser"            17330
**
** 17230, "Only the System Administrator (SA) or the Database Owner (dbo) may execute this stored procedure." 
** 17240, "'" + @name_in_db + "' is not a valid name." 
** 17231, "No login with the specified name exists." 
** 17330, "A user with the same name already exists in the database."
** 17331, "User already has a login under a different name."
** 17332, "User already has alias access to the database."
** 17333, "No group with the specified name exists." 
** 17334, "All user ids have been assigned."
** 17335, "New user added."
*/

create procedure sp_adduser
@loginame varchar(30),			/* user's login name in syslogins */
@name_in_db varchar(30) = NULL,		/* user's name to add to current db */ 
@grpname varchar(30) = NULL		/* group to put new user in */
as

declare @suid int			/* user's system id */
declare @grpid int			/* group id of group to put user in */
declare @uid int			/* new user's id */
declare @msg varchar(250)

/*
**  You must be SA or the dbo to execute this sproc.
*/
if suser_id() != 1 and user_id() != 1
begin
	/*
	** 17230, "Only the System Administrator (SA) or the Database Owner (dbo) may execute this stored procedure." 
	*/
	exec sp_getmessage 17230, @msg output
	print @msg
	return (1)
end

/*
**  If no new user name is given, use the login name.
*/
if @name_in_db = NULL
	select @name_in_db = @loginame

/*
**  Check to see that the @name_in_db is valid.
*/
if valid_name(@name_in_db) = 0
begin
	/*
	** 17240, "'" + @name_in_db + "' is not a valid name." 
	*/
	exec sp_getmessage 17240, @msg output
	print @msg, @name_in_db
	return (1)
end

/*
**  The name guest is a special case.  If it doesn't have a login it
**  can still be a valid user.  We'll catch it here and special case it.
*/
if @loginame = "guest" and not exists
	(select name
		from master.dbo.syslogins
			where name = @loginame)
begin
	if exists (select *
			from sysusers
		   where name = @loginame)
	begin
		/*
		** 17330, "A user with the same name already exists in the database."
		*/
		exec sp_getmessage 17330, @msg output
		print @msg
		return (1)
	end

	/*
	**  Add the guest user and return.
	*/
	insert into sysusers (uid, suid, gid, name)
		values (2, -1, 0, "guest")

	return (0)
end

/*
**  Check to see that the user has a login name.
**  We'll also initialize @grpid to 0 while we're here.
*/
select @suid = suid, @grpid = 0
	from master.dbo.syslogins
where name = @loginame

if @suid = NULL
begin
	/*
	** 17231, "No login with the specified name exists." 
	*/
	exec sp_getmessage 17231, @msg output
	print @msg
	return (1)
end

/*
**  Now check to see if the user already exists in the database.
*/
if exists (select *
		   from sysusers
	   where name = @name_in_db)
begin
	/*
	** 17330, "A user with the same name already exists in the database."
	*/
	exec sp_getmessage 17330, @msg output
	print @msg
	return (1)
end

/*
**  See if the user already has an account under a different name.
**  That is, is the user's suid already in the sysusers table.
*/
if exists (select *
	   from sysusers
	   where suid = @suid)
begin
	/*
	** 17331, "User already has a login under a different name."
	*/
	exec sp_getmessage 17331, @msg output
	print @msg
	return (1)
end

/*
**  See if the user is known in the database already with an alias.
**  That is, does the user's suid appear in the sysalternates table.
*/
if exists (select *
	   from sysalternates
	   where suid = @suid)
begin
	/*
	** 17332, "User already has alias access to the database."
	*/
	exec sp_getmessage 17332, @msg output
	print @msg
	return (1)
end

/*
**  If a group name is given, check to see that it is valid.
**  User ids are > 0 and <= 16383 and group ids are > 16383.
*/
if @grpname != NULL
begin
	select @grpid = -1
	select @grpid = gid
		from sysusers
	where name = @grpname and (uid > 16383 or uid = 0)

	if @grpid = -1
	begin
		/*
		** 17333, "No group with the specified name exists." 
		*/
		exec sp_getmessage 17333, @msg output
		print @msg
		return (1)
	end
end

/*
**  Add the user to the sysusers table.
**  Check to see if the special user 'guest' (uid = 2) has already
**  been added.  If not then the uid to use is 3, otherwise max(uid) + 1.
*/
select @uid = max(uid) + 1
	from sysusers
		where uid < 16384 and uid > 2

/* check if there's any more user id's available */
if @uid >= 16384
begin
	/*
	** 17334, "All user ids have been assigned."
	*/
	exec sp_getmessage 17334, @msg output
	print @msg
	return (1)
end

/*
**  This is the first regular user to be added so give them the first
**  number.
*/
if @uid = NULL
	select @uid = 3

insert into sysusers (uid, suid, gid, name)
	values (@uid, @suid, @grpid, @name_in_db)

/*
** 17335, "New user added."
*/
exec sp_getmessage 17335, @msg output
print @msg

return (0)
                                                                                                                                                                                                                    
go

go
if exists (select * from sysobjects 
where name = "sp_addremotelogin")
begin
	drop proc sp_addremotelogin
end
go

/* Sccsid = "@(#) generic/sproc/src/addremotelogin 52.1 8/12/92" */
/*	4.8	1.1	06/14/90	sproc/src/addremotelogin */
/*
** Messages for "sp_addremotelogin"     17270
**
** 17260, "Can't run %1! from within a transaction." 
** 17270, "There is not a server named '%1!'."
** 17271, "'%1!' is the local server - remote login not applicable."               
** 17272, "There is already a default-name mapping of a remote login from remote server '%1!'."
** 17273, "New remote login created."
** 17274, "'%1!' isn't a local user -- remote login denied."
** 17275, "There is already a remote user named '%1!' for remote server '%2!'."
** 17276  "Usage: sp_addremotelogin remoteserver [, loginame [,remotename]]"
*/

create procedure sp_addremotelogin
@remoteserver	varchar(30),		/* name of remote server */
@loginame varchar(30) = NULL,		/* user's remote name */
@remotename varchar(30) = NULL		/* user's local user name */
as

declare	@msg	varchar(200)
declare @name   varchar(30)

/*
**  If we're in a transaction, disallow this since it might make recovery
**  impossible.
*/
if @@trancount > 0
begin
	/*
	** 17260, "Can't run %1! from within a transaction." 
	*/
	exec sp_getmessage 17260, @msg output
	print @msg, "sp_addremotelogin"
	return (1)
end

/*
**  Check that the server name is valid.
*/
if not exists (select *
			from master.dbo.sysservers
		where srvname = @remoteserver)
begin
	/*
	** 17270, "There is not a server named '%1!'."
	*/
	exec sp_getmessage 17270, @msg output
	print @msg, @remoteserver
	return (1)
end

/*
**  If it's the local server don't bother.
*/
if exists (select *
		from master.dbo.sysservers
			where srvname = @remoteserver
				and srvid = 0)
begin
	/*
	** 17271, "'%1!' is the local server - remote login not applicable."        
	*/
	exec sp_getmessage 17271, @msg output
	print @msg, @remoteserver
	return (1)
end

/*
**  There are three cases to handle.
**
**	1) if only @remoteserver is given then a entry is made in
**		sysremotelogins that means anyone that doesn't have
**		an exact of mapped match in sysremotelogins will use
**		their remotename as their local name and it will be looked
**		up in syslogins.
**
**	2) if @remotename is omitted then it means that anyone from the
**		remote server logging in that doesn't have a complete
**		match in sysremotelogins will be mapped to @loginame.
**
**	3) if @remotename and @loginame are given then it is a straight
**		remote login for sysremotelogins.
*/

/*
**  Case 1:  Only @remoteserver given.
*/
if @loginame = null and @remotename = null
begin
	/*
	**  Check that there is not already an entry for local mapping.
	*/
	if exists (select *
		from master.dbo.sysremotelogins l, master.dbo.sysservers s
			where l.remoteserverid = s.srvid
				and s.srvname = @remoteserver
				and l.remoteusername = null)
	begin
		/*
		** 17272, "There is already a default-name mapping of a remote login from remote server '%1!'."
		*/
		exec sp_getmessage 17272, @msg output
		print @msg, @remoteserver
		return (1)
	end

	/*
	**  Add the entry.
	*/
	insert into master.dbo.sysremotelogins 
		(remoteserverid, remoteusername, suid, status)
	select srvid, null, -1, 0
		from master.dbo.sysservers
			where srvname = @remoteserver
	/*
	** 17273, "New remote login created."
	*/
	exec sp_getmessage 17273, @msg output
	print @msg
	return (0)

end

/*
**  Check that the @loginame is valid.  These is needed for both
**  case 2 and 3.
*/
if not exists (select *
		from master.dbo.syslogins
			where name = @loginame)
begin
	/*
	** 17274, "'%1!' isn't a local user -- remote login denied."
	*/
	exec sp_getmessage 17274, @msg output
	print @msg, @loginame
	return (1)
end

/*
**  Check to make sure that there is not already a @remotename for 
**  the @remoteserver.
*/
if exists (select *
		from master.dbo.sysremotelogins l, master.dbo.sysservers s
			where l.remoteserverid = s.srvid
				and s.srvname = @remoteserver
				and l.remoteusername = @remotename)
begin
	/*
	** 17275, "There is already a remote user named '%1!' for remote server '%2!'."
	*/
	select @name = isnull(@remotename, "NULL")
	exec sp_getmessage 17275, @msg output
	print @msg, @name, @remoteserver

	return (1)
end
	

/*
**  Case 2: We want to make an entry into sysremotelogins that will map
**	any non-exact matches to a particular local user.
*/
if @remotename = null
begin
	/*
	**  Check that there is not already an entry for local mapping.
	*/
	if exists (select *
		from master.dbo.sysremotelogins l, master.dbo.sysservers s
			where l.remoteserverid = s.srvid
				and s.srvname = @remoteserver
				and l.remoteusername = null)
	begin
		/*
		** 17272, "There is already a default-name mapping of a remote login from remote server '%1!'."
		*/
		exec sp_getmessage 17272, @msg output
		print @msg, @remoteserver
		return (1)
	end

	/*
	**  Go ahead and make the entry.
	*/
	insert into master.dbo.sysremotelogins
		(remoteserverid, remoteusername, suid, status)
	select srvid, null, suser_id(@loginame), 0
		from master.dbo.sysservers
				where srvname = @remoteserver

	/*
	** 17273, "New remote login created."
	*/
	exec sp_getmessage 17273, @msg output
	print @msg
	return (0)
end

/*
**  Case 3:  All the parameters have been supplied.  All we need to check
**	is that the entry isn't already in sysremotelogins.
**	We've verified the @remoteserver and @loginame above.
*/
if @loginame != null and @remotename != null
begin
	/*
	**  Make sure that the @loginame and @remotename are a
	**  unique combination.
	*/
	if exists (select *
		from master.dbo.sysremotelogins l, master.dbo.sysservers s
			where l.remoteusername = @remotename
				and l.remoteserverid = s.srvid
				and s.srvname = @remoteserver
				and l.suid = suser_id(@loginame))
	begin
		/*
		** 17275, "There is already a remote user named '%1!' for remote server '%2!'."
		*/
		exec sp_getmessage 17275, @msg output
		print @msg, @remotename, @remoteserver
		return (1)
	end

	/*
	**  Go ahead the do the insert.
	*/
	insert into master.dbo.sysremotelogins
		(remoteserverid, remoteusername, suid, status)
	select srvid, @remotename, suser_id(@loginame), 0
		from master.dbo.sysservers
			where srvname = @remoteserver
	/*
	** 17273, "New remote login created."
	*/
	exec sp_getmessage 17273, @msg output
	print @msg
	return (0)
end

/*
**  We got here because the syntax was incorrect.
*/
exec sp_getmessage 17276, @msg output
print @msg
return (1)
                                                                                                                                                                                                                                                          
go

go
if exists (select * from sysobjects 
where name = "sp_addsegment")
begin
	drop proc sp_addsegment
end
go

/* Sccsid = "@(#) generic/sproc/src/addsegment 52.1 8/12/92" */
/*	4.1	1.1	06/14/90	sproc/src/addsegment */
/*
** Messages for "sp_addsegment"         17280
**
** 17260, "Can't run %1! from within a transaction." 
** 17230, "Only the System Administrator (SA) or the Database Owner (dbo) may execute this stored procedure."
** 17280, "No such device exists -- run sp_helpdb to list the
** 	  devices for the current database."
** 17281, "The specified device is not used by the database."
** 17282, "The specified device is not a database device."
** 17283, "'%1!' is reserved exclusively as a log device."
** 17284, "'%1!' is not a valid identifier."
** 17285, "There is already a segment named '%1!'."
** 17286, "The maximum number of segments for the current database are already defined."
** 17287, "Segment created."
*/
create procedure sp_addsegment
@segname	varchar(30),	/* segment name */
@devname	varchar(30)	/* device name to put segment on */
as

declare @dbuid	smallint	/* id of the owner of the database */
declare @segbit	int		/* this is the bit to turn on in sysusages */
declare	@msg	char(100)
declare @name   varchar(30)

/*
**  If we're in a transaction, disallow this since it might make recovery
**  impossible.
*/
if @@trancount > 0
begin
	/*
	** 17260, "Can't run %1! from within a transaction." 
	*/
	select @name = "sp_addsegment"
	exec sp_getmessage 17260, @msg output
	print @msg, @name
	return (1)
end

/*
**  You must be SA or the dbo to execute this sproc.
*/
if suser_id() != 1 and user_id() != 1
begin
	/*
	** 17230, "Only the System Administrator (SA) or the Database Owner (dbo) may execute this stored procedure."
	*/
	exec sp_getmessage 17230, @msg output
	print @msg
	return (1)
end

/*
**  See if the device exists.
*/
if not exists (select *
		from master.dbo.sysdevices
			where name like @devname)
begin
	/*
	** 17280, "No such device exists -- run sp_helpdb to list the
	** 	  devices for the current database."
	*/
	exec sp_getmessage 17280, @msg output
	print @msg
	return (1)
end

/*
**  Check to see if the device is marked as a log device.
**  If so, print error.
*/
if exists (select *
		from master.dbo.sysusages u, master.dbo.sysdevices d
			where d.name = @devname
				and u.vstart between d.low and d.high
				and u.dbid = db_id()
				and segmap = 4)
begin
	/*
	** 17283, "'%1!' is reserved exclusively as a log device."
	*/
	exec sp_getmessage 17283, @msg output
	print @msg, @devname
	return (1)
end

/*
**  Now see if the @devname is a proper database device
*/
if not exists (select *
		from master.dbo.sysusages u, master.dbo.sysdevices d
			where d.name = @devname
				and u.vstart between d.low and d.high
				and u.dbid = db_id()
				and d.cntrltype = 0)
begin
	/*
	** 17282, "The specified device is not a database device."
	*/
	exec sp_getmessage 17282, @msg output
	print @msg
	return (1)
end

/*
**  Now see if the @dbname uses the @devname
*/
if not exists (select *
		from master.dbo.sysusages u, master.dbo.sysdevices d
			where d.name = @devname
				and u.vstart between d.low and d.high
				and u.dbid = db_id())
begin
	/*
	** 17281, "The specified device is not used by the database."
	*/
	exec sp_getmessage 17281, @msg output
	print @msg
	return (1)
end

/*
** Check for valid identifier.
*/
if valid_name(@segname) = 0
begin
	/*
	** 17284, "'%1!' is not a valid identifier."
	*/
	exec sp_getmessage 17284, @msg output
	print @msg, @segname
	return (1)
end

/*
**  Now go ahead and define the new segment and add it to the segmap
**  of sysusages.
**  NOTE: Don't update master..sysusages and syssegments as a xact since
**  	it could cause problems for recovery.
*/

/*
**  Check that @segname doesn't already exist.
*/
if exists (select *
		from syssegments holdlock
			where name = @segname)
begin
	/*
	** 17285, "There is already a segment named '%1!'."
	*/
	exec sp_getmessage 17285, @msg output
	print @msg, @segname
	return (1)
end

/*
**  Figure out the next segment number to use.
**  Segment number may be 0-31.
*/
select @segbit = 3
while @segbit < 32
begin
	/*
	**  Did we find one?
	*/
	if exists (select *
			from syssegments
				where segment = @segbit)
	begin
		select @segbit = @segbit + 1
	end

	/*
	**  We found an opening so break out.
	*/
	else break

end

if @segbit >= 32
begin
	/*
	** 17286, "The maximum number of segments for the current database are already defined."
	*/
	exec sp_getmessage 17286, @msg output
	print @msg
	return (1)
end

/*
**  Add the new segment.
*/
insert into syssegments (segment, name, status)
	values (@segbit, @segname, 0)

/*
**  Now set the segments on @devname sysusages.
*/
if (@segbit < 31)
	select @segbit = power(2, @segbit)
else
	/*
	**  Since this is segment 31, power(2, 31) will overflow
	**  since segmap is an int.  We'll grab the machine-dependent
	**  bit mask from spt_values to set the right bit.
	*/
	select @segbit = low
		from master.dbo.spt_values
			where type = "E"
				and number = 2
update master.dbo.sysusages
	set segmap = segmap | @segbit
		from master.dbo.sysusages u,
			master.dbo.sysdevices d
		where d.name = @devname
			and u.vstart between d.low and d.high
			and u.dbid = db_id()

/*
**  Now we need to activate the new segment map.
*/
declare @dbname	varchar(30)
select @dbname = db_name()
dbcc dbrepair (@dbname, remap)
/*
** 17287, "Segment created."
*/
exec sp_getmessage 17287, @msg output
print @msg
return (0)
                                                                                                                                                                                                                                       
go

go
if exists (select * from sysobjects 
where name = "sp_addserver")
begin
	drop proc sp_addserver
end
go

/* Sccsid = "@(#) generic/sproc/src/addserver 52.1 8/12/92" */
/*	4.8	1.1	06/14/90	sproc/src/addserver */

/*
** Messages for "sp_addserver"          17290
**
** 17260, "Can't run %1! from within a transaction." 
** 17240, "'" + @server + "' is not a valid name." 
** 17290, "There is already a server named '%1!'."
** 17291, "Usage: sp_addserver servername [, 'local']"
** 17292, "There is already a local server."
** 17293, "Server added."
*/

create procedure sp_addserver
@server	varchar(30),		/* server name */
@local	varchar(10) = NULL	/* local server */
as

declare	@msg	varchar(250)

/*
**  If we're in a transaction, disallow this since it might make recovery
**  impossible.
*/
if @@trancount > 0
begin
	/*
	** 17260, "Can't run %1! from within a transaction." 
	*/
	exec sp_getmessage 17260, @msg output
	print @msg, "sp_addserver"
	return (1)
end

/*
**  Server names must be unique so check.
*/
if exists (select *
		from master.dbo.sysservers
			where srvname = @server)
begin
	/*
	** 17290, "There is already a server named '%1!'."
	*/
	exec sp_getmessage 17290, @msg output
	print @msg, @server 
	return (1)
end

/*
**  Check to see that the @server is valid.
*/
if valid_name(@server) = 0
begin
	/*
	** 17240, "'" + @server + "' is not a valid name." 
	*/
	exec sp_getmessage 17240, @msg output
	print @msg, @server
	return (1)
end

/*
**  If this is the not the local server, then its srvid = max(srvid) + 1.
*/
if @local = null
begin	
	insert into master.dbo.sysservers (srvid, srvstatus, srvname, srvnetname)
			select isnull(max(srvid), 0) + 1, 0, @server, @server
				from master.dbo.sysservers
end

/*
**  If @local = "local" then this is the local server and it's
**  srvid = 0.
*/
else
begin
	if lower(@local) != "local"
	begin
		/*
		** 17291, "Usage: sp_addserver servername [, 'local']"
		*/
		exec sp_getmessage 17291, @msg output
		print @msg
		return (1)
	end

	if exists (select *
			from master.dbo.sysservers
				where srvid = 0)
	begin
		/*
		** 17292, "There is already a local server."
		*/
		exec sp_getmessage 17292, @msg output
		print @msg
		return (1)
	end

	insert into master.dbo.sysservers (srvid, srvstatus, srvname, srvnetname)
			values (0, 0, @server, @server)
end

/*
** 17293, "Server added."
*/
exec sp_getmessage 17293, @msg output
print @msg
return (0)
                                                                                                                                                                                                                                                  
go

go
if exists (select * from sysobjects 
where name = "sp_addlanguage")
begin
	drop proc sp_addlanguage
end
go

/* Sccsid = "@(#) generic/sproc/src/addlanguage 52.1 8/12/92" */
/*	4.8	1.1	06/14/90	sproc/src/addlanguage */

/*
** Messages for "sp_addlanguage"        17250
**
** 17250, "'%1!' already exists in Syslanguages."
** 17251, "'%1!' is not a valid date order."
** 17252, "'%1!' is not a valid first day."
** 17253, "'%1!' alias already exists in Syslanguages."
** 17254, "Language not inserted."
** 17255, "New language inserted."
*/

create procedure sp_addlanguage 
@language varchar(30),
@alias varchar(30) = NULL,
@months varchar(251),
@shortmons varchar(119),
@days varchar(216),
@datefmt char(3),
@datefirst tinyint
as

declare @msg varchar(250)
declare @nextlangid smallint
declare @returncode	int 
declare @convdate char(3)

/*  Check to see if the language exists. */
select @returncode = 0
execute @returncode = sp_validlang @language
if @returncode = 0
begin
	/*
	**  17250, "'%1!' already exists in Syslanguages."
	*/
	exec sp_getmessage 17250, @msg output
	print @msg, @language
	return 1
end

/* Check to see that the list of full month names is valid. */
execute @returncode = sp_chklangparam @months, "full month", 12, 20
if @returncode != 0
	return 1

/* Check to see that the list of short month names is valid. */
execute @returncode = sp_chklangparam @shortmons, "short month", 12, 9
if @returncode != 0
	return 1

/* Check to see that the list of day names is valid. */
execute @returncode = sp_chklangparam @days, "day", 7, 30
if @returncode != 0
	return 1

/* Check to see that the @datefmt is valid. */
if (@datefmt != 'mdy' and @datefmt != 'dmy' and @datefmt != 'ymd' and @datefmt != 'ydm'
	and @datefmt != 'myd' and @datefmt != 'dym')
begin
	/*
	** 17251, "'%1!' is not a valid date order."
	*/
	exec sp_getmessage 17251, @msg output
	print @msg, @datefmt
	return 1
end

/*
**  Check to see that the @datefirst is valid.
*/
if (@datefirst < 1 or @datefirst > 7)
begin
	/*
	** 17252, "'%1!' is not a valid first day."
	*/
	select @convdate = convert(char(3), @datefirst)
	exec sp_getmessage 17252, @msg output
	print @msg, @convdate
	return 1
end

/*
**  If the user didn't specify the alias name, the alias name is same as 
**  the official name.
*/
if @alias is null
begin
	select @alias =  @language
end

/*  Check to see if the alias exists. */
select @returncode = 0
execute @returncode = sp_validaltlang @alias
if @returncode = 0
begin
	/*
	** 17253, "'%1!' alias already exists in Syslanguages."
	*/
	exec sp_getmessage 17253, @msg output
	print @msg, @alias
	return 1
end

if @language = 'us_english'
begin
	/*  The language id of us_english is 0. */
	insert syslanguages (langid, dateformat, datefirst, upgrade, 
		name, alias, months, shortmonths, days)
	select 0, @datefmt, @datefirst, 0, 
		@language, @alias, @months, @shortmons, @days
end
else
begin

	if (select max(langid) from syslanguages) is null
	begin
		select @nextlangid = 1
	end
	else
	begin
		select @nextlangid = (select max(langid)+1 
		from syslanguages)
	end

	insert syslanguages (langid, dateformat, datefirst, upgrade, 
		name, alias, months, shortmonths, days)
	select @nextlangid, @datefmt, @datefirst, 0, 
		@language, @alias, @months, @shortmons, @days
end


/* If the insert failed, say so. */
if @@error != 0
begin
	/*
	** 17254, "Language not inserted."
	*/
	exec sp_getmessage 17254, @msg output
	print @msg
	return
end

/*
** 17255, "New language inserted."
*/
exec sp_getmessage 17255, @msg output
print @msg
    
                                                                                                                                             
go

go
if exists (select * from sysobjects 
where name = "sp_defaultlanguage")
begin
	drop proc sp_defaultlanguage
end
go

/* Sccsid = "@(#) generic/sproc/src/defaultlanguage 52.1 8/12/92" */
/*	4.8	1.1	06/14/90	sproc/src/defaultlanguage */

/*
** Messages for "sp_defaultlanguage"    17450
**
** 17201, "'%1!' is not a valid official language name." **
** 17450, "Only the System Administrator (SA) or '%1!' can change %2!'s default language."
** 17451, "This user does not exist.  Run sp_addlogin to add this user in."
** 17452, "%1!'s default language has been changed to %2!."
*/

create procedure sp_defaultlanguage
@loginame varchar(30),			/* login name of the user */
@language varchar(30) = NULL		/* default language for the new user */
as

declare @msg varchar(250)
declare @returncode int

/*
**  Only the system administrator (sa) can run this command.
**  Check to make sure the executor is the sa.
*/
if (suser_id() != 1 and suser_id() != suser_id(@loginame))
begin
	/*
	** 17450, "Only the System Administrator (SA) or '%1!' can change %2!'s default language."
	*/
	exec sp_getmessage 17450, @msg output
	print @msg, @loginame, @loginame
	return 1
end

/* 
**  Check to see that the @language is valid.
*/
if @language is not null
begin
	select @returncode = 0
	execute @returncode = sp_validlang @language
	if @returncode != 0
	begin
		if @language != "us_english"
		begin
			/*
			** 17201, "'%1!' is not a valid official language name." **
			*/
			exec sp_getmessage 17201, @msg output
			print @msg, @language
			return @returncode
		end
	end
end

/*
**  Make sure the login already exist.
*/
if not exists (select *
		  from syslogins
          where name = @loginame)
begin
	/*
	** 17451, "This user does not exist.  Run sp_addlogin to add this user in."
	*/
	exec sp_getmessage 17451, @msg output
	print @msg
	return 1
end

/*
**  Set the default language for this user.
*/
update syslogins 
	set language = @language
	 	where name = @loginame

/*
** 17452, "%1!'s default language has been changed to %2!."
*/
exec sp_getmessage 17452, @msg output
print @msg, @loginame, @language

return 0
                                                
go

go
if exists (select * from sysobjects 
where name = "sp_helplanguage")
begin
	drop proc sp_helplanguage
end
go

/* Sccsid = "@(#) generic/sproc/src/helplanguage 52.1 8/12/92" */
/*	4.8	1.1	06/14/90	sproc/src/fixindex */
/*
** Messages for "sp_helplanguage"       17670
**
** 17201, "'%1!' is not an official language name from Syslanguages."
** 17670, "No alternate languages are available."
** 17671, "us_english is always available, even though it is not in
**	master.dbo.syslanguages."
*/
create procedure sp_helplanguage 
@language varchar(30) = NULL
as

declare @msg varchar(250)

/* Print all languages if the user didn't give the language name. */
if @language is null
begin
	if exists (select * from syslanguages)
		select * from syslanguages
	else
	begin
		/* 17670, "No alternate languages are available." */
		exec sp_getmessage 17670, @msg out
		print @msg
	end

	/* Find out whether us_english is there or not. */
	if not exists (select * from syslanguages   
			where name = 'us_english') 
	begin
		/* 
		** 17671, "us_english is always available, even though it is not in
		** 	master.dbo.syslanguages." 
		*/
		exec sp_getmessage 17671, @msg out
		print @msg
	end

	return 0
end

/*  Report information on this language. */
if exists (select * from syslanguages   
                where name = @language) 
begin
        select * from syslanguages 
                where name = @language
        return 0
end 

if exists (select * from syslanguages
		where alias = @language)
begin
	select * from syslanguages 
		where alias = @language
	return 0
end

/* Couldn't find this language. */
if @language = 'us_english'
begin
	/* 
	** 17671, "us_english is always available, even though it is not in
	** 	master.dbo.syslanguages." 
	*/
	exec sp_getmessage 17671, @msg out
	print @msg
	return 0
end
else
begin
	/* 17201, "'%1!' is not an official language name from Syslanguages." */
	exec sp_getmessage 17201, @msg out
	print @msg, @language
	return 1
end
                                                                                                                                                                                         
go

dump tran master with truncate_only

go

go
if exists (select * from sysobjects 
where name = "sp_droplanguage")
begin
	drop proc sp_droplanguage
end
go

/* Sccsid = "@(#) generic/sproc/src/droplanguage 52.1 8/12/92" */
/*	4.8	1.1	06/14/90	sproc/src/defaultlanguage */

/*
** Messages for "sp_droplanguage"       17505
**
** 17201, "'%1!' is not an official language name from Syslanguages." 
** 17505, "Can't drop '%1!' because there are associated entries in master.dbo.sysmessages.  Run sp_droplanguage with the 'dropmessages' flag."
** 17506, "The only legal value for @dropmessages is 'dropmessages'."
** 17507, "Language deleted."
*/

create procedure sp_droplanguage 
@language varchar(30),
@dropmessages varchar(30) = NULL
as

declare @msg varchar(250)
declare @langid smallint
declare @dropmsgs int


/*  Check to see if the language exists. */
declare @returncode	int 
select @returncode = 0
execute @returncode = sp_validlang @language
if @returncode != 0
begin
	/*
	** 17201, "'%1!' is not an official language name from Syslanguages." 
	*/
	exec sp_getmessage 17201, @msg output
	print @msg, @language 
	return 1
end

/* Get language id from syslanguages. */
select @langid = (select langid 
			from syslanguages 
				where name = @language)

/*  Check to see if "dropmessages" is requested. */
select @dropmsgs = 0
if @dropmessages is null
begin
	if exists (select * from sysmessages 
			where langid = @langid)
	begin
		/* 
		**  Cannot drop a language if the language has associated
		**  entries in the master.dbo.sysmessages.
		*/

		/*
		** 17505, "Can't drop '%1!' because there are associated entries in master.dbo.sysmessages.  Run sp_droplanguage with the 'dropmessages' flag."
		*/
		exec sp_getmessage 17505, @msg output
		print @msg, @language
		return 1
	end
end
else
begin
	if @dropmessages != "dropmessages"
	begin
		/*
		** 17506, "The only legal value for @dropmessages is 'dropmessages'."
		*/
		exec sp_getmessage 17506, @msg output
		print @msg
		return 1
	end

	select @dropmsgs = 1
end

/* 
**  Drop the language and delete messages from Sysmessages if there is any.
*/
if @dropmsgs = 1
begin
	delete sysmessages
		where langid = @langid
end

delete syslanguages 
	where langid = @langid

/*
** 17507, "Language deleted."
*/
exec sp_getmessage 17507, @msg output
print @msg
                                                                                                                                          
go

go
if exists (select * from sysobjects 
where name = "sp_setlangalias")
begin
	drop proc sp_setlangalias
end
go

/* Sccsid = "@(#) generic/sproc/src/setlangalias 52.1 8/12/92" */
/*	4.8	1.1	06/14/90	sproc/src/serveroption */

/*
** Messages for "sp_setlangalias"       17810
**
** 17253, "'%1!' alias already exists in Syslanguages."
** 17201, "'%1!' is not an official language name from Syslanguages."
** 17810, "Language alias not changed."
** 17811, "Language alias reset."
*/

create procedure sp_setlangalias 
@language varchar(30),
@alias varchar(30)
as

declare @msg varchar(250)

/*  Check to see if the language exists. */
declare @returncode	int 
select @returncode = 0
execute @returncode = sp_validlang @language
if @returncode != 0
begin
	/*
	** 17201, "'%1!' is not an official language name from Syslanguages."
	*/
	exec sp_getmessage 17201, @msg output
	print @msg, @language
	return 1
end

/*  Check to see if the alias exists. */
select @returncode = 0
execute @returncode = sp_validaltlang @alias
if @returncode = 0
begin
	/*
	** 17253, "'%1!' alias already exists in Syslanguages."
	*/
	exec sp_getmessage 17253, @msg output
	print @msg, @alias
	return 1
end

/* Reset the alternate language name. */
update syslanguages 
	set alias = @alias
		where name = @language

/* If the update failed, say so. */
	if @@error != 0
begin
	/*
	** 17810, "Language alias not changed."
	*/
	exec sp_getmessage 17810, @msg output
	print @msg
	return
end

/*
** 17811, "Language alias reset."
*/
exec sp_getmessage 17811, @msg output
print @msg
                                                                                            
go

go
if exists (select * from sysobjects 
where name = "sp_bindefault")
begin
	drop proc sp_bindefault
end
go

/* Sccsid = "@(#) generic/sproc/src/bindefault 52.1 8/12/92" */
/*	4.8	1.1	06/14/90	sproc/src/bindefault */

/*
** Messages for "sp_bindefault"         17340
**
** 17340, "Default and table or usertype must be in 'current' database."
** 17341, "Usage: bindefault defaultname, objectname [, 'futureonly']"
** 17342, "No such default exists.  You must create the default first."
** 17343, "You can't bind a default to a timestamp datatype column."
** 17344, "You do not own a column of that name."
** 17345, "Default bound to column."
** 17346, "You do not own a datatype of that name."
** 17347, "Default bound to datatype."
** 17348, "The new default has been bound to columns(s) of the specified user datatype."
*/ 

/*
** IMPORTANT NOTE:
** This stored procedure uses the built-in function object_id() in the
** where clause of a select query. If you intend to change this query
** or use the object_id() or db_id() builtin in this procedure, please read the
** READ.ME file in the $DBMS/generic/sproc directory to ensure that the rules
** pertaining to object-id's and db-id's outlined there, are followed.
*/

create procedure sp_bindefault
@defname varchar(92),			/* name of the default */
@objname varchar(61),			/* table or usertype name */
@futureonly varchar(15) = NULL		/* flag to indicate extent of binding */
as

declare @futurevalue varchar(15)	/* the value of @futureonly that causes
					** the binding to be limited */
declare @msg   varchar(250)

set nocount on

select @futurevalue = "futureonly"	/* initialize @futurevalue */

/*
**  When a default or rule is bound to a user-defined datatype, it is also
**  bound, by default, to any columns of the user datatype that are currently
**  using the existing default or rule as their default or rule.  This default
**  action may be overridden by setting @futureonly = @futurevalue when the
**  procedure is invoked.  In this case existing columns with the user
**  datatype won't have their existing default or rule changed.
*/

/*
**  Check to see that the object names are local to the current database.
*/
if (@objname like "%.%.%")
   or
   (@defname like "%.%.%" and
	substring(@defname, 1, charindex(".", @defname) - 1) != db_name())
begin
	/*
	** 17340, "Default and table or usertype must be in 'current' database."
	*/
	exec sp_getmessage 17340, @msg output
	print @msg
	return (1)
end

/*
**  Check that the @futureonly argument, if supplied, is correct.
*/
if (@futureonly != null)
begin
	if (@futureonly != @futurevalue)
	begin
		/*
		** 17341, "Usage: bindefault defaultname, objectname [, 'futureonly']"
		*/
		exec sp_getmessage 17341, @msg output
		print @msg
		return (1)
	end
end

/*
**  Check to see that the default exists and get it's id.
*/
if not exists (select id
		from sysobjects
	where id = object_id(@defname)
		and sysstat & 7 = 6)		/* default object */
begin
	/*
	** 17342, "No such default exists.  You must create the default first."
	*/
	exec sp_getmessage 17342, @msg output
	print @msg
	return (1)
end

/*
**  If @objname is of the form tab.col then we are binding to a column.
**  Otherwise its a datatype.  In the column case, we need to extract
**  and verify the table and column names and make sure the user owns
**  the table that is getting the default bound.
*/
if @objname like "%.%"
begin
	declare @tabname varchar(30)		/* name of table */
	declare @colname varchar(30)		/* name of column */

	/*
	**  Get the table name out.
	*/
	select @tabname = substring(@objname, 1, charindex(".", @objname) - 1)
	select @colname = substring(@objname, charindex(".", @objname) + 1, 61)

	/*
	**  If the column type is timestamp, disallow the bind.
	**  Defaults can't be bound to timestamp columns.
	*/
	if exists (select *
			from sysobjects o, syscolumns c
		where c.id = object_id(@tabname)
			and c.name = @colname
			and c.name = @colname
			and o.id = object_id(@tabname)
			and o.sysstat & 7 = 3
			and c.usertype = 80)
	begin
		/*
		** 17343, "You can't bind a default to a timestamp datatype column."
		*/
		exec sp_getmessage 17343, @msg output
		print @msg
		return (1)
	end

	update syscolumns
		set cdefault = object_id(@defname)
			from syscolumns, sysobjects
		where syscolumns.id = object_id(@tabname)
			and syscolumns.name = @colname
			and sysobjects.id = object_id(@tabname)
			and uid = user_id()
			and sysobjects.sysstat & 7 = 3      /* user table */

	/*
	**  Did the bind happen?
	*/
	if @@rowcount != 1
	begin
		/*
		** 17344, "You do not own a column of that name."
		*/
		exec sp_getmessage 17344, @msg output
		print @msg
		return (1)
	end

	/*
	**  Since binding a default is a schema change, update schema count
	**  for the object in the sysobjects table.
	*/
	update sysobjects
		set schema = schema + 1
			from sysobjects
				where id = object_id(@tabname)
					and uid = user_id()
					and schema_inc(object_id(@tabname)) is NULL

	/*
	** 17345, "Default bound to column."
	*/
	exec sp_getmessage 17345, @msg output
	print @msg

end
else
begin
	/*
	**  We're binding to a user type.  In this case, the @objname
	**  is really the name of the user datatype.
	**  When we bind to a user type, any existing columns get changed
	**  to the new binding unless their current binding is not equal
	**  to the current binding for the usertype or if they set the
	**  @futureonly parameter to @futurevalue.
	*/
	declare @olddefault int			/* current default for type */

	/*
	**  Get the current default for the datatype.
	*/
	select @olddefault = tdefault
		from systypes
	where name = @objname
		and uid = user_id()
		and usertype > 100

	if @olddefault = null
	begin
		/*
		** 17346, "You do not own a datatype of that name."
		*/
		exec sp_getmessage 17346, @msg output
		print @msg
		return (1)
	end

	update systypes
		set tdefault = object_id(@defname)
			from systypes
		where name = @objname
			and uid = user_id()
			and usertype > 100


	/*
	** 17347, "Default bound to datatype."
	*/
	exec sp_getmessage 17347, @msg output
	print @msg

	/*
	**  Now see if there are any columns with the usertype that
	**  need the new binding.
	*/
	if isnull(@futureonly, "") != @futurevalue
		and exists (select *
			from syscolumns, systypes
				where syscolumns.usertype = systypes.usertype
					and systypes.name = @objname
					and systypes.usertype > 100
					and systypes.uid = user_id()
                                        and (syscolumns.cdefault = @olddefault
                                        or syscolumns.cdefault = 0 ) )
	begin
		/*
		**  Update the table schema to indicate that something
		**  has changed in the table's schema.
		*/
		update sysobjects
			set schema = schema + 1
				from sysobjects, syscolumns, systypes
			where sysobjects.id = syscolumns.id
				and syscolumns.usertype = systypes.usertype
				and systypes.name = @objname
				and systypes.usertype > 100
				and systypes.uid = user_id()
                                and (syscolumns.cdefault = @olddefault
                                          or  syscolumns.cdefault = 0 )
				and sysobjects.id in
					(select s.id from sysobjects s
					where schema_inc(s.id) is NULL)

		/*
		**  Update syscolumns with new binding.
		*/
		update syscolumns
			set cdefault = systypes.tdefault
				from syscolumns, systypes
			where syscolumns.usertype = systypes.usertype
				and systypes.name = @objname
				and systypes.usertype > 100
				and systypes.uid = user_id()
                                and (syscolumns.cdefault = @olddefault
                                          or  syscolumns.cdefault = 0 )


		/*
		** 17348, "The new default has been bound to columns(s) of the specified user datatype."
		*/
		exec sp_getmessage 17348, @msg output
		print @msg

	end
end

return (0)











                                                                                                                                                                                             
go

go
if exists (select * from sysobjects 
where name = "sp_bindrule")
begin
	drop proc sp_bindrule
end
go

/* Sccsid = "@(#) generic/sproc/src/bindrule 52.1 8/12/92" */
/*	4.8	1.1	06/14/90	sproc/src/bindrule */

/*
** Messages for "sp_bindrule"           17350
**
** 17344, "You do not own a column of that name." 
** 17346, "You do not own a datatype of that name." 
** 17350, "Rule and table or usertype must be in 'current' database."
** 17351, "Usage: bindrule rulename, objectname [, 'futureonly']"
** 17352, "No such rule exists.  You must create the rule first."
** 17353, "You can't bind a rule to a text, image, or timestamp datatype column."
** 17354, "Rule bound to table column."
** 17355, "You can't bind a rule to a text, image, or timestamp datatype."
** 17356, "Rule bound to datatype."
** 17357, "The new rule has been bound to column(s) of the specified user datatype."
*/


/*
** IMPORTANT NOTE:
** This stored procedure uses the built-in function object_id() in the
** where clause of a select query. If you intend to change this query
** or use the object_id() or db_id() builtin in this procedure, please read the
** READ.ME file in the $DBMS/generic/sproc directory to ensure that the rules
** pertaining to object-id's and db-id's outlined there, are followed.
*/

create procedure sp_bindrule
@rulename varchar(92),			/* name of the rule */
@objname varchar(61),			/* table or usertype name */
@futureonly varchar(15) = NULL		/* column name */
as

declare @futurevalue varchar(15)	/* the value of @futureonly that causes
					** the binding to be limited */
declare @msg varchar(250)

set nocount on

select @futurevalue = "futureonly"	/* initialize @futurevalue */

/*
**  When a default or rule is bound to a user-defined datatype, it is also
**  bound, by default, to any columns of the user datatype that are currently
**  using the existing default or rule as their default or rule.  This default
**  action may be overridden by setting @futureonly = @futurevalue when the
**  procedure is invoked.  In this case existing columns with the user
**  datatype won't have their existing default or rule changed.
*/

/*
**  Check to see that the object names are local to the current database.
*/
if (@objname like "%.%.%")
   or
   (@rulename like "%.%.%" and
	substring(@rulename, 1, charindex(".", @rulename) - 1) != db_name())
begin
	/*
	** 17350, "Rule and table or usertype must be in 'current' database."
	*/
	exec sp_getmessage 17350, @msg output
	print @msg
	return (1)
end

/*
**  Check that the @futureonly argument, if supplied, is correct.
*/
if (@futureonly != null)
begin
	if (@futureonly != @futurevalue)
	begin
		/*
		** 17351, "Usage: bindrule rulename, objectname [, 'futureonly']"
		*/
		exec sp_getmessage 17351, @msg output
		print @msg
		return (1)
	end
end

/*
**  Check to see that the rule exists and get it's id.
*/
if not exists (select id
	from sysobjects
where id = object_id(@rulename)
	and sysstat & 7 = 7)		/* rule object */

begin
	/*
	** 17352, "No such rule exists.  You must create the rule first."
	*/
	exec sp_getmessage 17352, @msg output
	print @msg
	return (1)
end

/*
**  If @objname is of the form tab.col then we are binding to a column.
**  Otherwise its a datatype.  In the column case, we need to extract
**  and verify the table and column names and make sure the user owns
**  the table that is getting the rule bound.
*/
if @objname like "%.%"
begin
	declare @tabname varchar(30)		/* name of table */
	declare @colname varchar(30)		/* name of column */

	/*
	**  Get the table name out.
	*/
	select @tabname = substring(@objname, 1, charindex(".", @objname) - 1)
	select @colname = substring(@objname, charindex(".", @objname) + 1, 61)

	/*
	**  If the column type is image, text, or timestamp, disallow the bind.
	**  Rules can't be bound to image, text, or timestamp columns.
	**  The qualification to check for types is a little strange because
	**  text and image are real, basic data types while timestamp is not.
	**  Timestamp is really a binary.  The types are checked in case
	**  there is a user-defined datatype that is an image or text.
	**  User-defined datatypes mapping to timestamp are not allowed
	**  by sp_addtype.
	*/
	if exists (select *
			from sysobjects o, syscolumns c
		where c.id = object_id(@tabname)
			and c.name = @colname
			and c.name = @colname
			and o.id = object_id(@tabname)
			and o.sysstat & 7 = 3
			and (c.type in (35, 34) or c.usertype = 80))
	begin
		/*
		** 17353, "You can't bind a rule to a text, image, or timestamp datatype column."
		*/
		exec sp_getmessage 17353, @msg output
		print @msg
		return (1)
	end

	update syscolumns
		set domain = object_id(@rulename)
			from syscolumns, sysobjects
		where syscolumns.id = object_id(@tabname)
			and syscolumns.name = @colname
			and sysobjects.id = object_id(@tabname)
			and uid = user_id()
			and sysobjects.sysstat & 7 = 3      /* user table */

	/*
	**  Did the bind happen?
	*/
	if @@rowcount != 1
	begin
		/*
		** 17344, "You do not own a column of that name." 
		*/
		exec sp_getmessage 17344, @msg output
		print @msg
		return (1)
	end

	/*
	**  Since binding a rule is a schema change, update schema count
	**  for the object in the sysobjects table.
	*/
	update sysobjects
		set schema = schema + 1
			from sysobjects
				where id = object_id(@tabname)
					and uid = user_id()
					and schema_inc(object_id(@tabname)) is NULL

	/*
	** 17354, "Rule bound to table column."
	*/
	exec sp_getmessage 17354, @msg output
	print @msg

end
else
begin
	/*
	**  We're binding to a user type.  In this case, the @objname
	**  is really the name of the user datatype.
	**  When we bind to a user type, any existing columns get changed
	**  to the new binding unless their current binding is not equal
	**  to the current binding for the usertype or if they set the
	**  @futureonly parameter to @futurevalue.
	*/
	declare @oldrule int			/* current rule for type */

	/*
	**  If the column type is image, text, or timestamp, disallow the bind.
	**  Rules can't be bound to image or text columns.
	*/
	if exists (select *
			from systypes
				where name = @objname
					and (type in (35, 34) or usertype = 80))
	begin
		/*
		** 17355, "You can't bind a rule to a text, image, or timestamp datatype."
		*/
		exec sp_getmessage 17355, @msg output
		print @msg
		return (1)
	end

	/*
	**  Get the current rule for the datatype.
	*/
	select @oldrule = domain
		from systypes
	where name = @objname
		and uid = user_id()
		and usertype > 100

	if @oldrule = null
	begin
		/*
		** 17346, "You do not own a datatype of that name." 
		*/
		exec sp_getmessage 17346, @msg output
		print @msg
		return (1)
	end

	update systypes
		set domain = object_id(@rulename)
			from systypes
		where name = @objname
			and uid = user_id()
			and usertype > 100


	/*
	** 17356, "Rule bound to datatype."
	*/
	exec sp_getmessage 17356, @msg output
	print @msg


	/*
	**  Now see if there are any columns with the usertype that
	**  need the new binding.
	*/
	if isnull(@futureonly, "") != @futurevalue
		and exists (select *
			from syscolumns, systypes
				where syscolumns.usertype = systypes.usertype
					and systypes.name = @objname
					and systypes.usertype > 100
					and systypes.uid = user_id()
                                        and (syscolumns.domain = @oldrule
                                          or  syscolumns.domain = 0 )     )
	begin
		/*
		**  Update the table schema to indicate that something
		**  has changed in the table's schema.
		*/
		update sysobjects
			set schema = schema + 1
				from sysobjects, syscolumns, systypes
			where sysobjects.id = syscolumns.id
				and syscolumns.usertype = systypes.usertype
				and systypes.name = @objname
				and systypes.usertype > 100
				and systypes.uid = user_id()
                                and (syscolumns.domain = @oldrule
                                  or  syscolumns.domain = 0 )
				and sysobjects.id in
					(select s.id from sysobjects s
					where schema_inc(s.id) is NULL)
		/*
		**  Update syscolumns with new binding.
		*/
		update syscolumns
			set domain = systypes.domain
				from syscolumns, systypes
			where syscolumns.usertype = systypes.usertype
				and systypes.name = @objname
				and systypes.usertype > 100
				and systypes.uid = user_id()
                                and (syscolumns.domain = @oldrule
                                  or  syscolumns.domain = 0 )

		/*
		** 17357, "The new rule has been bound to column(s) of the specified user datatype."
		*/
		exec sp_getmessage 17357, @msg output
		print @msg

	end
end

return (0)

                                                                                                                                                                              
go

go
if exists (select * from sysobjects 
where name = "sp_changedbowner")
begin
	drop proc sp_changedbowner
end
go

/* Sccsid = "@(#) generic/sproc/src/changedbowner 52.1 8/12/92" */
/*	4.8	1.1	06/14/90	sproc/src/changedbowner */
 
/*
** Messages for "sp_changedbowner"      17360
**
** 17231, "No login with the specified name exists."
** 17360, "Only the System Administrator (SA) can change to owner of a
**	database."
** 17361, "Can't change the owner of the master database."
** 17362, "The proposed new db owner already is a user in the database."
** 17363, "The proposed new db owner already is aliased in the database."
** 17364, "The dependent aliases were mapped to the new dbo."
** 17365, "The dependent aliases were dropped."
** 17366, "Database owner changed."
** 17431, "true"
*/

create procedure sp_changedbowner
@loginame varchar(30),         /* login to become dbo */
@map      varchar(10) = NULL   /* True to map aliases, else drop  */
as

declare @suid    smallint
declare @oldsuid smallint
declare @msg   	varchar(250)
declare @true   varchar(10)

/*
**  Only the SA can change the owner of a database.
*/
if suser_id() != 1
begin
	/*
	** 17360, "Only the System Administrator (SA) can change to owner of a database."
	*/
	exec sp_getmessage 17360, @msg output
	print @msg
	return(1)
end

/*
**  Can't change the owner of the master database.
*/
if db_id() = 1
begin
	/*
	** 17361, "Can't change the owner of the master database."
	*/
	exec sp_getmessage 17361, @msg output
	print @msg
	return(1)
end

/*
**  Make sure that @loginame exists and has a login.
*/
select @suid = suid
	from master.dbo.syslogins
		where name = @loginame

if @suid = NULL
begin
	/*
	** 17231, "No login with the specified name exists."
	*/
	exec sp_getmessage 17231, @msg output
	print @msg
	return(1)
end

/*
**  Make sure that @loginame isn't already a user or alias in the database.
*/
if exists (select *
		from sysusers
			where suid = @suid)
begin
	/*
	** 17362, "The proposed new db owner already is a user in the database."
	*/
	exec sp_getmessage 17362, @msg output
	print @msg
	return(1)
end
if exists (select *
		from sysalternates
			where suid = @suid)
begin
	/*
	** 17363, "The proposed new db owner already is aliased in the database."
	*/
	exec sp_getmessage 17363, @msg output
	print @msg
	return(1)
end

/* 
** find old (current) dbo's suid
*/
select @oldsuid = suid
	from sysusers
		where uid = 1

begin transaction

/*
**  Now change the suid of the owner of the database to the suid of @loginame.
*/
update sysusers
	set suid = @suid
		where uid = 1

/*
** if the user requested that aliases be mapped to new dbo, do that.
*/
/* 17431, "true" */
exec sp_getmessage 17431, @true out
if lower(@map) in ("true", @true)
begin

	if exists (select *
			from sysalternates
				where altsuid = @oldsuid)
	begin
		update sysalternates
			set altsuid = @suid
				where altsuid = @oldsuid

		/*
		** 17364, "The dependent aliases were mapped to the new dbo."
		*/
		exec sp_getmessage 17364, @msg output
		print @msg
	end
end
/* else drop the aliases to the old dbo */
else
begin

	if exists (select *
			from sysalternates
				where altsuid = @oldsuid)
	begin
		delete from sysalternates
			where altsuid = @oldsuid

		  
		/*
		** 17365, "The dependent aliases were dropped."
		*/
		exec sp_getmessage 17365, @msg output
		print @msg
	end
end


/*
**  Reflect the new owner of the database in master.dbo.sysdatabases.
*/
update master.dbo.sysdatabases
	set suid = @suid
		where dbid = db_id()

commit transaction

/*
**  Checkpoint the database so that the in-memory data structure for the
**  database will be consistent with sysdatabases.
*/
checkpoint

/*
** 17366, "Database owner changed."
*/
exec sp_getmessage 17366, @msg output
print @msg
return (0)







                                                                                                                                                                    
go

go
if exists (select * from sysobjects 
where name = "sp_changegroup")
begin
	drop proc sp_changegroup
end
go

/* Sccsid = "@(#) generic/sproc/src/changegroup 52.1 8/12/92" */
/*	4.8	1.1	06/14/90	sproc/src/changegroup */

/*
** Messages for "sp_changegroup"        17370
**
** 17230, "Only the System Administrator (SA) or the Database Owner (dbo) may execute this stored procedure."
** 17333, "No such group exists."
**      (is now: "No group with the specified name exists.")
** 17232, "No such user exists."
**      (is now: "No user with the specified name exists in the current
** database.")
** 17370, "Group changed."
*/

create procedure sp_changegroup
@grpname varchar(30),			/* group name */
@username varchar(30)			/* user name to add to group */
as

declare @gid int			/* group id */
declare @uid int			/* user id */
declare @msg varchar(250)

/*
**  You must be SA or the dbo to execute this sproc.
*/
if suser_id() != 1 and user_id() != 1
begin
	/*
	** 17230, "Only the System Administrator (SA) or the Database Owner (dbo) may execute this stored procedure."
	*/
	exec sp_getmessage 17230, @msg output
	print @msg
	return (1)
end

/*
**  See if the group name exists.
*/
select @gid = uid
	from sysusers
where name = @grpname
	and (uid > 16383 or uid = 0)

/*
**  If no such group, quit.
**  User ids are <= 16383 and group ids are > 16383 or = 0.
*/
if @gid = NULL
begin
	/*
	** 17333, "No such group exists."
	*/
	exec sp_getmessage 17333, @msg output
        print @msg
	return (1)
end

/*
**  See if the user name exists.
*/
select @uid = uid
	from sysusers
where name = @username
	and (uid <= 16383 and uid > 0)

/*
**  If no such user in the database, quit.
*/
if @uid = NULL
begin

	/*
	** 17232, "No such user exists."
	*/
	exec sp_getmessage 17232, @msg output
        print @msg
	return (1)
end

/*
**  Everything is consistent so change the group.
*/
update sysusers
	set gid = @gid
		from sysusers
	where uid = @uid

/*
**  We need to invalidate the protection cache since objects have
**  changed ownership.  This command will invalidate the current
**  protection cache so when protections are checked the new and
**  correct protections will be used.
*/
grant all to null

/*
** 17370, "Group changed."
*/
exec sp_getmessage 17370, @msg output
print @msg
return (0)





























































                                               
go

go
if exists (select * from sysobjects 
where name = "sp_checknames")
begin
	drop proc sp_checknames
end
go

/* Sccsid = "@(#) generic/sproc/src/checknames 52.1 8/12/92" */
/*	4.8	1.1	06/14/90	sproc/src/checknames */
create procedure sp_checknames
@mode varchar(20) = NULL		/* mode of operation; e.g. 'silent' */
as

declare @msilent	int		/* set to 1 if 'silent' mode is on */
declare @ret_val	int		/* set to 1 if we find funny char */
declare @codepoint	tinyint
declare @dbname		varchar(30)	/* holds database name */
declare @msg		varchar(255)	/* used for messages to user */
declare @pat		varchar(255)	/* holds the pattern to search for */

set nocount on

if (@mode like '%help%')
begin
	print 'sp_checknames is used to search for non 7-bit ASCII characters'
	print 'in several important columns of system tables.  The following'
	print 'columns are searched:'
	print ' '
	print '    In "master":'
	print '        sysdatabases.name'
	print '        sysdevices.name'
	print '        syslogins.name'
	print '        syslogins.dbname'
	print '        syslogins.password'
	print '        sysremotelogins.remoteusername'
	print '        sysservers.srvname'
	print '        sysservers.srvnetname'
	print ' '
	print '    In all databases:'
	print '        syscolumns.name'
	print '        sysindexes.name'
	print '        sysobjects.name'
	print '        syssegments.name'
	print '        systypes.name'
	print '        sysusers.name'
	print ' '

	return (0)
end

/*
**  First, initialize return value, and set up mode variables:
*/
select @ret_val = 0

if (@mode like '%silent%')
	select @msilent = 1
else
	select @msilent = 0


/*
**  Now, initialize the pattern string we will search for:
**	@pat contains the pattern "NOT IN THE RANGE OF all 7-bit ASCII
**	characters, except the right bracket "]".  (As of release 4.9.1,
**	it is not possible to represent the right bracket in the non-
**	inclusive matching pattern.)
*/
select @pat = '%[^- !"#$%&''()*+,./0123456789:;<=>?@ABCDEFGHIJKLMNOPQRSTUVWXYZ[\^_`abcdefghijklmnopqrstuvwxyz{|}~'

select @codepoint = 0
while (@codepoint < 32)
begin
	select @pat = @pat + char(@codepoint)
	select @codepoint = @codepoint + 1
end

select @pat = @pat + char(127) + ']%'


/*
**  Get the database name we are in:
*/
select @dbname = db_name()

if (@msilent = 0)
begin
	print ' '
	select @msg = 'Looking for non 7-bit ASCII characters in the system ' +
			'tables of database:  "' + @dbname + '"'
	print @msg
	print ' '
end


/*
**  Look through these only if in the master database:
*/
if (@dbname = 'master')
begin
    if exists (select name from master.dbo.sysdatabases
		    where name like @pat)
    begin
	if (@msilent = 1)
	    return (1)

	select @ret_val = 1
	print ' '
	print '==============================================================='
	print 'Table.Column name:  "sysdatabases.name"'
	print ' '
	print 'The following database names contain non 7-bit ASCII characters.'
	print 'If you wish to change their names, use "sp_renamedb":'
	print ' '
	select dbid,name from master.dbo.sysdatabases
			where name like @pat
    end

    if exists (select name from master.dbo.sysdevices
		    where name like @pat)
    begin
	if (@msilent = 1)
	    return (1)

	select @ret_val = 1
	print ' '
	print '==============================================================='
	print 'Table.Column name:  "sysdevices.name"'
	print ' '
	print 'The following device names contain non 7-bit ASCII characters.'
	print 'If you wish to change their names, use "UPDATE":'
        print ' '
	select name from master.dbo.sysdevices
			where name like @pat
    end

    if exists (select name from master.dbo.syslogins
		    where name like @pat)
    begin
	if (@msilent = 1)
	    return (1)

	select @ret_val = 1
	print ' '
	print '==============================================================='
	print 'Table.Column name:  "syslogins.name"'
        print ' '
	print 'The following login names contain non 7-bit ASCII characters.'
	print 'If you wish to change these names, use "sp_droplogin" and'
	print '"sp_addlogin":'
        print ' '
	select suid,name from master.dbo.syslogins
			where name like @pat
    end

    if exists (select dbname from master.dbo.syslogins
		    where dbname like @pat)
    begin
	if (@msilent = 1)
	    return (1)

	select @ret_val = 1
	print ' '
	print '==============================================================='
	print 'Table.Column name:  "syslogins.dbname"'
	print ' '
	print 'The following logins have default database names that contain'
	print 'non 7-bit ASCII characters.  If you wish to change them use'
	print '"sp_defaultdb":'
        print ' '
	select suid,name,dbname from master.dbo.syslogins
			where dbname like @pat
    end

/*
**  @pat contains the pattern "NOT IN THE RANGE OF all 7-bit ASCII characters,
**  except the right bracket ("]").  Thus, if a password contains the right
**  bracket character, this non-inclusive matching pattern will not work, and
**  sp_checknames will think the password contains non 7-bit ASCII characters.
*/
    if exists (select password from master.dbo.syslogins
		    where password like @pat)
    begin
	if (@msilent = 1)
	    return (1)

	select @ret_val = 1
	print ' '
	print '==============================================================='
	print 'Table.Column name:  "syslogins.password"'
	print ' '
	print 'The following logins have passwords that contain non 7-bit'
	print 'ASCII characters.  If you wish to change them use "sp_password";'
	print 'Remember, only the sa and the login itself may examine or change'
	print 'the syslogins.password column:'
        print ' '
	select suid,name from master.dbo.syslogins
			where password like @pat
    end

    if exists (select remoteusername from master.dbo.sysremotelogins
		    where remoteusername like @pat)
    begin
	if (@msilent = 1)
	    return (1)

	select @ret_val = 1
	print ' '
	print '==============================================================='
	print 'Table.Column name:  "sysremotelogins.remoteusername"'
        print ' '
	print 'The following remote login names contain non 7-bit ASCII'
	print 'characters.  If you wish to change these names, use'
	print '"sp_dropremotelogin" and "sp_addremotelogin":'
        print ' '
	select remoteserverid,remoteusername from master.dbo.sysremotelogins
			where remoteusername like @pat
    end

    if exists (select srvname from master.dbo.sysservers
		    where srvname like @pat)
    begin
	if (@msilent = 1)
	    return (1)

	select @ret_val = 1
	print ' '
	print '==============================================================='
	print 'Table.Column name:  "sysservers.srvname"'
        print ' '
	print 'The following server names contain non 7-bit ASCII characters.'
	print 'If you wish to change their names, use "sp_dropserver" and'
	print '"sp_addserver":'
        print ' '
	select srvid,srvname from master.dbo.sysservers
			where srvname like @pat
    end

    if exists (select srvnetname from master.dbo.sysservers
		    where srvnetname like @pat)
    begin
	if (@msilent = 1)
	    return (1)

	select @ret_val = 1
	print ' '
	print '==============================================================='
	print 'Table.Column name:  "sysservers.srvnetname"'
        print ' '
	print 'The following servers have "interface file" names that contain'
	print 'non 7-bit ASCII characters.  If you wish to change these names,'
	print 'use "UPDATE":'
        print ' '
	select srvid,srvname,srvnetname from master.dbo.sysservers
			where srvnetname like @pat
    end

end


/*
**  For *ALL* databases, we want to look through these:
*/
if exists (select name from dbo.syscolumns
	    where name like @pat)
begin
    if (@msilent = 1)
	return (1)

    select @ret_val = 1
    print ' '
    print '==============================================================='
    print 'Table.Column name:  "syscolumns.name"'
    print ' '
    print 'The following column and parameter names contain non 7-bit ASCII'
    print 'characters.  If you wish to change these names, use "sp_rename":'
    print ' '
    select objname=o.name,colname=c.name from dbo.syscolumns c, dbo.sysobjects o
		where c.name like @pat and o.id = c.id
end

if exists (select name from dbo.sysindexes
            where name like @pat
                  and indid > 0)
begin
    if (@msilent = 1)
	return (1)

    select @ret_val = 1
    print ' '
    print '==============================================================='
    print 'Table.Column name:  "sysindexes.name"'
    print ' '
    print 'The following index names contain non 7-bit ASCII characters.'
    print 'If you wish to change these names, use "UPDATE":'
    print ' '
    select id,indid,name from dbo.sysindexes
		where name like @pat
end

if exists (select name from dbo.sysobjects
	    where name like @pat)
begin
    if (@msilent = 1)
	return (1)

    select @ret_val = 1
    print ' '
    print '==============================================================='
    print 'Table.Column name:  "sysobjects.name"'
    print ' '
    print 'The following object names contain non 7-bit ASCII characters.'
    print 'If you wish to change these names, use "sp_rename":'
    print ' '
    select owner=u.name,o.name from dbo.sysobjects o,dbo.sysusers u
		where o.name like @pat and o.uid=u.uid
end

if exists (select name from dbo.syssegments
	    where name like @pat)
begin
    if (@msilent = 1)
	return (1)

    select @ret_val = 1
    print ' '
    print '==============================================================='
    print 'Table.Column name:  "syssegments.name"'
    print ' '
    print 'The following segment names contain non 7-bit ASCII characters.'
    print 'If you wish to change these names, use "UPDATE":'
    print ' '
    select segment,name from dbo.syssegments
		where name like @pat
end

if exists (select name from dbo.systypes
	    where name like @pat)
begin
    if (@msilent = 1)
	return (1)

    select @ret_val = 1
    print ' '
    print '==============================================================='
    print 'Table.Column name:  "systypes.name"'
    print ' '
    print 'The following datatype names contain non 7-bit ASCII characters.'
    print 'If you wish to change these names, use "sp_rename":'
    print ' '
    select name from dbo.systypes
		where name like @pat
end

if exists (select name from dbo.sysusers
	    where name like @pat)
begin
    if (@msilent = 1)
	return (1)

    select @ret_val = 1
    print ' '
    print '==============================================================='
    print 'Table.Column name:  "sysusers.name"'
    print ' '
    print 'The following user or group names contain non 7-bit ASCII'
    print 'characters.  If you wish to change these names, use "UPDATE":'
    print ' '
    select suid,uid,name from dbo.sysusers
		where name like @pat
end

if (@ret_val = 0  and  @msilent = 0)
begin
    select @msg = 'Good news!  Database "' + @dbname + '" has no obj/user/etc.'
    print @msg
    print 'names that contain non 7-bit ASCII characters.'
end

return (@ret_val)
                                                          
go

go
if exists (select * from sysobjects 
where name = "sp_start_xact")
begin
	drop proc sp_start_xact
end
go

create procedure sp_start_xact 
	@applname varchar(30),
	@xactname varchar(30),
	@count	smallint,
	@password varchar(30) = NULL
AS

set nocount on

BEGIN
	BEGIN TRANSACTION
		INSERT spt_committab VALUES 
		(
                        0,
                        getdate(),
                        getdate(),
			@count, 
			@count, 
			'b',
			@applname, 
			@xactname,
			@password
		) 

                UPDATE spt_committab
                        set commid = 1 + (select max(commid) from spt_committab)
                        where commid = 0

                SELECT max(commid) from spt_committab
	COMMIT TRANSACTION
END
                                                                                                                                             
go

go
if exists (select * from sysobjects 
where name = "sp_commit_xact")
begin
	drop proc sp_commit_xact
end
go

create procedure sp_commit_xact
	@commid	int,
	@password varchar(30) = NULL
AS

declare @msg varchar(250)

if exists (select *
	from spt_committab
	where commid = @commid
	and password = @password)
begin
	/*
	**  If status is aborted, return a 1 to indicate a failure.
	*/
	if exists (select *
			from spt_committab
				where commid = @commid
					and status = 'a')
	begin
		select 1
		return (1)
	end

	/*  Mark the xact as committed. */
	UPDATE spt_committab 
		SET status = 'c', lastchange = getdate()
		WHERE commid = @commid
	select 0
	return (0)
end
else
begin
	/* Error so return 1 */
	/*
	** 17380, "Commit service xact id doesn't exist."
	*/
	exec sp_getmessage 17380, @msg output
	raiserror 30000 @msg
	select 1
	return (1)
end
                          
go

go
if exists (select * from sysobjects 
where name = "sp_abort_xact")
begin
	drop proc sp_abort_xact
end
go

CREATE PROCEDURE sp_abort_xact
	@commid	int,
	@password varchar(30) = NULL
AS

declare @msg varchar(250)

if exists (select *
	from spt_committab
	where commid = @commid
	and password = @password)
begin
	UPDATE spt_committab 
		SET status = 'a' , lastchange = getdate()
		WHERE commid = @commid
END
else
begin
	/*
	** 17380, "Commit service xact id doesn't exist."
	*/
	exec sp_getmessage 17380, @msg output
	raiserror 30001 @msg
end
                                                                           
go

go
if exists (select * from sysobjects 
where name = "sp_remove_xact")
begin
	drop proc sp_remove_xact
end
go

CREATE PROCEDURE sp_remove_xact
	@commid	smallint,
	@count	smallint,
	@password varchar(30) = NULL
AS

declare @msg varchar(250)

if exists (select *
	from spt_committab
	where commid = @commid
	and password = @password)
begin
	/*
	** Decrement outnum by @count.
	*/
	UPDATE spt_committab 
		SET outnum = outnum - @count, lastchange = GETDATE()
		WHERE commid = @commid

	/*
	**  Delete the row if outnum < 1
	*/
	DELETE spt_committab
		WHERE commid = @commid
			and outnum < 1

end
else
begin
	/*
	** 17380, "Commit service xact id doesn't exist."
	*/
	exec sp_getmessage 17380, @msg output
	raiserror 30002 @msg
end
                                                                                                                                                  
go

go
if exists (select * from sysobjects 
where name = "sp_stat_xact")
begin
	drop proc sp_stat_xact
end
go

create procedure sp_stat_xact
	@commid	int
AS
BEGIN
	IF EXISTS 
	(
		SELECT status 
			FROM spt_committab
			WHERE commid = @commid
	)
		SELECT status 
			FROM spt_committab
			WHERE commid = @commid
	ELSE
		SELECT status = 'u'
END
                      
go

go
if exists (select * from sysobjects 
where name = "sp_probe_xact")
begin
	drop proc sp_probe_xact
end
go

create procedure sp_probe_xact
	@commid	int
AS
BEGIN
	declare @stat	char(1)

	begin tran
		IF EXISTS ( SELECT status 
				FROM spt_committab
					WHERE commid = @commid)
		begin
			SELECT @stat = status 
				FROM spt_committab
					WHERE commid = @commid
			
			if (@stat != 'c')
			begin
				update spt_committab
					set status = 'a'
						where commid = @commid
				select status = 'a'
			end
			else select status = @stat
		end
		else select status = 'u'
	commit tran

END
                                
go

go
if exists (select * from sysobjects 
where name = "sp_scan_xact")
begin
	drop proc sp_scan_xact
end
go

create procedure sp_scan_xact 
	@commid	int = NULL
as
BEGIN
	IF	@commid = -1 or @commid is NULL

		SELECT commid,start,lastchange,totnum,outnum,
		       status,applname,xactname
		FROM spt_committab
	ELSE
		SELECT commid,start,lastchange,totnum,outnum,
		       status,applname,xactname
		FROM spt_committab
		WHERE @commid = commid
END























                                                                                                                                                    
go

go
if exists (select * from sysobjects 
where name = "sp_commonkey")
begin
	drop proc sp_commonkey
end
go

/* Sccsid = "@(#) generic/sproc/src/commonkey 52.1 8/12/92" */
/*	4.8	1.1	06/14/90	sproc/src/commonkey */

/*
** Messages for "sp_commonkey"          17390
**
** 17390, "Table or view name must be in 'current' database."
** 17391, "First table in the common key doesn't exist."
** 17392, "Second table in the common key doesn't exist."
** 17393, "Only the table owner may define its common keys."
** 17394, "The tables have no such first column or the columns are of different types."                     
** 17395, "The tables have no such second column or the columns are of different types."                    
** 17396, "The tables have no such third column or the columns are of different types."                     
** 17397, "The tables have no such fourth column or the columns are of different types."
** 17398, "The tables have no such fifth column or the columns are of different types."
** 17399, "The tables have no such sixth column or the columns are of different types."
** 17400, "The tables have no such seventh column or the columns are of different types."
** 17401, "The tables have no such eighth column or the columns are of different types."
** 17402, "New common key added."
*/


/*
** IMPORTANT NOTE:
** This stored procedure uses the built-in function object_id() in the
** where clause of a select query. If you intend to change this query
** or use the object_id() or db_id() builtin in this procedure, please read the
** READ.ME file in the $DBMS/generic/sproc directory to ensure that the rules
** pertaining to object-id's and db-id's outlined there, are followed.
*/

create procedure sp_commonkey 
@tabaname  varchar(92),		/* name of first table in the key */
@tabbname varchar(92),		/* name of second table in the key */
@col1a     varchar(30), 	/* first column name of first table */
@col1b     varchar(30), 	/* first column name of second table */
@col2a     varchar(30) = NULL,
@col2b     varchar(30) = NULL,
@col3a     varchar(30) = NULL,
@col3b     varchar(30) = NULL,
@col4a     varchar(30) = NULL,
@col4b     varchar(30) = NULL,
@col5a     varchar(30) = NULL,
@col5b     varchar(30) = NULL,
@col6a     varchar(30) = NULL,
@col6b     varchar(30) = NULL,
@col7a     varchar(30) = NULL,
@col7b     varchar(30) = NULL,
@col8a     varchar(30) = NULL,
@col8b     varchar(30) = NULL
as

declare @uida smallint		/* owner of the first table */
declare @cnt    int		/* how many columns are in the key */
declare @msg    varchar(250)

declare @key1a int		/* colids of the first table */
declare @key2a int
declare @key3a int
declare @key4a int
declare @key5a int
declare @key6a int
declare @key7a int
declare @key8a int

declare @key1b int		/* colids of the second table */
declare @key2b int
declare @key3b int
declare @key4b int
declare @key5b int
declare @key6b int
declare @key7b int
declare @key8b int

/*
**  Check to see that the tabnames are local.
*/
if @tabaname like "%.%.%"
begin
	if substring(@tabaname, 1, charindex(".", @tabaname) - 1) != db_name()
	begin
		/*
		** 17390, "Table or view name must be in 'current' database."
		*/
		exec sp_getmessage 17390, @msg output
		print @msg
		return (1)
	end
end
if @tabbname like "%.%.%"
begin
	if substring(@tabbname, 1, charindex(".", @tabbname) - 1) != db_name()
	begin
		/*
		** 17390, "Table or view name must be in 'current' database."
		*/
		exec sp_getmessage 17390, @msg output
		print @msg
		return (1)
	end
end

/*
**  See if we can find the objects.  They must be a system table, user table,
**  or view.  The low 3 bits of sysobjects.sysstat indicate what the 
**  object type is -- it's more reliable than using sysobjects.type which
**  could change.
*/
if not exists (select *
	from sysobjects
		where id = object_id(@tabaname)
			and (sysstat & 7 = 1		/* system table */
				or sysstat & 7 = 2	/* view */
				or sysstat & 7 = 3))	/* user table */
/*
**  If either of the tables don't exist, quit.
*/
begin
	/*
	** 17391, "First table in the common key doesn't exist."
	*/
	exec sp_getmessage 17391, @msg output
	print @msg
    	return (1)
end 
if not exists (select id
	from sysobjects
		where id = object_id(@tabbname)
			and (sysstat & 7 = 1
				or sysstat & 7 = 2
				or sysstat & 7 = 3))
begin
	/*
	** 17392, "Second table in the common key doesn't exist."
	*/
	exec sp_getmessage 17392, @msg output
	print @msg
    	return (1)
end 

/*
**  Only the owner of the table can define it's common keys.
*/
select @uida = uid
	from sysobjects
		where id = object_id(@tabaname)
			and (sysstat & 7 = 1		/* system table */
				or sysstat & 7 = 2	/* view */
				or sysstat & 7 = 3)	/* user table */
if @uida != user_id()
begin
	/*
	** 17393, "Only the table owner may define its common keys."
	*/
	exec sp_getmessage 17393, @msg output
	print @msg
	return (1)
end

/*
**  Now check to see that the first key columns exist and have compatible types.
*/
select @cnt = 1, @key1a = a.colid, @key1b = b.colid
	from syscolumns a, syscolumns b, master.dbo.spt_values y,
		master.dbo.spt_values z
		where a.name = @col1a
			and a.id = object_id(@tabaname)
			and b.name = @col1b
			and b.id = object_id(@tabbname)
			and y.type = "J"
			and a.type = y.low
			and z.type = "J"
			and b.type = z.low
			and y.number = z.number
if @key1a = NULL
begin
	/*
	** 17394, "The tables have no such first column or the columns are of different types."
	*/
	exec sp_getmessage 17394, @msg output
	print @msg
	return (1)
end

if @col2a != NULL
begin
	select @cnt = @cnt + 1, @key2a = a.colid, @key2b = b.colid
		from syscolumns a, syscolumns b, master.dbo.spt_values y,
			master.dbo.spt_values z
			where a.name = @col2a
				and a.id = object_id(@tabaname)
				and b.name = @col2b
				and b.id = object_id(@tabbname)
				and y.type = "J"
				and a.type = y.low
				and z.type = "J"
				and b.type = z.low
				and y.number = z.number
	if @key2a = NULL
	begin
		/*
		** 17395, "The tables have no such second column or the columns are of different types."
		*/
		exec sp_getmessage 17395, @msg output
		print @msg
		return (1)
	end
end
else goto keys_ok

if @col3a != NULL
begin
	select @cnt = @cnt + 1, @key3a = a.colid, @key3b = b.colid
		from syscolumns a, syscolumns b, master.dbo.spt_values y,
			master.dbo.spt_values z
			where a.name = @col3a
				and a.id = object_id(@tabaname)
				and b.name = @col3b
				and b.id = object_id(@tabbname)
				and y.type = "J"
				and a.type = y.low
				and z.type = "J"
				and b.type = z.low
				and y.number = z.number
	if @key3a = NULL
	begin
		/*
		** 17396, "The tables have no such third column or the columns are of different types."                     
		*/
		exec sp_getmessage 17396, @msg output
		print @msg
		return (1)
	end
end
else goto keys_ok

if @col4a != NULL
begin
	select @cnt = @cnt + 1, @key4a = a.colid, @key4b = b.colid
		from syscolumns a, syscolumns b, master.dbo.spt_values y,
			master.dbo.spt_values z
			where a.name = @col4a
				and a.id = object_id(@tabaname)
				and b.name = @col4b
				and b.id = object_id(@tabbname)
				and y.type = "J"
				and a.type = y.low
				and z.type = "J"
				and b.type = z.low
				and y.number = z.number
	if @key4a = NULL
	begin
		/*
		** 17397, "The tables have no such fourth column or the columns are of different types."
		*/
		exec sp_getmessage 17397, @msg output
		print @msg
		return (1)
	end
end
else goto keys_ok

if @col5a != NULL
begin
	select @cnt = @cnt + 1, @key5a = a.colid, @key5b = b.colid
		from syscolumns a, syscolumns b, master.dbo.spt_values y,
			master.dbo.spt_values z
			where a.name = @col5a
				and a.id = object_id(@tabaname)
				and b.name = @col5b
				and b.id = object_id(@tabbname)
				and y.type = "J"
				and a.type = y.low
				and z.type = "J"
				and b.type = z.low
				and y.number = z.number
	if @key5a = NULL
	begin
		/*
		** 17398, "The tables have no such fifth column or the columns are of different types."
		*/
		exec sp_getmessage 17398, @msg output
		print @msg
		return (1)
	end
end
else goto keys_ok

if @col6a != NULL
begin
	select @cnt = @cnt + 1, @key6a = a.colid, @key6b = b.colid
		from syscolumns a, syscolumns b, master.dbo.spt_values y,
			master.dbo.spt_values z
			where a.name = @col6a
				and a.id = object_id(@tabaname)
				and b.name = @col6b
				and b.id = object_id(@tabbname)
				and y.type = "J"
				and a.type = y.low
				and z.type = "J"
				and b.type = z.low
				and y.number = z.number
	if @key6a = NULL
	begin
		/*
		** 17399, "The tables have no such sixth column or the columns are of different types."
		*/
		exec sp_getmessage 17399, @msg output
		print @msg
		return (1)
	end
end
else goto keys_ok

if @col7a != NULL
begin
	select @cnt = @cnt + 1, @key7a = a.colid, @key7b = b.colid
		from syscolumns a, syscolumns b, master.dbo.spt_values y,
			master.dbo.spt_values z
			where a.name = @col7a
				and a.id = object_id(@tabaname)
				and b.name = @col7b
				and b.id = object_id(@tabbname)
				and y.type = "J"
				and a.type = y.low
				and z.type = "J"
				and b.type = z.low
				and y.number = z.number
	if @key7a = NULL
	begin
		/*
		** 17400, "The tables have no such seventh column or the columns are of different types."
		*/
		exec sp_getmessage 17400, @msg output
		print @msg
		return (1)
	end
end
else goto keys_ok

if @col8a != NULL
begin
	select @cnt = @cnt + 1, @key8a = a.colid, @key8b = b.colid
		from syscolumns a, syscolumns b, master.dbo.spt_values y,
			master.dbo.spt_values z
			where a.name = @col8a
				and a.id = object_id(@tabaname)
				and b.name = @col8b
				and b.id = object_id(@tabbname)
				and y.type = "J"
				and a.type = y.low
				and z.type = "J"
				and b.type = z.low
				and y.number = z.number
	if @key8a = NULL
	begin
		/*
		** 17401, "The tables have no such eighth column or the columns are of different types."
		*/
		exec sp_getmessage 17401, @msg output
		print @msg
		return (1)
	end
end

/*
**  If we made it this far then all the columns for the common key are ok.
**  Everything is consistent so add the common key to syskeys.
*/
keys_ok:

insert syskeys (id, type, depid, keycnt, size, key1, key2, key3, key4, key5,
	key6, key7, key8, depkey1, depkey2, depkey3, depkey4, depkey5,
	depkey6, depkey7, depkey8)
values (object_id(@tabaname), 3, object_id(@tabbname), @cnt, 0, @key1a, 
	@key2a, @key3a, @key4a, @key5a,
	@key6a, @key7a, @key8a, @key1b, @key2b, @key3b, @key4b, @key5b,
	@key6b, @key7b, @key8b)   

/*
** 17402, "New common key added."
*/
exec sp_getmessage 17402, @msg output
print @msg
                                     
go

go
if exists (select * from sysobjects 
where name = "sp_configure")
begin
	drop proc sp_configure
end
go

/* Sccsid = "@(#) generic/sproc/configure 52.1 8/12/92" */
/*	4.8	1.1	06/14/90	sproc/src/configure */

/*
** Messages for "sp_configure"          17410
**      Must use "langid" when referencing spt_values
**
** 17260, "Can't run %1! from within a transaction." 
** 17410, "Configuration option doesn't exist."
** 17411, "Configuration option is not unique."
** 17412, "Only the System Administrator (SA) may change configuration parameters."
** 17413, "You can't set the number of devices to be less than the number of devices already defined in sysdevices."
** 17414, "You can't set the default language to a language ID that is not defined in Syslanguages."
** 17415, "Configuration option value is not legal."
** 17416, "Configuration option changed. Run the RECONFIGURE command to install."
** 17417, "Maximum file descriptors or FILLM process quota too low to support requested number of user connections. Configuration variable 'user connections' will not be modified."
*/

create procedure sp_configure
@configname varchar(20) = NULL,		/* option name to configure */
@configvalue int = NULL			/* configure value */
as

declare @confignum int			/* number of option to be configured */
declare @configcount int		/* number of options like @configname */
declare @msg  varchar(250)
declare @sptlang        int    		/* current sessions language */
declare @whichone	int		/* using english or default lang ? */

select @whichone = 0

select @sptlang = @@langid

if @@langid != 0
begin
	if not exists (
		select * from sysmessages where error
		between 17015 and 17049
		and langid = @@langid)
	    select @sptlang = 0
	else
	if not exists (
		select * from sysmessages where error
		between 17100 and 17109
		and langid = @@langid)
	    select @sptlang = 0
end

/*
**  If no option name is given, the procedure will just print out all the
**  options and their values.
*/
if @configname is NULL
begin
	if @sptlang = 0
	    select name, minimum = low, maximum = high,
		config_value = sysconfigures.value,
		run_value = syscurconfigs.value
	    from spt_values, sysconfigures, syscurconfigs
		where type = "C"
			and number *= sysconfigures.config
			and number *= syscurconfigs.config
			and number >= 0
	else
	    select name, convert(char(24), description),
		minimum = low, maximum = high,
		config_value = sysconfigures.value,
		run_value = syscurconfigs.value
	    from spt_values, sysconfigures, syscurconfigs, sysmessages
		where  type = "C"
			and number *= sysconfigures.config
			and number *= syscurconfigs.config
			and number >= 0
			and msgnum = error and isnull(langid, 0) = @sptlang

	return (0)
end

set nocount on

/*
**  Use @configname and try to find the right option.
**  If there isn't just one, print appropriate diagnostics and return.
*/
select @configcount = count(*)
 	   from spt_values
		where name like "%" + @configname + "%" and type = "C"
			and number >= 0

/* 
** If we couldn't find the english, and another language is selected
** then try again.
*/
if @configcount = 0 and @sptlang != 0
begin
    select @whichone = 1
    select @configcount = count(*)
 	   from spt_values, sysmessages
		where description like "%" + @configname + "%" and type = "C"
			and number >= 0
			and msgnum = error and isnull(langid, 0) = @sptlang
end

/*
**  If still no option, show the user what the options are.
*/
if @configcount = 0
begin
	/*
	** 17410, "Configuration option doesn't exist."
	*/
	exec sp_getmessage 17410, @msg output
	print @msg

	/*
	** Show the user what the options are.
	*/
	if @sptlang = 0
	    select name, minimum = low, maximum = high,
		config_value = sysconfigures.value,
		run_value = syscurconfigs.value
	    from spt_values, sysconfigures, syscurconfigs
		where type = "C"
			and number *= sysconfigures.config
			and number *= syscurconfigs.config
			and number >= 0
	else
	    select name, convert(char( 24), description), 
		minimum = low, maximum = high,
		config_value = sysconfigures.value,
		run_value = syscurconfigs.value
	    from spt_values, sysconfigures, syscurconfigs, sysmessages
		where type = "C"
			and number *= sysconfigures.config
			and number *= syscurconfigs.config
			and number >= 0
			and msgnum = error and isnull(langid, 0) = @sptlang

	return (0)
end

/*
**  If more than one option like @configname, show the duplicates and return.
*/
if @configcount > 1
begin
	/*
	** 17411, "Configuration option is not unique."
	*/
	exec sp_getmessage 17411, @msg output
	print @msg

	if @sptlang = 0
	    select duplicate_options = name
		from spt_values
			where name like "%" + @configname + "%"
				and type = "C"
				and number >= 0
	else
	    select duplicate_options = name, 
			convert(char(24), description)
		from spt_values, sysmessages
			where (name like "%" + @configname + "%"
				or description like "%" + @configname + "%")
				and type = "C"
				and number >= 0
				and msgnum = error
				and msgnum = error and isnull(langid, 0) = @sptlang

	return (1)
end

/*
** If @configvalue is NULL, just show the current state of the option.
*/
if @configvalue = NULL
begin
    	if @whichone = 0
		select name, minimum = low, maximum = high,
			config_value = sysconfigures.value,
			run_value = syscurconfigs.value
		from spt_values, sysconfigures, syscurconfigs
			where type = "C"
			and number *= sysconfigures.config
			and number *= syscurconfigs.config
			and name like "%" + @configname + "%"
			and number >= 0

     	else
         	select name = convert(char(24), description),
                	minimum = low, maximum = high,
                	config_value = sysconfigures.value,
                	run_value = syscurconfigs.value
        	from spt_values, sysconfigures, syscurconfigs, sysmessages
                	where type = "C"
                        and number *= sysconfigures.config
                        and number *= syscurconfigs.config
                        and description like "%" + @configname + "%"
                        and number >= 0
                        and msgnum = error and isnull(langid, 0) = @sptlang

     return (0)
end

/*
**  Only the SA can execute the update part of this procedure so check.
*/
if suser_id() != 1
begin
	/*
	** 17412, "Only the System Administrator (SA) may change configuration parameters."
	*/
	exec sp_getmessage 17412, @msg output
	print @msg
	return (1)
end

/*
**  Now get the configuration number.
*/
if @whichone = 0
    select @confignum = number
	from spt_values
		where type = "C" and (@configvalue between low and high
			or @configvalue = 0)
			and name like "%" + @configname + "%"
			and number >= 0
else
    select @confignum = number
	from spt_values, sysmessages
		where type = "C" and (@configvalue between low and high
			or @configvalue = 0)
			and description like "%" + @configname + "%"
			and number >= 0
			and msgnum = error and isnull(langid, 0) = @sptlang

/*
**  If this is user connections, check 
**  @@max_connections - num_log_data_dev - num_mirrors - num_site_hndlrs 
**  before increasing connections.  For VMS this guarantees that enough FILLM
**  quota exists for the server process at this time.  For other platforms
**  this guarantees enough file descriptors are available.
*/
if @confignum = 103 
begin
	declare @num_log_data_dev int
	declare @num_mirrors int
	declare @num_site_hndlrs int
        declare @conn_limit int
	select @num_log_data_dev = count(*) 
	    from sysdevices
               where cntrltype = 0
	select @num_mirrors = count(*)
            from sysdevices
                where mirrorname is not NULL
        select @num_site_hndlrs = count(*) 
            from sysservers
                where srvname != @@servername
        select @conn_limit = @@max_connections - @num_log_data_dev -
                             @num_mirrors - @num_site_hndlrs
	if (@configvalue > @conn_limit)
		begin
			/*
			**  17417, "Maximum file descriptors or FILLM process 
                        **          quota too low to support requested number
                        **          of user connections. Configuration 
                        **          variable 'user connections' will not be
                        **          modified."
			*/
			exec sp_getmessage 17417, @msg output
			print @msg
			return(1)
		end
end

/*
**  If this is the number of devices configuration parameter,
**  we want to make sure that it's not being set to lower than the
**  number of devices in sysdevices.
*/
if @confignum = 116
begin
	/*
	**  Get the max vdevno.
	*/
	declare @maxvdevno	int
	select @maxvdevno = max(convert(tinyint, substring(convert(binary(4),
		d.low), v.low, 1)))
	from master.dbo.sysdevices d, master.dbo.spt_values v
		where v.type = "E"
		and v.number = 3

	/*
	**  If @configvalue == 0, then set it to the current number of devices.
	*/
	if @configvalue = 0
	select @configvalue = @maxvdevno + 1
	if (select low
		from master.dbo.spt_values
			where type = "C"
				and number = 116) > @configvalue
	begin
		select @configvalue = low
			from master.dbo.spt_values
				where type = "C"
					and number = 116
	end

	if ((@maxvdevno + 1) > @configvalue)
	begin
		/*
		** 17413, "You can't set the number of devices to be less than the number of devices already defined in sysdevices."
		*/
		exec sp_getmessage 17413, @msg output
		print @msg
		return (1)
	end
end


/* 
**  If this is the number of default language, we want to make sure
**  that the new value is a valid language id in Syslanguages.
*/ 
if @confignum = 124
begin
	if not exists (select *
		from syslanguages
			where langid = @configvalue)   
	begin
		/* 0 is Sybase default language, us_english */
		if @configvalue != 0
		begin
			/*
			** 17414, "You can't set the default language to a language ID that is not defined in Syslanguages."
			*/
			exec sp_getmessage 17414, @msg output
			print @msg
			return (1)
		end
	end
end

/*
**  Although the @configname is good, @configvalue wasn't in range.
*/
if @confignum is NULL
begin
	/*
	** 17415, "Configuration option value is not legal."
	*/
	exec sp_getmessage 17415, @msg output
	print @msg
	return (1)
end

/*
**  If we're in a transaction, disallow this since it might make recovery
**  impossible.
*/
if @@trancount > 0
begin
	/*
	** 17260, "Can't run %1! from within a transaction." 
	*/
	exec sp_getmessage 17260, @msg output
	print @msg, "sp_configure"
	return (1)
end

/*
**  Now update sysconfigure.
*/
update sysconfigures
	set value = @configvalue
		where config = @confignum


/*
** 17416, "Configuration option changed. Run the RECONFIGURE command to install."
*/
exec sp_getmessage 17416, @msg output
print @msg

return (0)
                                                                                                                                                 
go

go
if exists (select * from sysobjects 
where name = "sp_dboption")
begin
	drop proc sp_dboption
end
go

/* Sccsid = "@(#) generic/sproc/dboption 52.1 8/12/92" */
/*	4.8	1.1	06/14/90	sproc/src/a_values */

/*
** Messages for "sp_dboption"           17420
**      Use "langid" when looking at spt_values ???
**
** 17260, "Can't run %1! from within a transaction." 
** 17420, "Settable database options."
** 17421, "No such database -- run sp_helpdb to list databases."
** 17422, "The 'master' database's options can not be changed."
** 17423, "Usage: sp_dboption [dbname, optname, {true | false}]"
** 17424, "Database option doesn't exist or can't be set by user."
** 17425, "Run sp_dboption with no parameters to see options."
** 17426, "Database option is not unique."
** 17427, "Only the System Administrator (SA) or the owner of the
**	database may set db options."                      
** 17428, "You must be in the 'master' database in order to change
**	database options."                                
** 17429, "The database is currently in use -- 'read only' option
**	disallowed."                                       
** 17430, "Run the CHECKPOINT command in the database that was changed."
** 17431, "true"
** 17432, "false"
*/

create procedure sp_dboption
@dbname varchar(30) = NULL,		/* database name to change */
@optname varchar(20) = NULL,		/* option name to turn on/off */
@optvalue varchar(10) = NULL		/* true or false */
as

declare @dbid int			/* dbid of the database */
declare @dbuid int			/* id of the owner of the database */
declare @statvalue smallint		/* number of option */
declare @optcount int			/* number of options like @optname */
declare @msg varchar(250)
declare @sptlang	int
declare @true		varchar(10)
declare @false		varchar(10)
declare @whichone	int		/* which language? */

select @sptlang = @@langid,  @whichone = 0

if @@langid != 0
begin
	if not exists (
		select * from sysmessages where error
		between 17050 and 17069
		and langid = @@langid)
	select @sptlang = 0
end


/*
**  If no @dbname given, just list the possible dboptions.
**  Only certain status bits may be set or cleared.  
**	   settable                	    not settable
**      ------------------------------  --------------------------
**	allow select into/bulkcopy (4)	load only (512)
**	read only (1024)		not recovered (256)
**	dbo use only (2048)		dbname has changed (16384)
**	single user (4096)		don't recover (32)
**	truncate log on checkpoint (8)
**	no checkpoint on recovery (16)
**      ALL SETTABLE OPTIONS (7196)
*/
if @dbname = null
begin
	/*
	** 17420, "Settable database options."
	*/
	exec sp_getmessage 17420, @msg output
	print @msg

	if @sptlang = 0
	    select database_options = name
		from spt_values
			where type = "D"
				and number in 
					(4, 8, 16, 1024, 2048, 4096, 7196)
		order by name
	else
	    select database_options = name, convert(char(22), description)
		from spt_values, sysmessages
			where type = "D"
				and number in 
					(4, 8, 16, 1024, 2048, 4096, 7196)
				and msgnum = error
				and langid = @sptlang
		order by name
	return (0)
end

/*
**  Verify the database name and get the @dbid and @dbuid
*/
select @dbid = dbid, @dbuid = suid
	from sysdatabases
		where name = @dbname

/*
**  If @dbname not found, say so and list the databases.
*/
if @dbid = NULL
begin
	/*
	** 17421, "No such database -- run sp_helpdb to list databases."
	*/
	exec sp_getmessage 17421, @msg output
	print @msg
	return (1)
end

/*
**  You can not change any of the options in master.  If the user tries to
**  do so tell them they can't.
*/
if @dbid = 1
begin
	/*
	** 17422, "The 'master' database's options can not be changed."
	*/
	exec sp_getmessage 17422, @msg output
	print @msg
	return (1)
end

/*
**  Check remaining parameters.
*/
/* 17431, "true" */
exec sp_getmessage 17431, @true out
/* 17432, "false" */
exec sp_getmessage 17432, @false out
if @optname is NULL or lower(@optvalue) not in 
	("true", "false", @true, @false) or @optvalue = null
begin
	/*
	** 17423, "Usage: sp_dboption [dbname, optname, {true | false}]"
	*/
	exec sp_getmessage 17423, @msg output
	print @msg
	return (1)
end

/*
**  Use @optname and try to find the right option.
**  If there isn't just one, print appropriate diagnostics and return.
*/
select @optcount = count(*)
 	   from spt_values
		where name like "%" + @optname + "%" and type = "D"
			and number in (4, 8, 16, 1024, 2048, 4096, 7196)
/*
** If no option, and alternate language is set, use other language
*/
if @optcount = 0 and @sptlang != 0
begin
    select @optcount = count(*)
 	   from spt_values, sysmessages
		where description like "%" + @optname + "%" and type = "D"
			and number in (4, 8, 16, 1024, 2048, 4096, 7196)
			and msgnum = error
			and langid = @sptlang
    select @whichone = 1
end

/*
**  If no option, show the user what the options are.
*/
if @optcount = 0
begin
	/*
	** 17424, "Database option doesn't exist or can't be set by user."
	*/
	exec sp_getmessage 17424, @msg output
	print @msg

	/*
	** 17425, "Run sp_dboption with no parameters to see options."
	*/
	exec sp_getmessage 17425, @msg output
	print @msg
	return (0)
end

/*
**  If more than one option like @optname, show the duplicates and return.
*/
if @optcount > 1
begin
	/*
	** 17426, "Database option is not unique."
	*/
	exec sp_getmessage 17426, @msg output
	print @msg

	if @sptlang = 0
	    select duplicate_options = name
		from spt_values
			where 
				name like "%" + @optname + "%"
				and type = "D"
				and number in 
					(4, 8, 16, 1024, 2048, 4096, 7196)
	else
	    select duplicate_options = name, convert(char(22), description)
		from spt_values, sysmessages
			where 
				(name like "%" + @optname + "%"
				or description like "%" + @optname + "%")
				and type = "D"
				and number in 
					(4, 8, 16, 1024, 2048, 4096, 7196)
				and msgnum = error
				and langid = @sptlang

	return (1)
end

/*
**  Only the SA or the dbo of @dbnbame can execute the update part
**  of this procedure so check.  Also the sproc must be executed in the master
**  database.
*/
if suser_id() != 1 and suser_id() != @dbuid
begin
	/*
	** 17427, "Only the System Administrator (SA) or the owner of the database may set db options."                      
	*/
	exec sp_getmessage 17427, @msg output
	print @msg
	return (1)
end
if db_name() != "master"
begin
	/*
	** 17428, "You must be in the 'master' database in order to change database options."                                
	*/
	exec sp_getmessage 17428, @msg output
	print @msg
	return (1)
end

/*
**  If we're in a transaction, disallow this since it might make recovery
**  impossible.
*/
if @@trancount > 0
begin
	/*
	** 17260, "Can't run %1! from within a transaction." 
	*/
	exec sp_getmessage 17260, @msg output
	print @msg, "sp_dboption"
	return (1)
end

/*
**  Get the number which is the bit value to set
*/
if @whichone = 0
    select @statvalue = number
 	   from spt_values
		where name like "%" + @optname + "%" and type = "D"
			and number in (4, 8, 16, 1024, 2048, 4096, 7196)
else
    select @statvalue = number
 	   from spt_values, sysmessages
		where description like "%" + @optname + "%" and type = "D"
			and number in (4, 8, 16, 1024, 2048, 4096, 7196)
			and msgnum = error
			and langid = @sptlang


/*
**  Now update sysdatabases.
*/
if lower(@optvalue) in ("true", @true)
begin
	/*
	**  If this the option to make the database read only,
	**  we need to do some checking first.
	**  Unless it's the master db, no one can be using it.
	**  If it's the master db, only the SA may be using it.
	*/
	if (@statvalue = 1024) and (select count(*)
					from master.dbo.sysprocesses
						where dbid = @dbid) > 0
	begin
		/*
		** 17429, "The database is currently in use -- 'read only' option disallowed."                                       
		*/
		exec sp_getmessage 17429, @msg output
		print @msg
		return (1)
	end

	update sysdatabases
		set status = status | @statvalue
			where dbid = @dbid
end

/*
**  We want to turn it off.
*/
else
begin
	update sysdatabases
		set status = status & ~@statvalue
			where dbid = @dbid
end

/*
**  Advise the user to run the CHECKPOINT command in the database that
**  was changed.
*/
/*
** 17430, "Run the CHECKPOINT command in the database that was changed."
*/
exec sp_getmessage 17430, @msg output
print @msg

return (0)
                                                                                                                                                                                                         
go

go
if exists (select * from sysobjects 
where name = "sp_dbupgrade")
begin
	drop proc sp_dbupgrade
end
go

/* Sccsid = "@(#) generic/sproc/src/dbupgrade 52.1 8/12/92" */

create procedure sp_dbupgrade
as

/* 
** 	Do the sysindexes column names update which is part of the 38 upgrade.
** 	The sysgams updates have already been taken care of by pg_gamalloc.
*/
print "Upgrading Sysindexes columns in the database"
if not exists (select name from syscolumns where id = 2 and name = 'doampg')
begin
	update syscolumns
	set name = 'doampg'
	where id = 2 and name = 'dpages'
	update syscolumns
	set name = 'ioampg'
	where id = 2 and name = 'reserved'
	update syscolumns
	set name = 'spare1'
	where id = 2 and name = 'used'
	update syscolumns
	set name = 'spare2'
	where id = 2 and name = 'rows'
end

/*	The following updates are part of the 42 upgrade. */

/*
**	Tweak the Syscolumns entries for the Sysindexes table so that 
**	"soid" and "csid" replace half of "usagecnt".
*/
if not exists (select * from syscolumns where id = 2  and  name = 'soid') 
begin
	begin transaction 
	update syscolumns
		set type = 52, length = 2, usertype = 6, offset = 42
		where id = 2  and  colid = 13
	insert into syscolumns
		(id, number, colid, status, type, length, offset,
		 usertype, cdefault, domain, name, printfmt)
	    	values (2, 0, 23, 0, 48, 1, 40, 5, 0, 0, 'soid', '')
	insert into syscolumns
		(id, number, colid, status, type, length, offset,
		 usertype, cdefault, domain, name, printfmt)
	    	values (2, 0, 24, 0, 48, 1, 41, 5, 0, 0, 'csid', '')
	commit transaction
end

print "Adding new datatypes to the database."
if exists (select * from systypes where name = 'text')
 begin 
        delete systypes where name = 'text'
 end
insert systypes (uid, usertype, variable, allownulls, type, length, 
			tdefault, domain, name, printfmt)
        values (1, 19, 0, 1, 35, 16, 0, 0, 'text', null) 
if exists (select * from systypes where name = 'image')
 begin 
        delete systypes where name = 'image'
 end
insert systypes (uid, usertype, variable, allownulls, type, length, 
			tdefault, domain, name, printfmt)
        values (1, 20, 0, 1, 34, 16, 0, 0, 'image', null) 
if exists (select * from systypes where name = 'timestamp')
 begin 
        delete systypes where name = 'timestamp'
 end
insert systypes (uid, usertype, variable, allownulls, type, length, 
			tdefault, domain, name, printfmt)
        values (1, 80, 0, 1, 37, 8, 0, 0, 'timestamp', null) 
if exists (select * from systypes where name = 'smallmoney')
 begin 
        delete systypes where name = 'smallmoney'
 end
insert systypes (uid, usertype, variable, allownulls, type, length, 
			tdefault, domain, name, printfmt)
        values (1, 21, 0, 1, 122, 4, 0, 0, 'smallmoney', null) 
if exists (select * from systypes where name = 'smalldatetime')
 begin 
        delete systypes where name = 'smalldatetime'
 end
insert systypes (uid, usertype, variable, allownulls, type, length, 
			tdefault, domain, name, printfmt)
        values (1, 22, 0, 1, 58, 4, 0, 0, 'smalldatetime', null) 
if exists (select * from systypes where name = 'real')
 begin 
        delete systypes where name = 'real'
 end
insert systypes (uid, usertype, variable, allownulls, type, length, 
			tdefault, domain, name, printfmt)
        values (1, 23, 0, 1, 59, 4, 0, 0, 'real', null) 

/* 4.9 user types for national character */
if exists (select * from systypes where name = 'nchar')
 begin 
        delete systypes where name = 'nchar'
 end
insert systypes (uid, usertype, variable, allownulls, type, length, 
			tdefault, domain, name, printfmt )
	values (1, 24, 0, 1, 47, 255, 0, 0, 'nchar', null)

if exists (select * from systypes where name = 'nvarchar')
 begin 
        delete systypes where name = 'nvarchar'
 end
insert systypes (uid, usertype, variable, allownulls, type, length, 
			tdefault, domain, name, printfmt)
        values (1, 25, 1, 1, 39, 255, 0, 0, 'nvarchar', null) 

if exists (select * from systypes where name = 'NULL')
 begin 
        delete systypes where name = 'NULL'
 end
insert systypes (uid, usertype, variable, allownulls, type, length, 
			tdefault, domain, name, printfmt)
        values (1, 0, 0, 1, 0, 0, 0, 0, 'NULL', null) 

/* 4.9 system table creation */
print "Creating system catalog: sysusermessages and its indexes."
if not exists (select * from sysobjects where name='sysusermessages')
    begin
	execute sp_configure 'allow updates', 1
	reconfigure with override

	dbcc traceon(3701)
	begin
	    create table sysusermessages(error int,uid smallint,
		description varchar(255), langid smallint null)
	    create clustered index csysusermessages
		on sysusermessages (error)
	    create unique nonclustered index ncsysusermessages
		on sysusermessages (error, langid)
	end
	dbcc traceoff(3701)

	execute sp_configure 'allow updates', 0
	reconfigure with override
    end

print "Shutting down SQL Server"
shutdown

return (0)
                               
go

go
if exists (select * from sysobjects 
where name = "sp_defaultdb")
begin
	drop proc sp_defaultdb
end
go

/* Sccsid = "@(#) generic/sproc/src/defaultdb 52.1 8/12/92" */
/*	4.2	28.1	05/14/90	sproc/src/defaultdb */

/*
** Messages for "sp_defaultdb"          17440
** 
** 17260, "Can't run %1! from within a transaction."
** 17231, "No login with the specified name exists."
**      (was "No such login exists.")
** 17440, "Database name not valid -- default not changed."
** 17441, "You can't change someone else's default database."
** 17442, "Default database changed." 
*/

create procedure sp_defaultdb
@loginame varchar(30),			/* login name of the user */
@defdb varchar(30) 			/* default db for the user */
as

declare @suid int		/* the suid to use to qualify the change */
declare @msg varchar(250)

/*
**  If we're in a transaction, disallow this since it might make recovery
**  impossible.
*/
if @@trancount > 0
begin
	/*
	** 17260, "Can't run %1! from within a transaction."
	*/
	exec sp_getmessage 17260, @msg output
	print @msg, "sp_defaultdb"
	return (1)
end

/*
**  Check that the account exists.
*/
if not exists (select *
			from syslogins
		where name = @loginame)
begin
	/*
	** 17231, "No login with the specified name exists."
	*/
	exec sp_getmessage 17231, @msg output
        print @msg
	return (1)
end

/*
**  Check that the database name is valid.
*/
if not exists (select *
			from sysdatabases
		where name = @defdb)
begin
	/*
	** 17440, "Database name not valid -- default not changed."
	*/
	exec sp_getmessage 17440, @msg output
        print @msg
	return (1)
end

/*
**  Both the owner of the account (@loginame) and the SA can run this
**  command.  If the SA is running it, set @suid to the suid of @loginame.
*/
select @suid = suser_id()
if @suid = 1
begin
	/*
	**  Get the suid for @loginame.  We know it exists because we
	**  checked above.
	*/
	select @suid = suid
		from syslogins 
			where name = @loginame
end
			
/*
**  Change the database
*/
update syslogins
	set dbname = @defdb
		where suid = @suid
			and name = @loginame

/*
**  If nothing got updated then it means that the the user tried to change
**  someone else's default.
*/
if @@rowcount < 1
begin
	/*
	** 17441, "You can't change someone else's default database."
	*/
	exec sp_getmessage 17441, @msg output
        print @msg
	return (1)
end

/*
** 17442, "Default database changed." 
*/
exec sp_getmessage 17442, @msg output
print @msg

return (0)













                                                                                                                                                                                               
go

go
if exists (select * from sysobjects 
where name = "sp_depends")
begin
	drop proc sp_depends
end
go

/* Sccsid = "@(#) generic/sproc/depends 52.1 8/12/92" */
/*	4.8	1.1	06/14/90	sproc/src/defaultlanguage */

/*
** Messages for "sp_depends"            17460
**
** 17460, "Object must be in the current database."
** 17461, "Object does not exist in this database."
** 17462, "Things the object references in the current database."
** 17463, "Things inside the current database that reference the object."
** 17464, "Object doesn't reference any object and no objects reference it."
*/

/*
** IMPORTANT NOTE:
** This stored procedure uses the built-in function object_id() in the
** where clause of a select query. If you intend to change this query
** or use the object_id() or db_id() builtin in this procedure, please read the
** READ.ME file in the $DBMS/generic/sproc directory to ensure that the rules
** pertaining to object-id's and db-id's outlined there, are followed.
*/

create procedure sp_depends
@objname varchar(92)		/* the object we want to check */
as

declare @found_some bit			/* flag for dependencies found */
declare @msg varchar(250)
declare @sptlang	int		/* current sessions language */
declare @length		int

/*
**  Make sure the @objname is local to the current database.
*/
if @objname like "%.%.%" and
	substring(@objname, 1, charindex(".", @objname) - 1) != db_name()
begin
	/*
	** 17460, "Object must be in the current database."
	*/
	exec sp_getmessage 17460, @msg output
	print @msg
	return (1)
end

/*
**  See if @objname exists.
*/
if not exists (select id
		from sysobjects
			where id = object_id(@objname))
begin
	/*
	** 17461, "Object does not exist in this database."
	*/
	exec sp_getmessage 17461, @msg output
	print @msg
	return (1)
end

/*
**  Initialize @found_some to indicate that we haven't seen any dependencies.
*/
select @found_some = 0

set nocount on

/*
**  Print out the particulars about the local dependencies.
*/
if exists (select *
		from sysdepends
			where id = object_id(@objname))
begin
	/*
	** 17462, "Things the object references in the current database."
	*/
	exec sp_getmessage 17462, @msg output
	print @msg

	select @sptlang = @@langid

	if @@langid != 0
	begin
		if not exists (
			select * from sysmessages where error
			between 17010 and 17014
			and langid = @@langid)
		    select @sptlang = 0
		else
		if not exists (
			select * from sysmessages where error
			between 17100 and 17109
			and langid = @@langid)
		    select @sptlang = 0
	end

	select @length = max(datalength(s.name + "." + o.name))
		    from sysobjects o,
			sysdepends d, sysusers s
		    where o.id = d.depid
			and d.id = object_id(@objname)
			and o.uid = s.uid

	if (@length > 40)
	    select object = s.name + "." + o.name,
		type = convert(char(16), m0.description),
		updated = convert(char(10), m1.description),
		selected = convert(char(10), m2.description)
			from sysobjects o, master.dbo.spt_values v,
				sysdepends d, master.dbo.spt_values u,
				master.dbo.spt_values w,
				sysusers s, 
				sysmessages m0, sysmessages m1, sysmessages m2
			where o.id = d.depid
				and o.sysstat & 7 = v.number and v.type = 'O'
				and v.msgnum = m0.error
				and isnull(m0.langid, 0) = @sptlang
				and u.type = 'B' and u.number = d.resultobj
				and u.msgnum = m1.error
				and isnull(m1.langid, 0) = @sptlang
				and w.type = 'B' and w.number = d.readobj
				and w.msgnum = m2.error
				and isnull(m2.langid, 0) = @sptlang
				and d.id = object_id(@objname)
				and o.uid = s.uid

	else
	    select object = convert(char(40), (s.name + "." + o.name)),
		type = convert(char(16), m0.description),
		updated = convert(char(10), m1.description),
		selected = convert(char(10), m2.description)
			from sysobjects o, master.dbo.spt_values v,
				sysdepends d, master.dbo.spt_values u,
				master.dbo.spt_values w,
				sysusers s, 
				sysmessages m0, sysmessages m1, sysmessages m2
			where o.id = d.depid
				and o.sysstat & 7 = v.number and v.type = 'O'
				and v.msgnum = m0.error
				and isnull(m0.langid, 0) = @sptlang
				and u.type = 'B' and u.number = d.resultobj
				and u.msgnum = m1.error
				and isnull(m1.langid, 0) = @sptlang
				and w.type = 'B' and w.number = d.readobj
				and w.msgnum = m2.error
				and isnull(m2.langid, 0) = @sptlang
				and d.id = object_id(@objname)
				and o.uid = s.uid


	select @found_some = 1
end

/*
**  Now check for things that the objects depends upon
*/
if exists (select *
		from sysdepends
			where depid = object_id(@objname))
begin
	/*
	** 17463, "Things inside the current database that reference the object."
	*/
	exec sp_getmessage 17463, @msg output
	print @msg
	select distinct
	       @length = max(datalength(s.name + "." + o.name))
			from sysobjects o,
				sysdepends d, sysusers s
			where o.id = d.id
				and d.depid = object_id(@objname)
				and o.uid = s.uid
	if (@length > 40)
	    select distinct
		object = s.name + "." + o.name,
		type = convert(char(16), v.name)
			from sysobjects o, master.dbo.spt_values v,
				sysdepends d, sysusers s
			where o.id = d.id
				and o.sysstat & 7 = v.number and v.type = 'O'
				and d.depid = object_id(@objname)
				and o.uid = s.uid
	else
	    select distinct
		object = convert(char(40), (s.name + "." + o.name)),
		type = convert(char(16), v.name)
			from sysobjects o, master.dbo.spt_values v,
				sysdepends d, sysusers s
			where o.id = d.id
				and o.sysstat & 7 = v.number and v.type = 'O'
				and d.depid = object_id(@objname)
				and o.uid = s.uid
	select @found_some = 1
end

/*
**  Did we find anything in sysdepends?
*/
if @found_some = 0
begin
	/*
	** 17464, "Object doesn't reference any object and no objects reference it."
	*/
	exec sp_getmessage 17464, @msg output
	print @msg
end

set nocount off

return (0)
                                                                                                                                                                                              
go

dump tran master with truncate_only

go

go
if exists (select * from sysobjects 
where name = "sp_diskdefault")
begin
	drop proc sp_diskdefault
end
go

/* Sccsid = "@(#) generic/sproc/src/diskdefault 52.1 8/12/92" */
/*	4.8	1.1	06/14/90	sproc/src/defaultlanguage */

/*
** Messages for "sp_diskdefault"        17470
**
** 17260, "Can't run %1! from within a transaction." 
** 17261, "Only the System Administrator (SA) may execute this procedure." 
** 17470, "No such device exists -- run sp_helpdevice to list the DataServer devices."
** 17471, "The device name supplied is not a database disk."
** 17472, "Usage: sp_diskdefault logicalname {defaulton | defaultoff}." 
*/

create procedure sp_diskdefault
@logicalname	varchar(30),		/* logical name of the device */
@defstatus	varchar(15)		/* turn on or off */
as

declare @msg varchar(250)

/*
**  If we're in a transaction, disallow this since it might make recovery
**  impossible.
*/
if @@trancount > 0
begin
	/*
	** 17260, "Can't run %1! from within a transaction." 
	*/
	exec sp_getmessage 17260, @msg output
	print @msg, "sp_diskfault"
	return (1)
end

/*
**  Only the SA can run this sproc.
*/
if suser_id() != 1
begin
	/*
	** 17261, "Only the System Administrator (SA) may execute this procedure." 
	*/
	exec sp_getmessage 17261, @msg output
	print @msg
	return (1)
end

/*
**  Make sure that a device with @logicalname exists.
*/
if not exists (select *
		from master.dbo.sysdevices
			where name = @logicalname)
begin
	/*
	** 17470, "No such device exists -- run sp_helpdevice to list the DataServer devices."
	*/
	exec sp_getmessage 17470, @msg output
	print @msg
	return (1)
end

/*
**  Make sure that is a database disk and not a dump device.
*/
if exists (select *
		from master.dbo.sysdevices
			where name = @logicalname 
				and status & 16 = 16)
begin
	/*
	** 17471, "The device name supplied is not a database disk."
	*/
	exec sp_getmessage 17471, @msg output
	print @msg
	return (1)
end

if @defstatus = "defaulton"
begin
	update master.dbo.sysdevices
		set status = status | 1
			where name = @logicalname
	return (0)
end

if @defstatus = "defaultoff"
begin
	update master.dbo.sysdevices
		set status = status & ~1
			where name = @logicalname
	return (0)
end

/*
**  @defstatus must be "defaulton" or "defaultoff"
*/
/*
** 17472, "Usage: sp_diskdefault logicalname {defaulton | defaultoff}." 
*/
exec sp_getmessage 17472, @msg output
print @msg

return (1)
                
go

go
if exists (select * from sysobjects 
where name = "sp_dropalias")
begin
	drop proc sp_dropalias
end
go

/* Sccsid = "@(#) generic/sproc/src/dropalias 52.1 8/12/92" */
/*	4.8	1.1	06/14/90	sproc/src/defaultlanguage */

/*
** Messages for "sp_dropalias"          17480
**
** 17230, "Only the System Administrator (SA) or the Database Owner (dbo) may execute this stored procedure."
** 17231, "No login with the specified name exists."
** 17480, "Alias user dropped."
** 17481, "No alias for specified user exists."
*/

create procedure sp_dropalias
@loginame varchar(30)		/* account name of the user with the alias */
as

declare @msg varchar(250)

/*
**  You must be SA or the dbo to execute this sproc.
*/
if suser_id() != 1 and user_id() != 1
begin
	/*
	** 17230, "Only the System Administrator (SA) or the Database Owner (dbo) may execute this stored procedure."
	*/
	exec sp_getmessage 17230, @msg output
	print @msg
	return (1)
end

/*
**  Check to make sure that the @loginame has an account.
*/
if (select suser_id(@loginame)) = NULL
begin
	/*
	** 17231, "No login with the specified name exists."
	*/
	exec sp_getmessage 17231, @msg output
        print @msg
	return (1)
end

/*
**  Delete the alias, if any, from sysalternates.
*/
delete from sysalternates
	where suid = suser_id(@loginame)

/*
**  If nothing happened (rowcount = 0), there was no alias.
*/
if @@rowcount > 0
begin
	/*
	** 17480, "Alias user dropped."
	*/
	exec sp_getmessage 17480, @msg output
        print @msg
	return (0)
end
else
begin
	/*
	** 17481, "No alias for specified user exists."
	*/
	exec sp_getmessage 17481, @msg output
        print @msg
	return (1)
end
                                                                                                                                                                                                                                                  
go

go
if exists (select * from sysobjects 
where name = "sp_dropdevice")
begin
	drop proc sp_dropdevice
end
go

/* Sccsid = "@(#) generic/sproc/dropdevice 52.1 8/12/92" */
/*	4.8	1.1	06/14/90	sproc/src/defaultlanguage */

/*
** Messages for "sp_dropdevice"         17482
**
** 17260, "Can't run %1! from within a transaction." 
** 17261, "Only the System Administrator (SA) may execute this procedure." 
** 17471, "No such device exists -- run sp_helpdevice to list the DataServer devices." 
** 17482, "Device is being used by a database. You can't drop it."
** 17483, "Device dropped."
*/

create procedure sp_dropdevice
@logicalname	varchar(30)		/* logical name of the device */
as

declare @msg varchar(250)
declare @len1 int, @len2 int

/*
**  If we're in a transaction, disallow this since it might make recovery
**  impossible.
*/
if @@trancount > 0
begin
	/*
	** 17260, "Can't run %1! from within a transaction." 
	*/
	exec sp_getmessage 17260, @msg output
	print @msg, "sp_dropdevice"
	return (1)
end

/*
**  Only the system administrator (SA) can run this command.
**  Check to make sure the executor is the sa.
*/
if suser_id() != 1
begin
	/*
	** 17261, "Only the System Administrator (SA) may execute this procedure." 
 	*/
	exec sp_getmessage 17261, @msg output
        print @msg
	return (1)
end

/*
**  Check and make sure that the device actually exists.
*/
if not exists (select * 
		from master.dbo.sysdevices
			where name = @logicalname)
begin
	/*
	** 17471, "No such device exists -- run sp_helpdevice to list the DataServer devices." 
	*/
	exec sp_getmessage 17471, @msg output
        print @msg
	return (1)
end

/*
**  Check and make sure that no database is using the device.
**  If so, print out who is using it and exit.
*/
if exists (select *
	from sysdatabases, sysusages, sysdevices
		where sysdatabases.dbid = sysusages.dbid
			and sysdevices.low <= size + vstart
			and sysdevices.high >= size + vstart - 1
			and sysdevices.status & 2 = 2 
			and sysdevices.name = @logicalname)
begin
	/*
	** 17482, "Device is being used by a database. You can't drop it."
	*/
	exec sp_getmessage 17482, @msg output
        print @msg

	select @len1 = max(datalength(sysdatabases.name)),
	       @len2 = max(datalength(sysdevices.name))
	from sysdatabases, sysusages, sysdevices
		where sysdatabases.dbid = sysusages.dbid
			and sysdevices.low <= size + vstart
			and sysdevices.high >= size + vstart - 1
			and sysdevices.status & 2 = 2 
			and sysdevices.name = @logicalname

	if (@len1 > 23 or @len2 > 21)
	    select database_name = sysdatabases.name,
		device = sysdevices.name,
		size = convert(varchar(8), size / 500) + " MB"
	    from sysdatabases, sysusages, sysdevices
		where sysdatabases.dbid = sysusages.dbid
			and sysdevices.low <= size + vstart
			and sysdevices.high >= size + vstart - 1
			and sysdevices.status & 2 = 2 
			and sysdevices.name = @logicalname
	    order by sysdatabases.name, sysdevices.name, size
	else
	    select database_name = convert(char(23), sysdatabases.name),
		device = convert(char(21), sysdevices.name),
		size = convert(varchar(8), size / 500) + " MB"
	    from sysdatabases, sysusages, sysdevices
		where sysdatabases.dbid = sysusages.dbid
			and sysdevices.low <= size + vstart
			and sysdevices.high >= size + vstart - 1
			and sysdevices.status & 2 = 2 
			and sysdevices.name = @logicalname
	    order by sysdatabases.name, sysdevices.name, size

	return (1)
end

/*
**  Everything's ok so drop the device.
*/
delete sysdevices
	where name = @logicalname

/*
** 17483, "Device dropped."
*/
exec sp_getmessage 17483, @msg output
print @msg

return (0)
                                                             
go

go
if exists (select * from sysobjects 
where name = "sp_dropdumpdevice")
begin
	drop proc sp_dropdumpdevice
end
go

/* Sccsid = "@(#) generic/sproc/src/dropdumpdevice 52.1 8/12/92" */
/*	4.8	1.1	06/14/90	sproc/src/defaultlanguage */

/*
** Messages for "sp_dropdumpdevice"     17484
**
** 17260, "Can't run %1! from within a transaction." 
** 17261, "Only the System Administrator (SA) may execute this procedure."
** 17483, "Device dropped." 
** 17484, "No device with specified logical name exists."
** 17485, "Device is not a dump device and may not be dropped."
*/

create procedure sp_dropdumpdevice
@logicalname varchar(30)		/* name of device to drop */
as

declare @msg varchar(250)

/*
**  N.B.  This sproc is redundant due to the addition of sp_dropdevice.
**  	  However, it is still included in installmaster for backwards
**	  compatibility with existing programs.
*/

/*
**  If we're in a transaction, disallow this since it might make recovery
**  impossible.
*/
if @@trancount > 0
begin
	/*
	** 17260, "Can't run %1! from within a transaction." 
	*/
	exec sp_getmessage 17260, @msg output
	print @msg, "sp_dropdumpdevice"
	return (1)
end

/*
**  Only the system administrator (SA) can run this command.
**  Check to make sure the executor is the sa.
*/
if suser_id() != 1
begin
	/*
	** 17261, "Only the System Administrator (SA) may execute this procedure."
	*/
	exec sp_getmessage 17261, @msg output
        print @msg
	return (1)
end

/*
**  Delete the device.  Only dump devices may be dropped.
*/
delete from master.dbo.sysdevices
	where name = @logicalname
		and status & 16 = 16

/*
** Check @@rowcount when it works
*/
if @@rowcount > 0
begin
	/*
	** 17483, "Device dropped." 
 	*/
	exec sp_getmessage 17483, @msg output
        print @msg
	return (0)
end
else
begin
	/*
	**  Nothing happened because the device doesn't exist or isn't
	**  a dump device.
	*/
	if not exists (select *
			from sysdevices
				where name = @logicalname)
	begin
		/*
		** 17484, "No device with specified logical name exists."
		*/
		exec sp_getmessage 17484, @msg output
        	print @msg
	end
	else 
	begin
		/*
		** 17485, "Device is not a dump device and may not be dropped."
		*/
		exec sp_getmessage 17485, @msg output
        	print @msg
	end
	return (1)
end
                                                                                                                                             
go

go
if exists (select * from sysobjects 
where name = "sp_dropgroup")
begin
	drop proc sp_dropgroup
end
go

/* Sccsid = "@(#) generic/sproc/src/dropgroup 52.1 8/12/92" */
/*	4.8	1.1	06/14/90	sproc/src/defaultlanguage */

/*
** Messages for "sp_dropgroup"          17486
**
** 17230, "Only the System Administrator (SA) or the Database Owner (dbo) may execute this stored procedure." 
** 17333, "No group with the specified name exists." 
** 17486, "Can't drop the group 'public'."
** 17487, "You cannot drop group because it owns objects in database."
** 17488, "Group has members.  It must be empty before it can be dropped."
** 17489, "Group has been dropped."
*/

create procedure sp_dropgroup
@grpname varchar(30)		/* group to be dropped */
as

declare @gid int		/* group id of the group to be dropped */
declare @msg varchar(250)

/*
**  You must be SA or the dbo to execute this sproc.
*/
if suser_id() != 1 and user_id() != 1
begin
	/*
	** 17230, "Only the System Administrator (SA) or the Database Owner (dbo) may execute this stored procedure." 
	*/
	exec sp_getmessage 17230, @msg output
	print @msg
	return (1)
end

/*
**  See if the group exists.
**  User ids are <= 16383 and group ids are > 16383.
*/
select @gid = uid
	from sysusers
		where name = @grpname
			and (uid > 16383 or uid = 0)

if @gid = NULL
begin
	/*
	** 17333, "No group with the specified name exists." 
	*/
	exec sp_getmessage 17333, @msg output
	print @msg
	return (1)
end

/*
**  Can't drop the group public.
*/
if @gid = 0
begin
	/*
	** 17486, "Can't drop the group 'public'."
	*/
	exec sp_getmessage 17486, @msg output
	print @msg
	return (1)
end

/*
**  Check to see if the group owns anything.  If so, return.
*/
if exists (select *
		   from sysobjects
			   where uid = @gid)
begin
	/*
	** 17487, "You cannot drop group because it owns objects in database."
	*/
	exec sp_getmessage 17487, @msg output
	print @msg

	/*
	**  Show what is owned by the group.
	*/
	select s.name, s.type, owner = u.name
		from sysobjects s, sysusers u
			where s.id = @gid
				and u.uid = @gid
	return (1)
end


/*
**  Check to see that nobody is in the group.  If so, return.
*/
if (select count(*)
	from sysusers
		where gid = @gid
			and uid <= 16383) != 0
begin
	/*
	** 17488, "Group has members.  It must be empty before it can be dropped."
	*/
	exec sp_getmessage 17488, @msg output
	print @msg

	/*
	**  Show who is in the group.
	*/
	select name
		from sysusers
			where gid = @gid
				and uid <= 16383
	
	return (1)
end

/*
**  Drop the group.
**  Also drop any references to the group in the sysprotects table.
*/
begin transaction

	delete from sysusers
		where uid = @gid

	delete from sysprotects
		where uid = @gid

commit transaction

/*
** 17489, "Group has been dropped."
*/
exec sp_getmessage 17489, @msg output
print @msg

return (0)
                                                                                          
go

go
if exists (select * from sysobjects 
where name = "sp_dropkey")
begin
	drop proc sp_dropkey
end
go

/* Sccsid = "@(#) generic/sproc/src/dropkey 52.1 8/12/92" */
/*	4.8	1.1	06/14/90	sproc/src/defaultlanguage */

/*
** Messages for "sp_dropkey"            17490
**
** 17390, "Table or view name must be in 'current' database." 
** 17490, "Usage: sp_dropkey {primary | foreign | common}, tabname [,deptabname]."
** 17491, "Type must be 'primary', 'foreign', or 'common'."
** 17492, "The table or view named doesn't exist in the current database."
** 17493, "You must be the owner of the table or view to drop its key."
** 17494, "No primary key for the table or view exists."
** 17495, "Primary key for the table or view dropped."
** 17496, "Dependent foreign keys were also dropped."
** 17497, "You need to supply the dependent table or view as the third parameter."      
** 17498, "The dependent table or view doesn't exist in the current database."          
** 17499, "No foreign key for the table or view exists."
** 17500, "Foreign key dropped."
** 17501, "No common keys exist between the two tables or views supplied."
** 17502, "Common keys dropped."
*/

/*
** IMPORTANT NOTE:
** This stored procedure uses the built-in function object_id() in the
** where clause of a select query. If you intend to change this query
** or use the object_id() or db_id() builtin in this procedure, please read the
** READ.ME file in the $DBMS/generic/sproc directory to ensure that the rules
** pertaining to object-id's and db-id's outlined there, are followed.
*/

create procedure sp_dropkey
@keytype varchar(10), 			/* type of key to drop */
@tabname varchar(92),			/* table with the key */
@deptabname varchar(92) = null		/* dependent table */
as

declare @uid smallint			/* owner of @tabname */
declare @depuid smallint		/* owner of @related table */
declare @msg varchar(250)

/*
**  First make sure that the key type is ok.
*/
if @keytype not in ("primary", "foreign", "common")
begin
	/*
	** 17490, "Usage: sp_dropkey {primary | foreign | common}, tabname [,deptabname]."
	*/
	exec sp_getmessage 17490, @msg output
	print @msg
	/*
	** 17491, "Type must be 'primary', 'foreign', or 'common'."
	*/
	exec sp_getmessage 17491, @msg output
	print @msg
	return (1)
end

/*
**  Check to see that the tabname is local.
*/
if @tabname like "%.%.%"
begin
	if substring(@tabname, 1, charindex(".", @tabname) - 1) != db_name()
	begin
		/*
		** 17390, "Table or view name must be in 'current' database." 
		*/
		exec sp_getmessage 17390, @msg output
		print @msg
		return (1)
	end
end
if @deptabname like "%.%.%"
begin
	if substring(@deptabname, 1, charindex(".", @deptabname) - 1) != db_name()
	begin
		/*
		** 17390, "Table or view name must be in 'current' database."
		*/
		exec sp_getmessage 17390, @msg output
		print @msg
		return (1)
	end
end

/*
**  Get the ids of the @tabname and @deptabname.
*/
if not exists (select *
		from sysobjects
			where id = object_id(@tabname))
begin
	/*
	** 17492, "The table or view named doesn't exist in the current database."
	*/
	exec sp_getmessage 17492, @msg output
	print @msg
	return (1)
end

/*
** Get the user-id of @tabname
*/
select @uid = uid
	from sysobjects
		where id = object_id(@tabname)

if @uid != user_id()
begin
	/*
	** 17493, "You must be the owner of the table or view to drop its key."
	*/
	exec sp_getmessage 17493, @msg output
	print @msg
	return (1)
end

/*
**  If primary key, just drop it.
*/
if @keytype = "primary"
begin
	delete from syskeys
		where id = object_id(@tabname)
			and type = 1

	if @@rowcount = 0
	begin
		/*
		** 17494, "No primary key for the table or view exists."
		*/
		exec sp_getmessage 17494, @msg output
		print @msg
		return (1)
	end

	else
	begin
		/*
		** 17495, "Primary key for the table or view dropped."
		*/
		exec sp_getmessage 17495, @msg output
		print @msg
	end

	/*
	**  Check to see if there are any foreign keys dependent on the
	**  primary key.  If so -- drop them.
	*/
	delete from syskeys
		where depid = object_id(@tabname)
			and type = 2
	
	if @@rowcount != 0
	begin
		/*
		** 17496, "Dependent foreign keys were also dropped."
		*/ 
		exec sp_getmessage 17496, @msg output
		print @msg
	end

	return (0)
end

/*
**  It's either a foreign or common key so we need to verify the
**  existence of the @deptabname.
*/
if not exists (select id
			from sysobjects
				where id = object_id(@deptabname))
begin
	/*
	**  Was the @deptabname supplied?
	*/
	if @deptabname = null
	begin
		/*
		** 17497, "You need to supply the dependent table or view as the third parameter."      
		*/
		exec sp_getmessage 17497, @msg output
		print @msg
		return (1)
	end

	/*
	**  It was supplied but it doesn't exist.
	*/
	/*
	** 17498, "The dependent table or view doesn't exist in the current database."          
	*/
	exec sp_getmessage 17498, @msg output
	print @msg
	return (1)
end


/*
**  If foreign key, get rid of it.
*/
if @keytype = "foreign"
begin
	/*
	**  Get rid of the foreign key entry.
	*/
	delete from syskeys
		where type = 2
			and id = object_id(@tabname)
			and depid = object_id(@deptabname)
	if @@rowcount = 0
	begin
		/*
		** 17499, "No foreign key for the table or view exists."
		*/
		exec sp_getmessage 17499, @msg output
		print @msg
		return (1)
	end

	/*
	** 17500, "Foreign key dropped."
	*/
	exec sp_getmessage 17500, @msg output
	print @msg

	return (0)
end

/*
**  Key type must be common so just get rid of the common keys
**  with the right ids and depids.  Since whenever a common key is defined
**  it is added to both of the tables involved, we'll get rid of both of
**  those entries.
*/
delete from syskeys
	where type = 3
		and id = object_id(@tabname)
		and depid = object_id(@deptabname)

if @@rowcount = 0
begin
	/*
	** 17501, "No common keys exist between the two tables or views supplied."
	*/
	exec sp_getmessage 17501, @msg output
	print @msg
	return (1)
end

/*
**  Now get rid of the inverse common key entries.
*/
delete from syskeys
	where type = 3
		and id = object_id(@deptabname)
		and depid = object_id(@tabname)

/*
** 17502, "Common keys dropped."
*/
exec sp_getmessage 17502, @msg output
print @msg

return (0)
                                                               
go

go
if exists (select * from sysobjects 
where name = "sp_droplogin")
begin
	drop proc sp_droplogin
end
go

/* Sccsid = "@(#) generic/sproc/src/droplogin 52.1 8/12/92" */
/*	4.8	1.1	06/14/90	sproc/src/defaultlanguage */

/*
** Messages for "sp_droplogin"          17509
**
** 17260, "Can't run %1! from within a transaction." 
** 17261, "Only the System Administrator (SA) may execute this procedure."
** 17231, "No login with the specified name exists."
** 17509, "User exists in current database.  Drop user before dropping login."
** 17510, "User exists as an alias in current database.  Drop alias before dropping login."
** 17511, "Login dropped."
*/

create procedure sp_droplogin
@loginame varchar(30)			/* name of login to drop */
as

declare @msg varchar (250)

/*
**  This procedure makes a weak attempt to check for any dependencies.
**  It looks in the current database to see if the suid is used in
**  sysusers or sysalternates.  If so, a diagnostic is issued and the
**  login is not dropped.
**
**  Ideally, this procedure should check each database to see if the login
**  is a user.  However, this is not yet possible since procedures do not
**  allow parameters to be used for database or table names.
*/

/*
**  If we're in a transaction, disallow this since it might make recovery
**  impossible.
*/
if @@trancount > 0
begin
	/*
	** 17260, "Can't run %1! from within a transaction." 
	*/
	exec sp_getmessage 17260, @msg output
	print @msg, "sp_droplogin"
	return (1)
end

/*
**  Only the system administrator (SA) can run this command.
**  Check to make sure the executor is the sa.
*/
if suser_id() != 1
begin
	/*
	** 17261, "Only the System Administrator (SA) may execute this procedure."
	*/
	exec sp_getmessage 17261, @msg output
	print @msg
	return (1)
end

/*
**  Check sysusers.
*/
if exists (select *
		from sysusers
			where suid = suser_id(@loginame))
begin
	/*
	** 17509, "User exists in current database.  Drop user before dropping login."
	*/
	exec sp_getmessage 17509, @msg output
	print @msg
	select database_name = db_name(), login_name = @loginame,
		name_in_database = name
			from sysusers where suser_id(@loginame) = suid
	return (1)
end

/*
**  Check sysalternates.
*/
if exists (select *
		from sysalternates
			where suid = suser_id(@loginame))
begin

	/*
	** 17510, "User exists as an alias in current database.  Drop alias before dropping login."
	*/
	exec sp_getmessage 17510, @msg output
	print @msg
	select database_name = db_name(), login_name = @loginame,
		name_in_database = u.name
			from sysusers u, sysalternates a
				where suser_id(@loginame) = a.suid
					and a.altsuid = u.suid
	return (1)
end

/*
**  Delete the login.
*/
delete from syslogins
	where name = @loginame

/*
** Check @@rowcount when it works
*/
if @@rowcount > 0
begin
	/*
	** 17511, "Login dropped."
	*/
	exec sp_getmessage 17511, @msg output
	print @msg
	return (0)
end
else
begin
	/*
	** 17231, "No login with the specified name exists."
	*/
	exec sp_getmessage 17231, @msg output
	print @msg
	return (1)
end
                                                                                                                                  
go

go
if exists (select * from sysobjects 
where name = "sp_droptype")
begin
	drop proc sp_droptype
end
go

/* Sccsid = "@(#) generic/sproc/src/droptype 52.1 8/12/92" */
/*	4.8	1.1	06/14/90	sproc/src/defaultlanguage */

/*
** Messages for "sp_droptype"           17540
**
** 17540, "The type doesn't exist or you don't own it."
** 17541, "Type is being used. You cannot drop it."
** 17542, "Type has been dropped."
*/

create procedure sp_droptype
@typename varchar(30)			/* the user type to drop */
as

declare @typeid smallint		/* the typeid of the usertype to drop */
declare @msg    varchar(250)

/*
**  Initialize @typeid so we can tell if we can't find it.
*/
select @typeid = 0

/*
**  Find the user type with @typename.  It must be a user type (usertype > 99)
**  and it must be owned by the person (or dbo) running the procedure.
*/
select @typeid = usertype
	from systypes
		where (uid = user_id() or user_id() = 1)
			and name = @typename
			and usertype > 99

if @typeid = 0
begin
	/*
	** 17540, "The type doesn't exist or you don't own it."
	*/
	exec sp_getmessage 17540, @msg output
	print @msg
	return (1)
end

/*
**  Check to see if the type is being used.  If it is, it can't be dropped.
*/
if exists (select *
		   from syscolumns
			   where usertype = @typeid)
begin
	/*
	** 17541, "Type is being used. You cannot drop it."
	*/
	exec sp_getmessage 17541, @msg output
	print @msg

	/*
	**  Show where it's being used.
	*/
	select object = o.name, type = o.type, owner = u.name, column = c.name,
		datatype = t.name
	from syscolumns c, systypes t, sysusers u, sysobjects o
		where c.usertype = @typeid
			and t.usertype = @typeid
			and o.uid = u.uid
			and c.id = o.id
	order by object, column

	return (1)
end

/*
**  Everything is consistent so drop the type.
*/
delete from systypes
	where usertype = @typeid

/*
** 17542, "Type has been dropped."
*/
exec sp_getmessage 17542, @msg output
print @msg

return (0)
                                                                                                                                                                                                                     
go

go
if exists (select * from sysobjects 
where name = "sp_dropuser")
begin
	drop proc sp_dropuser
end
go

/* Sccsid = "@(#) generic/sproc/src/dropuser 52.1 8/12/92" */
/*	4.8	1.1	06/14/90	sproc/src/defaultlanguage */

/*
** Messages for "sp_dropuser"           17543
**
** 17230, "Only the System Administrator (SA) or the Database Owner (dbo) may execute this stored procedure."
** 17232, "No user with the specified name exists in the current database."
** 17543, "You cannot drop the 'database owner'."
** 17544, "You cannot drop the 'guest' user from master or tempdb."
** 17545, "You cannot drop user because user '%1!' owns objects in database."
** 17546, "You cannot drop user because user '%1!' owns types in database."
** 17547, "The dependent aliases were also dropped."
** 17548, "User has been dropped from current database."
*/

create procedure sp_dropuser
@name_in_db varchar(30)			/* user name to drop */
as

declare @suid int			/* suid of the user */
declare @uid int			/* uid of the user */
declare @objectcount int		/* count of objects user owns */
declare @typecount int			/* count of types user owns */
declare	@userdropped int		/* flag to indicate user was dropped */
declare @msg varchar(250)

/*
**  You must be SA or the dbo to execute this sproc.
*/
if suser_id() != 1 and user_id() != 1
begin
	/*
	** 17230, "Only the System Administrator (SA) or the Database Owner (dbo) may execute this stored procedure."
	*/
	exec sp_getmessage 17230, @msg output
	print @msg
	return (1)
end

/*
**  See if the user exists in the database.
**  User ids are <= 16383 and group ids are > 16383.
*/
select @uid = uid, @suid = suid
	from sysusers
		where name = @name_in_db
			and uid <= 16383 and uid > 0

/*
**  No such user so return.
*/
if @uid = NULL
begin
	/*
	** 17232, "No user with the specified name exists in the current database."
	*/
	exec sp_getmessage 17232, @msg output
	print @msg
	return (1)
end

/*
**  Big trouble if dbo (uid = 1) is dropped so check.
*/
if @uid = 1
begin
	/*
	** 17543, "You cannot drop the 'database owner'."
	*/
	exec sp_getmessage 17543, @msg output
	print @msg
	return (1)
end

/*
**  Trouble if guest gets dropped from master or tempdb, so check.
*/
if (@name_in_db = "guest" and (db_id() = 1 or db_id() = 2))
begin
	/*
	** 17544, "You cannot drop the 'guest' user from master or tempdb."
	*/
	exec sp_getmessage 17544, @msg output
	print @msg
	return(1)
end

/*
**  If the user owns any objects or datatypes and we're not
**  forcing the drop, return without doing anything.
*/
select @objectcount = count(*)
	   from sysobjects
		   where uid = @uid
select @typecount = count(*)
	from systypes
		where uid = @uid

if @objectcount > 0 or @typecount > 0
begin
	if @objectcount > 0
	begin
		/*
		** 17545, "You cannot drop user because user '%1!' owns objects in database."
		*/
		exec sp_getmessage 17545, @msg output
		print @msg, @name_in_db     
		select name, type
			from sysobjects
				where uid = @uid
	end

	if @typecount > 0
	begin
		/*
		** 17546, "You cannot drop user because user '%1!' owns types in database."
		*/
		exec sp_getmessage 17546, @msg output
		print @msg, @name_in_db
		select user_type = a.name, physical_type = b.name
			from systypes a, systypes b
				where a.uid = @uid
					and a.type = b.type
					and b.usertype < 100
	end

	return (1)
end


/*
**  Drop the user.
**  Also drop any references to the user in the sysprotects table.
**  If anyone is aliased to the user, drop them also.
*/
begin transaction

	delete from sysusers
		where suid = @suid
	select @userdropped = @@rowcount

	delete from sysprotects
		where uid = @uid

	/*
	**  Drop any dependent aliases.
	*/
	if exists (select *
			from sysalternates
				where altsuid = @suid)
	begin
		delete from sysalternates
			where altsuid = @suid
		/*
		** 17547, "The dependent aliases were also dropped."
		*/
		exec sp_getmessage 17547, @msg output
		print @msg
	end

if @userdropped = 1
	commit transaction
else rollback transaction

/*
** 17548, "User has been dropped from current database."
*/
exec sp_getmessage 17548, @msg output
print @msg

return (0)
                                                                                  
go

go
if exists (select * from sysobjects 
where name = "sp_dropremotelogin")
begin
	drop proc sp_dropremotelogin
end
go

/* Sccsid = "@(#) generic/sproc/src/dropremotelogin 52.1 8/12/92" */
/*	4.8	1.1	06/14/90	sproc/src/defaultlanguage */

/*
** Messages for "sp_dropremotelogin"    17512
**
** 17260, "Can't run %1! from within a transaction." 
** 17512, "Remote login dropped."
** 17513, "There is no remote user '%1!' mapped to local user '%2!' from the remote server '%3!'."
*/

create procedure sp_dropremotelogin
@remoteserver	varchar(30),		/* name of remote server */
@loginame varchar(30) = NULL,		/* user's remote name */
@remotename varchar(30) = NULL		/* user's local user name */
as

declare	@msg	varchar(250)
declare @suid	smallint
declare @rname  varchar(30)
declare @lname  varchar(30)

/*
**  If we're in a transaction, disallow this since it might make recovery
**  impossible.
*/
if @@trancount > 0
begin
	/*
	** 17260, "Can't run %1! from within a transaction." 
	*/
	exec sp_getmessage 17260, @msg output
	print @msg, "sp_dropremotelogin"
	return (1)
end

/*
**  If @loginame is NULL then we want to set @suid = -1. Otherwise get
**  it real value.
*/
if @loginame = null
	select @suid = -1
else select @suid = suser_id(@loginame)

/*
**  Delete the remote login.
*/
delete master.dbo.sysremotelogins
	from master.dbo.sysremotelogins l, master.dbo.sysservers s
	where l.remoteserverid = s.srvid
		and s.srvname = @remoteserver
		and l.remoteusername = @remotename
		and l.suid = @suid

/*
** Check @@rowcount when it works
*/
if @@rowcount > 0
begin
	/*
	** 17512, "Remote login dropped."
	*/
	exec sp_getmessage 17512, @msg output
	print @msg
	return (0)
end
else
begin
	/*
	** 17513, "There is no remote user '%1!' mapped to local user '%2!' from the remote server '%3!'."
	*/
	select @rname = isnull(@remotename, "NULL")
	select @lname = isnull(@loginame, "NULL")
	exec sp_getmessage 17513, @msg output
	print @msg, @rname, @lname, @remoteserver
	return (1)
end
                                                                                                                                                                               
go

go
if exists (select * from sysobjects 
where name = "sp_dropsegment")
begin
	drop proc sp_dropsegment
end
go

/* Sccsid = "@(#) generic/sproc/src/dropsegment 52.1 8/12/92" */
/*	4.8	1.1	06/14/90	sproc/src/defaultlanguage */

/*
** Messages for "sp_dropsegment"        17520
**
** 17260, "Can't run %1! from within a transaction."
** 17230, "Only the System Administrator (SA) or the Database Owner (dbo) may execute this stored procedure."
** 17281, "The specified device is not used by the database."
** 17520, "There is no such segment as '%1!'."
** 17521, "Can't drop the '%1!'segment completely."
** 17522, "The segment '%1!' is being used."
** 17523, "Segment '%1!' does not reference device '%2!'."
** 17524, "There is only one device mapping for the segment '%1!' -- use sp_dropsegment with no device argument."
** 17525, "Segment dropped."
** 17526, "Segment reference to device dropped."
** 17527, "WARNING: There are no longer any segments referencing device '%1!'.  This device will no longer be used for space allocation."
** 17528, "WARNING: There are no longer any segments referencing devices '%1!'.  These devices will no longer be used for space allocation."
*/

create procedure sp_dropsegment
@segname	varchar(30),		/* segment name */
@device		varchar(30) = null	/* device name */
as

declare @dbuid	smallint	/* id of the owner of the database */
declare @segbit	int		/* this is the bit to turn on in sysusages */
declare	@msg	varchar(250)

/*
**  If we're in a transaction, disallow this since it might make recovery
**  impossible.
*/
if @@trancount > 0
begin
	/*
	** 17260, "Can't run %1! from within a transaction."
	*/
	exec sp_getmessage 17260, @msg output
	print @msg, "sp_dropsegment"
	return (1)
end

/*
**  You must be SA or the dbo to execute this sproc.
*/
if suser_id() != 1 and user_id() != 1
begin
	/*
	** 17230, "Only the System Administrator (SA) or the Database Owner (dbo) may execute this stored procedure."
	*/
	exec sp_getmessage 17230, @msg output
	print @msg
	return (1)
end

/*
**  There are two drop cases:
**	1) dropping the segment
**	2) dropping a segment reference to a device
**  The sproc does things differently depending on which we're doing.
*/

/*
**  Check to see if the segment exists.
*/
if not exists (select *
		from syssegments
			where name = @segname)
begin
	/*
	** 17520, "There is no such segment as '%1!'."
	*/
	exec sp_getmessage 17520, @msg output
	print @msg, @segname
	return (1)
end

/*
**  Get the segment number of @segname.
*/
select @segbit = segment
	from syssegments 
		where name = @segname

/*
**  Now convert the segment number to the right bit for segmap.
*/
if (@segbit < 31)
	select @segbit = power(2, @segbit)
else
	/*
	**  Since this is segment 31, power(2, 31) will overflow
	**  since segmap is an int.  We'll grab the machine-dependent
	**  bit mask from spt_values to clear the right bit.
	*/
	select @segbit = low
		from master.dbo.spt_values
			where type = "E"
				and number = 2

/*
**  Don't allow the segments 'default', 'system', or 'logsegment' to
**  be dropped completely.
*/
if @segname in ("system", "default", "logsegment")
begin
	if @device = null
	begin
		/*
		** 17521, "Can't drop the '%1!'segment completely."
		*/
		exec sp_getmessage 17521, @msg output
		print @msg, @segname
		return (1)
	end

	/*
	**  For the case where we are dropping the logsegment from a 
	**  device, the logic below works OK.  If this is the last
	**  device for the the segment, it won't let the segment be
	**  dropped.
	*/
end


/*
**  If we are dropping the segment, check to see that the segment isn't
**  being used by anyone.
*/
if @device = null
begin

	/*
	**  Check to see if the segment is being used.
	*/
	if exists (select *
			from sysindexes i, syssegments s
				where s.name = @segname
					and i.segment = s.segment)
	begin
		/*
		** 17522, "The segment '%1!' is being used."
		*/
		exec sp_getmessage 17522, @msg output
		print @msg, @segname
		return (1)
	end
end

/*
**  If we are dropping the segment reference, check to see that arguments are
**  reasonable.
*/
if @device != null
begin
	/*
	**  Now see if the database even uses the @device
	*/
	if not exists (select *
			from sysusages u, sysdevices d
				where d.name = @device
					and u.vstart between d.low and d.high
					and u.dbid = db_id())
	begin
		/*
		** 17281, "The specified device is not used by the database."
		*/
		exec sp_getmessage 17281, @msg output
		print @msg
		return (1)
	end

	/*
	**  Now check that the segment references the device.
	*/
	if not exists (select *
			from master.dbo.sysusages u, master.dbo.sysdevices d
				where u.segmap & @segbit = @segbit
				and d.name = @device
				and d.low <= u.size + u.vstart
				and d.high >= u.size + u.vstart - 1 
				and u.dbid = db_id()
				and d.status & 2 = 2)
	begin
		/*
		** 17523, "Segment '%1!' does not reference device '%2!'."
		*/
		exec sp_getmessage 17523, @msg output
		print @msg, @segname, @device
		return (1)
	end

	/*
        **  Now check to see if this is the last unique device reference for the
	**  segment.  If it is then we don't want to drop the reference.
	*/
        select distinct d.name into #temptable
		from master.dbo.sysusages u, master.dbo.sysdevices d
			where u.segmap & @segbit = @segbit
				and d.low <= u.size + u.vstart
				and d.high >= u.size + u.vstart - 1
				and u.dbid = db_id()
                                and d.status & 2 = 2

        if (select count(*) from #temptable) <= 1
	begin
		/*
		** 17524, "There is only one device mapping for the segment '%1!' -- use sp_dropsegment with no device argument."
		*/
		exec sp_getmessage 17524, @msg output
		print @msg, @segname
		return (1)
	end

        drop table #temptable
end

/*
**  If we're dropping the segment, go ahead drop the segment and
**  clear its bit in sysusages.
*/
if @device = null
begin
	/*
	**  NOTE: Don't update master..sysusages and syssegments as a xact since
	**  	it could cause problems for recovery.
	*/

	delete syssegments
		where name = @segname

	/*
	**  Now clear the segment from device in sysusages.
	*/
	update master.dbo.sysusages
		set segmap = segmap & (~@segbit)
			from master.dbo.sysusages u, master.dbo.sysdevices d
				where d.low <= u.size + u.vstart
					and d.high >= u.size + u.vstart - 1
					and u.dbid = db_id()
					and d.status & 2 = 2
end

/*
**  We want to just clear the segment reference from the device.
*/
else
begin
	update master.dbo.sysusages
		set segmap = segmap & (~@segbit)
			from master.dbo.sysusages u, master.dbo.sysdevices d
				where d.low <= u.size + u.vstart
					and d.high >= u.size + u.vstart - 1
					and u.dbid = db_id()
					and d.status & 2 = 2
					and d.name = @device

end

/*
**  Now we need to activate the new segment map.
*/
declare @dbname	varchar(30)
select @dbname = db_name()
dbcc dbrepair (@dbname, remap)

if @device = null
begin
	/*
	** 17525, "Segment dropped."
	*/
	exec sp_getmessage 17525, @msg output
	print @msg
end
else 
begin
	/*
	** 17526, "Segment reference to device dropped."
	*/
	exec sp_getmessage 17526, @msg output
	print @msg
end

/*
**  If there are no more segment references to the device,
**  print a warning.
*/
if exists (select *
		from master.dbo.sysusages
			where segmap = 0
				and dbid = db_id())
begin
	declare @nosegs	varchar(255),	/* list of unreferenced devices */
		@curdevice	varchar(30),
		@i	int
	
	select @curdevice = min(d.name)
		from master.dbo.sysusages u, master.dbo.sysdevices d
			where d.low <= u.size + u.vstart
				and d.high >= u.size + u.vstart - 1
				and u.dbid = db_id()
				and d.status & 2 = 2
				and segmap = 0
	select @nosegs = @curdevice, @i = 1
	while (@curdevice != null)
	begin
		select @curdevice = min(d.name)
			from master.dbo.sysusages u, master.dbo.sysdevices d
				where d.low <= u.size + u.vstart
					and d.high >= u.size + u.vstart - 1
					and u.dbid = db_id()
					and d.status & 2 = 2
					and segmap = 0
					and d.name > @curdevice
		if @curdevice != null
		begin
			select @nosegs = @nosegs + ", " + @curdevice
			select @i = @i + 1
		end
	end

	/*
	**  Get the device names.
	*/
	if @i > 1
		/*
		** 17528, "WARNING: There are no longer any segments referencing devices '%1!'.  These devices will no longer be used for space allocation."
		*/
		exec sp_getmessage 17528, @msg output
	else 
		/*
		** 17527, "WARNING: There are no longer any segments referencing device '%1!'.  This device will no longer be used for space allocation."
		*/
		exec sp_getmessage 17527, @msg output
	print @msg, @nosegs
end
return (0)
                                                                                                                                                                                                                                                              
go

go
if exists (select * from sysobjects 
where name = "sp_dropserver")
begin
	drop proc sp_dropserver
end
go

/* Sccsid = "@(#) generic/sproc/src/dropserver 52.1 8/12/92" */
/*	4.8	1.1	06/14/90	sproc/src/defaultlanguage */

/*
** Messages for "sp_dropserver"         17530
**
** 17260, "Can't run %1! from within a transaction." 
** 17270, "There is not a server named '%1!'."
** 17530, "There are still remote logins for the server '%1!'."
** 17531, "Remote logins for remote server '%1!' have been dropped."
** 17532, "Usage: sp_dropserver server [, droplogins]"
** 17533, "Server dropped."
*/

create procedure sp_dropserver
@server	varchar(30),			/* server name */
@droplogins	char(10) = NULL		/* drop all related logins? */
as

declare	@msg	varchar(200)

/*
**  If we're in a transaction, disallow this since it might make recovery
**  impossible.
*/
if @@trancount > 0
begin
	/*
	** 17260, "Can't run %1! from within a transaction." 
	*/
	exec sp_getmessage 17260, @msg output
	print @msg, "sp_dropserver"
	return (1)
end

/*
**  Check to see if the server exists.
*/
if not exists (select *
		from master.dbo.sysservers
			where srvname = @server)
begin
	/*
	** 17270, "There is not a server named '%1!'."
	*/
	exec sp_getmessage 17270, @msg output
	print @msg, @server
	return (1)
end

/*
**  Check to see if there are any related logins in sysremotelogins.
*/
if @droplogins = NULL
begin
	if exists (select *
			from master.dbo.sysremotelogins l,
				master.dbo.sysservers s
			where s.srvid = l.remoteserverid
				and s.srvname = @server)
	begin
		/*
		** 17530, "There are still remote logins for the server '%1!'."
		*/
		exec sp_getmessage 17530, @msg output
		print @msg, @server
		return (1)
	end
end

/*
**  If @droplogins is true then drop any associated logins
*/
else if @droplogins = "droplogins"
begin
	begin transaction dropserver

		delete master.dbo.sysremotelogins
			from master.dbo.sysremotelogins l,
				master.dbo.sysservers s
			where s.srvid = l.remoteserverid
				and s.srvname = @server
		if @@rowcount > 0
		begin
			/*
			** 17531, "Remote logins for remote server '%1!' have been dropped."
			*/
			exec sp_getmessage 17531, @msg output
			print @msg, @server
		end

		delete master.dbo.sysservers
			where srvname = @server

		/*
		** 17533, "Server dropped."
		*/
		exec sp_getmessage 17533, @msg output
		print @msg

	commit transaction dropserver

	return (0)
end

/*
**  Bad argument to @droplogins.
*/
else
begin
	/*
	** 17532, "Usage: sp_dropserver server [, droplogins]"
	*/
	exec sp_getmessage 17532, @msg output
	print @msg
	return (1)
end
		
/*
**  Drop the server.
*/
delete master.dbo.sysservers
	where srvname = @server

/*
** 17533, "Server dropped."
*/
exec sp_getmessage 17533, @msg output
print @msg

return (0)
                                                                                                                                                    
go

go
if exists (select * from sysobjects 
where name = "sp_extendsegment")
begin
	drop proc sp_extendsegment
end
go

/* Sccsid = "@(#) generic/sproc/src/extendsegment 52.1 8/12/92" */
/*	4.8	1.1	06/14/90	sproc/src/extendsegment */

/*
** Messages for "sp_extendsegment"      17550
**
** 17260, "Can't run %1! from within a transaction."
** 17230, "Only the System Administrator (SA) or the Database Owner (dbo) may execute this stored procedure."
** 17284, "'%1!' is not a valid identifier."
** 17520, "There is no such segment as '%1!'."
** 17281, "The specified device is not used by the database."
** 17283, "'%1!' is reserved exclusively as a log device."
** 17280, "No such device exists -- run sp_helpdb to list the devices for the current database."
** 17550, "Segment extended."
** 17551, "Device '%1!' is now exclusively used by '%2!'"
** 17552, "This command has been ignored.  Extending the log segment on device '%1!' would leave no space for creating objects in database '%2!'."
*/

create procedure sp_extendsegment
@segname	varchar(30),	/* segment name */
@devname	varchar(30)	/* device name to put segment on */
as

declare @dbuid	smallint	/* id of the owner of the database */
declare	@dbname	varchar(30)	/* name of the database. */
declare @segbit	int		/* this is the bit to turn on in sysusages */
declare	@msg	varchar(250)

/*
**  If we're in a transaction, disallow this since it might make recovery
**  impossible.
*/
if @@trancount > 0
begin
	/*
	** 17260, "Can't run %1! from within a transaction."
 	*/
	exec sp_getmessage 17260, @msg output
	print @msg, "sp_extendsegment"
	return (1)
end

/*
**  You must be SA or the dbo to execute this sproc.
*/
if suser_id() != 1 and user_id() != 1
begin
	/*
	** 17230, "Only the System Administrator (SA) or the Database Owner (dbo) may execute this stored procedure."
	*/
	exec sp_getmessage 17230, @msg output
        print @msg
	return (1)
end

/*
**  Check to see if the segment exists.
*/
if not exists (select *
		from syssegments
			where name = @segname)
begin
	/*
	** 17520, "There is no such segment as '%1!'."
	*/
	exec sp_getmessage 17520, @msg output
        print @msg, @segname
	return (1)
end

/*
**  See if the device exists.
*/
if not exists (select *
		from master.dbo.sysdevices
			where name like @devname)
begin
	/*
	** 17280, "No such device exists -- run sp_helpdb to list the devices for the current database."

	*/
	exec sp_getmessage 17280, @msg output
        print @msg
	return (1)
end

/*
**  Now see if the @dbname uses the @devname
*/
select @dbname = db_name()

if not exists (select *
		from master.dbo.sysusages u, master.dbo.sysdevices d
			where d.name = @devname
				and u.vstart between d.low and d.high
				and u.dbid = db_id())
begin
	/*
	** 17281, "The specified device is not used by the database."
	*/
	exec sp_getmessage 17281, @msg output
        print @msg
	return (1)
end

/*
**  Check to see if the device is marked as a log device.
**  If so, print error.
*/
if exists (select *
		from master.dbo.sysusages u, master.dbo.sysdevices d
			where d.name = @devname
				and u.vstart between d.low and d.high
				and u.dbid = db_id()
				and segmap = 4)
begin
	/*
	** 17283, "'%1!' is reserved exclusively as a log device."
	*/
	exec sp_getmessage 17283, @msg output
        print @msg, @devname
	return (1)
end

/*
** Check for valid identifier.
*/
if valid_name(@segname) = 0
begin
	/*
	** 17284, "'%1!' is not a valid identifier."
	*/
	exec sp_getmessage 17284, @msg output
	print @msg, @segname
	return (1)
end

/*
**  Now go ahead and define the new segment and add it to the segmap
**  of sysusages.
**  NOTE: Don't update master..sysusages and syssegments as a xact since
**  	it could cause problems for recovery.
*/

/*
**  Get the segment number for @segname.
*/
select @segbit = segment
	from syssegments
		where name = @segname

/*
**  If @segbit is 2 then it's the logsegment and the logsegment
**  doesn't share devices with other segments.  In this case,
**  don't OR the @segbit in but just set segmap to 4.
*/
if @segbit = 2
begin
	/*
	** Extending the logsegment means we won't be able to
	** create any more objects on this device. (See comment above.)
	** Do it only if non-log space is available on other devices.
	*/
	if not exists (select *
		from master.dbo.sysdevices d,
			master.dbo.sysusages u
		where u.vstart between d.low and d.high
			and u.dbid = db_id()
			and u.segmap != 4
			and d.name != @devname
			and d.cntrltype = 0)
	begin
		/*
		** 17552, "This command has been ignored.  Extending the log
		** segment on device '%1!' would leave no space for creating
		** objects in database '%2!'."
		*/
		exec sp_getmessage 17552, @msg output
		print @msg, @devname, @dbname
		return (1)
	end

	update master.dbo.sysusages
		set segmap = 4
			from master.dbo.sysusages u,
				master.dbo.sysdevices d
			where d.name = @devname
				and u.vstart between d.low and d.high
				and u.dbid = db_id()
end

else
begin
	if (@segbit < 31)
		select @segbit = power(2, @segbit)
	else
		/*
		**  Since this is segment 31, power(2, 31) will
		**  overflow since segmap is an int.  We'll grab the
		**  machine-dependent bit mask from spt_values to set
		**  the right bit.
		*/
		select @segbit = low
			from master.dbo.spt_values
				where type = "E"
					and number = 2
	/*
	**  Add the segment to @devname in sysusages.
	*/
	update master.dbo.sysusages
		set segmap = segmap | @segbit
			from master.dbo.sysusages u,
				master.dbo.sysdevices d
			where d.name = @devname
				and u.vstart between d.low and d.high
				and u.dbid = db_id()
end

/*
**  Now we need to activate the new segment map.
*/
dbcc dbrepair (@dbname, remap)
/*
** 17550, "Segment extended."
*/
exec sp_getmessage 17550, @msg output
print @msg

/*
**  Get the segment number for @segname.
*/
select @segbit = segment
	from syssegments
		where name = @segname

/*
**  If we are extending the logsegment, print out a message about what it
**  means to do so.
*/
if @segbit = 2
begin
	/*
	** 17551, "Device '%1!' is now exclusively used by '%2!'"
	*/
	exec sp_getmessage 17551, @msg output
        print @msg, @devname, @segname
end

return (0)
                                                                                             
go

go
if exists (select * from sysobjects 
where name = "sp_fixindex")
begin
	drop proc sp_fixindex
end
go

/* Sccsid = "@(#) generic/sproc/src/fixindex 52.1 8/12/92" */
/*	4.8	1.1	06/14/90	sproc/src/fixindex */
create procedure sp_fixindex
		@dbname		varchar(30),
		@tabname	varchar(30),  		/* system table name */
		@indid		int			/* index id value    */
as
	/*
	**	Description:	allow the SA to force a drop and then a
	**			create index on system catalogs.
	**
	**	Usage:		sp_fixindex  database, systemcatalog, ind_id
	**
	**	Note:		before using this procedure the database has to
	**			be in single user mode. The sp_dboption has to
	**			be used for user databases, and update of
	**			sysdatabases for master.
	**	
	**	History:	3/28/88		(robbie)
	*/

	declare	@ramboix smallint			/* mask for rambo indx*/
	declare @badlist  varchar(255)   /* name list of all tables that should
					      not have any indexes on them */
	/*
	**	Initialize name lists. These will be used in catching
	**	any attempts to fix indexes on fake tables or tables
	**	that have no indexes on them.
	*/
	select @badlist = "syslocks, sysprocesses, syscurconfig, 
			   syssegments, syslogckp"

	/*
	**	Make sure we are "fixing" a system catalog.
	*/
	if @tabname NOT LIKE  "sys%"
	begin
		print "Procedure should be used on system tables only."
		return (1)
	end

	/*
	**	Make sure that we are doing this on somenthing that 
	**	has indexes (or real tables).
	*/
	if @badlist LIKE  "%" + @tabname + "%"
	begin
		print "Cannot re-create index on this table."
		return (1)
	end

	/*
	**	At this point we are sure that the table has an index
	**	of requested type, so all there is to be done is to
	**	set the ramboix bit for this object unless we try to
	**	fix Sysobjects.
	*/
	if @tabname != "sysobjects"
	begin
		select @ramboix = 0x1000
		update sysobjects set sysstat = sysstat | @ramboix
		where name = @tabname

		checkpoint
	end

	/*
	**	Call dbcc to do the job.
	*/
	dbcc dbrepair(@dbname, REPAIRINDEX, @tabname, @indid)

	/*
	**	Processing successfully done, so turn off the ramboix
	**	bit if not sysobjects, and tell the user that all is fine.
	*/
	if @tabname != "sysobjects"
	begin
		update sysobjects set sysstat = sysstat & ~@ramboix
		where name = @tabname
	 
		checkpoint
	end

	return (0)
                                                                                                                     
go

go
if exists (select * from sysobjects 
where name = "sp_foreignkey")
begin
	drop proc sp_foreignkey
end
go

/* Sccsid = "@(#) generic/sproc/src/foreignkey 52.1 8/12/92" */
/*	4.8	1.1	06/14/90	sproc/src/fixindex */

/*
** Messages for "sp_foreignkey"         17560
**
** 17390, "Table or view name must be in 'current' database."
** 17560, "Foreign key table doesn't exist."
** 17561, "Primary key table doesn't exist."
** 17562, "Only the owner of the table may define a foreign key."
** 17563, "The table does not have a column named '%1!'."
** 	  ** substitute in "@col[1-8]" for the arg.
** 17564, "Primary key does not exist with the same number of columns as the foreign key."
** 17565, "Primary key does not exist."
** 17566, "Datatypes of the column '%1!' in the keys are different." 
** 	  ** substitute in "@col[1-8]" for the arg.
** 17567, "New foreign key added."
*/

/*
** IMPORTANT NOTE:
** This stored procedure uses the built-in function object_id() in the
** where clause of a select query. If you intend to change this query
** or use the object_id() or db_id() builtin in this procedure, please read the
** READ.ME file in the $DBMS/generic/sproc directory to ensure that the rules
** pertaining to object-id's and db-id's outlined there, are followed.
*/

create procedure sp_foreignkey 
@tabname  varchar(92),		/* name of table that we are doing */
@pktabname varchar(92),		/* name of table with primary key */
@col1     varchar(30), 		/* column name of table we are doing */
@col2     varchar(30) = NULL,
@col3     varchar(30) = NULL,
@col4     varchar(30) = NULL,
@col5     varchar(30) = NULL,
@col6     varchar(30) = NULL,
@col7     varchar(30) = NULL,
@col8     varchar(30) = NULL
as

declare @uid smallint		/* id of owner of the talbe */
declare @cnt    int		/* how many columns are in foreign key */

declare @pkey1 int		/* colids of the foreign key */
declare @pkey2 int
declare @pkey3 int
declare @pkey4 int
declare @pkey5 int
declare @pkey6 int
declare @pkey7 int
declare @pkey8 int

declare @fkey1 int		/* colids of the primary key */
declare @fkey2 int
declare @fkey3 int
declare @fkey4 int
declare @fkey5 int
declare @fkey6 int
declare @fkey7 int
declare @fkey8 int

declare @msg   varchar(250)

/*
**  Check to see that the tabname is local.
*/
if @tabname like "%.%.%"
begin
	if substring(@tabname, 1, charindex(".", @tabname) - 1) != db_name()
	begin
		/*
		** 17390, "Table or view name must be in 'current' database."
		*/
		exec sp_getmessage 17390, @msg output
		print @msg
		return (1)
	end
end
if @pktabname like "%.%.%"
begin
	if substring(@pktabname, 1, charindex(".", @pktabname) - 1) != db_name()
	begin
		/*
		** 17390, "Table or view name must be in 'current' database."
		*/
		exec sp_getmessage 17390, @msg output
		print @msg
		return (1)
	end
end

/*
**  See if we can find the objects.  They must be a system table, user table,
**  or view.  The low 3 bits of sysobjects.sysstat indicate what the 
**  object type is -- it's more reliable than using sysobjects.type which
**  could change.
*/
if not exists (select *
	from sysobjects
		where id = object_id(@tabname)
			and (sysstat & 7 = 1		/* system table */
				or sysstat & 7 = 2	/* view */
				or sysstat & 7 = 3))	/* user table */
/*
**  If either of the tables don't exist, quit.
*/
begin
    /*
    ** 17560, "Foreign key table doesn't exist."
    */
    exec sp_getmessage 17560, @msg output
    print @msg
    return (1)
end 
if not exists (select *
	from sysobjects
		where id = object_id(@pktabname)
			and (sysstat & 7 = 1
				or sysstat & 7 = 2
				or sysstat & 7 = 3))
begin
    /*
    ** 17561, "Primary key table doesn't exist."
    */
    exec sp_getmessage 17561, @msg output
    print @msg
    return (1)
end 

/*
**  Only the owner of the table can define it's foreign keys.
*/
select @uid = uid
	from sysobjects
		where id = object_id(@tabname)
			and (sysstat & 7 = 1            /* system table */
				or sysstat & 7 = 2      /* view */
				or sysstat & 7 = 3)     /* user table */

if @uid != user_id()
begin
	/*
        ** 17562, "Only the owner of the table may define a foreign key."
	*/
	exec sp_getmessage 17562, @msg output
	print @msg
	return (1)
end

/*
**  Now check to see that the foreign key columns exist.
*/
select @cnt = 1, @fkey1 = colid
	from syscolumns
		where name = @col1 
			and id = object_id(@tabname)
if @fkey1 = NULL
begin
	/*
	** 17563, "The table does not have a column named '%1!'."
	*/
	exec sp_getmessage 17563, @msg output
	print @msg, @col1 
	return (1)
end

if @col2 != NULL
begin
	select @cnt = @cnt + 1, @fkey2 = colid
		from syscolumns
			where name = @col2 
				and id = object_id(@tabname)
	if @fkey2 is NULL
	begin
		/*
		** 17563, "The table does not have a column named '%1!'."
		*/
		exec sp_getmessage 17563, @msg output
		print @msg, @col2
		return (1)
	end
end
else goto foreign_ok

if @col3 != NULL
begin
	select @cnt = @cnt + 1, @fkey3 = colid
		from syscolumns
			where name = @col3 
				and id = object_id(@tabname)
	if @fkey3 is NULL
	begin
		/*
		** 17563, "The table does not have a column named '%1!'."
		*/
		exec sp_getmessage 17563, @msg output
		print @msg, @col3
		return (1)
	end
end
else goto foreign_ok

if @col4 != NULL
begin
	select @cnt = @cnt + 1, @fkey4 = colid
		from syscolumns
			where name = @col4 
				and id = object_id(@tabname)
	if @fkey4 is NULL
	begin
		/*
		** 17563, "The table does not have a column named '%1!'."
		*/
		exec sp_getmessage 17563, @msg output
		print @msg, @col4
		return (1)
	end
end
else goto foreign_ok

if @col5 != NULL
begin
	select @cnt = @cnt + 1, @fkey5 = colid
		from syscolumns
			where name = @col5 
				and id = object_id(@tabname)
	if @fkey5 is NULL
	begin
		/*
		** 17563, "The table does not have a column named '%1!'."
		*/
		exec sp_getmessage 17563, @msg output
		print @msg, @col5
		return (1)
	end
end
else goto foreign_ok

if @col6 != NULL
begin
	select @cnt = @cnt + 1, @fkey6 = colid
		from syscolumns
			where name = @col6 
				and id = object_id(@tabname)
	if @fkey6 is NULL
	begin
		/*
		** 17563, "The table does not have a column named '%1!'."
		*/
		exec sp_getmessage 17563, @msg output
		print @msg, @col6
		return (1)
	end
end
else goto foreign_ok

if @col7 != NULL
begin
	select @cnt = @cnt + 1, @fkey7 = colid
		from syscolumns
			where name = @col7 
				and id = object_id(@tabname)
	if @fkey7 is NULL
	begin
		/*
		** 17563, "The table does not have a column named '%1!'."
		*/
		exec sp_getmessage 17563, @msg output
		print @msg, @col7
		return (1)
	end
end
else goto foreign_ok

if @col8 != NULL
begin
	select @cnt = @cnt + 1, @fkey8 = colid
		from syscolumns
			where name = @col8 
				and id = object_id(@tabname)
	if @fkey8 is NULL
	begin
		/*
		** 17563, "The table does not have a column named '%1!'."
		*/
		exec sp_getmessage 17563, @msg output
		print @msg, @col8
		return (1)
	end
end


/*
**  If we made it this far then all the columns for the foreign key are ok.
*/
foreign_ok:

/*
**  Now let's check out the primary key that the foreign key is on.
**  There must be the same number of columns in the key and the
**  base types of the columns must agree.
*/
select @pkey1 = key1, @pkey2 = key2, @pkey3 = key3, @pkey4 = key4,
	@pkey5 = key5, @pkey6 = key6, @pkey7 = key7, @pkey8 = key8
		from syskeys
	where id = object_id(@pktabname)
		and type = 1
		and keycnt = @cnt

/*
**  If @pkey1 is null then there is no such primary key or the number of
**  columns in the primary key are not the same as the number of columns
**  in the foreign key.
*/
if @pkey1 = NULL
begin
	if exists (select *
			from syskeys
		where id = object_id(@pktabname)
			and type = 1)
	begin
		/*
		** 17564, "Primary key does not exist with the same number of columns as the foreign key."
		*/
		exec sp_getmessage 17564, @msg output
	        print @msg
	end
	else
	begin
		/*
		** 17565, "Primary key does not exist."
		*/
		exec sp_getmessage 17565, @msg output
		print @msg
	end
	return (1)
end

/*
**  Since we have the right number of columns in the foreign and primary keys,
**  check that there base datatypes agree.
*/
if not exists (select *
		from syscolumns a, syscolumns b, master.dbo.spt_values y,
			master.dbo.spt_values z
		where a.colid = @fkey1
			and a.id = object_id(@tabname)
			and b.colid = @pkey1
			and b.id = object_id(@pktabname)
			and y.type = "J"
			and a.type = y.low
			and z.type = "J"
			and b.type = z.low
			and y.number = z.number)
begin
	/*
	** 17566, "Datatypes of the column '%1!' in the keys are different."
	*/
	exec sp_getmessage 17566, @msg output
	print @msg, @col1
	return (1)
end

if @fkey2 != NULL and not exists (select *
		from syscolumns a, syscolumns b, master.dbo.spt_values y,
			master.dbo.spt_values z
		where a.colid = @fkey2
			and a.id = object_id(@tabname)
			and b.colid = @pkey2
			and b.id = object_id(@pktabname)
			and y.type = "J"
			and a.type = y.low
			and z.type = "J"
			and b.type = z.low
			and y.number = z.number)
begin
	/*
	** 17566, "Datatypes of the column '%1!' in the keys are different."
	*/
	exec sp_getmessage 17566, @msg output
	print @msg, @col2
	return (1)
end
else goto doinsert

if @fkey3 != NULL and not exists (select *
		from syscolumns a, syscolumns b, master.dbo.spt_values y,
			master.dbo.spt_values z
		where a.colid = @fkey3
			and a.id = object_id(@tabname)
			and b.colid = @pkey3
			and b.id = object_id(@pktabname)
			and y.type = "J"
			and a.type = y.low
			and z.type = "J"
			and b.type = z.low
			and y.number = z.number)
begin
	/*
	** 17566, "Datatypes of the column '%1!' in the keys are different."
	*/
	exec sp_getmessage 17566, @msg output
	print @msg, @col3
	return (1)
end
else goto doinsert

if @fkey4 != NULL and not exists (select *
		from syscolumns a, syscolumns b, master.dbo.spt_values y,
			master.dbo.spt_values z
		where a.colid = @fkey4
			and a.id = object_id(@tabname)
			and b.colid = @pkey4
			and b.id = object_id(@pktabname)
			and y.type = "J"
			and a.type = y.low
			and z.type = "J"
			and b.type = z.low
			and y.number = z.number)
begin
	/*
	** 17566, "Datatypes of the column '%1!' in the keys are different."
	*/
	exec sp_getmessage 17566, @msg output
	print @msg, @col4
	return (1)
end

if @fkey5 != NULL and not exists (select *
		from syscolumns a, syscolumns b, master.dbo.spt_values y,
			master.dbo.spt_values z
		where a.colid = @fkey5
			and a.id = object_id(@tabname)
			and b.colid = @pkey5
			and b.id = object_id(@pktabname)
			and y.type = "J"
			and a.type = y.low
			and z.type = "J"
			and b.type = z.low
			and y.number = z.number)
begin
	/*
	** 17566, "Datatypes of the column '%1!' in the keys are different."
	*/
	exec sp_getmessage 17566, @msg output
	print @msg, @col5
	return (1)
end
else goto doinsert

if @fkey6 != NULL and not exists (select *
		from syscolumns a, syscolumns b, master.dbo.spt_values y,
			master.dbo.spt_values z
		where a.colid = @fkey6
			and a.id = object_id(@tabname)
			and b.colid = @pkey6
			and b.id = object_id(@pktabname)
			and y.type = "J"
			and a.type = y.low
			and z.type = "J"
			and b.type = z.low
			and y.number = z.number)
begin
	/*
	** 17566, "Datatypes of the column '%1!' in the keys are different."
	*/
	exec sp_getmessage 17566, @msg output
	print @msg, @col6
	return (1)
end
else goto doinsert

if @fkey7 != NULL and not exists (select *
		from syscolumns a, syscolumns b, master.dbo.spt_values y,
			master.dbo.spt_values z
		where a.colid = @fkey7
			and a.id = object_id(@tabname)
			and b.colid = @pkey7
			and b.id = object_id(@pktabname)
			and y.type = "J"
			and a.type = y.low
			and z.type = "J"
			and b.type = z.low
			and y.number = z.number)
begin
	/*
	** 17566, "Datatypes of the column '%1!' in the keys are different."
	*/
	exec sp_getmessage 17566, @msg output
	print @msg, @col7
	return (1)
end
else goto doinsert

if @fkey8 != NULL and not exists (select *
		from syscolumns a, syscolumns b, master.dbo.spt_values y,
			master.dbo.spt_values z
		where a.colid = @fkey8
			and a.id = object_id(@tabname)
			and b.colid = @pkey8
			and b.id = object_id(@pktabname)
			and y.type = "J"
			and a.type = y.low
			and z.type = "J"
			and b.type = z.low
			and y.number = z.number)
begin
	/*
	** 17566, "Datatypes of the column '%1!' in the keys are different."
	*/
	exec sp_getmessage 17566, @msg output
	print @msg, @col8
	return (1)
end

/*
**  Everything is consistent so add the foreign key to syskeys.
*/
doinsert:

insert syskeys (id, type, depid, keycnt, size, key1, key2, key3, key4, key5,
	key6, key7, key8, depkey1, depkey2, depkey3, depkey4, depkey5,
	depkey6, depkey7, depkey8)
values (object_id(@tabname), 2, object_id(@pktabname), @cnt, 0, @fkey1, 
	@fkey2, @fkey3, @fkey4, @fkey5,
	@fkey6, @fkey7, @fkey8, @pkey1, @pkey2, @pkey3, @pkey4, @pkey5,
	@pkey6, @pkey7, @pkey8)   

/* 
** 17567, "New foreign key added."
*/
exec sp_getmessage 17567, @msg output
print @msg

return (0)
                                                                                                                                                                                                                                                         
go

go
if exists (select * from sysobjects 
where name = "sp_helpdb")
begin
	drop proc sp_helpdb
end
go

/* Sccsid = "@(#) generic/sproc/helpdb 52.1 8/12/92" */
/*	4.8	1.1	06/14/90	sproc/src/help */
/*
** Messages for "sp_helpdb"             17590
**
** 17590, "The specified database does not exist."
** 17591, "no options set"
** 17592, " -- unused by any segments --"
*/
create procedure sp_helpdb
@dbname varchar(30) = NULL			/* database name to change */
as

declare @showdev	bit
declare @allopts	int
declare @msg 		varchar(90)
declare @sptlang	int
declare @len1 int, @len2 int

select @sptlang = @@langid

if @@langid != 0
begin
	if not exists (
		select * from sysmessages where error
		between 17050 and 17069
		and langid = @@langid)
	    select @sptlang = 0
	else
	if not exists (
		select * from sysmessages where error
		between 17110 and 17119
		and langid = @@langid)
	    select @sptlang = 0
end

set nocount on

/*
**  If no database name given, get 'em all.
*/
if @dbname = null
	select @dbname = "%", @showdev = 0
else select @showdev = 1

/*
**  Sure the database exists
*/
if not exists (select *
	from sysdatabases
		where name like @dbname)
begin
	/* 17590, "The specified database does not exist." */
	exec sp_getmessage 17590, @msg out
	print @msg
	return (1)
end

/*
**  Set allopts to be the sum of all possible user-settable database status
**  bits.
*/
select @allopts = 7196

/*
**  Since we examine the status bits in sysdatabase and turn them
**  into english, we need a temporary table to build the descriptions.
*/
create table #spdbdesc
(
	dbid	smallint null,
	dbdesc	varchar(102) null
)

/*
**  Initialize #spdbdesc from sysdatabases
*/
insert into #spdbdesc (dbid)
		select dbid 
			from sysdatabases
				where name like @dbname

/*
**  Now for each dbid in #spdbdesc, build the database status
**  description.
*/
declare @curdbid smallint		/* the one we're currently working on */
declare @dbdesc varchar(102)		/* the total description for the db */
declare @bitdesc varchar(30)		/* the bit description for the db */

/*
**  Set @curdbid to the first dbid.
*/
select @curdbid = min(dbid)
	from #spdbdesc
while @curdbid != NULL
begin


	/*
	**  Initialize @dbdesc.
	*/
	select @dbdesc = ""

	/*
	**  Check select into/bulk copy bit (4)
	*/
	select @bitdesc = null
	select @bitdesc = m.description
		from spt_values v, sysdatabases d, sysmessages m
			where d.dbid = @curdbid
				and v.type = "D"
				and d.status & v.number = 4
				and v.number != @allopts       /* all options */
				and v.msgnum = m.error
				and isnull(m.langid, 0) = @sptlang
	if @bitdesc != null
	begin
		if @dbdesc != ""
			select @dbdesc = @dbdesc + ", " +  @bitdesc
		else select @dbdesc = @bitdesc
	end

	/*
	**  Check no checkpoint on recovery bit (16)
	*/
	select @bitdesc = null
	select @bitdesc = m.description
		from spt_values v, sysdatabases d, sysmessages m
			where d.dbid = @curdbid
				and v.type = "D"
				and d.status & v.number = 16
				and v.number != @allopts /* all options */
				and v.msgnum = m.error
				and isnull(m.langid, 0) = @sptlang
	if @bitdesc != null
	begin
		if @dbdesc != ""
			select @dbdesc = @dbdesc + ", " +  @bitdesc
		else select @dbdesc = @bitdesc
	end

	/*
	**  Check single user bit (4096)
	*/
	select @bitdesc = null
	select @bitdesc = m.description
		from spt_values v, sysdatabases d, sysmessages m
			where d.dbid = @curdbid
				and v.type = "D"
				and d.status & v.number = 4096
				and v.number != @allopts       /* all options */
				and v.msgnum = m.error
				and isnull(m.langid, 0) = @sptlang
	if @bitdesc != null
	begin
		if @dbdesc != ""
			select @dbdesc = @dbdesc + ", " +  @bitdesc
		else select @dbdesc = @bitdesc
	end

	/*
	**  Check dbo only bit (2048)
	*/
	select @bitdesc = null
	select @bitdesc = m.description
		from spt_values v, sysdatabases d, sysmessages m
			where d.dbid = @curdbid
				and v.type = "D"
				and d.status & v.number = 2048
				and v.number != @allopts       /* all options */
				and v.msgnum = m.error
				and isnull(m.langid, 0) = @sptlang
	if @bitdesc != null
	begin
		if @dbdesc != ""
			select @dbdesc = @dbdesc + ", " +  @bitdesc
		else select @dbdesc = @bitdesc
	end

	/*
	**  Check read only bit (1024)
	*/
	select @bitdesc = null
	select @bitdesc = m.description
		from spt_values v, sysdatabases d, sysmessages m
			where d.dbid = @curdbid
				and v.type = "D"
				and d.status & v.number = 1024
				and v.number != @allopts       /* all options */
				and v.msgnum = m.error
				and isnull(m.langid, 0) = @sptlang
	if @bitdesc != null
	begin
		if @dbdesc != ""
			select @dbdesc = @dbdesc + ", " +  @bitdesc
		else select @dbdesc = @bitdesc
	end

	/*
	**  Check load only bit (512)
	*/
	select @bitdesc = null
	select @bitdesc = m.description
		from spt_values v, sysdatabases d, sysmessages m
			where d.dbid = @curdbid
				and v.type = "D"
				and d.status & v.number = 512
				and v.number != @allopts       /* all options */
				and v.msgnum = m.error
				and isnull(m.langid, 0) = @sptlang
	if @bitdesc != null
	begin
		if @dbdesc != ""
			select @dbdesc = @dbdesc + ", " +  @bitdesc
		else select @dbdesc = @bitdesc
	end

	/*
	**  Check not recovered only bit (256)
	*/
	select @bitdesc = null
	select @bitdesc = m.description
		from spt_values v, sysdatabases d, sysmessages m
			where d.dbid = @curdbid
				and v.type = "D"
				and d.status & v.number = 256
				and v.number != @allopts       /* all options */
				and v.msgnum = m.error
				and isnull(m.langid, 0) = @sptlang
	if @bitdesc != null
	begin
		if @dbdesc != ""
			select @dbdesc = @dbdesc + ", " +  @bitdesc
		else select @dbdesc = @bitdesc
	end

	/*
	**  Check don't recover bit (32)
	*/
	select @bitdesc = null
	select @bitdesc = m.description
		from spt_values v, sysdatabases d, sysmessages m
			where d.dbid = @curdbid
				and v.type = "D"
				and d.status & v.number = 32
				and v.number != @allopts       /* all options */
				and v.msgnum = m.error
				and isnull(m.langid, 0) = @sptlang
	if @bitdesc != null
	begin
		if @dbdesc != ""
			select @dbdesc = @dbdesc + ", " +  @bitdesc
		else select @dbdesc = @bitdesc
	end

	/*
	**  Check truncate log on checkpoint bit (8)
	*/
	select @bitdesc = null
	select @bitdesc = m.description
		from spt_values v, sysdatabases d, sysmessages m
			where d.dbid = @curdbid
				and v.type = "D"
				and d.status & v.number = 8
				and v.number != @allopts       /* all options */
				and v.msgnum = m.error
				and isnull(m.langid, 0) = @sptlang
	if @bitdesc != null
	begin
		if @dbdesc != ""
			select @dbdesc = @dbdesc + ", " +  @bitdesc
		else select @dbdesc = @bitdesc
	end

	/*
	**  If not flags are set, say so.
	*/
	if @dbdesc = ""
	begin
		/* 17591, "no options set" */
		exec sp_getmessage 17591, @dbdesc out
	end

	/*
	**  Save the description.
	*/
	update #spdbdesc
		set dbdesc = @dbdesc
			from #spdbdesc
				where dbid = @curdbid

	/*
	**  Now get the next, if any dbid.
	*/
	select @curdbid = min(dbid)
		from #spdbdesc
			where dbid > @curdbid
end 

/*
**  Now #spdbdesc is complete so we can print out the db info
*/
select distinct @len1 = max(datalength(sysdatabases.name)),
		@len2 = max(datalength(syslogins.name))
		from sysdatabases, syslogins, sysusages, #spdbdesc
		where sysdatabases.dbid = #spdbdesc.dbid
			and sysdatabases.suid = syslogins.suid
			and #spdbdesc.dbid = sysusages.dbid

if (@len1 > 24 or @len2 > 24)
	select distinct name = sysdatabases.name,
		db_size = convert(varchar(10),
			round(
			(spt_values.low * convert(float, sum(sysusages.size)))
			/ 1048576, 0))
			+ " " + "MB",
		owner = syslogins.name,
		dbid = sysdatabases.dbid,
		created = convert(char(14), sysdatabases.crdate, 107),
		status = #spdbdesc.dbdesc
			from sysdatabases, syslogins, sysusages, #spdbdesc,
				spt_values
		where sysdatabases.dbid = #spdbdesc.dbid
			and sysdatabases.suid = syslogins.suid
			and #spdbdesc.dbid = sysusages.dbid
			and spt_values.type = "E"
			and spt_values.number = 1
		group by #spdbdesc.dbid
		having sysdatabases.dbid = #spdbdesc.dbid
			and sysdatabases.suid = syslogins.suid
			and #spdbdesc.dbid = sysusages.dbid
			and spt_values.type = "E"
			and spt_values.number = 1
		order by sysdatabases.name
else
	select distinct name = convert(char(24), sysdatabases.name),
		db_size = convert(varchar(10),
			round(
			(spt_values.low * convert(float, sum(sysusages.size)))
			/ 1048576, 0))
			+ " " + "MB",
		owner = convert(char(24), syslogins.name),
		dbid = sysdatabases.dbid,
		created = convert(char(14), sysdatabases.crdate, 107),
		status = #spdbdesc.dbdesc
			from sysdatabases, syslogins, sysusages, #spdbdesc,
				spt_values
		where sysdatabases.dbid = #spdbdesc.dbid
			and sysdatabases.suid = syslogins.suid
			and #spdbdesc.dbid = sysusages.dbid
			and spt_values.type = "E"
			and spt_values.number = 1
		group by #spdbdesc.dbid
		having sysdatabases.dbid = #spdbdesc.dbid
			and sysdatabases.suid = syslogins.suid
			and #spdbdesc.dbid = sysusages.dbid
			and spt_values.type = "E"
			and spt_values.number = 1
		order by sysdatabases.name

/*
**  If we are looking at one database, show it's device allocation.
*/
if @showdev = 1
begin
	select device_fragments = sysdevices.name, size =
		convert(varchar(10),
			round(
			(spt_values.low * convert(float, size))
			/ 1048576, 0)) + " " + "MB",
		usage = m.description
	from sysdatabases, sysusages, sysdevices, spt_values a, spt_values b,
			sysmessages m
		where sysdatabases.dbid = sysusages.dbid
			and sysdevices.low <= size + vstart
			and sysdevices.high >= size + vstart - 1
			and sysdevices.status & 2 = 2 
			and sysdatabases.name = @dbname
			and a.type = "E"
			and a.number = 1
			and b.type = "S"
			and sysusages.segmap & 7 = b.number
			and b.msgnum = m.error
			and isnull(m.langid, 0) = @sptlang
	order by 1

	/*
	**  If there is only one database and we are in it, show the
	**  segments.
	*/
	if exists (select *
			from #spdbdesc
				where db_id() = dbid)
	begin
		declare @curdevice	varchar(30),
			@curseg		smallint,
			@segbit		int

		delete #spdbdesc

		select @curdevice = min(d.name)
			from  master.dbo.sysusages u, master.dbo.sysdevices d
				where u.dbid = db_id()
					and d.low <= size + vstart
					and d.high >= size + vstart - 1
					and d.status & 2 = 2 
		while (@curdevice != null)
		begin
			/*
			** We need an inner loop here to go through
			**  all the possible segment.
			*/
			select @curseg = min(segment)
					from syssegments
			while (@curseg != null)
			begin
				if (@curseg < 31)
					select @segbit = power(2, @curseg)
				else select @segbit = low
					from master.dbo.spt_values
						where type = "E"
							and number = 2
				insert into #spdbdesc
					select @curseg, @curdevice
						from master.dbo.sysusages u,
							master.dbo.sysdevices d,
							master.dbo.spt_values v
					where u.segmap & @segbit = @segbit
						and d.low <= u.size + u.vstart
						and d.high >= u.size + u.vstart - 1
						and u.dbid = db_id()
						and d.status & 2 = 2 
						and v.number = 1
						and v.type = "E"
						and d.name = @curdevice
				select @curseg = min(segment)
						from syssegments
							where segment > @curseg
			end

			select @curdevice = min(d.name)
				from  master.dbo.sysusages u,
					master.dbo.sysdevices d
				where u.dbid = db_id()
					and d.low <= size + vstart
					and d.high >= size + vstart - 1
					and d.status & 2 = 2 
					and d.name > @curdevice
		end

		/*
		**  One last check for any devices that have no segments.
		*/
		insert into #spdbdesc
			select null, d.name
				from master.dbo.sysusages u,
					master.dbo.sysdevices d
			where u.segmap = 0
				and d.low <= u.size + u.vstart
				and d.high >= u.size + u.vstart - 1
				and u.dbid = db_id()
				and d.status & 2 = 2 

		/* 17592, " -- unused by any segments --" */
		exec sp_getmessage 17592, @msg out


		select distinct @len1 = max(datalength(dbdesc))
			from #spdbdesc, syssegments
				where dbid *= segment

		if (@len1 > 30)
			select distinct device = dbdesc,
				segment = isnull(name, @msg)
			from #spdbdesc, syssegments
				where dbid *= segment
				order by 1, 2
		else
			select distinct device = convert(char(30), dbdesc),
				segment = isnull(name, @msg)
			from #spdbdesc, syssegments
				where dbid *= segment
				order by 1, 2
	end

end

drop table #spdbdesc
return (0)
                                                                    
go

go
if exists (select * from sysobjects 
where name = "sp_helpdevice")
begin
	drop proc sp_helpdevice
end
go

/* Sccsid = "@(#) generic/sproc/helpdevice 52.1 8/12/92" */
/*	4.8	1.1	06/14/90	sproc/src/help */
/*
** Messages for "sp_helpdevice"         17610
**
** 17610, "No such i/o device exists."
** 17611, "special"
** 17612, "disk"
** 17613, "tape"
** 17614, "UNKNOWN DEVICE"
** 17615, "MIRROR ENABLED"
** 17616, "MIRROR DISABLED"
** 17617, "mirror = "
** 17618, "only device '%1!' of mirror is enabled -- device '%2!' is disabled"
** 17619, "channel"
** 17620, "nonserial writes"
*/
create procedure sp_helpdevice
@devname varchar(30) = "%"		/* device to check out */
as

declare @tapeblocksize int

declare @msg varchar(90)
declare @sptlang	int
declare @length		int

select @sptlang = @@langid

if @@langid != 0
begin
	if not exists (
		select * from sysmessages where error
		between 17120 and 17129
		and langid = @@langid)
	    select @sptlang = 0
end

/*
**  See if the device exists.
*/
if not exists (select *
			from master.dbo.sysdevices
				where name like @devname)
begin
	/* 17610, "No such i/o device exists." */
	exec sp_getmessage 17610, @msg out
	print @msg
	return (1)
end

/*
**  Create a temporary table where we can build up a translation of
**  the device status bits.
*/
create table #spdevtab
(
	name varchar(30),
	statusdesc varchar(250) null
)

set nocount on

/*
**  Initialize the temporary table with the names of the devices.
*/
insert into #spdevtab (name)
	select name
		from master.dbo.sysdevices
			where name like @devname


/*
**  Now figure out what kind of controller type it is.  The type are
**  COMPLETELY machine dependent and are for UNIX.
**  cntrltype = 0	special
**	        2	disk
**	      3-8	tape
**	      9-14	channel
*/

/* 17611, "special" */
exec sp_getmessage 17611, @msg out
update #spdevtab
	set statusdesc = @msg
		from master.dbo.sysdevices d, #spdevtab
			where d.cntrltype = 0
				and #spdevtab.name = d.name

/* 17612, "disk" */
exec sp_getmessage 17612, @msg out
update #spdevtab
	set statusdesc = @msg
		from master.dbo.sysdevices d, #spdevtab
			where d.cntrltype = 2
				and #spdevtab.name = d.name

/* 17613, "tape" */
exec sp_getmessage 17613, @msg out
update #spdevtab
	set statusdesc = @msg
		from master.dbo.sysdevices d, #spdevtab
			where d.cntrltype >= 3 and d.cntrltype <= 8
				and #spdevtab.name = d.name
/* 17619, "channel" */
exec sp_getmessage 17619, @msg out
update #spdevtab
	set statusdesc = @msg
		from master.dbo.sysdevices d, #spdevtab
			where d.cntrltype >= 9 and d.cntrltype <= 14
				and #spdevtab.name = d.name

/*
**  If a tape device, also figure out the tape capacity which is listed
**  in sysdevices.high in number of 32k blocks.
*/
if exists (select *
		from master.dbo.sysdevices d, #spdevtab
			where d.cntrltype >= 3 and d.cntrltype <= 8
				and d.high > 0
				and #spdevtab.name = d.name)
begin
        /*
        ** Find size of tape block.  Default to 32k.
        */

        select @tapeblocksize = low
                from master.dbo.spt_values
                        where type = "E"
                                and number = 4
        if @tapeblocksize = NULL
        begin
                select @tapeblocksize = 32768
        end

	update #spdevtab
		set statusdesc = statusdesc + ", " + str(round((d.high *
                                convert(float, @tapeblocksize)) / 1048576., 0))
			+ " MB"
		from master.dbo.sysdevices d, #spdevtab
			where d.cntrltype >= 3 and d.cntrltype <= 8
				and d.high > 0
				and #spdevtab.name = d.name
end

/* 17614, "UNKNOWN DEVICE" */
exec sp_getmessage 17614, @msg out
update #spdevtab
	set statusdesc = @msg
		from master.dbo.sysdevices d, #spdevtab
			where d.cntrltype > 14
				and #spdevtab.name = d.name

/*
**  Now check out the status bits and turn them into english.
**  The mirror status bits are >= 32.
*/
if exists (select *
	from master.dbo.sysdevices d, master.dbo.spt_values v, #spdevtab
		where v.type = "V" and v.number > -1
			and d.status >= 32
			and #spdevtab.name = d.name)
begin
	/*
	**  Check to see if the mirror is enabled. 0x200 (512) bit in status.
	*/
	if exists (select *
		from master.dbo.sysdevices d, #spdevtab
			where d.status & 512 = 512
				and #spdevtab.name = d.name)
	begin
		/* 17615, "MIRROR ENABLED" */
		exec sp_getmessage 17615, @msg out
		update #spdevtab
			set statusdesc = statusdesc + ", " + @msg
		from master.dbo.sysdevices d, #spdevtab
			where d.status & 512 = 512
				and #spdevtab.name = d.name
	end

	if exists (select *
		from master.dbo.sysdevices d, #spdevtab
			where d.status & 512 != 512
				and d.status >= 32
				and #spdevtab.name = d.name)
	begin
		/* 17616, "MIRROR DISABLED" */
		exec sp_getmessage 17616, @msg out
		update #spdevtab
			set statusdesc = statusdesc + ", " + @msg
		from master.dbo.sysdevices d, #spdevtab
			where d.status & 512 != 512
				and d.status >= 32
				and #spdevtab.name = d.name
	end

	/* add mirror name */
	/* 17617, "mirror = " */
	exec sp_getmessage 17617, @msg out
	update #spdevtab
		set statusdesc = statusdesc + ", " + @msg + " '" + d.mirrorname
			+ "'"
		from master.dbo.sysdevices d, #spdevtab
			where #spdevtab.name = d.name
				and d.status >= 32
end

/*
**  Check to see if there is a mirrorname entry but mirroring not enabled.
**  If so, then one side of the mirror is off-line.
*/
else if exists (select *
	from master.dbo.sysdevices d, #spdevtab
		where #spdevtab.name = d.name
		and d.mirrorname != null)
begin
	/* Set up the message */
	declare @part1	varchar(60)
	declare @part2	varchar(60)
	declare @part3	varchar(60)
	/* 17618, "only device '%1!' of mirror is enabled -- device '%2!'
	**	is disabled"
	*/
	exec sp_getmessage 17618, @msg out
	select @part1 = substring(@msg, 1, charindex("%1!", @msg) - 1)
	select @part2 = substring(@msg, charindex("%1!", @msg) + 3, 
		char_length(@msg) - charindex("%2!", @msg) - 3)
	select @part3 = substring(@msg, charindex("%2!", @msg) + 3, 60)

	/*
	**  Figure out which side of the mirror is disabled.
	**  If 0x100 is on then phyname is disabled and mirrorname is enabled.
	*/
	if exists (select *
		from master.dbo.sysdevices d, master.dbo.spt_values v, #spdevtab
			where v.type = "V" and v.number > -1
				and d.status & v.number = 256
				and #spdevtab.name = d.name)
	begin
		update #spdevtab
			set statusdesc = @part1 + d.mirrorname 
				+ @part2 + d.phyname + @part3
			from master.dbo.sysdevices d, master.dbo.spt_values v,
				#spdevtab
			where v.type = "V" and v.number > -1
				and d.status & v.number = 256
				and #spdevtab.name = d.name
	end
	else if exists (select *
		from master.dbo.sysdevices d, master.dbo.spt_values v, #spdevtab
			where v.type = "V" and v.number > -1
				and d.status & v.number = 64
				and #spdevtab.name = d.name)
	begin
		update #spdevtab
			set statusdesc = @part1 + d.phyname 
				+ @part2 + d.mirrorname + @part3
			from master.dbo.sysdevices d, master.dbo.sysdevices e,
				master.dbo.spt_values v, #spdevtab
			where v.type = "V" and v.number > -1
				and d.status & v.number = 64
				and #spdevtab.name = d.name
				and e.status & 256 != 256
				and #spdevtab.name = e.name
	end
end


/*
**  Status of 0x20 is "serial writes" for mirrored disks.
*/
if exists (select *
	from master.dbo.sysdevices d, master.dbo.spt_values v, #spdevtab
		where v.type = "V" and v.number > -1
			and d.status & v.number = 32
			and #spdevtab.name = d.name)
begin
	update #spdevtab
		set statusdesc = statusdesc + ", " + m.description
		from master.dbo.sysdevices d, master.dbo.spt_values v, #spdevtab,
				master.dbo.sysmessages m
			where v.type = "V" and v.number > -1
				and d.status & v.number = 32
				and #spdevtab.name = d.name
				and v.msgnum = m.error
				and isnull(m.langid, 0) = @sptlang
end

/* 17620, "nonserial writes" */
exec sp_getmessage 17620, @msg out
update #spdevtab
	set statusdesc = @msg
		from master.dbo.sysdevices d, #spdevtab
			where d.status > 32
				and d.status &32 != 32
				and #spdevtab.name = d.name

/*
**  Status of 0x80 is "reads mirrored" for mirrored disks.
*/
if exists (select *
	from master.dbo.sysdevices d, master.dbo.spt_values v, #spdevtab
		where v.type = "V" and v.number > -1
			and d.status & v.number = 128
			and #spdevtab.name = d.name)
begin
	update #spdevtab
		set statusdesc = statusdesc + ", " + m.description
		from master.dbo.sysdevices d, master.dbo.spt_values v, #spdevtab,
				master.dbo.sysmessages m
			where v.type = "V" and v.number > -1
				and d.status & v.number = 128
				and #spdevtab.name = d.name
				and v.msgnum = m.error
				and isnull(m.langid, 0) = @sptlang
end

/*
**  Now check out the status bits and turn them into english.
**  Status of 0x10 is a dump device.
*/
if exists (select *
	from master.dbo.sysdevices d, master.dbo.spt_values v, #spdevtab
		where v.type = "V" and v.number > -1
			and d.status & v.number = 16
			and #spdevtab.name = d.name)
begin
	update #spdevtab
		set statusdesc = statusdesc + ", " + m.description
		from master.dbo.sysdevices d, master.dbo.spt_values v, #spdevtab,
				master.dbo.sysmessages m
			where v.type = "V" and v.number > -1
				and d.status & v.number = 16
				and #spdevtab.name = d.name
				and v.msgnum = m.error
				and isnull(m.langid, 0) = @sptlang
end

/*
**  Now check out the status bits and turn them into english.
**  Status of 0x01 is a default disk.
*/
if exists (select *
	from master.dbo.sysdevices d, master.dbo.spt_values v, #spdevtab
		where v.type = "V" and v.number > -1
			and d.status & v.number = 1
			and #spdevtab.name = d.name)
begin
	update #spdevtab
		set statusdesc = statusdesc + ", " + m.description
		from master.dbo.sysdevices d, master.dbo.spt_values v, #spdevtab,
				master.dbo.sysmessages m
			where v.type = "V" and v.number > -1
				and d.status & v.number = 1
				and #spdevtab.name = d.name
				and v.msgnum = m.error
				and isnull(m.langid, 0) = @sptlang
end

/*
**  Now check out the status bits and turn them into english.
**  Status of 0x02 is a physical disk.
*/
if exists (select *
	from master.dbo.sysdevices d, master.dbo.spt_values v, #spdevtab
		where v.type = "V" and v.number > -1
			and d.status & v.number = 2
			and #spdevtab.name = d.name)
begin
	update #spdevtab
		set statusdesc = convert(char(225), statusdesc) + ", " + m.description
		from master.dbo.sysdevices d, master.dbo.spt_values v, #spdevtab,
				master.dbo.sysmessages m
			where v.type = "V" and v.number > -1
				and d.status & v.number = 2
				and #spdevtab.name = d.name
				and v.msgnum = m.error
				and isnull(m.langid, 0) = @sptlang

	/*
	** Compute number of Pages in a Megabyte.
	*/
	declare @numpgsmb float		/* Number of Pages per Megabytes */

	select @numpgsmb = (1048576. / v.low)
		from master.dbo.spt_values v
			where v.number = 1
				and v.type = "E"

	/*
	**  Add in its size in MB.
	*/
	update #spdevtab
		set statusdesc = statusdesc + ", " +
			ltrim(str((1. + (d.high - d.low)) / @numpgsmb, 10, 2)) + " MB"
		from master.dbo.sysdevices d, #spdevtab
			where d.status & 2 = 2
				and #spdevtab.name = d.name
end

/*
**  Now check out the status bits and turn them into english.
**  Status of 0x04 is a logical disk.
*/
if exists (select *
	from master.dbo.sysdevices d, master.dbo.spt_values v, #spdevtab
		where v.type = "V" and v.number > -1
			and d.status & v.number = 4
			and #spdevtab.name = d.name)
begin
	update #spdevtab
		set statusdesc = convert(char(225), statusdesc) + 
			", " + m.description
		from master.dbo.sysdevices d, master.dbo.spt_values v, 
				#spdevtab, master.dbo.sysmessages m
			where v.type = "V" and v.number > -1
				and d.status & v.number = 4
				and #spdevtab.name = d.name
				and v.msgnum = m.error
				and isnull(m.langid, 0) = @sptlang
end

/*
**  Now check out the status bits and turn them into english.
**  Status of 0x08 is a skip tape header.
*/
if exists (select *
	from master.dbo.sysdevices d, master.dbo.spt_values v, #spdevtab
		where v.type = "V" and v.number > -1
			and d.status & v.number = 8
			and #spdevtab.name = d.name)
begin
	update #spdevtab
		set statusdesc = convert(char(225), statusdesc) + 
			", " + m.description
		from master.dbo.sysdevices d, master.dbo.spt_values v, 
				#spdevtab, master.dbo.sysmessages m
			where v.type = "V" and v.number > -1
				and d.status & v.number = 8
				and #spdevtab.name = d.name
				and v.msgnum = m.error
				and isnull(m.langid, 0) = @sptlang
end

set nocount off

/*
**  The device number is in the high byte of sysdevices.low so
**  spt_values tells us which byte to pick out.
*/

select @length = max(datalength(d.phyname))
	from master.dbo.sysdevices d, #spdevtab
	where d.name = #spdevtab.name

if (@length > 46)
    select device_name = d.name,
	physical_name = d.phyname,
	description = #spdevtab.statusdesc,
	d.status, d.cntrltype,
	device_number = convert(tinyint, substring(convert(binary(4), d.low),
		v.low, 1)),
	d.low, d.high
		from master.dbo.sysdevices d, #spdevtab,
		     master.dbo.spt_values v
		where d.name = #spdevtab.name
		     and v.type = "E" and v.number = 3
else
    select device_name = d.name,
	physical_name = convert(char(46), d.phyname),
	description = #spdevtab.statusdesc,
	d.status, d.cntrltype,
	device_number = convert(tinyint, substring(convert(binary(4), d.low),
		v.low, 1)),
	d.low, d.high
		from master.dbo.sysdevices d, #spdevtab,
		     master.dbo.spt_values v
		where d.name = #spdevtab.name
		     and v.type = "E" and v.number = 3

return (0)
                                                                                                                                                                                                                 
go

go
if exists (select * from sysobjects 
where name = "sp_helpgroup")
begin
	drop proc sp_helpgroup
end
go

/* Sccsid = "@(#) generic/sproc/helpgroup 52.1 8/12/92" */
/*	4.8	1.1	06/14/90	sproc/src/help */
/*
** Messages for "sp_helpgroup"          17630
**
** 17333, "No group with the specified name exists."
*/
create procedure sp_helpgroup
@grpname varchar(30) = NULL		/* group name of interest */
as

declare @msg varchar(90)
declare @len1 int, @len2 int

/*
**  If no group name given, list all the groups.
**  User ids are <= 16383 and group ids are > 16383 or = 0.
*/
if @grpname = NULL
begin
	select Group_name = name, Group_id = gid
		from sysusers
			where (uid > 16383 or uid = 0)
		order by name

	return (0)
end

/*
**  Check to see if group exists.
*/
if not exists (select *
			from sysusers
		where name = @grpname
			and (uid > 16383 or uid = 0))
begin
	/* 17333, "No group with the specified name exists." */
	exec sp_getmessage 17333, @msg out
	print @msg
	return (1)
end

/*
**  List the particulars for the group.
*/
select @len1 = max(datalength(g.name)),
       @len2 = max(datalength(u.name))
		from sysusers u, sysusers g
			where g.name like @grpname
			and g.uid = u.gid
			and (g.uid > 16383 or g.uid = 0)
			and u.uid != u.gid

if (@len1 > 25 or @len2 > 25)
    select Group_name = g.name, Group_id = g.gid,
	Users_in_group = u.name, Userid = u.uid
		from sysusers u, sysusers g
			where g.name like @grpname
			and g.uid = u.gid
			and (g.uid > 16383 or g.uid = 0)
			and u.uid != u.gid
		order by g.name, u.name
else
    select Group_name = convert(char(25), g.name), Group_id = g.gid,
	Users_in_group = convert(char(25), u.name), Userid = u.uid
		from sysusers u, sysusers g
			where g.name like @grpname
			and g.uid = u.gid
			and (g.uid > 16383 or g.uid = 0)
			and u.uid != u.gid
		order by g.name, u.name

return (0)
                                      
go

go
if exists (select * from sysobjects 
where name = "sp_helplog")
begin
	drop proc sp_helplog
end
go

/* Sccsid = "@(#) generic/sproc/src/helplog 52.1 8/12/92" */
/*	4.8	1.1	06/14/90	sproc/src/fixindex */
/*
** Messages for "sp_helplog"            17672
**
** 17672, "In database '%1!', the log starts on device '%2!'."
*/
create procedure sp_helplog
as
declare @firstpage int,
	@devname varchar(255),
	@msg varchar(255),
	@dbname varchar(255)


/* Get the first page of the log from sysindexes */
select @firstpage = first
	from sysindexes
		where id = 8

/*
**  Get the name of the device which contains the first page of the log.
**  The device number is in the high byte of d.low and u.vstart and which is the
**  high byte is defined in spt_values.
*/
select @devname = d.name 
	from master.dbo.sysdevices d, master.dbo.sysusages u,
		master.dbo.spt_values v
	where (d.status & 2 = 2 or d.status & 4 = 4) 
		and @firstpage >= u.lstart
		and @firstpage < u.lstart + u.size - 1
		and convert(tinyint, substring(convert(binary(4), d.low),
			v.low, 1))
		  = convert(tinyint, substring(convert(binary(4), u.vstart),
		       v.low, 1))
		and v.type = "E"
		and v.number = 3

/* Print out the name of the device which contains the first page of the log */
/* 17672, "In database '%1!', the log starts on device '%2!'." */
select @dbname = db_name()
exec sp_getmessage 17672, @msg out
print @msg, @dbname, @devname

return (0)
                                                                                                                                                                                                            
go

go
if exists (select * from sysobjects 
where name = "sp_helpindex")
begin
	drop proc sp_helpindex
end
go

/* Sccsid = "@(#) generic/sproc/helpindex 52.1 8/12/92" */
/*	4.8	1.1	06/14/90	sproc/src/help */
/*
** Messages for "sp_helpindex"          17640
**
** 17460, "Object must be in the current database."
** 17461, "Object does not exist in this database."
** 17640, "Object does not have any indexes."
*/

/*
** IMPORTANT NOTE:
** This stored procedure uses the built-in function object_id() in the
** where clause of a select query. If you intend to change this query
** or use the object_id() or db_id() builtin in this procedure, please read the
** READ.ME file in the $DBMS/generic/sproc directory to ensure that the rules
** pertaining to object-id's and db-id's outlined there, are followed.
*/

create procedure sp_helpindex
@objname varchar(92)			/* the table to check for indexes */
as

declare @indid int			/* the index id of an index */
declare @keys varchar(200)		/* string to build up index key in */
declare @inddesc varchar(68)		/* string to build up index desc in */
declare @msg varchar(90)
declare @len1 int, @len2 int


/*
**  Check to see that the object names are local to the current database.
*/
if @objname like "%.%.%" and
	substring(@objname, 1, charindex(".", @objname) - 1) != db_name()
begin
	/* 17460, "Object must be in the current database." */
	exec sp_getmessage 17460, @msg out
	print @msg
	return (1)
end

/*
**  Check to see the the table exists 
*/
if not exists (select id
		from sysobjects
			where id = object_id(@objname))
/*
**  Table doesn't exist so return.
*/
begin
	/* 17461, "Object does not exist in this database." */
	exec sp_getmessage 17461, @msg out
	print @msg
	return (1)
end

/*
**  See if the object has any indexes.
**  Since there may be more than one entry in sysindexes for the object,
**  this select will set @indid to the index id of the first index.
*/
select @indid = min(indid)
	from sysindexes
		where id = object_id(@objname)
			and indid > 0
			and indid < 255

/*
**  If no indexes, return.
*/
if @indid is NULL
begin
	/* 17640, "Object does not have any indexes." */
	exec sp_getmessage 17640, @msg out
	print @msg
	return (1)
end

/*
**  Now check out each index, figure out it's type and keys and
**  save the info in a temporary table that we'll print out at the end.
*/
create table #spindtab
(
	index_name	varchar(30),
	index_keys	varchar(255),
	index_description	varchar(68)
)

while @indid != NULL
begin
	
	/*
	**  First we'll figure out what the keys are.
	*/
	declare @i int
	declare @thiskey varchar(30)
	declare @lastindid int

	select @keys = "", @i = 1

	set nocount on

	while @i <= 16
	begin
		select @thiskey = index_col(@objname, @indid, @i)

		if @thiskey = NULL
		begin
			goto keysdone
		end

		if @i > 1
		begin
			select @keys = @keys + ", "
		end

		select @keys = @keys + index_col(@objname, @indid, @i)

		/*
		**  Increment @i so it will check for the next key.
		*/
		select @i = @i + 1

	end


	/*
	**  When we get here we now have all the keys.
	*/
	keysdone:
		set nocount off

	/*
	**  Initialize the index description by figuring out if it's a
	**  clustered or nonclustered index.
	*/
	if @indid = 1
	begin
		select @inddesc = "clustered"
	end
	if @indid > 1
	begin
		select @inddesc = "nonclustered"
	end

	/*
	**  Now we'll check out the status bits for this index and
	**  build an english description from them.
	*/

	/*
	**  See if the index is unique (0x02).
	*/
	if exists (select *
		from master.dbo.spt_values v, sysindexes i
			where i.status & v.number = v.number
				and v.type = "I"
				and v.number = 2
				and i.id = object_id(@objname)
				and i.indid = @indid)
	begin
	select @inddesc = @inddesc + ", " + v.name
		from master.dbo.spt_values v, sysindexes i
			where i.status & v.number = v.number
				and v.type = "I"
				and v.number = 2
				and i.id = object_id(@objname)
				and i.indid = @indid
	end

	/*
	**  See if the index is ignore_dupkey (0x01).
	*/
	if exists (select *
		from master.dbo.spt_values v, sysindexes i
			where i.status & v.number = v.number
				and v.type = "I"
				and v.number = 1
				and i.id = object_id(@objname)
				and i.indid = @indid)
	begin
	select @inddesc = @inddesc + ", " + v.name
		from master.dbo.spt_values v, sysindexes i
			where i.status & v.number = v.number
				and v.type = "I"
				and v.number = 1
				and i.id = object_id(@objname)
				and i.indid = @indid
	end

	/*
	**  See if the index is ignore_dup_row (0x04).
	*/
	if exists (select *
		from master.dbo.spt_values v, sysindexes i
			where i.status & v.number = v.number
				and v.type = "I"
				and v.number = 4
				and i.id = object_id(@objname)
				and i.indid = @indid)
	begin
	select @inddesc = @inddesc + ", " + v.name
		from master.dbo.spt_values v, sysindexes i
			where i.status & v.number = v.number
				and v.type = "I"
				and v.number = 4
				and i.id = object_id(@objname)
				and i.indid = @indid
	end

	/*
	**  See if the index is allow_dup_row (0x40).
	*/
	if exists (select *
		from master.dbo.spt_values v, sysindexes i
			where i.status & v.number = v.number
				and v.type = "I"
				and v.number = 64
				and i.id = object_id(@objname)
				and i.indid = @indid)
	begin
	select @inddesc = @inddesc + ", " + v.name   
		from master.dbo.spt_values v, sysindexes i
			where i.status & v.number = v.number
				and v.type = "I"
				and v.number = 64
				and i.id = object_id(@objname)
				and i.indid = @indid
	end

	/*
	**  Add the location of the data.
	*/
	select @inddesc = @inddesc + " located on " + s.name
		from syssegments s, sysindexes i
			where s.segment = i.segment
				and i.id = object_id(@objname)
				and i.indid = @indid

	/*
	**  Now we have the whole description for the index so we'll add
	**  the goods to the temporary table.
	*/
	insert into #spindtab
		select name, @keys, @inddesc
			from sysindexes
				where id = object_id(@objname)
					and indid = @indid
	/*
	**  Now move @indid to the next index.
	*/
	select @lastindid = @indid
	select @indid = NULL
	select @indid = min(indid)
		from sysindexes
			where id = object_id(@objname)
				and indid > @lastindid
				and indid < 255
end

/*
**  Now print out the contents of the temporary index table.
*/
select @len1 = max(datalength(index_name)),
       @len2 = max(datalength(index_description))
	from #spindtab

if (@len1 > 20 or @len2 > 56)
    select index_name = index_name,
	index_description = index_description,
	index_keys = index_keys from #spindtab
else
    select index_name = convert(char(20), index_name),
	index_description = convert(char(56), index_description),
	index_keys = index_keys from #spindtab

drop table #spindtab

return (0)
                                                          
go

dump tran master with truncate_only

go

go
if exists (select * from sysobjects 
where name = "sp_helpjoins")
begin
	drop proc sp_helpjoins
end
go

/* Sccsid = "@(#) generic/sproc/src/helpjoins 52.1 8/12/92" */
/*	4.8	1.1	06/14/90	sproc/src/help */
/*
** Messages for "sp_helpjoins"          17650
**
** 17460, "Object must be in the current database."
** 17650, "First table doesn't exist."
** 17651, "Second table doesn't exist."
*/

/*
** IMPORTANT NOTE:
** This stored procedure uses the built-in function object_id() in the
** where clause of a select query. If you intend to change this query
** or use the object_id() or db_id() builtin in this procedure, please read the
** READ.ME file in the $DBMS/generic/sproc directory to ensure that the rules
** pertaining to object-id's and db-id's outlined there, are followed.
*/

create procedure sp_helpjoins
@lefttab varchar(92),			/* name of first table to join */
@righttab varchar(92)			/* name of first table to join */
as

declare @foundit bit			/* flag to indicate joins found */
declare @msg varchar(90)

/*
**  This procedure returns any foreign or common joins.
**  If none exists, then it returns any joins that have the same usertype.
**  If none exists, it returns any joins that have the same physical type.
*/

/*
**  Make sure the @objname is local to the current database.
*/
if @lefttab like "%.%.%" and
	substring(@lefttab, 1, charindex(".", @lefttab) - 1) != db_name()
begin
	/* 17460, "Object must be in the current database." */
	exec sp_getmessage 17460, @msg out
	print @msg
	return (1)
end
if @righttab like "%.%.%" and
	substring(@righttab, 1, charindex(".", @righttab) - 1) != db_name()
begin
	print "Object must be in your current database."
	return (1)
end

/*
**  See if we can find the objects.  They must be a system table, user table,
**  or view.  The low 3 bits of sysobjects.sysstat indicate what the 
**  object type is -- it's more reliable than using sysobjects.type which
**  could change.
*/
/*
**  If either of the tables don't exist, quit.
*/
if not exists (select id
	from sysobjects
		where id = object_id(@lefttab)
			and (sysstat & 7 = 1		/* system table */
				or sysstat & 7 = 2	/* view */
				or sysstat & 7 = 3))	/* user table */
begin
	/* 17650, "First table doesn't exist." */
	exec sp_getmessage 17650, @msg out
	print @msg
	return (1)
end 

if not exists (select id
	from sysobjects
		where id = object_id(@righttab)
			and (sysstat & 7 = 1		/* system table */
				or sysstat & 7 = 2	/* view */
				or sysstat & 7 = 3))	/* user table */

begin
	/* 17651, "Second table doesn't exist." */
	exec sp_getmessage 17651, @msg out
	print @msg
	return (1)
end 

create table #hjtab
(
	a1	varchar(30),
	a2	varchar(30),
	b1	varchar(30) null,
	b2	varchar(30) null,
	c1	varchar(30) null,
	c2	varchar(30) null,
	d1	varchar(30) null,
	d2	varchar(30) null,
	e1	varchar(30) null,
	e2	varchar(30) null,
	f1	varchar(30) null,
	f2	varchar(30) null,
	g1	varchar(30) null,
	g2	varchar(30) null,
	h1	varchar(30) null,
	h2	varchar(30) null
)

/*
**  Look for foreign key joins.
*/
select @foundit = 0
if exists (select *
		from syskeys
			where type = 2
				and id = object_id(@lefttab)
				and depid = object_id(@righttab))
begin
	insert into #hjtab
	select distinct first_pair = col_name(id, key1), col_name(depid, depkey1),
		second_pair = col_name(id, key2), col_name(depid, depkey2),
		third_pair = col_name(id, key3), col_name(depid, depkey3),
		fourth_pair = col_name(id, key4), col_name(depid, depkey4),
		fifth_pair = col_name(id, key5), col_name(depid, depkey5),
		sixth_pair = col_name(id, key6), col_name(depid, depkey6),
		seventh_pair = col_name(id, key7), col_name(depid, depkey7),
		eighth_pair = col_name(id, key8), col_name(depid, depkey8)
	from syskeys
		where type = 2
			and id = object_id(@lefttab)
			and depid = object_id(@righttab)

	select @foundit = 1
end

if exists (select *
		from syskeys
			where type = 2
				and id = object_id(@righttab)
				and depid = object_id(@lefttab))
begin
	insert into #hjtab
	select distinct first_pair = col_name(depid, depkey1), col_name(id, key1),
		second_pair = col_name(depid, depkey2), col_name(id, key2),
		third_pair = col_name(depid, depkey3), col_name(id, key3),
		fourth_pair = col_name(depid, depkey4), col_name(id, key4),
		fifth_pair = col_name(depid, depkey5), col_name(id, key5),
		sixth_pair = col_name(depid, depkey6), col_name(id, key6),
		seventh_pair = col_name(depid, depkey7), col_name(id, key7),
		eighth_pair = col_name(depid, depkey8), col_name(id, key8)
	from syskeys
		where type = 2
			and id = object_id(@righttab)
			and depid = object_id(@lefttab)

	select @foundit = 1
end

/*
**  Look for common key joins.
*/
if exists (select *
		from syskeys
			where type = 3
				and id = object_id(@lefttab)
				and depid = object_id(@righttab))
begin
	insert into #hjtab
	select distinct first_pair = col_name(id, key1), col_name(depid, depkey1),
		second_pair = col_name(id, key2), col_name(depid, depkey2),
		third_pair = col_name(id, key3), col_name(depid, depkey3),
		fourth_pair = col_name(id, key4), col_name(depid, depkey4),
		fifth_pair = col_name(id, key5), col_name(depid, depkey5),
		sixth_pair = col_name(id, key6), col_name(depid, depkey6),
		seventh_pair = col_name(id, key7), col_name(depid, depkey7),
		eighth_pair = col_name(id, key8), col_name(depid, depkey8)
	from syskeys
		where type = 3
			and id = object_id(@lefttab)
			and depid = object_id(@righttab)

	select @foundit = 1
end

if exists (select *
		from syskeys
			where type = 3
				and id = object_id(@righttab)
				and depid = object_id(@lefttab))
begin
	insert into #hjtab
	select distinct first_pair = col_name(depid, depkey1), col_name(id, key1),
		second_pair = col_name(depid, depkey2), col_name(id, key2),
		third_pair = col_name(depid, depkey3), col_name(id, key3),
		fourth_pair = col_name(depid, depkey4), col_name(id, key4),
		fifth_pair = col_name(depid, depkey5), col_name(id, key5),
		sixth_pair = col_name(depid, depkey6), col_name(id, key6),
		seventh_pair = col_name(depid, depkey7), col_name(id, key7),
		eighth_pair = col_name(depid, depkey8), col_name(id, key8)
	from syskeys
		where type = 3
			and id = object_id(@righttab)
			and depid = object_id(@lefttab)

	select @foundit = 1
end

/*
**  We got a foreignkey and we didn't get a common key.
*/
if @foundit = 1
begin
	select distinct *
		from #hjtab

	drop table #hjtab

	return (0)
end

/*
**  We didn't find any defined joins so we'll look for common user types.
*/
if exists (select *
		from syscolumns a, syscolumns b
			where a.id = object_id(@lefttab)
				and b.id = object_id(@righttab)
				and a.usertype = b.usertype
				and a.usertype > 99)
begin
	select distinct first_pair = col_name(a.id, a.colid),
		col_name(b.id, b.colid)
	from syscolumns a, syscolumns b
		where a.id = object_id(@lefttab)
			and b.id = object_id(@righttab)
			and a.usertype = b.usertype
			and a.usertype > 99
	order by first_pair

	/*
	**  If we found something, we can stop.
	*/
	if @@rowcount > 0
		return (0)
end

/*
**  We couldn't find anything so far so we'll see if we have anything
**  that just shares the same physical type.
*/
if exists (select *
		from syscolumns a, syscolumns b, master.dbo.spt_values y,
			master.dbo.spt_values z
		where a.id = object_id(@lefttab)
			and b.id = object_id(@righttab)
			and a.id != b.id
			and a.name = b.name
			and y.type = "J"
			and a.type = y.low
			and z.type = "J"
			and b.type = z.low
			and y.number = z.number)
begin
	select distinct first_pair = col_name(a.id, a.colid),
		col_name(b.id, b.colid)
	from syscolumns a, syscolumns b, master.dbo.spt_values y,
		master.dbo.spt_values z
	where a.id = object_id(@lefttab)
		and b.id = object_id(@righttab)
		and a.id != b.id
		and a.name = b.name
		and y.type = "J"
		and a.type = y.low
		and z.type = "J"
		and b.type = z.low
		and y.number = z.number
	order by first_pair

end

return (0)
                                                                                                                                                     
go

go
if exists (select * from sysobjects 
where name = "sp_helpkey")
begin
	drop proc sp_helpkey
end
go

/* Sccsid = "@(#) generic/sproc/helpkey 52.1 8/12/92" */
/*	4.8	1.1	06/14/90	sproc/src/help */
/*
** Messages for "sp_helpkey"            17660
**
** 17390, "Table or view name must be in 'current' database."
** 17492, "The table or view named doesn't exist in the current database."
** 17660, "No defined keys for this object."
** 17661, " -- none --"
*/

/*
** IMPORTANT NOTE:
** This stored procedure uses the built-in function object_id() in the
** where clause of a select query. If you intend to change this query
** or use the object_id() or db_id() builtin in this procedure, please read the
** READ.ME file in the $DBMS/generic/sproc directory to ensure that the rules
** pertaining to object-id's and db-id's outlined there, are followed.
*/

create procedure sp_helpkey
@tabname varchar(92) = null	/* table or view we want to check */
as

declare @msg	varchar(90)
declare @none	varchar(30)
declare @len1 int, @len2 int

/*
**  Check to see that the object names are local to the current database.
*/
if @tabname like "%.%.%" and
	substring(@tabname, 1, charindex(".", @tabname) - 1) != db_name()
begin
	/* 17390, "Table or view name must be in 'current' database." */
	exec sp_getmessage 17390, @msg out
	print @msg
	return (1)
end

exec sp_getmessage 17661, @none out

/*
**  If @tabname is null, show all the keys.
*/
if @tabname = null
begin
    select @len1 = max(datalength(col_name(k.id, key1) + ", "
			+ isnull(col_name(k.id, key2), "*") + ", "
			+ isnull(col_name(k.id, key3), "*") + ", "
			+ isnull(col_name(k.id, key4), "*") + ", "
			+ isnull(col_name(k.id, key5), "*") + ", "
			+ isnull(col_name(k.id, key6), "*") + ", "
			+ isnull(col_name(k.id, key7), "*") + ", "
			+ isnull(col_name(k.id, key8), "*"))),
	   @len2 = max(datalength(
			  isnull(col_name(k.depid, depkey1), "*") + ", "
			+ isnull(col_name(k.depid, depkey2), "*") + ", "
			+ isnull(col_name(k.depid, depkey3), "*") + ", "
			+ isnull(col_name(k.depid, depkey4), "*") + ", "
			+ isnull(col_name(k.depid, depkey5), "*") + ", "
			+ isnull(col_name(k.depid, depkey6), "*") + ", "
			+ isnull(col_name(k.depid, depkey7), "*") + ", "
			+ isnull(col_name(k.depid, depkey8), "*")))
		from syskeys k

    if (@len1 > 70 or @len2 > 70)
	select keytype = convert(char(10), v.name), object = object_name(k.id),
		related_object = isnull(object_name(k.depid), @none),
		object_keys = 	 col_name(k.id, key1) + ", "
			+ isnull(col_name(k.id, key2), "*") + ", "
			+ isnull(col_name(k.id, key3), "*") + ", "
			+ isnull(col_name(k.id, key4), "*") + ", "
			+ isnull(col_name(k.id, key5), "*") + ", "
			+ isnull(col_name(k.id, key6), "*") + ", "
			+ isnull(col_name(k.id, key7), "*") + ", "
			+ isnull(col_name(k.id, key8), "*"),
		related_keys = 
			  isnull(col_name(k.depid, depkey1), "*") + ", "
			+ isnull(col_name(k.depid, depkey2), "*") + ", "
			+ isnull(col_name(k.depid, depkey3), "*") + ", "
			+ isnull(col_name(k.depid, depkey4), "*") + ", "
			+ isnull(col_name(k.depid, depkey5), "*") + ", "
			+ isnull(col_name(k.depid, depkey6), "*") + ", "
			+ isnull(col_name(k.depid, depkey7), "*") + ", "
			+ isnull(col_name(k.depid, depkey8), "*")
	from syskeys k, master.dbo.spt_values v
		where k.type = v.number and v.type = 'K'
	order by object, keytype, related_object
    else
	select keytype = convert(char(10), v.name), object = object_name(k.id),
		related_object = isnull(object_name(k.depid), @none),
		object_keys = convert(char(70), 
				 col_name(k.id, key1) + ", "
			+ isnull(col_name(k.id, key2), "*") + ", "
			+ isnull(col_name(k.id, key3), "*") + ", "
			+ isnull(col_name(k.id, key4), "*") + ", "
			+ isnull(col_name(k.id, key5), "*") + ", "
			+ isnull(col_name(k.id, key6), "*") + ", "
			+ isnull(col_name(k.id, key7), "*") + ", "
			+ isnull(col_name(k.id, key8), "*")),
		related_keys = convert(char(70), 
			  isnull(col_name(k.depid, depkey1), "*") + ", "
			+ isnull(col_name(k.depid, depkey2), "*") + ", "
			+ isnull(col_name(k.depid, depkey3), "*") + ", "
			+ isnull(col_name(k.depid, depkey4), "*") + ", "
			+ isnull(col_name(k.depid, depkey5), "*") + ", "
			+ isnull(col_name(k.depid, depkey6), "*") + ", "
			+ isnull(col_name(k.depid, depkey7), "*") + ", "
			+ isnull(col_name(k.depid, depkey8), "*"))
	from syskeys k, master.dbo.spt_values v
		where k.type = v.number and v.type = 'K'
	order by object, keytype, related_object

	return (0)
end

/*
**  We're looking for a particular table or view.
*/
else
begin
	/*
	**  Make sure the table or view exists.
	*/
	if not exists (select id
			from sysobjects
				where id = object_id(@tabname))
	begin
		/* 17492, "The table or view named doesn't exist in the current database." */
		exec sp_getmessage 17492, @msg out
		print @msg
		return (1)
	end

	/*
	**  See if any keys exist.
	*/
	if not exists (select *
			from syskeys
			where id = object_id(@tabname) or 
				depid = object_id(@tabname))
	begin
		/* 17660, "No defined keys for this object." */
		exec sp_getmessage 17660, @msg out
		print @msg
		return (1)
	end

	select @len1 = max(datalength(col_name(k.id, key1) + ", "
			+ isnull(col_name(k.id, key2), "*") + ", "
			+ isnull(col_name(k.id, key3), "*") + ", "
			+ isnull(col_name(k.id, key4), "*") + ", "
			+ isnull(col_name(k.id, key5), "*") + ", "
			+ isnull(col_name(k.id, key6), "*") + ", "
			+ isnull(col_name(k.id, key7), "*") + ", "
			+ isnull(col_name(k.id, key8), "*"))),
	       @len2 = max(datalength(
			  isnull(col_name(k.depid, depkey1), "*") + ", "
			+ isnull(col_name(k.depid, depkey2), "*") + ", "
			+ isnull(col_name(k.depid, depkey3), "*") + ", "
			+ isnull(col_name(k.depid, depkey4), "*") + ", "
			+ isnull(col_name(k.depid, depkey5), "*") + ", "
			+ isnull(col_name(k.depid, depkey6), "*") + ", "
			+ isnull(col_name(k.depid, depkey7), "*") + ", "
			+ isnull(col_name(k.depid, depkey8), "*")))
		from syskeys k
		    where k.id = object_id(@tabname) or 
			  k.depid = object_id(@tabname)

	if (@len1 > 70 or @len2 > 70)
	    select keytype = convert(char(10), v.name),
		object = object_name(k.id),
		related_object = isnull(object_name(k.depid), @none),
		object_keys = 	 col_name(k.id, key1) + ", "
			+ isnull(col_name(k.id, key2), "*") + ", "
			+ isnull(col_name(k.id, key3), "*") + ", "
			+ isnull(col_name(k.id, key4), "*") + ", "
			+ isnull(col_name(k.id, key5), "*") + ", "
			+ isnull(col_name(k.id, key6), "*") + ", "
			+ isnull(col_name(k.id, key7), "*") + ", "
			+ isnull(col_name(k.id, key8), "*"),
		related_keys =
			  isnull(col_name(k.depid, depkey1), "*") + ", "
			+ isnull(col_name(k.depid, depkey2), "*") + ", "
			+ isnull(col_name(k.depid, depkey3), "*") + ", "
			+ isnull(col_name(k.depid, depkey4), "*") + ", "
			+ isnull(col_name(k.depid, depkey5), "*") + ", "
			+ isnull(col_name(k.depid, depkey6), "*") + ", "
			+ isnull(col_name(k.depid, depkey7), "*") + ", "
			+ isnull(col_name(k.depid, depkey8), "*")
	    from syskeys k, master.dbo.spt_values v
		where k.type = v.number and v.type = 'K'
			and (k.id = object_id(@tabname) or 
			     k.depid = object_id(@tabname))
		order by object, keytype, related_object
	else
	    select keytype = convert(char(10), v.name),
		object = object_name(k.id),
		related_object = isnull(object_name(k.depid), @none),
		object_keys = convert(char(70),
				 col_name(k.id, key1) + ", "
			+ isnull(col_name(k.id, key2), "*") + ", "
			+ isnull(col_name(k.id, key3), "*") + ", "
			+ isnull(col_name(k.id, key4), "*") + ", "
			+ isnull(col_name(k.id, key5), "*") + ", "
			+ isnull(col_name(k.id, key6), "*") + ", "
			+ isnull(col_name(k.id, key7), "*") + ", "
			+ isnull(col_name(k.id, key8), "*")),
		related_keys = convert(char(70),
			  isnull(col_name(k.depid, depkey1), "*") + ", "
			+ isnull(col_name(k.depid, depkey2), "*") + ", "
			+ isnull(col_name(k.depid, depkey3), "*") + ", "
			+ isnull(col_name(k.depid, depkey4), "*") + ", "
			+ isnull(col_name(k.depid, depkey5), "*") + ", "
			+ isnull(col_name(k.depid, depkey6), "*") + ", "
			+ isnull(col_name(k.depid, depkey7), "*") + ", "
			+ isnull(col_name(k.depid, depkey8), "*"))
	    from syskeys k, master.dbo.spt_values v
		where k.type = v.number and v.type = 'K'
			and (k.id = object_id(@tabname) or 
			     k.depid = object_id(@tabname))
		order by object, keytype, related_object

	return (0)
end
                                                                                                                                
go

go
if exists (select * from sysobjects 
where name = "sp_objectsegment")
begin
	drop proc sp_objectsegment
end
go

/* Sccsid = "@(#) generic/sproc/src/objectsegment 52.1 8/12/92" */
/*	4.8	1.1	06/14/90	sproc/src/lock */

/*
** Messages for "sp_objectsegment"      17714
**
** LOCALIZE the following:
**
**      select Data_located_on_segment = s.name, When_created = crdate
**
** Data_located_on_segment
** When_created
**
** 17714, "not applicable" 
*/

/*
** IMPORTANT NOTE:
** This stored procedure uses the built-in function object_id() in the
** where clause of a select query. If you intend to change this query
** or use the object_id() or db_id() builtin in this procedure, please read the
** READ.ME file in the $DBMS/generic/sproc directory to ensure that the rules
** pertaining to object-id's and db-id's outlined there, are followed.
*/

create procedure sp_objectsegment
@objname	varchar(92)	/* table name */
as
declare @msg varchar(30)

	/* 
	** Print out the create date for the object and it's
	** data segment, if applicable.
	*/

	/*
	**  Objects have the following value for sysstat & 7:
	**	0 - trigger
	**	1 - system table
	**	2 - view
	**	3 - user table
	**	4 - sproc
	**	5 - NOT UNUSED
	**	6 - default
	**	7 - rule
	*/
	if exists (select *
			from sysobjects
				where id = object_id(@objname)
					and sysstat & 7 in (1, 3))
	begin
		select Data_located_on_segment = s.name, When_created = crdate
			from sysobjects o, syssegments s, sysindexes i
				where o.id = object_id(@objname)
					and i.id = o.id
					and i.indid < 2
					and i.segment = s.segment
	end

	/*
	**  It's not a table so segment is not applicable.
	*/
	else
	begin
		/*
		** 17714, "not applicable" 
		*/
		exec sp_getmessage 17714, @msg output
		select Data_located_on_segment = @msg,
			When_created = crdate
		from sysobjects
			where id = object_id(@objname)
	end

return (0)

                      
go

go
if exists (select * from sysobjects 
where name = "sp_indsuspect")
begin
	drop proc sp_indsuspect
end
go

/* Sccsid = "@(#) generic/sproc/indsuspect 52.1 8/12/92" */

/*
** Messages from sysmessages
**
** 17860, "Suspect indexes in database %1!:"
** 17861, "There are no suspect indexes in database %1!."
** 17862, "Table must be in the 'current' database."
** 17863, "There is no table named %1! in the 'current' database."
** 17864, "Suspect indexes on table %1!:"
** 17865, "There are no suspect indexes on table %1!."
*/

create procedure sp_indsuspect
@tab_name varchar(92) = NULL		/* if NULL, check all tables in db */
AS

declare @msg		varchar(255)	/* used for message to user */
declare @msg2		varchar(30)	/* used for table/db name */
declare @ind_suspect	smallint	/* value of IND_SUSPECT bit */

set nocount on

/* 
** Specify the bit mask as -32768, not in hex notation, for portability
** to byte-swapped platforms.  This could break on a 1's complement 
** platform, but there isn't really a better solution.  SQL handles 
** hex numbers as binary data, not as numeric values as in C.
*/

select @ind_suspect = -32768

if (@tab_name is null)
begin
	/*
	** No table name specified, sp search for any
	** suspected indexes in the entire database.
	*/
	if exists (select * from sysindexes i
			where (i.status & @ind_suspect) != 0)
	begin
		/* 17860, "Suspect indexes in database %1!:" */
		exec sp_getmessage 17860, @msg output
		select @msg2 = db_name()
		print @msg, @msg2

		select
                        "Own.Tab.Ind (Obj_ID, Ind_ID)" =
				u.name + "." + o.name + '.' + i.name +
				' (' + convert(varchar, o.id) + ', ' +
				convert(varchar, i.indid) + ')'
		from
			sysobjects o,
			sysindexes i,
			sysusers u
		where
			o.id = i.id
		    and o.uid = u.uid
		    and (i.status & @ind_suspect) != 0
	end
	else
	begin
		/* 17861, "There are no suspect indexes in database %1!." */
		exec sp_getmessage 17861, @msg output
		select @msg2 = db_name()
		print @msg, @msg2
	end
end
else
begin
	/*
	** User has specified a table.
	** Check to see that the table name is local to the current database.
	*/
	if (@tab_name like '%.%.%')
	begin
		/* 17862, "Table must be in the 'current' database." */
		exec sp_getmessage 17862, @msg output
		print @msg
		return (1)
	end

	/*
	** Now, see if the table actually exists.
	*/
	if (object_id(@tab_name) is null)
	begin
		/* 17863, "There is no table named %1! in the 'current' database." */
		exec sp_getmessage 17863, @msg output
		print @msg, @tab_name
		return (2)
	end

	/*
	** Now, check for any suspect indexes on this table.
	*/
	if exists (select * from sysindexes i
			where i.id = object_id(@tab_name)
			  and (i.status & @ind_suspect) != 0)
	begin
		/* 17864, "Suspect indexes on table %1!:" */
		exec sp_getmessage 17864, @msg output
		print @msg, @tab_name

		select
                        "Own.Tab.Ind (Obj_ID, Ind_ID)" =
				u.name + "." + o.name + '.' + i.name +
				' (' + convert(varchar, o.id) + ', ' +
				convert(varchar, i.indid) + ')'
		from
			sysobjects o,
			sysindexes i,
			sysusers u
		where
			o.id = i.id
		    and o.uid = u.uid
		    and o.id = object_id(@tab_name)
		    and (i.status & @ind_suspect) != 0
	end
	else
	begin
		/* 17865, "There are no suspect indexes on table %1!." */
		exec sp_getmessage 17865, @msg output
		print @msg, @tab_name
	end
end
return (0)
                                                             
go

go
if exists (select * from sysobjects 
where name = "sp_help")
begin
	drop proc sp_help
end
go

/* Sccsid = "@(#) generic/sproc/help 52.1 8/12/92" */
/*	4.8	1.1	06/14/90	sproc/src/help */
/*
** Messages for "sp_help"               17570
**
** 17460, "Object must be in the current database."
** 17461, "Object does not exist in this database."
** 17570, "Operating System File"
** 17571, "---------------------"
*/

/*
** IMPORTANT NOTE:
** This stored procedure uses the built-in function object_id() in the
** where clause of a select query. If you intend to change this query
** or use the object_id() or db_id() builtin in this procedure, please read the
** READ.ME file in the $DBMS/generic/sproc directory to ensure that the rules
** pertaining to object-id's and db-id's outlined there, are followed.
*/

create procedure sp_help
@objname varchar(92) = NULL			/* object name we're after */
as

declare @typeid int				/* type of object in systypes */
declare @sysstat smallint			/* the type of the object */
declare @OS_file varchar(255)			/* physical file for ext tab */
declare @msg varchar(250)
declare @sptlang	int
declare @len1 int, @len2 int, @len3 int, @len4 int

select @sptlang = @@langid

if @@langid != 0
begin
	if not exists (
		select * from sysmessages where error
		between 17100 and 17109
		and langid = @@langid)
	    select @sptlang = 0
end

set nocount on

/*
**  If no @objname given, give a little info about all objects.
**  Note: 0x807 is the mask for sysstats (=2055decimal).
** 	  800 is used by Stratus for external tables.
*/
if @objname = NULL
begin
	select @len1 = max(datalength(o.name)),
	       @len2 = max(datalength(user_name(uid)))
		from sysobjects o

	if (@len1 > 15 or @len2 > 15)
	    select Name = o.name,
		Owner = user_name(uid),
		Object_type = convert(char(22), m.description + x.name)
			from sysobjects o, master.dbo.spt_values v,
			master.dbo.spt_values x, master.dbo.sysmessages m
		where o.sysstat & 2055 = v.number
			and v.type = "O"
			and v.msgnum = m.error
			and isnull(m.langid, 0) = @sptlang
			and m.error between 17100 and 17109
			and x.type = "R"
			and o.userstat & -32768 = x.number
		order by Object_type desc, Name asc
	else
	    select Name = convert(char(15), o.name),
		Owner = convert(char(15), user_name(uid)),
		Object_type = convert(char(22), m.description + x.name)
			from sysobjects o, master.dbo.spt_values v,
			master.dbo.spt_values x, master.dbo.sysmessages m
		where o.sysstat & 2055 = v.number
			and v.type = "O"
			and v.msgnum = m.error
			and isnull(m.langid, 0) = @sptlang
			and m.error between 17100 and 17109
			and x.type = "R"
			and o.userstat & -32768 = x.number
		order by Object_type desc, Name asc


	select @len1 = max(datalength(s.name)),
	       @len2 = max(datalength(st.name)),
	       @len3 = max(datalength(object_name(s.tdefault))),
	       @len4 = max(datalength(object_name(s.domain)))
	from systypes s, systypes st
		where s.type = st.type
			and s.usertype > 99
			and st.usertype != 18 /* ignore sysname */
			and st.usertype < 100

	if (@len1 > 15 or @len2 > 15 or @len3 > 15 or @len4 > 15)
	    select User_type = s.name,
		Storage_type = st.name,
		Length = s.length,
		Nulls = s.allownulls,
		Default_name = object_name(s.tdefault),
		Rule_name = object_name(s.domain)
		from systypes s, systypes st
		    where s.type = st.type
			and s.usertype > 99
			and st.usertype != 18 /* ignore sysname */
			and st.usertype < 100
		order by s.name
	else
	    select User_type = convert(char(15), s.name),
		Storage_type = convert(char(15), st.name),
		Length = s.length,
		Nulls = s.allownulls,
		Default_name = convert(char(15), object_name(s.tdefault)),
		Rule_name = convert(char(15), object_name(s.domain))
		from systypes s, systypes st
		    where s.type = st.type
			and s.usertype > 99
			and st.usertype != 18 /* ignore sysname */
			and st.usertype < 100
		order by s.name

	return (0)
end

/*
**  Make sure the @objname is local to the current database.
*/
if @objname like "%.%.%" and
	substring(@objname, 1, charindex(".", @objname) - 1) != db_name()
begin
	/* 17460, "Object must be in the current database." */
	exec sp_getmessage 17460, @msg out
	print @msg
	return  (1)
end

/*
**  Now check to see if the @objname is in sysobjects.  It has to be either
**  in sysobjects or systypes.
*/
if not exists (select *
	from sysobjects
		where id = object_id(@objname))

/*
**  It wasn't in sysobjects so we'll check in systypes.
*/
begin
	select @typeid = usertype
		from systypes
			where name = @objname

	/*
	**  Time to give up -- @objname is not in sysobjects or systypes.
	*/
	if @typeid = NULL
	begin
		/* 17461, "Object does not exist in this database." */
		exec sp_getmessage 17461, @msg out
		print @msg
		return  (1)
	end

	/*
	** Print help about a data type
	*/
	select @len1 = max(datalength(s.name)),
	       @len2 = max(datalength(st.name)),
	       @len3 = max(datalength(object_name(s.tdefault))),
	       @len4 = max(datalength(object_name(s.domain)))
		from systypes s, systypes st
		    where s.usertype = @typeid
			and s.type = st.type
			and st.usertype != 18 /* ignore sysname */
			and st.usertype < 100

	if (@len1 > 15 or @len2 > 15 or @len3 > 15 or @len4 > 15)
	    select Type_name = s.name,
		Storage_type = st.name,
		Length = s.length,
		Nulls = s.allownulls,
		Default_name = object_name(s.tdefault),
		Rule_name = object_name(s.domain)
		from systypes s, systypes st
		    where s.usertype = @typeid
			and s.type = st.type
			and st.usertype != 18 /* ignore sysname */
			and st.usertype < 100
	else
	    select Type_name = convert(char(15), s.name),
		Storage_type = convert(char(15), st.name),
		Length = s.length,
		Nulls = s.allownulls,
		Default_name = convert(char(15), object_name(s.tdefault)),
		Rule_name = convert(char(15), object_name(s.domain))
		from systypes s, systypes st
		    where s.usertype = @typeid
			and s.type = st.type
			and st.usertype != 18 /* ignore sysname */
			and st.usertype < 100

	return (0)
end

/*
**  It's in sysobjects so print out the information.
*/
select Name = o.name, Owner = user_name(uid), 
	Type = convert(char(16), m.description + x.name)
	from sysobjects o, master.dbo.spt_values v,
		master.dbo.spt_values x, master.dbo.sysmessages m
	where o.id = object_id(@objname)
		and o.sysstat & 2055 = v.number
		and v.type = "O"
		and v.msgnum = m.error
		and isnull(m.langid, 0) = @sptlang
		and m.error between 17100 and 17109
		and x.type = "R"
		and o.userstat & -32768 = x.number

execute sp_objectsegment @objname

/*
**  Objects have the following value for sysstat & 7:
**	0 - trigger
**	1 - system table
**	2 - view
**	3 - user table
**	4 - sproc
**	5 - NOT UNUSED
**	6 - default
**	7 - rule
**
**  If the object is a system table, view, or user table, we want to check
**  out the objects columns here.
*/

select @sysstat = sysstat
	from sysobjects
		where id = object_id(@objname)

if @sysstat & 7 in (1, 2, 3)
begin
	select Column_name = c.name,
	       Type = t.name,
	       Length = c.length,
	       Nulls = convert(bit, (c.status & 8)),
	       Default_name = object_name(c.cdefault),
	       Rule_name = object_name(c.domain),
	       rtype = t.type, utype = t.usertype
	into #helptype
	from syscolumns c, systypes t
		where c.id = object_id(@objname)
			and c.usertype *= t.usertype

	/* Handle National Characters */
	update #helptype
		set Length = Length / @@ncharsize
		where (rtype = 47 and utype = 24)
		   or (rtype = 39 and utype = 25)

	select @len1 = max(datalength(Column_name)),
	       @len2 = max(datalength(Type)),
	       @len3 = max(datalength(Default_name)),
	       @len4 = max(datalength(Rule_name))
	from #helptype

	if (@len1 > 15 or @len2 > 15 or @len3 > 15 or @len4 > 15)
	    select Column_name,
		   Type,
		   Length,
		   Nulls,
		   Default_name,
		   Rule_name
		from #helptype
	else
	    select Column_name = convert(char(15), Column_name),
		   Type = convert(char(15), Type),
		   Length,
		   Nulls,
		   Default_name = convert(char(15), Default_name),
		   Rule_name = convert(char(15), Rule_name)
		from #helptype

	drop table #helptype
end

/*
**  For procedures, the parameters of the procedures are stored in syscolumns.
*/
if @sysstat & 7 = 4
begin
	/*
	**  Does the sproc have any parameters?
	*/
	if exists (select *
			from syscolumns c, systypes t
				where c.id = object_id(@objname)
					and c.usertype *= t.usertype)
	begin
		select Parameter_name = convert(char(15), c.name),
		       Type = convert(char(15), t.name),
		       Length = c.length,
		       Param_order=c.colid,
		       rtype = t.type, utype = t.usertype
		into #helpproc
		from syscolumns c, systypes t
			where c.id = object_id(@objname)
				and c.usertype *= t.usertype

		/* Handle National Characters */
		update #helpproc
			set Length = Length / @@ncharsize
			where (rtype = 47 and utype = 24)
			   or (rtype = 39 and utype = 25)

		select @len1 = max(datalength(Parameter_name)),
		       @len2 = max(datalength(Type))
		from #helpproc

		if (@len1 > 15 or @len2 > 15)
		    select Parameter_name,
			   Type,
			   Length,
			   Param_order
		    from #helpproc
		else
		    select Parameter_name = convert(char(15), Parameter_name),
			   Type = convert(char(15), Type),
			   Length,
			   Param_order
		    from #helpproc

		drop table #helpproc
	end
end

/*
**  If the object is an external table, show which OS file it's using.
*/
if @sysstat & 2055 = 2051
begin
	select @OS_file = name from sysindexes
		where id = object_id(@objname)
		and indid in (0,1)
	/*
	** 17570, "Operating System File"
	** 17571, "---------------------"
	*/
	print ""
	exec sp_getmessage 17570, @msg out
	print @msg
	exec sp_getmessage 17571, @msg out
	print @msg
	print @OS_file
	print ""
end

/*
**  If the object is a table, check out the indexes.
*/
if @sysstat & 7 in (1, 3)
	execute dbo.sp_helpindex @objname

/*
**  If the object is a table or view, check out the keys.
*/
if @sysstat & 7 in (1, 2, 3)
	execute dbo.sp_helpkey @objname

return (0)
                                                     
go

go
if exists (select * from sysobjects 
where name = "sp_helprotect")
begin
	drop proc sp_helprotect
end
go

/* Sccsid = "@(#) generic/sproc/helprotect 52.1 8/12/92" */
/*	4.8	1.1	06/14/90	sproc/src/help */
/*
** Messages for "sp_helprotect"         17673
**
** 17460, "Object must be in the current database."
** 17232, "No user with the specified name exists in the current database."
** 17673, "All"
** 17674, "No such object or user exists in the database."
*/
create procedure sp_helprotect
@name varchar(92),			/* name of object or user to check */
@username varchar(30) = NULL		/* name of user to restrict check */
as

declare @low int			/* range of userids to check */
declare @high int
declare @objid int			/* id of @name if object */
declare @msg	varchar(100)
declare @len1 int, @len2 int

/*
**  Check to see that the object names are local to the current database.
*/
if @name like "%.%.%" and
	substring(@name, 1, charindex(".", @name) - 1) != db_name()
begin
	/* 17460, "Object must be in the current database." */
	exec sp_getmessage 17460, @msg out
	print @msg
	return (1)
end

/*
**  Initialize the range of user ids to check.  We will either check all
**  users (the initial values) or just one in particular (@low = @high)
*/
select @low = -1, @high = 32767

if @username is not NULL
begin
	/*
	**  Set @low and @high so the search will be restricted to
	**  a particular user.
	*/
	select @low = uid, @high = uid
		from sysusers
			where name = @username

	/*
	**  @username isn't valid.
	*/
	if @low = -1
	begin
		/* 17232, "No user with the specified name exists in the current database." */
		exec sp_getmessage 17232, @msg out
		print @msg
		return (1)
	end
end

/*
**  There are two cases handled by this procedure.  If the first parameter
**  is an object (table, view, procedure) then @name is taken as an object
**  name and the procedure will figure out permissions for the object.
**
**  If the first parameter is not one of the objects mentioned it will be
**  taken as user name and all the permissions for the user or group name
**  will be shown.
*/

/*
**  Check to see if it's an object.
*/
if exists (select *
		from sysobjects
			where id = object_id(@name)
				and (sysstat & 7 = 1	/* system table */
				or sysstat & 7 = 2	/* view */
				or sysstat & 7 = 3	/* user table */
				or sysstat & 7 = 4))	/* procedure */
begin
	/*
	**  This is the case where we will show the various permissions for
	**  an object, possibly restricted by a particular user.
	*/
	/* 17673, "All" */
	exec sp_getmessage 17673, @msg out

	select @len1 = max(datalength(user_name(p.uid))),
	       @len2 = max(datalength(isnull(col_name(id, c.number), @msg)))
		from sysprotects p, master.dbo.spt_values c,
			master.dbo.spt_values a, master.dbo.spt_values b
		where convert(tinyint, substring(isnull(p.columns, 0x1), c.low, 1))
			& c.high != 0
			and c.number <=
				(select count(*)
					from syscolumns
					where id = object_id(@name))
			and a.type = "T"
			and a.number = p.action
			and b.type = "T"
			and b.number = p.protecttype
			and c.type = "P"
			and p.id = object_id(@name)
			and p.uid between @low and @high

	if (@len1 > 15 or @len2 > 10)
	    select type = convert(char(8), b.name), action = a.name,
		user = user_name(p.uid),
		column = isnull(col_name(id, c.number), @msg)
			from sysprotects p, master.dbo.spt_values c,
				master.dbo.spt_values a, master.dbo.spt_values b
			where convert(tinyint, substring(isnull(p.columns, 0x1), c.low, 1))
				& c.high != 0
				and c.number <=
					(select count(*)
						from syscolumns
						where id = object_id(@name))
				and a.type = "T"
				and a.number = p.action
				and b.type = "T"
				and b.number = p.protecttype
				and c.type = "P"
				and p.id = object_id(@name)
				and p.uid between @low and @high
			order by type, action, user, column
	else
	    select type = convert(char(8), b.name), action = a.name,
		user = convert(char(15), user_name(p.uid)),
		column = convert(char(10), isnull(col_name(id, c.number), @msg))
			from sysprotects p, master.dbo.spt_values c,
				master.dbo.spt_values a, master.dbo.spt_values b
			where convert(tinyint, substring(isnull(p.columns, 0x1), c.low, 1))
				& c.high != 0
				and c.number <=
					(select count(*)
						from syscolumns
						where id = object_id(@name))
				and a.type = "T"
				and a.number = p.action
				and b.type = "T"
				and b.number = p.protecttype
				and c.type = "P"
				and p.id = object_id(@name)
				and p.uid between @low and @high
			order by type, action, user, column
	return (0)
end

/*
**  Since @name is not an object let's try it as a user.
*/
select @low = uid, @high = uid
	from sysusers
		where name = @name

/*
**  @name isn't a user either so return.
*/
if @low = -1
begin
	/* 17674, "No such object or user exists in the database." */
	exec sp_getmessage 17674, @msg out
	print @msg
	return (1)
end

/*
**  Now we have the user so run the same protection query as before but
**  restrict on user and not on object.
*/
select distinct @len1 = max(datalength(isnull(object_name(p.id), ""))),
	@len2 = max(datalength(isnull(col_name(id, c.number), "All")))
		from sysprotects p, master.dbo.spt_values c,
			master.dbo.spt_values a, master.dbo.spt_values b
		where convert(tinyint, substring(isnull(p.columns, 0x1), c.low, 1))
			& c.high != 0
			and c.number <= 255
			and a.type = "T"
			and a.number = p.action
			and b.type = "T"
			and b.number = p.protecttype
			and c.type = "P"
			and p.uid = @low

if (@len1 > 15 or @len2 > 10)
    select distinct type = convert(char(8), b.name), action = a.name,
	object = isnull(object_name(p.id), ""),
	column = isnull(col_name(id, c.number), "All")
		from sysprotects p, master.dbo.spt_values c,
			master.dbo.spt_values a, master.dbo.spt_values b
		where convert(tinyint, substring(isnull(p.columns, 0x1), c.low, 1))
			& c.high != 0
			and c.number <= 255
			and a.type = "T"
			and a.number = p.action
			and b.type = "T"
			and b.number = p.protecttype
			and c.type = "P"
			and p.uid = @low
		order by type, object, column, action
else
    select distinct type = convert(char(8), b.name), action = a.name,
	object = convert(char(15), isnull(object_name(p.id), "")),
	column = convert(char(10), isnull(col_name(id, c.number), "All"))
		from sysprotects p, master.dbo.spt_values c,
			master.dbo.spt_values a, master.dbo.spt_values b
		where convert(tinyint, substring(isnull(p.columns, 0x1), c.low, 1))
			& c.high != 0
			and c.number <= 255
			and a.type = "T"
			and a.number = p.action
			and b.type = "T"
			and b.number = p.protecttype
			and c.type = "P"
			and p.uid = @low
		order by type, object, column, action

return (0)
                                                                                 
go

go
if exists (select * from sysobjects 
where name = "sp_helptext")
begin
	drop proc sp_helptext
end
go

/* Sccsid = "@(#) generic/sproc/helptext 52.1 8/12/92" */
/*	4.8	1.1	06/14/90	sproc/src/helptext */
/*
** Messages for "sp_helptext"           17nnn
**
** 17460, "Object must be in the current database."
** 17461, "Object does not exist in this database." 
** 17679, "There is no text for object @objname." 
*/
create procedure sp_helptext
@objname varchar(92)
as
declare @text_count int
declare @msg varchar(100)
/*
**  Make sure the @objname is local to the current database.
*/
if @objname like "%.%.%" and
	substring(@objname, 1, charindex(".", @objname) - 1) != db_name()
begin
	/* 17460, "Object must be in the current database." */
	exec sp_getmessage 17460, @msg out
	print @msg
	return (1)
end

/*
**  See if @objname exists.
*/
if (object_id(@objname) = NULL)
begin
	/* 17461, "Object does not exist in this database." */
	exec sp_getmessage 17461, @msg out
	print @msg
	return (1)
end

/*
**  Find out howmany lines of text are coming back.
**	and return if there are none.
*/
select @text_count = count(*)
	from syscomments
where id = object_id(@objname)

if @text_count = 0
begin
	/* 17679, "There is no text for object @objname." */
	exec sp_getmessage 17679, @msg out
	print @msg, @objname
	return (1)
end
	
/*
**  Return # howmany lines of text that are about to come back.
**  This is required by the "old" report writer.
*/
select "# Lines of Text" = @text_count

/*
**  Now get the text.
*/
select text
	from syscomments 
where id = object_id(@objname)

return (0)
                                             
go

go
if exists (select * from sysobjects 
where name = "sp_helpuser")
begin
	drop proc sp_helpuser
end
go

/* Sccsid = "@(#) generic/sproc/helpuser 52.1 8/12/92" */
/*	4.8	1.1	06/14/90	sproc/src/help */
/*
** Messages for "sp_helpuser"           17700
**
** 17700, "Users aliased to user."
** 17701, "The name supplied is a group name."
** 17702, "The name supplied is aliased to another user."
** 17703, "The name supplied is not a user, group, or aliased."
*/
create procedure sp_helpuser
@name_in_db varchar(30) = NULL
as

declare @msg varchar(100)
declare @len1 int, @len2 int, @len3 int, @len4 int

set nocount on

/*
**  If no @name_in_db, list all the users.
**  User ids are <= 16383 and group ids are > 16383.
*/
if @name_in_db = NULL
begin
    select @len1 = max(datalength(u.name)),
	@len2 = max(datalength(g.name)),
	@len3 = max(datalength(m.name)),
	@len4 = max(datalength(m.dbname))
		from sysusers u, sysusers g,
			master.dbo.syslogins m
		where u.suid *= m.suid
			and u.gid *= g.uid
			and u.uid <= 16383 and u.uid > 0

    if (@len1 > 17 or @len2 > 17 or @len3 > 17 or @len4 > 15)
	select Users_name = u.name, ID_in_db = u.uid,
		Group_name = g.name,
		Login_name = m.name,
		Default_db = m.dbname
			from sysusers u, sysusers g,
				master.dbo.syslogins m
			where u.suid *= m.suid
				and u.gid *= g.uid
				and u.uid <= 16383 and u.uid > 0
			order by Users_name
   else
	select Users_name = convert(char(17), u.name), ID_in_db = u.uid,
		Group_name = convert(char(17), g.name),
		Login_name = convert(char(17), m.name),
		Default_db = convert(char(15), m.dbname)
			from sysusers u, sysusers g,
				master.dbo.syslogins m
			where u.suid *= m.suid
				and u.gid *= g.uid
				and u.uid <= 16383 and u.uid > 0
			order by Users_name
    return (0)
end

/*
**  See if the @name_in_db is a user.  If so, print out the info for
**  the user, including users pretending to be the user (sysaliases).
*/
if exists (select *
		from sysusers
			where name = @name_in_db
				and uid <= 16383 and uid > 0)
begin
	select @len1 = max(datalength(u.name)),
	    @len2 = max(datalength(g.name)),
	    @len3 = max(datalength(m.name)),
	    @len4 = max(datalength(m.dbname))
		from sysusers u, sysusers g,
			master.dbo.syslogins m
		where u.suid *= m.suid
			and u.gid *= g.uid
			and u.name = @name_in_db
			and u.uid <= 16383 and u.uid > 0

	if (@len1 > 17 or @len2 > 17 or @len3 > 17 or @len4 > 15)
	    select Users_name = u.name, ID_in_db = u.uid,
		Group_name = g.name,
		Login_name = m.name,
		Default_db = m.dbname
			from sysusers u, sysusers g,
				master.dbo.syslogins m
			where u.suid *= m.suid
				and u.gid *= g.uid
				and u.name = @name_in_db
				and u.uid <= 16383 and u.uid > 0
	else
	    select Users_name = convert(char(17), u.name), ID_in_db = u.uid,
		Group_name = convert(char(17), g.name),
		Login_name = convert(char(17), m.name),
		Default_db = convert(char(15), m.dbname)
			from sysusers u, sysusers g,
				master.dbo.syslogins m
			where u.suid *= m.suid
				and u.gid *= g.uid
				and u.name = @name_in_db
				and u.uid <= 16383 and u.uid > 0    

	declare @suid	smallint

	select @suid = suid
		from sysusers 
			where name = @name_in_db

	/*
	** If anyone is using @name_in_db as an alias print it out.
	*/
	if exists (select *
			from sysalternates
		where altsuid = @suid)
	begin
		/* 17700, "Users aliased to user." */
		exec sp_getmessage 17700, @msg out
		print @msg
		select Login_name = suser_name(suid)
			from sysalternates
				where altsuid = @suid
			order by Login_name
	end

	return (0)
end

/*
**  Maybe the @name_in_db is a group.  Is so print out the info.
*/
if exists (select *
		from sysusers
			where name = @name_in_db
				and (uid > 16383 or uid = 0))
begin
	/* 17701, "The name supplied is a group name." */
	exec sp_getmessage 17701, @msg out
	print @msg
	execute sp_helpgroup @name_in_db
	return (0)
end

/*
**  Last thing to try is that the @name_in_db might be aliased.
*/
if exists (select *
		from sysalternates
			where suid = suser_id(@name_in_db))
begin
	/* 17702, "The name supplied is aliased to another user." */
	exec sp_getmessage 17702, @msg out
	print @msg

	select @len1 = max(datalength(u.name)),
	    @len2 = max(datalength(g.name)),
	    @len3 = max(datalength(m.name)),
	    @len4 = max(datalength(m.dbname))
		from sysusers u, sysusers g, sysalternates a,
			master.dbo.syslogins m
		where u.suid *= m.suid
			and u.gid *= g.uid
			and u.uid <= 16383 and u.uid > 0
			and a.suid = suser_id(@name_in_db)
			and a.altsuid = u.suid

	if (@len1 > 17 or @len2 > 17 or @len3 > 17 or @len4 > 15)
	    select Alias_name = u.name, ID_in_db = u.uid,
		Group_name = g.name,
		Login_name = m.name,
		Default_db = m.dbname
			from sysusers u, sysusers g, sysalternates a,
				master.dbo.syslogins m
			where u.suid *= m.suid
				and u.gid *= g.uid
				and u.uid <= 16383 and u.uid > 0
				and a.suid = suser_id(@name_in_db)
				and a.altsuid = u.suid
	else
	    select Alias_name = convert(char(17), u.name), ID_in_db = u.uid,
		Group_name = convert(char(17), g.name),
		Login_name = convert(char(17), m.name),
		Default_db = convert(char(15), m.dbname)
			from sysusers u, sysusers g, sysalternates a,
				master.dbo.syslogins m
			where u.suid *= m.suid
				and u.gid *= g.uid
				and u.uid <= 16383 and u.uid > 0
				and a.suid = suser_id(@name_in_db)
				and a.altsuid = u.suid

	return (0)
end

/* 17703, "The name supplied is not a user, group, or aliased." */
exec sp_getmessage 17703, @msg out
print @msg

return (1)
                                                                                                                                                                                                                             
go

go
if exists (select * from sysobjects 
where name = "sp_loaddbupgrade")
begin
	drop proc sp_loaddbupgrade
end
go

/* Sccsid = "@(#) generic/sproc/src/loaddbupgrade 52.1 8/12/92" */

create procedure sp_loaddbupgrade 
@databasename varchar(30), 
@devname varchar(30)
as

dbcc traceon(3402)

/* The recovery which is part of load database will perform the upgrade */
load database @databasename from @devname

dbcc traceoff(3402)

return (0)
                                                                                                                                                                                       
go

go
if exists (select * from sysobjects 
where name = "sp_lock")
begin
	drop proc sp_lock
end
go

/* Sccsid = "@(#) generic/sproc/lock 52.1 8/12/92" */
/*	4.8	1.1	06/14/90	sproc/src/lock */
create procedure sp_lock
@spid1 int = NULL,		/* server process id to check for locks */
@spid2 int = NULL		/* other process id to check for locks */
as

declare @length int

/*
**  Show the locks for both parameters.
*/
if @spid1 is not NULL
begin
    select @length = max(datalength(db_name(dbid)))
	from syslocks
		where spid in (@spid1, @spid2)

    if (@length > 15)
	select spid, locktype = name, table_id = id, page,
		dbname = db_name(dbid)
	from syslocks, spt_values
		where syslocks.type = spt_values.number
			and spt_values.type = "L"
			and spid in (@spid1, @spid2)
    else
	select spid, locktype = name, table_id = id, page,
		dbname = convert(char(15), db_name(dbid))
	from syslocks, spt_values
		where syslocks.type = spt_values.number
			and spt_values.type = "L"
			and spid in (@spid1, @spid2)
end

/*
**  No parameters, so show all the locks.
*/
else
begin
    select @length = max(datalength(db_name(dbid)))
	from syslocks

    if (@length > 15)
	select spid, locktype = name, table_id = id, page,
		dbname = db_name(dbid)
	from syslocks, spt_values
		where syslocks.type = spt_values.number
			and spt_values.type = "L"
	order by spid, dbname, table_id, locktype, page
    else
	select spid, locktype = name, table_id = id, page,
		dbname = convert(char(15), db_name(dbid))
	from syslocks, spt_values
		where syslocks.type = spt_values.number
			and spt_values.type = "L"
	order by spid, dbname, table_id, locktype, page
end

return (0)
                                                                                                                                                                                                                                         
go

go
if exists (select * from sysobjects 
where name = "sp_logdevice")
begin
	drop proc sp_logdevice
end
go

/* Sccsid = "@(#) generic/sproc/src/logdevice 52.1 8/12/92" */
/*	4.8	1.1	06/14/90	sproc/src/lock */

/*
** Messages for "sp_logdevice"          17710
**
** 17421, "No such database -- run sp_helpdb to list databases."
** 17471, "No such device exists -- run sp_helpdevice to list the DataServer devices."
** 17230, "Only the System Administrator (SA) or the Database Owner (dbo) may execute this stored procedure."
** 17281, "The specified device is not used by the database."
** 17710, "This command has been ignored.  The device specified
**	   is the only non-log device available for the database and
**	   cannot be made log-only."
** 17711, "Syslogs moved."
*/

create procedure sp_logdevice
@dbname	varchar(30),		/* database name that has the syslogs */
@devname	varchar(30)	/* device name to put syslogs on */
as

declare @dbid	smallint	/* dbid of the database to be changed */
declare @dbuid	smallint	/* id of the owner of the database */
declare @logbit	int		/* this is the bit to turn on in sysusages */
declare @msg    varchar(250)

select @logbit = 4		/* bit 3 is the one to turn on */

/*
**  Verify the database name and get the @dbid and @dbuid
*/
select @dbid = dbid, @dbuid = suid
	from sysdatabases
		where name = @dbname

/*
**  If @dbname not found, say so and list the databases.
*/
if @dbid = NULL
begin
	/*
	** 17421, "No such database -- run sp_helpdb to list databases."
	*/
	exec sp_getmessage 17421, @msg output
	print @msg
	return (1)
end

/*
**  See if the device exists.
*/
if not exists (select *
		from master.dbo.sysdevices
			where name like @devname)
begin
	/*
	** 17471, "No such device exists -- run sp_helpdevice to list the DataServer devices."
	*/
	exec sp_getmessage 17471, @msg output
	print @msg
	return (1)
end

/*
**  You must be SA or the dbo to execute this sproc.
*/
if suser_id() != 1 and suser_id() != @dbuid
begin
	/*
	** 17230, "Only the System Administrator (SA) or the Database Owner (dbo) may execute this stored procedure."
	*/
	exec sp_getmessage 17230, @msg output
	print @msg
	return (1)
end

/*
**  Now see if the @dbname uses the @devname
*/
if not exists (select *
		from sysusages u, sysdevices d
			where d.name = @devname
				and u.vstart between d.low and d.high
				and u.dbid = @dbid)
begin
	/*
	** 17281, "The specified device is not used by the database."
	*/
	exec sp_getmessage 17281, @msg output
	print @msg
	return (1)
end

/*
**  Check if there are any additional segments on original device to be made
**  into log only (don't want to make the only segment not usable for data!)
*/
if (select count(*)
	from master.dbo.sysusages u, master.dbo.sysdevices d
		where d.name != @devname
			and u.vstart between d.low and d.high
			and u.dbid = @dbid
			and u.segmap != @logbit
			and d.cntrltype = 0) = 0
begin
	/*
	** 17710, "This command has been ignored.  The device specified
	** is the only non-log device available for the database and
	** cannot be made log-only."
	*/
	exec sp_getmessage 17710, @msg output
	print @msg
	return (1)
end

/*
**  Set the segments on @devname as log-only.
*/
begin transaction

update master.dbo.sysusages
	set segmap = @logbit
		from master.dbo.sysusages u, master.dbo.sysdevices d
			where d.name = @devname
				and u.vstart between d.low and d.high
				and u.dbid = @dbid

/*
**  Clear the bit from any database segments on other devices that aren't
**  already log only.
*/
update master.dbo.sysusages
	set segmap = segmap & ~@logbit
		from master.dbo.sysusages u, master.dbo.sysdevices d
			where u.dbid = @dbid
			and u.vstart between d.low and d.high
			and d.name != @devname
			and u.segmap != @logbit

if @@rowcount = 0
	rollback transaction
else
	commit transaction

/*
**  Now we need to activate the new segment map.
*/
dbcc dbrepair (@dbname, remap)
/*
** 17711, "Syslogs moved."
*/
exec sp_getmessage 17711, @msg output
print @msg

return (0)
                                                                                                                                                                                                                  
go

go
if exists (select * from sysobjects 
where name = "sp_lookup")
begin
	drop proc sp_lookup
end
go

/* Sccsid = "@(#) generic/sproc/src/lookup 52.1 8/12/92" */
/*	4.8	1.1	06/14/90	sproc/src/lock */
create procedure sp_lookup
@typearg int,
@owname	varchar(30) = "%", /* owner of the desired objects (except indexes) */
@obname	varchar(30) = "%", /* name of the desired objects (including indexes) */
@indtab	varchar(30) = "%", /* table associated with the desired index */
@indown varchar(30) = "%"  /* owner of the desired index */
as
	create table #ddtab
		(name	varchar(30),
		 owner	varchar(30),
		 type	int,
		 indtab	varchar(30))

declare @table	int
declare @view	int
declare @index	int
declare @sproc	int
declare @trgr	int
declare @dflt	int
declare @rule	int
declare @dtype	int
declare @db	int
declare @report int

select @table = 1, @view = 2, @index = 4, @sproc = 8, @trgr = 16, @dflt = 32,
	@rule = 64, @dtype = 128, @db = 256, @report = 512

if (@typearg & @table = @table)
	insert into #ddtab
		select name, user_name(uid), @table, '' from dbo.sysobjects
			where name like @obname
				and user_name(uid) like @owname
				and (sysstat & 7 = 1	/* system table */
		  		or sysstat & 7 = 3)	/* user table */


if (@typearg & @view = @view)
	insert into #ddtab
		select name, user_name(uid), @view, '' from dbo.sysobjects
			where name like @obname
				and user_name(uid) like @owname
			  	and sysstat & 7 = 2		/* view */

if (@typearg & @index = @index)
	insert into #ddtab
		select i.name, user_name(o.uid), @index, o.name
			from dbo.sysindexes i, dbo.sysobjects o
				where i.name like @obname
					and i.indid > 0
					and i.id = o.id
					and user_name(o.uid) like @indown
					and o.name = object_name(o.id)
					and o.name like @indtab

if (@typearg & @report = @report)
	insert into #ddtab
		select name, user_name(uid), @report, '' from dbo.sysobjects
			where name like @obname
				and user_name(uid) like @owname
				and sysstat & 7 = 4		/* sproc */
				and userstat & -32768 = -32768	/* report */

if (@typearg & @sproc = @sproc)
begin
	/*
	**  If we also wanted reports, don't pick up reports again as sprocs.
	*/
	if (@typearg & @report = @report)
	begin
		insert into #ddtab
			select name, user_name(uid), @sproc, '' from dbo.sysobjects
			 where name like @obname
				and user_name(uid) like @owname
				and sysstat & 7 = 4	/* stored procedure */
				and userstat & -32768 != -32768	/* report */
	end
	else
	begin
		insert into #ddtab
			select name, user_name(uid), @sproc, '' from dbo.sysobjects
			 where name like @obname
				and user_name(uid) like @owname
				and sysstat & 7 = 4	/* stored procedure */
	end
end

if (@typearg & @trgr = @trgr)
	insert into #ddtab
		select name, user_name(uid), @trgr, '' from dbo.sysobjects
			where name like @obname
				and user_name(uid) like @owname
			  	and sysstat & 7 = 0	/* trigger */

if (@typearg & @dflt = @dflt)
	insert into #ddtab
		select name, user_name(uid), @dflt, '' from dbo.sysobjects
			 where name like @obname
			 	and user_name(uid) like @owname
			 	and sysstat & 7 = 6		/* default */

if (@typearg & @rule = @rule)
	insert into #ddtab
		select name, user_name(uid), @rule, '' from dbo.sysobjects
			 where name like @obname
			 	and user_name(uid) like @owname
			 	and sysstat & 7 = 7		/* rule */

if (@typearg & @dtype = @dtype)
	insert into #ddtab
		select name, user_name(uid), @dtype, '' from dbo.systypes
			where name like @obname
				and user_name(uid) like @owname

if (@typearg & @db = @db)
	insert into #ddtab
		select name, suser_name(suid), @db, ''
			from master.dbo.sysdatabases
				where (name like @obname)
					and suser_name(suid) like @owname

select * from #ddtab order by name

drop table #ddtab

return (0)
                                                                                                                                                                                                          
go

go
if exists (select * from sysobjects 
where name = "sp_helpremotelogin")
begin
	drop proc sp_helpremotelogin
end
go

/* Sccsid = "@(#) generic/sproc/helpremotelogin 52.1 8/12/92" */
/*	4.8	1.1	06/14/90	sproc/src/fixindex */
/*
** Messages for "sp_helpremotelogin"    17680
**
** 17680, "There are no remote servers defined."
** 17681, "There are no remote logins for the remote server '%1!'."
** 17682, "There are no remotelogins defined."
** 17683, "There are no remote logins for '%1!'."
** 17684, "There are no remote logins."
** 17685, "There are no remote logins for '%1!' on remote server '%2!'."
** 17686, "** mapped locally **"
** 17687, "** use local name **"
** 17661, "-- none --"
*/
create procedure sp_helpremotelogin
@remoteserver varchar(30) = NULL,	/* remote server name */
@remotename varchar(30) = NULL		/* remote login name */
as

declare	@msg	varchar(100)
declare @sptlang	int
declare @len1 int, @len2 int, @len3 int

set nocount on

/*
**  If no server given, get 'em all.
*/
if @remoteserver = null
begin
	select @remoteserver = "%"
end

else
begin
	if not exists (select *
			from master.dbo.sysservers s,
				master.dbo.sysremotelogins r
			where s.srvid = r.remoteserverid
				and s.srvname like @remoteserver
				and s.srvid > 0)
	begin
		if @remoteserver = "%"
		begin
			/* 17680, "There are no remote servers defined." */
			exec sp_getmessage 17680, @msg out
			print @msg
			return (1)
		end

		/* 17681, "There are no remote logins for the remote server '%1!'." */
		exec sp_getmessage 17681, @msg out
		print @msg, @remoteserver
		return (1)
	end
end

/*
**  If no remotename given, get 'em all.
*/
if @remotename = null
begin
	select @remotename = "%"
end

else
begin
	if not exists (select *
			from master.dbo.sysremotelogins
			where isnull(remoteusername, "") like @remotename)
	begin
		if @remotename = "%"
		begin
			/* 17682, "There are no remotelogins defined." */
			exec sp_getmessage 17682, @msg out
			print @msg
			return (1)
		end

		/* 17683, "There are no remote logins for '%1!'." */
		exec sp_getmessage 17683, @msg out
		print @msg, @remotename
		return (1)
	end
end

/*
**  Check for empty results.
*/
if not exists (select *
		from master.dbo.sysremotelogins r, master.dbo.sysservers s
		where isnull(r.remoteusername, "") like @remotename
			and s.srvid = r.remoteserverid
				and s.srvname like @remoteserver)
begin
	if ((@remoteserver = '%') and (@remotename = '%'))
		/* 17684, "There are no remote logins." */
		exec sp_getmessage 17684, @msg out
	else 
		/* 17685, "There are no remote logins for '%1!' on remote server '%2!'." */
		exec sp_getmessage 17685, @msg out

	print @msg, @remotename, @remoteserver
	return (1)
end

/*
**  Select the information.
*/
declare @maplocal varchar(22)
declare @uselocal varchar(22)

/* 17686, "** mapped locally **" */
/* 17687, "** use local name **" */
exec sp_getmessage 17686, @maplocal out
exec sp_getmessage 17687, @uselocal out

select @sptlang = @@langid

if @@langid != 0
begin
	if not exists (
		select * from sysmessages where error
		between 17070 and 17079
		and langid = @@langid)
	    select @sptlang = 0
end

select @len1 = max(datalength(s.srvname)),
       @len2 = max(datalength(isnull(r.remoteusername, @maplocal))),
       @len3 = max(datalength(isnull(suser_name(r.suid), @uselocal)))
	from master.dbo.sysservers s, master.dbo.sysremotelogins r
	where s.srvid = r.remoteserverid
		and s.srvname like @remoteserver
		and s.srvid > 0
		and isnull(r.remoteusername, "") like @remotename

if @sptlang = 0	/* us_english */
	if (@len1 > 22 or @len2 > 22 or @len3 > 22)
	    select server = s.srvname,
		remote_user_name = isnull(r.remoteusername, @maplocal),
		local_user_name = isnull(suser_name(r.suid), @uselocal),
		options = name
	    	    from master.dbo.sysservers s, master.dbo.sysremotelogins r,
			master.dbo.spt_values v
	            where s.srvid = r.remoteserverid
			and s.srvname like @remoteserver
			and s.srvid > 0
			and isnull(r.remoteusername, "") like @remotename
			and v.type = "F"
			and v.number = r.status
		    order by server, remote_user_name
	else
	    select server = convert(char(22), s.srvname),
		remote_user_name = 
		    convert(char(22), isnull(r.remoteusername, @maplocal)),
		local_user_name = 
		    convert(char(22), isnull(suser_name(r.suid), @uselocal)),
		options = name
	    	    from master.dbo.sysservers s, master.dbo.sysremotelogins r,
			master.dbo.spt_values v
	            where s.srvid = r.remoteserverid
			and s.srvname like @remoteserver
			and s.srvid > 0
			and isnull(r.remoteusername, "") like @remotename
			and v.type = "F"
			and v.number = r.status
		    order by server, remote_user_name
else /* non us_english */
	if (@len1 > 22 or @len2 > 22 or @len3 > 22)
	    select server = s.srvname,
		remote_user_name = isnull(r.remoteusername, @maplocal),
		local_user_name = isnull(suser_name(r.suid), @uselocal),
		options = m.description
		from master.dbo.sysservers s, master.dbo.sysremotelogins r,
			master.dbo.spt_values v, master.dbo.sysmessages m
		where s.srvid = r.remoteserverid
			and s.srvname like @remoteserver
			and s.srvid > 0
			and isnull(r.remoteusername, "") like @remotename
			and v.type = "F"
			and v.number = r.status
			and v.msgnum = m.error
			and m.langid = @sptlang
	    	order by server, remote_user_name
	else
	    select server = convert(char(22), s.srvname),
		remote_user_name = 
			convert(char(22), isnull(r.remoteusername, @maplocal)),
		local_user_name = 
			convert(char(22), isnull(suser_name(r.suid), @uselocal)),
		options = convert(char(16), m.description)
		from master.dbo.sysservers s, master.dbo.sysremotelogins r,
			master.dbo.spt_values v, master.dbo.sysmessages m
		where s.srvid = r.remoteserverid
			and s.srvname like @remoteserver
			and s.srvid > 0
			and isnull(r.remoteusername, "") like @remotename
			and v.type = "F"
			and v.number = r.status
			and v.msgnum = m.error
			and m.langid = @sptlang
	    	order by server, remote_user_name
return (0)
                                                                                                                                                                                                                                                         
go

go
if exists (select * from sysobjects 
where name = "sp_helpsegment")
begin
	drop proc sp_helpsegment
end
go

/* Sccsid = "@(#) generic/sproc/helpsegment 52.1 8/12/92" */
/*	4.8	1.1	06/14/90	sproc/src/fixindex */
/*
** Messages for "sp_helpsegment"        17nnn
**
** 17520, "There is no such segment as '%1!'."
*/
create procedure sp_helpsegment
@segname varchar(30) = NULL		/* segment name */
as

declare @segbit         int,    /* this is the bit version of the segment # */
	@segment        int,    /* the segment number of the segment */
	@factor         float,   /* conversion factor to convert to MB */
	@msg		varchar(100) /* message holder */

set nocount on

/*
**  If no segment name given, get 'em all.
*/
if @segname = null
begin
	select *
		from syssegments order by segment
	return (0)
end

/*
**  Make sure the segment exists
*/
if not exists (select *
	from syssegments
		where name = @segname)
begin
	/* 17520, "There is no such segment as '%1!'." */
	exec sp_getmessage 17520, @msg out
	print @msg, @segname
	return (1)
end

/*
**  Show the syssegment entry, then the fragments and size it is on,
**  then any dependent objects in the database.
*/
select *
	from syssegments
		where name = @segname

/*
**  Set the bit position for the segment.
*/
select @segment = segment
	from syssegments
		where name = @segname

/*
**  Now set the segments on @devname sysusages.
*/
if (@segment < 31)
	select @segbit = power(2, @segment)
else
	/*
	**  Since this is segment 31, power(2, 31) will overflow
	**  since segmap is an int.  We'll grab the machine-dependent
	**  bit mask from spt_values to set the right bit.
	*/
	select @segbit = low
		from master.dbo.spt_values
			where type = "E"
				and number = 2

/*
** Get factor for conversion of pages to megabytes from spt_values
*/
select @factor = convert(float, low) / 1048576.0
        from master.dbo.spt_values
        where number = 1 and type = "E"

/*
** Select the sizes of the segments
*/
select device = d.name,
       size = convert(varchar(20), round((sum(u.size) * @factor), 0)) + "MB"
        from master.dbo.sysusages u, master.dbo.sysdevices d
                where u.segmap & @segbit = @segbit
                        and u.dbid = db_id()
                        and d.status & 2 = 2
                        and d.low <= u.vstart
                        and d.high >= u.vstart + (u.size - 1)
                group by d.name order by d.name

/*
** Select the dependant objects
*/
if exists (select *
		from sysindexes i, syssegments s
			where s.name = @segname
				and s.segment = i.segment)
begin
	select table_name = object_name(i.id), index_name = i.name, i.indid
		from sysindexes i, syssegments s
			where s.name = @segname
				and s.segment = i.segment
		order by table_name, indid
end

return (0)
                                                                                                                                 
go

go
if exists (select * from sysobjects 
where name = "sp_helpsort")
begin
	drop proc sp_helpsort
end
go

/* Sccsid = "@(#) generic/sproc/helpsort 52.1 8/12/92" */
/*	4.8	1.1	06/14/90	sproc/src/fixindex */
/*
** Messages for "sp_helpsort"           17690
**
** 17690, "Character Set = "
** 17691, "Sort Order = "
** 17692, "Sort Order Description"
** 17693, "Characters, in Order"
** 17694, "Class 2 Character Set"
*/
create procedure sp_helpsort
AS
set nocount on

declare @sortid tinyint, @charid tinyint, @status tinyint
declare @csclass int
declare @image binary(1)
declare @count int, @end_flag int
    

declare @string varchar(66)
declare @msg varchar(100)
create table #helpsort3 (string varchar(66))

/*
** Get the sortorder ID, character set ID, and status
*/
select @sortid = value from syscurconfigs where config = 123
select @charid = value from syscurconfigs where config = 131
select @image = convert(binary(1), definition)
    	from syscharsets where id = @sortid and csid = @charid

/*
** Get the name and description of the character set and sort order
*/


if (@sortid = NULL)
 BEGIN
    select @sortid = 0, @charid = 0, @status = 0, @csclass = 0
	/* 17690, "Character Set = " */
    exec sp_getmessage 17690, @msg out
    insert #helpsort3 values (@msg + " 0, ascii_8")
    insert #helpsort3 values ("    8-bit ASCII Character Set - System Default")
	/* 17691, "Sort Order = " */
    exec sp_getmessage 17691, @msg out
    insert #helpsort3 values (@msg + " 0, bin_ascii_8")
    insert #helpsort3 values ("    Binary Ordering - System Default")
 END
else
 BEGIN
    select @status = convert(tinyint, @image)

	/* 17690, "Character Set = " */
    exec sp_getmessage 17690, @msg out
    select @string = @msg + " " + convert(varchar(4), id) + ", " + name,
	   @csclass = type
	    from syscharsets 
	    where id = @charid

    insert into #helpsort3 values (@string)

    select @count = 1
    select @end_flag = 1

    while (@end_flag != 0)
    begin
	    select @string = substring(description, @count, 62)
		    from syscharsets 
		    where id = @charid
	    select @end_flag = isnull(ascii(@string), 0)

	    if (@end_flag != 0)
	    begin
		    select @string = "    " + @string
		    insert #helpsort3 values (@string)
	    end
	    select @count = @count + 62
    end

    /* Check if class 2 character set.  If so, tell 'em. */
    if (@csclass = 1002)
    begin
	/* 17694, "Class 2 Character Set" */
	exec sp_getmessage 17694, @msg out
    	insert #helpsort3 values ("    " + @msg)
    end

	/* 17691, "Sort Order = " */
    exec sp_getmessage 17691, @msg out
    select @string = @msg + " " + convert(varchar(4), id) + ", " + name
	    from syscharsets 
	    where id = @sortid and csid = @charid

    insert into #helpsort3 values (@string)

    select @count = 1
    select @end_flag = 1

    while (@end_flag != 0)
    begin
	    select @string = substring(description, @count, 62)
		    from syscharsets 
		    where id = @sortid and csid = @charid
	    select @end_flag = isnull(ascii(@string), 0)

	    if (@end_flag != 0)
	    begin
		    select @string = "    " + @string
		    insert #helpsort3 values (@string)
	    end

	    select @count = @count + 62
    end
END

/* 17692, "Sort Order Description" */
exec sp_getmessage 17692, @msg out
print @msg
select "" = string from #helpsort3

/*
** If we have a class 2 character set, then we are unable 
** to output the multi-byte characters in their proper
** sort sequence from here... we're done.
*/
if (@csclass = 1002)
begin
	return (0)
end

/*
** Build the sorted list of printable characters for this sort order.
** If it's not stored in spt_values yet, then put the results in there.
*/
if not exists
(select * from spt_values where type = 'Z' and low = @charid and high = @sortid)
BEGIN
    
    create table #helpsort1 (char_val char(1))



    if @charid = 0       /* ascii_8 has printable chars from 32-126 */
        begin
                select @count = 32
                while @count <= 126
                begin
                        insert #helpsort1 (char_val)
                                values (char(@count))
                        select @count = @count + 1
                end

        end

    if @charid = 1      /* iso_1 has printable chars from 32-126 and 160-255 */
        begin
                select @count = 32
                while @count <= 126
                begin
                        insert #helpsort1 (char_val)
                                values (char(@count))
                        select @count = @count + 1
                end

                select @count = 160
                while @count <= 255
                begin
                        insert #helpsort1 (char_val)
                                values (char(@count))
                        select @count = @count + 1
                end
        end


    if @charid = 2      /* cp850 has printable chars from 32-255 */
        begin

                select @count = 32
                while @count <= 255
                begin
                        insert #helpsort1 (char_val)
                                values (char(@count))
                        select @count = @count + 1
                end
        end

    if @charid = 3      /* cp437 has printable chars from 32-255 */
        begin
                select @count = 32
                while @count <= 255
                begin
                        insert #helpsort1 (char_val)
                                values (char(@count))
                        select @count = @count + 1
                end
        end
    
    if @charid = 4      /* roman8 has printable chars from 32-126 and 161-255 */
        begin
                select @count = 32
                while @count <= 126
                begin
                        insert #helpsort1 (char_val)
                                values (char(@count))
                        select @count = @count + 1
                end

                select @count = 161
                while @count <= 255
                begin
                        insert #helpsort1 (char_val)
                                values (char(@count))
                        select @count = @count + 1
                end
        end
    
    if @charid = 5      /* mac has printable chars from 32-126 and 128-216 */
        begin
                select @count = 32
                while @count <= 126
                begin
                        insert #helpsort1 (char_val)
                                values (char(@count))
                        select @count = @count + 1
                end

                select @count = 128
                while @count <= 216
                begin
                        insert #helpsort1 (char_val)
                                values (char(@count))
                        select @count = @count + 1
                end
        end
    
     if @charid > 5     /* User Character Set Not recognised by sp_helpsort */
        begin

                select "Unknown Character Set : " + name from syscharsets
                                where id = @sortid and type = 2001
                return (0)
    
        end

    
    select (char_val) into #helpsort2
    	from #helpsort1
        order by char_val
    
    declare @char char(1)
    declare @char_str varchar(20)
    declare @incr int
    declare @seq_num int
    declare @rel char(1)
    declare @old_char char(1)
    
    select @char = char(0), @seq_num = 0, @count = 0, @incr = 8, @end_flag = 1
    select @rel = " ", @old_char = NULL
    
    set rowcount 1
   
    while @end_flag != 0
    begin
    
        select @char_str = ""
    
	/* If PST_NOTUNIQ is set, then possibly caseless */
	if (@status & 8 = 8)
            while (@count < @incr  and  @end_flag != 0)
            begin
                select @char = char_val
    	            from #helpsort2
                    where char_val >= @char
                select @end_flag = @@rowcount

		if (@end_flag != 0)
		begin
		    if (@char = @old_char)
			select @rel = "="
		    else
			select @rel = " "

		    select @old_char = @char
		    select @char_str = @char_str + @rel + @char
                    delete from #helpsort2 where ascii(@char) = ascii(char_val)
    
		    select @count = @count + 1
		end
            end
	else
            while (@count < @incr  and  @end_flag != 0)
            begin
                select @char = char_val
    	            from #helpsort2
                    where char_val > @char
                select @end_flag = @@rowcount

		if (@end_flag != 0)
		begin
		    select @char_str = @char_str + @rel + @char
                    delete from #helpsort2 where ascii(@char) = ascii(char_val)

		    select @count = @count + 1
		end
            end

        select @incr = @incr + 8, @seq_num = @seq_num + 1
        insert spt_values (name, number, type, low, high) 
		values (@char_str, @seq_num, 'Z', @charid, @sortid)
    end
    
    set rowcount 0
    
END

/*
** Display the sorted list of characters.
*/
select @count = 1
select @end_flag = 1
select @incr = 5

truncate table #helpsort3

while @end_flag != 0
BEGIN
	select @string = ""

	while @count < @incr
	begin
		select @string = @string + substring(name, 2, 19) 
			from spt_values
			where type = 'Z' and number = @count and low = @charid
				and high = @sortid
		select @end_flag = @@rowcount
		select @count = @count + 1
	end

	select @incr = @incr + 4

	insert into #helpsort3 values (@string)
END

/* 17693, "Characters, in Order" */
exec sp_getmessage 17693, @msg out
print @msg
select "" = string from #helpsort3

set nocount off

return(0)
                                                                                                                                                             
go

go
if exists (select * from sysobjects 
where name = "sp_helpserver")
begin
	drop proc sp_helpserver
end
go

/* Sccsid = "@(#) generic/sproc/helpserver 52.1 8/12/92" */
/*	4.8	1.1	06/14/90	sproc/src/fixindex */
/*
** Messages for "sp_helpserver"
**
** 17680, "There are no remote servers defined."
** 17270, "There is not a server named '%1!'."
*/
create procedure sp_helpserver
@server varchar(30) = NULL		/* server name */
as

declare	@msg	varchar(100)
declare @len1 int, @len2 int

set nocount on

/*
**  If no server name given, get 'em all.
*/
if @server = null
begin
	select @server = "%"
end

/*
**  Does the server exist?
*/
if not exists (select *
		from master.dbo.sysservers 
			where srvname like @server
				or srvnetname like @server)
begin
	if @server = "%"
		/* 17680, "There are no remote servers defined." */
		exec sp_getmessage 17680, @msg out
	else 
		/* 17270, "There is not a server named '%1!'." */
		exec sp_getmessage 17270, @msg out
	print @msg, @server
	return (1)
end
	
/*
**  Display server information.
**  First put it into a temp table so we can blot inappropriate status 
**  for the local server.  It's ugly but I couldn't think of another way.
*/
create table #spt_server
(
	name	varchar(30),
	network	varchar(30),
	status	varchar(20),
	id	smallint
)
insert into #spt_server
	select s.srvname, s.srvnetname, status = isnull(v.name, ""), 
		id = s.srvid
	from master.dbo.sysservers s, master.dbo.spt_values v
		where s.srvstatus *= v.number
			and v.type = "A"
			and (s.srvname like @server
				or s.srvnetname like @server)
update #spt_server
	set status = ""
		from master.dbo.sysservers s, #spt_server t
			where s.srvid = 0
				and s.srvname = t.name

select @len1 = max(datalength(network)),
       @len2 = max(datalength(status))
	from #spt_server

if (@len1 > 28 or @len2 > 11)
    select name, network_name = network, status, id = convert(char(4), id)
		from #spt_server
	order by name
else
    select name, network_name = convert(char(28), network), 
	status = convert(char(11), status), id = convert(char(4), id)
		from #spt_server
	order by name

return (0)
                                           
go

go
if exists (select * from sysobjects 
where name = "sp_markreport")
begin
	drop proc sp_markreport
end
go

/* Sccsid = "@(#) generic/sproc/src/markreport 52.1 8/12/92" */
/*	4.8	1.1	06/14/90	sproc/src/lock */

/*
** Messages for "sp_markreport"         17712
**
** 17712, "Report must be in your current database."
** 17713, "No such report exists."
*/

create procedure sp_markreport
@reportname varchar(92)		/* proc name we want to mark as report */
as

declare @msg  varchar(250)

/*
**  Make sure the @reportname is local to the current database.
*/
if @reportname like "%.%.%" and
	substring(@reportname, 1, charindex(".", @reportname) - 1) != db_name()
begin
	/*
	** 17712, "Report must be in your current database."
	*/
	exec sp_getmessage 17712, @msg output
	print @msg
	return (1)
end

/*
**  Make sure that it actually exists as a sproc.
*/
if not exists (select *
		from sysobjects
			where id = object_id(@reportname)
			and sysstat & 7 = 4	/* stored procedure */
			and uid = user_id())
begin
	/*
	** 17713, "No such report exists."
	*/
	exec sp_getmessage 17713, @msg output
	print @msg
	return (1)
end

update sysobjects
	set userstat = userstat | -32768	/* high bit means report */
		from sysobjects
			where id = object_id(@reportname)
			and sysstat & 7 = 4		/* stored procedure */
			and uid = user_id()

return (0)
                                              
go

go
if exists (select * from sysobjects 
where name = "sp_monitor")
begin
	drop proc sp_monitor
end
go

/* Sccsid = "@(#) generic/sproc/src/monitor 52.1 8/12/92" */
/*	4.8	1.1	06/14/90	sproc/src/lock */
create procedure sp_monitor
as

/*
**  Declare variables to be used to hold current monitor values.
*/
declare @now 		datetime
declare @cpu_busy 	int
declare @io_busy	int
declare @idle		int
declare @pack_received	int
declare @pack_sent	int
declare @pack_errors	int
declare @connections	int
declare @total_read	int
declare @total_write	int
declare @total_errors	int
declare @engonline	int
declare @oldcpu_busy 	int	/* used to see if DataServer has been rebooted */
declare @interval	int
declare @mspertick	int	/* milliseconds per tick */

/*
**  If we're in a transaction, disallow this since it might make recovery
**  impossible.
*/
if @@trancount > 0
begin
	print "Can't run sp_monitor from within a transaction."
	return (1)
end

/*
**  Set @mspertick.  This is just used to make the numbers easier to handle
**  and avoid overflow.
*/
select @mspertick = convert(int, @@timeticks / 1000.0)

/*
**  Set engonline to number of engines currently on line (so busy/idle
**  figures are correct). If this changes under us, the figures will not
**  necessarily be accurate for the next sp_monitor call; this should not
**  be a tremendous problem.
*/
 
select @engonline = count(*) from sysengines

/*
**  Get current monitor values.
*/
select
	@now = getdate(),
	@cpu_busy = @@cpu_busy,
	@io_busy = @@io_busy,
	@idle = @@idle,
	@pack_received = @@pack_received,
	@pack_sent = @@pack_sent,
	@connections = @@connections,
	@pack_errors = @@packet_errors,
	@total_read = @@total_read,
	@total_write = @@total_write,
	@total_errors = @@total_errors

/*
**  Check to see if DataServer has been rebooted.  If it has then the
**  value of @@cpu_busy will be less than the value of spt_monitor.cpu_busy.
**  If it has update spt_monitor.
*/
select @oldcpu_busy = cpu_busy
	from spt_monitor
if @oldcpu_busy > @cpu_busy
begin
	update spt_monitor
		set
			lastrun = @now,
			cpu_busy = @cpu_busy,
			io_busy = @io_busy,
			idle = @idle,
			pack_received = @pack_received,
			pack_sent = @pack_sent,
			connections = @connections,
			pack_errors = @pack_errors,
			total_read = @total_read,
			total_write = @total_write,
			total_errors = @total_errors
end

/*
**  Now print out old and new monitor values.
*/
set nocount on
select @interval = datediff(ss, lastrun, @now)
	from spt_monitor
/* To prevent a divide by zero error when run for the first
** time after boot up
*/
if @interval = 0
        select @interval = 1
select last_run = lastrun, current_run = @now, seconds = @interval
	from spt_monitor

select
	cpu_busy = convert(char(25), convert(varchar(11),
		convert(int, ((@cpu_busy * @mspertick) / 1000)))
		+ "("
		+ convert(varchar(11), convert(int, ((((@cpu_busy - cpu_busy)
		* @mspertick) / 1000)) / @engonline))
		+ ")"
		+ "-"
		+ convert(varchar(11), convert(int, (((((@cpu_busy - cpu_busy)
		* @mspertick) / 1000) / @engonline) * 100) / @interval))
		+ "%"),
	io_busy = convert(char(25), convert(varchar(11),
		convert(int, (((@io_busy * @mspertick) / 1000) / @engonline)))
		+ "("
		+ convert(varchar(11), convert(int, ((((@io_busy - io_busy)
		* @mspertick) / 1000) / @engonline)))
		+ ")"
		+ "-"
		+ convert(varchar(11), convert(int, (((((@io_busy - io_busy)
		* @mspertick) / 1000) / @engonline) * 100) / @interval))
		+ "%"),
	idle = convert(char(25), convert(varchar(11),
		convert(int, (((@idle * @mspertick) / 1000) / @engonline)))
		+ "("
		+ convert(varchar(11), convert(int, ((((@idle - idle)
		* @mspertick) / 1000) / @engonline)))
		+ ")"
		+ "-"
		+ convert(varchar(11), convert(int, (((((@idle - idle)
		* @mspertick) / 1000) / @engonline) * 100) / @interval))
		+ "%")
from spt_monitor

select
	packets_received = convert(char(25), convert(varchar(11), @pack_received) + "(" +
		convert(varchar(11), @pack_received - pack_received) + ")"),
	packets_sent = convert(char(25), convert(varchar(11), @pack_sent) + "(" +
		convert(varchar(11), @pack_sent - pack_sent) + ")"),
	packet_errors = convert(char(25), convert(varchar(11), @pack_errors) + "(" +
		convert(varchar(11), @pack_errors - pack_errors) + ")")
from spt_monitor

select
	total_read = convert(char(19), convert(varchar(11), @total_read) + "(" +
		convert(varchar(11), @total_read - total_read) + ")"),
	total_write = convert(char(19), convert(varchar(11), @total_write) + "(" +
		convert(varchar(11), @total_write - total_write) + ")"),
	total_errors = convert(char(19), convert(varchar(11), @total_errors) + "(" +
		convert(varchar(11), @total_errors - total_errors) + ")"),
	connections = convert(char(18), convert(varchar(11), @connections) + "(" +
		convert(varchar(11), @connections - connections) + ")")
from spt_monitor

/*
**  Now update spt_monitor
*/
update spt_monitor
	set
		lastrun = @now,
		cpu_busy = @cpu_busy,
		io_busy = @io_busy,
		idle = @idle,
		pack_received = @pack_received,
		pack_sent = @pack_sent,
		connections = @connections,
		pack_errors = @pack_errors,
		total_read = @total_read,
		total_write = @total_write,
		total_errors = @total_errors

return (0)
                               
go

go
if exists (select * from sysobjects 
where name = "sp_password")
begin
	drop proc sp_password
end
go

/* Sccsid = "@(#) generic/sproc/src/password 52.1 8/12/92" */
/*	4.8	1.1	06/14/90	sproc/src/password */

/*
** Messages for "sp_password"           17720
**
** 17260, "Can't run %1! from within a transaction."
** 17720, "Only System Administrator (SA) can use loginame option -- Password not changed."
** 17721, "No such login -- no password changed."
** 17722, "Old (current) password incorrect for user -- password not changed."
** 17723, "Password changed."
*/

create procedure sp_password
@old varchar(30) = NULL,		/* the old (current) password */
@new varchar(30),			/* the new password */
@loginame varchar(30) = NULL		/* user to change password on */
as

declare @suid int			/* suid of person to change pw on */
declare @msg  varchar(250)

/*
**  If we're in a transaction, disallow this since it might make recovery
**  impossible.
*/
if @@trancount > 0
begin
	/*
	** 17260, "Can't run %1! from within a transaction."
	*/
	exec sp_getmessage 17260, @msg output
	print @msg, "sp_password"
	return (1)
end

/*
**  If the system administrator (sa) is running this command, the sa can
**  change anyone's password and doesn't have to know the old password.
**  We have this case is suser_id() = 1 and @loginame is NOT NULL.
**  In this case, we'll fill in the old password and set the suid.
*/
if suser_id() != 1 and @loginame != NULL
begin
	/*
	**  Only the sa can use the @loginame.
	*/
	/*
	** 17720, "Only System Administrator (SA) can use loginame option -- Password not changed."
	*/
	exec sp_getmessage 17720, @msg output
	print @msg
	return (1)
end

/*
**  Does the SA want to change someone's password?
*/
if suser_id() = 1 and @loginame != NULL
begin
	/*  Check to see if the user exists. */
	select @suid = suid
		from syslogins
	where name = @loginame

	if @suid = NULL
	begin
		/*
		** 17721, "No such login -- no password changed."
		*/
		exec sp_getmessage 17721, @msg output
		print @msg
		return (1)
	end

	/*
	**  Get the old password for the user.  If @old not given, don't
	**  bother checking against the old password.
	*/
	if @old != null
	begin
		select @suid = suid
			from syslogins
		where name = @loginame and password = @old

		if @suid = NULL
		begin
			/*
			** 17722, "Old (current) password incorrect for user -- password not changed."
			*/
			exec sp_getmessage 17722, @msg output
			print @msg
			return (1)
		end
	end
end

/*
**  This is just the normal case when someone wants to change their own
**  password.  Set the @suid.
*/
else if @loginame = NULL
begin
	select @suid = suid
		from syslogins
	where password = @old
		and suid = suser_id()
end
if @suid = NULL
begin
	/*
	** 17722, "Old (current) password incorrect for user -- password not changed."
	*/
	exec sp_getmessage 17722, @msg output
	print @msg
	return (1)
end

/*
**  This is the final case.  The sa is running the command to change
**  someone else's password and is supplying the old password.  Confirm
**  that the old password is correct.
*/
if suser_id() = 1
begin
	select @suid = suid
		from syslogins
	where password = @old
		and suid = suser_id(@loginame)

	if @suid = NULL
	begin
		/*
		** 17722, "Old (current) password incorrect for user -- password not changed."
		*/
		exec sp_getmessage 17722, @msg output
		print @msg
		return (1)
	end
end

/*
**  If @suid still hasn't been set then the user running the procedure
**  doesn't have the right current password.
*/
if @suid = NULL
begin
	/*
	** 17722, "Old (current) password incorrect for user -- password not changed."
	*/
	exec sp_getmessage 17722, @msg output
	print @msg
	return (1)
end

/*
**  Everything is consistent so change the password.
*/
update syslogins
	set password = @new
		where suid = @suid

/*
** 17723, "Password changed."
*/
exec sp_getmessage 17723, @msg output
print @msg

return (0)
                                           
go

go
if exists (select * from sysobjects 
where name = "sp_placeobject")
begin
	drop proc sp_placeobject
end
go

/* Sccsid = "@(#) generic/sproc/src/placeobject 52.1 8/12/92" */
/*	4.8	1.1	06/14/90	sproc/src/password */

/*
** Messages for "sp_placeobject"        17730
**
** 17520, "There is no such segment as '%1!'."
** 17730, "Use sp_logdevice to move syslogs table."
** 17731, "You can't move system tables."
** 17732, "You do not own table '%1!'."
** 17733, "There is no table named '%1!'."
** 17734, "There is no index named '%1!' for table '%2!'."
** 17735, "'%1!' is now on segment '%2!'."
*/

create procedure sp_placeobject
@segname	varchar(30),	/* segment name */
@objname	varchar(62)	/* object name */
as

declare	@msg	varchar(250)
declare @objid	int
declare @tabname	varchar(30)
declare @indexname	varchar(30)
declare	@indexid	smallint
declare	@segment	smallint

/*
**  Check to see if the segment exists.
*/
select @segment = segment
		from syssegments
			where name = @segname
if @segment = null
begin
	/*
	** 17520, "There is no such segment as '%1!'."
	*/
	exec sp_getmessage 17520, @msg output
	print @msg, @segname
	return (1)
end

/*
**  Are we dealing with a table or it's index?
*/
if @objname like "%.%"
begin

	/*
	**  Get the table name out.
	*/
	select @tabname = substring(@objname, 1, charindex(".", @objname) - 1)
	select @indexname = substring(@objname, charindex(".", @objname) + 1, 61)
end
else
begin
	select @tabname = @objname, @indexname = null
end

/*
**  Can't use placeobject to move syslogs.
*/
if (object_id(@tabname) = 8)
begin
	/*
	** 17730, "Use sp_logdevice to move syslogs table."
	*/
	exec sp_getmessage 17730, @msg output
	print @msg
	return (1)
end

/*
**  Can't move system tables.
*/
if (object_id(@tabname) < 100)
begin
	/*
	** 17731, "You can't move system tables."
	*/
	exec sp_getmessage 17731, @msg output
	print @msg
	return (1)
end

/*
**  If the user is not the dbo or the SA, make sure he/she owns it.
*/
if suser_id() != 1 and user_id() != 1
begin
	if not exists (select *
			from sysobjects
				where name = @tabname
					and uid = user_id())
	begin
		/*
		** 17732, "You do not own table '%1!'."
		*/
		exec sp_getmessage 17732, @msg output
		print @msg, @tabname
		return (1)
	end
end
else
begin
	/*
	**  If dbo or SA, make sure the table exists.
	*/
	if not exists (select *
			from sysobjects
				where name = @tabname)
	begin
		/*
		** 17733, "There is no table named '%1!'."
		*/
		exec sp_getmessage 17733, @msg output
		print @msg, @tabname
		return (1)
	end
end

/*
**  If we are dealing with an index, make sure it exists.
*/
if @indexname != null and not exists (select *
					from sysindexes
						where id = object_id(@tabname)
							and name = @indexname)
begin
	/*
	** 17734, "There is no index named '%1!' for table '%2!'."
	*/
	exec sp_getmessage 17734, @msg output
	print @msg, @indexname, @tabname
	return (1)
end

/*
**  Everything's ok so change the segment for the object.
*/
if @indexname = null
begin
	select @indexid = indid
		from sysindexes
			where id = object_id(@tabname)
				and indid < 2
end
else
begin
	select @indexid = indid
		from sysindexes
			where id = object_id(@tabname)
				and name = @indexname
end

update sysindexes
set segment = @segment
	from sysindexes
		where id = object_id(@tabname)
			and indid = @indexid

declare @dbname	varchar(30)
select @dbname = db_name()
dbcc dbrepair (@dbname, remap)
/*
** 17735, "'%1!' is now on segment '%2!'."
*/
exec sp_getmessage 17735, @msg output
print @msg, @objname, @segname

return (0)
                                                                                                                                                
go

dump tran master with truncate_only

go

go
if exists (select * from sysobjects 
where name = "sp_primarykey")
begin
	drop proc sp_primarykey
end
go

/* Sccsid = "@(#) generic/sproc/src/primarykey 52.1 8/12/92" */
/*	4.8	1.1	06/14/90	sproc/src/password */

/*
** Messages for "sp_primarykey"         17740
**
** 17390, "Table or view name must be in 'current' database." 
** 17492, "The table or view named doesn't exist in the current database." 
** 17740, "Only the owner of the table may define a primary key."
** 17741, "Primary key already exists on table -- drop key first."
** 17742, "The table has no such first column."
** 17743, "The table has no such second column."
** 17744, "The table has no such third column."
** 17745, "The table has no such fourth column."
** 17746, "The table has no such fifth column."
** 17747, "The table has no such sixth column."
** 17748, "The table has no such seventh column."
** 17749, "The table has no such eighth column."
** 17750, "New primary key added."
*/

/*
** IMPORTANT NOTE:
** This stored procedure uses the built-in function object_id() in the
** where clause of a select query. If you intend to change this query
** or use the object_id() or db_id() builtin in this procedure, please read the
** READ.ME file in the $DBMS/generic/sproc directory to ensure that the rules
** pertaining to object-id's and db-id's outlined there, are followed.
*/

create procedure sp_primarykey
@tabname  varchar(92),			/* table name that has the key */
@col1     varchar(30), 			/* columns that make up the key */
@col2     varchar(30) = NULL,
@col3     varchar(30) = NULL,
@col4     varchar(30) = NULL,
@col5     varchar(30) = NULL,
@col6     varchar(30) = NULL,
@col7     varchar(30) = NULL,
@col8     varchar(30) = NULL
as

declare @uid smallint			/* owner id of the object */
declare @cnt smallint			/* howmany columns in key */
declare @key1 tinyint			/* colids of the columns in the key */
declare @key2 tinyint
declare @key3 tinyint
declare @key4 tinyint
declare @key5 tinyint
declare @key6 tinyint
declare @key7 tinyint
declare @key8 tinyint
declare @msg  varchar(250)

/*
**  Check to see that the tabname is local.
*/
if @tabname like "%.%.%" and
	substring(@tabname, 1, charindex(".", @tabname) - 1) != db_name()
begin
	/*
	** 17390, "Table or view name must be in 'current' database." 
	*/
	exec sp_getmessage 17390, @msg output
	print @msg
	return (1)
end

/*
**  See if we can find the object.  It must be a system table, user table,
**  or view.  The low 3 bits of sysobjects.sysstat indicate what the 
**  object type is -- it's more reliable than using sysobjects.type which
**  could change.
*/
if not exists (select *
	from sysobjects
		where id = object_id(@tabname)
			and (sysstat & 7 = 1		/* system table */
				or sysstat & 7 = 2	/* view */
				or sysstat & 7 = 3))	/* user table */
begin
	/*
	** 17492, "The table or view named doesn't exist in the current database." 
	*/
	exec sp_getmessage 17492, @msg output
	print @msg
	return (1)
end 

/*
**  Check to see that object owner is adding the key.
*/
select @uid = uid
	from sysobjects
		where id = object_id(@tabname)
			and (sysstat & 7 = 1            /* system table */
				 or sysstat & 7 = 2      /* view */
				  or sysstat & 7 = 3)     /* user table */
if @uid != user_id()
begin
	/*
	** 17740, "Only the owner of the table may define a primary key."
	*/
	exec sp_getmessage 17740, @msg output
	print @msg
	return (1)
end

/*
**  See if the primary key exists already.  Syskeys.type = 1 indicates
**  a primary key.
*/
if exists (select *
		from syskeys
			where id = object_id(@tabname)
				and type = 1)
begin
	/*
	** 17741, "Primary key already exists on table -- drop key first."
	*/
	exec sp_getmessage 17741, @msg output
	print @msg
	return (1)
end

/*
**  Now check out each column argument to verify it's existence.
*/
select @cnt = 1, @key1 = colid
	from syscolumns
		where name = @col1 
			and id = object_id(@tabname)
if @key1 is NULL
begin
	/*
	** 17742, "The table has no such first column."
	*/
	exec sp_getmessage 17742, @msg output
	print @msg
	return (1)
end

if @col2 != NULL
begin
	select @cnt = @cnt + 1, @key2 = colid
		from syscolumns
			where name = @col2 
				and id = object_id(@tabname)
	if @key2 is NULL
	begin
		/*
		** 17743, "The table has no such second column."
		*/
		exec sp_getmessage 17743, @msg output
		print @msg
		return (1)
	end
end
else goto doinsert

if @col3 != NULL
begin
	select @cnt = @cnt + 1, @key3 = colid
		from syscolumns
			where name = @col3 
				and id = object_id(@tabname)
	if @key3 is NULL
	begin
		/*
		** 17744, "The table has no such third column."
		*/
		exec sp_getmessage 17744, @msg output
		print @msg
		return (1)
	end
end
else goto doinsert

if @col4 != NULL
begin
	select @cnt = @cnt + 1, @key4 = colid
		from syscolumns
			where name = @col4 
				and id = object_id(@tabname)
	if @key4 is NULL
	begin
		/*
		** 17745, "The table has no such fourth column."
		*/
		exec sp_getmessage 17745, @msg output
		print @msg
		return (1)
	end
end
else goto doinsert

if @col5 != NULL
begin
	select @cnt = @cnt + 1, @key5 = colid
		from syscolumns
			where name = @col5 
				and id = object_id(@tabname)
	if @key5 is NULL
	begin
		/*
		** 17746, "The table has no such fifth column."
		*/
		exec sp_getmessage 17746, @msg output
		print @msg
		return (1)
	end
end
else goto doinsert

if @col6 != NULL
begin
	select @cnt = @cnt + 1, @key6 = colid
		from syscolumns
			where name = @col6 
				and id = object_id(@tabname)
	if @key6 is NULL
	begin
		/*
		** 17747, "The table has no such sixth column."
		*/
		exec sp_getmessage 17747, @msg output
		print @msg
		return (1)
	end
end
else goto doinsert

if @col7 != NULL
begin
	select @cnt = @cnt + 1, @key7 = colid
		from syscolumns
			where name = @col7 
				and id = object_id(@tabname)
	if @key7 is NULL
	begin
		/*
		** 17748, "The table has no such seventh column."
		*/
		exec sp_getmessage 17748, @msg output
		print @msg
		return (1)
	end
end
else goto doinsert

if @col8 != NULL
begin
	select @cnt = @cnt + 1, @key8 = colid
		from syscolumns
			where name = @col8 
				and id = object_id(@tabname)
	if @key8 is NULL
	begin
		/*
		** 17749, "The table has no such eighth column."
		*/
		exec sp_getmessage 17749, @msg output
		print @msg
		return (1)
	end
end

/*
**  Type 1 is a primary key, 2 is a foreignkey, and 3 is a commonjoin.
*/
doinsert:

insert into syskeys
	(id, type, depid, keycnt, size, key1, key2, key3, key4, key5,
		key6, key7, key8)
values (object_id(@tabname), 1, NULL, @cnt, 0, @key1, @key2, @key3, @key4, 
		@key5, @key6, @key7, @key8)   

/*
** 17750, "New primary key added."
*/
exec sp_getmessage 17750, @msg output
print @msg

return (0)
                                                                            
go

go
if exists (select * from sysobjects 
where name = "sp_recompile")
begin
	drop proc sp_recompile
end
go

/* Sccsid = "@(#) generic/sproc/src/recompile 52.1 8/12/92" */
/*	4.8	1.1	06/14/90	sproc/src/password */

/*
** Messages for "sp_recompile"          17760
**
** 17732, "You do not own table '%1!'." 
** 17390, "Table or view name must be in 'current' database."
** 17460, "Object must be in the current database."
** 17760, "'%1!' is a system table.  Sp_recompile cannot be used on system tables."
** 17761, "Object '%1!' is not a table."
** 17762, "Each stored procedure and trigger that uses table '%1!' will be recompiled the next time it is executed."
*/

/*
** IMPORTANT NOTE:
** This stored procedure uses the built-in function object_id() in the
** where clause of a select query. If you intend to change this query
** or use the object_id() or db_id() builtin in this procedure, please read the
** READ.ME file in the $DBMS/generic/sproc directory to ensure that the rules
** pertaining to object-id's and db-id's outlined there, are followed.
*/

create procedure sp_recompile
@objname	varchar(92)
as

declare @type	smallint
declare @uid		smallint
declare @msg    varchar(250)

if @objname like '%%.%%.%%'
begin
	/*
	** 17390, "Table or view name must be in 'current' database."
	*/
	exec sp_getmessage 17390, @msg output
	print @msg
	return
end

if not exists (select *
			from sysobjects
				where id = object_id(@objname))
begin
	/*
	** 17460, "Object must be in the current database."
	*/
	exec sp_getmessage 17460, @msg output
	print @msg
	return
end

select @type = sysstat & 7, @uid = uid
	from sysobjects
		where id = object_id(@objname)
if @type = 1
begin
	/*
	** 17760, "'%1!' is a system table.  Sp_recompile cannot be used on system tables."
	*/
	exec sp_getmessage 17760, @msg output
	print @msg, @objname
	return
end
if @type != 3
begin
	/*
	** 17761, "Object '%1!' is not a table."
	*/
	exec sp_getmessage 17761, @msg output
	print @msg, @objname
	return
end

if user_id() != 1 and @uid != user_id()
begin
	/*
	** 17732, "You do not own table '%1!'." 
	*/
	exec sp_getmessage 17732, @msg output
	print @msg, @objname
	return
end

set nocount on

update sysobjects
set schema = schema + 1
where id = object_id(@objname)

/*
** 17762, "Each stored procedure and trigger that uses table '%1!' will be recompiled the next time it is executed."
*/
exec sp_getmessage 17762, @msg output
print @msg, @objname
                                                                                                                                                                                                                                
go

go
if exists (select * from sysobjects 
where name = "sp_remoteoption")
begin
	drop proc sp_remoteoption
end
go

/* Sccsid = "@(#) generic/sproc/src/remoteoption 52.1 8/12/92" */
/*	4.8	1.1	06/14/90	sproc/src/password */

/*
** Messages for "sp_remoteoption"       17770
**
** 17513, "There is no remote user '%1!' mapped to local user '%2!' from
**	the remote server '%3!'."
** 17260, "Can't run %1! from within a transaction."
** 17770, "Settable remote login options."
** 17771, "There is no remote user '%1!' mapped to local user '%2!' on
**	remote server '%3!'."
** 17772, "Usage: sp_remoteoption [remoteserver, loginame, remotename,
**	optname, {true | false}]"
** 17773, "Remote login option doesn't exist or can't be set by user."
** 17774, "Run sp_remoteoption with no parameters to see options."
** 17775, "Remote login option is not unique."
** 17776, "Only the System Administrator (SA) may set remote login options."
** 17777, "Option '%1!' turned on."
** 17778, "Option '%1!' turned off."
** 17431, "true"
** 17432, "false"
*/

create procedure sp_remoteoption
@remoteserver varchar(30) = NULL,	/* server name to change */
@loginame varchar(30) = NULL,		/* user's remote name */
@remotename varchar(30) = NULL,		/* user's local user name */
@optname varchar(20) = NULL,		/* option name to turn on/off */
@optvalue varchar(10) = NULL		/* true or false */
as

declare @statvalue 	smallint	/* number of option */
declare @optcount 	int		/* number of options like @optname */
declare	@msg		varchar(100)
declare @suid		smallint
declare @rname  	varchar(30)
declare @lname  	varchar(30)
declare @true		varchar(10)
declare @false  	varchar(10)
declare @sptlang	int
declare @whichone	int		/* Which language */

select @sptlang = 0, @whichone = 0

if @@langid != 0
begin
	if not exists (
		select * from sysmessages where error
		between 17070 and 17079
		and langid = @@langid)
	    select @sptlang = 0
end

/*
**  If no @server given, just list the possible remote login options.
**  Only certain status bits may be set or cleared.  
**	   settable                	    not settable
**      ------------------------------  --------------------------
**	trusted (1)
*/
if @remoteserver = null
begin
	/*
	** 17770, "Settable remote login options."
	*/
	exec sp_getmessage 17770, @msg output
	print @msg
	if @sptlang = 0
	    select remotelogin_option = name
		from spt_values
			where type = "F"
				and number in (1, 1)
				and number > 0
		order by name
	else
	    select remotelogin_option = name, convert(char(22), description)
		from spt_values, sysmessages
			where type = "F"
				and number in (1, 1)
				and number > 0
				and msgnum = error
				and error between 17070 and 17079
				and langid = @sptlang
		order by name
	return (0)
end

/*
**  If @loginame is NULL then we want to set @suid = -1. Otherwise get
**  it real value.
*/
if @loginame = null
	select @suid = -1
else select @suid = suser_id(@loginame)

/*
**  Verify the server name, local, and remote names. 
*/
if not exists (select *
		from master.dbo.sysremotelogins r, master.dbo.sysservers s
			where r.remoteserverid = s.srvid
				and s.srvname = @remoteserver
				and r.remoteusername = @remotename
				and r.suid = @suid)
begin
	/*
	** 17771, "There is no remote user '%1!' mapped to local user '%2!' on
	**	remote server '%3!'."
	*/
	select @rname = isnull(@remotename, "NULL")
	select @lname = isnull(@loginame, "NULL")
	exec sp_getmessage 17771, @msg output
	print @msg, @rname, @lname, @remoteserver
	return (1)
end

/*
**  Check remaining parameters.
*/
/* 17431, "true" */
exec sp_getmessage 17431, @true out
/* 17432, "false" */
exec sp_getmessage 17432, @false out
if @optname is NULL or lower(@optvalue) not in 
	("true", "false", @true, @false) or @optvalue = null
begin
	/*
	** 17772, "Usage: sp_remoteoption [remoteserver, loginame, remotename,
	**	optname, {true | false}]"
	*/
	exec sp_getmessage 17772, @msg output
	print @msg
	return (1)
end

/*
**  Use @optname and try to find the right option.
**  If there isn't just one, print appropriate diagnostics and return.
*/
select @optcount = count(*)
 	   from spt_values
		where name like "%" + @optname + "%" and type = "F"
			and number in (1, 1)
			and number > 0

/*
** If option not found, and language not english, then check some more
*/
if @optcount = 0 and @sptlang != 0
begin
    select @optcount = count(*)
 	   from spt_values, sysmessages
		where description like "%" + @optname + "%" and type = "F"
			and number in (1, 1)
			and number > 0
			and error between 17070 and 17079
			and msgnum = error
			and langid = @sptlang
    select @whichone = 1
end

/*
**  If no option, show the user what the options are.
*/
if @optcount = 0
begin
	/*
	** 17773, "Remote login option doesn't exist or can't be set by user."
	*/
	exec sp_getmessage 17773, @msg output
	print @msg
	/*
	** 17774, "Run sp_remoteoption with no parameters to see options."
	*/
	exec sp_getmessage 17774, @msg output
	print @msg
	return (1)
end

/*
**  If more than one option like @optname, show the duplicates and return.
*/
if @optcount > 1
begin
	/*
	** 17775, "Remote login option is not unique."
	*/
	exec sp_getmessage 17775, @msg output
	print @msg

	if @sptlang = 0
	    select duplicate_option = name
		from spt_values
			where name like "%" + @optname + "%"
				and type = "F"
				and number in (1, 1)
				and number > 0
	else
	    select duplicate_option = name, convert(char(22), description)
		from spt_values, sysmessages
			where 
				(name like "%" + @optname + "%" 
				or description like "%" + @optname + "%")
				and type = "F"
				and number in (1, 1)
				and number > 0
				and error between 17070 and 17079
				and msgnum = error
				and langid = @sptlang

	return (1)
end

/*
**  Only the SA or the dbo of @dbnbame can execute the update part
**  of this procedure so check.  Also the sproc must be executed in the master
**  database.
*/
if suser_id() != 1
begin
	/*
	** 17776, "Only the System Administrator (SA) may set remote login options."
	*/
	exec sp_getmessage 17776, @msg output
	print @msg
	return (1)
end

/*
**  If we're in a transaction, disallow this since it might make recovery
**  impossible.
*/
if @@trancount > 0
begin
	/*
	** 17260, "Can't run %1! from within a transaction."
	*/
	exec sp_getmessage 17260, @msg output
	print @msg, "sp_remoteoption"
	return (1)
end

/*
**  Get the number which is the bit value to set
*/
if @whichone = 0
    select @statvalue = number
 	   from spt_values
		where name like "%" + @optname + "%" and type = "F"
			and number in (1, 1)
			and number > 0
else
    select @statvalue = number
 	   from spt_values, sysmessages
		where description like "%" + @optname + "%" 
			and type = "F"
			and number in (1, 1)
			and number > 0
			and error between 17070 and 17079
			and msgnum = error
			and langid = @sptlang

/*
**  Now update sysremotelogins.
*/
if lower(@optvalue) in ("true", @true)
begin
	update master.dbo.sysremotelogins
		set status = status | @statvalue
		from master.dbo.sysremotelogins r, master.dbo.sysservers s
			where r.remoteserverid = s.srvid
				and s.srvname = @remoteserver
				and r.remoteusername = @remotename
				and r.suid = @suid
	/*
	** 17777, "Option '%1!' turned on."
	*/
	exec sp_getmessage 17777, @msg output
	print @msg, @optname
	return (0)

end

/*
**  We want to turn it off.
*/
else
begin
	update master.dbo.sysremotelogins
		set status = status & ~@statvalue
		from master.dbo.sysremotelogins r, master.dbo.sysservers s
			where r.remoteserverid = s.srvid
				and s.srvname = @remoteserver
				and r.remoteusername = @remotename
				and r.suid = @suid
	/*
	** 17778, "Option '%1!' turned off."
	*/
	exec sp_getmessage 17778, @msg output
	print @msg, @optname
	return (0)
end

return (0)
                        
go

go
if exists (select * from sysobjects 
where name = "sp_rename")
begin
	drop proc sp_rename
end
go

/* Sccsid = "@(#) generic/sproc/src/rename 52.1 8/12/92" */
/*	4.8	1.1	06/14/90	sproc/src/password */

/*
** Messages for "sp_rename"             17780
**
** 17460, "Object must be in the current database."
** 17240, "'%1!' is not a valid name."
** 17780, "There is already a column named '%1!' in table '%2!'."
** 17781, "Column name has been changed."
** 17782, "You do not own a table or column (or index) of that name in the current database."
** 17783, "There is already an index named '%1!' for table '%2!'."
** 17784, "Index name has been changed."
** 17785, "Table or view names beginning with '#' are not allowed."
** 17786, "Object name cannot be changed either because it does not exist in this database, or you don't own it, or it is a system name."
** 17787, "Newname already exists in systypes."
** 17788, "Newname already exists in sysobjects."
** 17789, "Object name has been changed."
*/

/*
** IMPORTANT NOTE:
** This stored procedure uses the built-in function object_id() in the
** where clause of a select query. If you intend to change this query
** or use the object_id() or db_id() builtin in this procedure, please read the
** READ.ME file in the $DBMS/generic/sproc directory to ensure that the rules
** pertaining to object-id's and db-id's outlined there, are followed.
*/

create procedure sp_rename
@objname varchar(61),			/* old (current) object name */
@newname sysname(30)			/* new name we want to call it */
as

declare @objid int			/* object id of the thing to rename */
declare @msg varchar(250)

if @objname like "%.%.%"
begin
	/*
	** 17460, "Object must be in the current database."
	*/
	exec sp_getmessage 17460, @msg output
	print @msg
	return (1)
end

/*
**  Check to see that the @newname is valid.
*/
if valid_name(@newname) = 0
begin
	/*
	** 17240, "'%1!' is not a valid name."
	*/
	exec sp_getmessage 17240, @msg output
	print @msg, @newname
	return (1)
end

/*
**  Check to see if we are renaming a table/column (or table/index)
**  or a table or usertype.
**  If @objname is of the form table.column then it's a column.
**  In the column case, we need to extract and verify the table and
**  column names and make sure the user owns the table that is getting
**  the rule bound.
*/
if @objname like "%.%"
begin
	declare @tabname varchar(30)		/* name of table */
	declare @colname varchar(30)		/* name of column */
	declare @colid tinyint			/* colid of the column */

	/*
	**  Get the table name out.
	*/
	select @tabname = substring(@objname, 1, charindex(".", @objname) - 1)
	select @colname = substring(@objname, charindex(".", @objname) + 1, 61)

	/*
	**  Now check to see that the column exists in a table owned
	**  by the user.
	*/
	select @objid = syscolumns.id, @colid = syscolumns.colid
		from sysobjects, syscolumns
	where syscolumns.id = sysobjects.id
		and sysobjects.name = @tabname
		and syscolumns.name = @colname
		and (sysobjects.sysstat & 7 = 2		/* user table */
		or sysobjects.sysstat & 7 = 3)		/* view */
		and sysobjects.uid = user_id()

	/*
	**  Did we find it?  If not, it might be an index name so we'll
	**  check in the next case.
	*/
	if @objid != null
	begin
		/*
		**  Check to make sure that there is no already a column
		**  that has the new name.
		*/
		if exists (select *
				from syscolumns
					where id = @objid
						and name = @newname)
		begin
			/*
			** 17780, "There is already a column named '%1!' in table '%2!'."
			*/
			exec sp_getmessage 17780, @msg output
			print @msg, @newname, @tabname
			return (1)
		end

		/*
		**  Go ahead and change the column name.
		*/
		update syscolumns
			set name = @newname
				from syscolumns
			where id = @objid
				and colid = @colid

		/*
		** 17781, "Column name has been changed."
		*/
		exec sp_getmessage 17781, @msg output
		print @msg
		return (0)
	end

	/*
	**  Might be an index name.
	*/
	else
	begin
		select @objid = sysindexes.id, @colid = sysindexes.indid
			from sysobjects, sysindexes
		where sysindexes.id = sysobjects.id
			and sysobjects.name = @tabname
			and sysindexes.name = @colname
			and sysindexes.indid != 0
			and sysobjects.sysstat & 7 = 3	/* user table */
			and sysobjects.uid = user_id()

		/*
		**  If @objid is still NULL then that means it isn't an
		**  index name.  We checked above to see if it was a column
		**  name so now it's time to give up.
		*/
		if @objid = null
		begin
			/*
			** 17782, "You do not own a table or column (or index) of that name in the current database."
			*/
			exec sp_getmessage 17782, @msg output
			print @msg
			return (1)
		end

		/*
		**  Check to make sure that there is no already an index
		**  that has the new name.
		*/
		if exists (select *
				from sysindexes
					where id = @objid
						and name = @newname)
		begin
			/*
			** 17783, "There is already an index named '%1!' for table '%2!'."
			*/
			exec sp_getmessage 17783, @msg output
			print @msg, @newname, @tabname
			return (1)
		end

		/*
		**  Go ahead and change the index name.
		*/
		update sysindexes
			set name = @newname
				from sysindexes
			where id = @objid
				and indid = @colid

		/*
		** 17784, "Index name has been changed."
		*/
		exec sp_getmessage 17784, @msg output
		print @msg
		return (0)
	end
end

/*
**  Check to see if the object exists and is owned by the user.
**  It will either be in the sysobjects table or the systypes table.
**  Check sysobjects first.
**  System objects have ids < 100 and we don't allow their names to change.
*/
if exists (select id
	from sysobjects
		where id = object_id(@objname)
			and uid = user_id()
			and id > 99)

/*
**  Don't allow the newname to begin with #.
*/
begin
	if substring(@newname, 1, 1) = "#"
	begin
		/*
		** 17785, "Table or view names beginning with '#' are not allowed."
		*/
		exec sp_getmessage 17785, @msg output
		print @msg   
		return (1)
	end
end

/*
**  It's not in sysobjects so check systypes.
*/
else
begin
	select @objid = usertype
		from systypes
			where name = @objname
				and uid = user_id()
				and usertype > 99

	/*
	**  It's nowhere to be found so quit.
	*/
	if @objid is NULL
	begin
		/*
		** 17786, "Object name cannot be changed either because it does not exist in this database, or you don't own it, or it is a system name."
		*/
		exec sp_getmessage 17786, @msg output
		print @msg
		return (1)
	end

	/* Check that newname doesn't already exist. */
	if exists (select *
			from systypes
				where name = @newname)
	begin
		/*
		** 17787, "Newname already exists in systypes."
		*/
		exec sp_getmessage 17787, @msg output
		print @msg
		return (1)
	end

	/*
	** Change the name of a datatype
	*/
	update systypes
		set name = @newname
			where usertype = @objid

	return (0)
end

/*
**  It might be a table so update the index entry for the table IF it has
**  no clustered index.  No clustered index means that there is an entry
**  for the table under the @objid with indid = 0.
*/
begin transaction

	/* Check that newname doesn't already exist. */
	if exists (select *
			from sysobjects
				where name = @newname)
	begin
		/*
		** 17788, "Newname already exists in sysobjects."
		*/
		exec sp_getmessage 17788, @msg output
		print @msg
		rollback transaction
		return (1)
	end

	update sysobjects
		set name = @newname
			where id = object_id(@objname)

	 /*
 	 **	We also must update the object name in the descriptor
 	 **	otherwise, in the cache, the object would be under the
 	 **	old name.
 	 */
 	 dbcc chgobjname(@objname, @newname)
 
	 /*
	 **  This might not do anything -- only if we are dealing with a
	 **  table that has no clustered index.
	 **  Also change the name of the text entry, if any.
	 */
	 update sysindexes
		set name = @newname
			where id = object_id(@objname)
				and indid = 0
	 update sysindexes
		set name = "t" + @newname
			where id = object_id(@objname)
				and indid = 255
commit transaction

/*
** 17789, "Object name has been changed."
*/
exec sp_getmessage 17789, @msg output
print @msg

return (0)
                                                                                                                                                                                                                                  
go

go
if exists (select * from sysobjects 
where name = "sp_renamedb")
begin
	drop proc sp_renamedb
end
go

/* Sccsid = "@(#) generic/sproc/src/renamedb 52.1 8/12/92" */
/*	4.8	1.1	06/14/90	sproc/src/password */

/*
** Messages for "sp_renamedb"           17790
**
** 17260, "Can't run %1! from within a transaction." 
** 17590, "The specified database does not exist."
** 17240, "'%1!' is not a valid name."
** 17790, "Only the System Administrator (SA) can change the name of a database."
** 17791, "A database with the new name already exists."
** 17792, "The databases 'master', 'model', and 'tempdb' cannot be renamed."
** 17793, "System Administrator (SA) must set database '%1!' to single-user mode with sp_dboption before using sp_renamedb."
** 17794, "Database is renamed and in single-user mode."
** 17795, "System Administrator (SA) must reset it to multi-user mode with sp_dboption."
*/


/*
** IMPORTANT NOTE:
** This stored procedure uses the built-in function db_id() in the
** where clause of a select query. If you intend to change this query
** or use the object_id() or db_id() builtin in this procedure, please read the
** READ.ME file in the $DBMS/generic/sproc directory to ensure that the rules
** pertaining to object-id's and db-id's outlined there, are followed.
*/

create procedure sp_renamedb
@dbname sysname(30),			/* old (current) db name */
@newname sysname(30)			/* new name we want to call it */
as

declare @msg varchar(250)
declare @bitdesc varchar(30)		/* bit description for the db */

/*
**  If we're in a transaction, disallow this since it might make recovery
**  impossible.
*/
if @@trancount > 0
begin
	/*
	** 17260, "Can't run %1! from within a transaction." 
	*/
	exec sp_getmessage 17260, @msg output
	print @msg, "sp_renamedb"
	return (1)
end

/*
**  Only the SA can do this.
*/
if suser_id() != 1
begin
	/*
	** 17790, "Only the System Administrator (SA) can change the name of a database."
	*/
	exec sp_getmessage 17790, @msg output
	print @msg
	return (1)
end

/*
**  Make sure the database exists.
*/
if not exists (select *
		from master.dbo.sysdatabases
			where name = @dbname)
begin
	/*
	** 17590, "The specified database does not exist."
	*/
	exec sp_getmessage 17590, @msg output
	print @msg
	return (1)
end

/*
**  Make sure that the @newname db doesn't already exist.
*/
if exists (select *
		from master.dbo.sysdatabases
			where name = @newname)
begin
	/*
	** 17791, "A database with the new name already exists."
	*/
	exec sp_getmessage 17791, @msg output
	print @msg
	return (1)
end

/*
**  Check to see that the @newname is valid.
*/
if valid_name(@newname) = 0
begin
	/*
	** 17240, "'%1!' is not a valid name."
	*/
	exec sp_getmessage 17240, @msg output
	print @msg, @newname
	return (1)
end

/*
**  Don't allow the names of master, tempdb, and model to be changed.
*/
if @dbname in ("master", "model", "tempdb")
begin
	/*
	** 17792, "The databases 'master', 'model', and 'tempdb' cannot be renamed."
	*/
	exec sp_getmessage 17792, @msg output
	print @msg
	return (1)
end


/* 
** Check single user bit (4096) 
** Database must be in single user mode to necessitate the rid update in the
** database's DBTABLE
*/ 
select @bitdesc = null 
select @bitdesc = v.name
        from spt_values v, master.dbo.sysdatabases d 
                where d.dbid = db_id(@dbname) 
                        and v.type = "D" 
                        and d.status & v.number = 4096 
if @bitdesc = null 
begin 
	/*
	** 17793, "System Administrator (SA) must set database '%1!' to single-user mode with sp_dboption before using sp_renamedb."
	*/
	exec sp_getmessage 17793, @msg output
	print @msg, @dbname
        return(1)  
end  

/*
**  Everything is ok so do it.
**
**  First update the dbinfo in the sysindexes row for syslogs
**  of the database whose name is being changed. Then change
**  the corresponding entry in sysdatabases.
*/
dbcc chgdbname (@dbname, @newname)

update master.dbo.sysdatabases
	set name = @newname
		where name = @dbname

/*
** 17794, "Database is renamed and in single-user mode."
*/
exec sp_getmessage 17794, @msg output
print @msg

/*
** 17795, "System Administrator (SA) must reset it to multi-user mode with sp_dboption."
*/
exec sp_getmessage 17795, @msg output
print @msg

return (0)
                                                                                                                                                                                   
go

go
if exists (select * from sysobjects 
where name = "sp_serverinfo")
begin
	drop proc sp_serverinfo
end
go

/* Sccsid = "@(#) generic/sproc/serverinfo 52.1 8/12/92" */

/*
** Messages for "sp_serverinfo"         17796
**
** 17796, "Legal request codes are as follows:"
*/

create procedure sp_serverinfo
@request	varchar(30) = NULL,
@arg1		varchar(30) = NULL,	/* optional arg1 */
@arg2		varchar(30) = NULL,	/* optional arg2 */
@arg3		varchar(30) = NULL,	/* optional arg3 */
@arg4		varchar(30) = NULL,	/* optional arg4 */
@arg5		varchar(30) = NULL,	/* optional arg5 */
@arg6		varchar(30) = NULL,	/* optional arg6 */
@arg7		varchar(30) = NULL,	/* optional arg7 */
@arg8		varchar(30) = NULL,	/* optional arg8 */
@arg9		varchar(30) = NULL	/* optional arg9 */
as

declare @csid		int		/* character set id */
declare @soid		int		/* sort order id */
declare @msg            varchar(250)

set nocount on

if (@request is null  or  @request = "help")
begin
	/*
	** 17796, "Legal request codes are as follows:"
	*/
	exec sp_getmessage 17796, @msg output
	print @msg
	print "    server_csname"
	print "    server_soname"
	print "    csdefinition"
	print "    sodefinition"
	return (9)
end

if (@request = "server_csname")
    begin
	/*
	** User wants the name of the server's default character set.
	** No additional arguments required.
	*/
	select @csid = value
	from master.dbo.syscurconfigs
	where config = 131

	select name
	from master.dbo.syscharsets
	where id = @csid and type between 1000 and 1999

	return (0)
    end
else if (@request = "server_soname")
    begin
	/*
	** User wants the name of the server's default sort order.
	** No additional arguments required.
	*/
	select @soid = value
	from master.dbo.syscurconfigs
	where config = 123

	select @csid = value
	from master.dbo.syscurconfigs
	where config = 131

	select name
	from master.dbo.syscharsets
	where id = @soid and csid = @csid and type between 2000 and 2999

	return (0)
    end
else if (@request = "csdefinition")
    begin
	/*
	** User wants the type, id, and definition (IMAGE field) of the
	** character set specified in "@arg1".
	*/
	select @csid = id
	from master.dbo.syscharsets
	where name = @arg1

	set textsize 32768

	select type, id, definition
	from master.dbo.syscharsets
	where id = @csid and type between 1000 and 1999

	return (0)
    end
else if (@request = "sodefinition")
    begin
	/*
	** User wants the name of the server's character set.
	** No additional arguments required.
	*/
	/*
	** User wants the definition (IMAGE field) of the sort order which
	** is the logical equivalent to the server's default sort order,
	** except based on the character set specified in "@arg1".
	*/
	select @soid = value
	from master.dbo.syscurconfigs
	where config = 123

	select @csid = id
	from master.dbo.syscharsets
	where name = @arg1 and type between 1000 and 1999

	select definition
	from master.dbo.syscharsets
	where id = @soid and csid = @csid and type between 2000 and 2999

	return (0)
    end
else
    begin
	/*
	** Unknown request code.
	*/
	return (1)
    end
                                                                                                                      
go

go
if exists (select * from sysobjects 
where name = "sp_serveroption")
begin
	drop proc sp_serveroption
end
go

/* Sccsid = "@(#) generic/sproc/src/serveroption 52.1 8/12/92" */
/*	4.8	1.1	06/14/90	sproc/src/serveroption */

/*
** Messages for "sp_serveroption"       17800
**
** 17260, "Can't run %1! from within a transaction." 
** 17800, "No such server -- run sp_helpserver to list servers."
** 17801, "Usage: sp_serveroption [server, optname, {true | false}]"
** 17802, "Server option doesn't exist or can't be set by user."
** 17803, "Run sp_serveroption with no parameters to see options."
** 17804, "Server option is not unique."
** 17805, "Only the System Administrator (SA) may set server options."
** 17806, "Option can be set for remote servers only -- not the local server."
** 17807, "Settable server options."
** 17431, "true"
** 17432, "false"
*/

create procedure sp_serveroption
@server varchar(30) = NULL,		/* server name to change */
@optname varchar(20) = NULL,		/* option name to turn on/off */
@optvalue varchar(10) = NULL		/* true or false */
as

declare @srvid int			/* id of the server */
declare @statvalue smallint		/* number of option */
declare @optcount int			/* number of options like @optname */
declare @msg varchar(250) 
declare @true varchar(10) 
declare @false varchar(10) 

/*
**  If no @server given, just list the possible server options.
**  Only certain status bits may be set or cleared.  
**  The default is to allow timeouts (bit 0 is clear).
**	   settable                	    not settable
**      ------------------------------  --------------------------
**	  timeouts (0)
*/
if @server = null
begin
	/* 17807, "Settable server options." */
	exec sp_getmessage 17807, @msg out
	print @msg
	select "" = name
		from spt_values
			where type = "A"
				and number not in (-1, 1)
		order by name
	return (0)
end

/*
**  Verify the server name and get the @srvid
*/
select @srvid = srvid
	from master.dbo.sysservers
		where srvname = @server

/*
**  If @server not found, say so. 
*/
if @srvid = NULL
begin
	/*
	** 17800, "No such server -- run sp_helpserver to list servers."
	*/
	exec sp_getmessage 17800, @msg output
	print @msg
	return (1)
end

/*
**  Check remaining parameters.
*/
/* 17431, "true" */
exec sp_getmessage 17431, @true out
/* 17432, "false" */
exec sp_getmessage 17432, @false out
if @optname is NULL or lower(@optvalue) not in 
	("true", "false", @true, @false) or @optvalue = null
begin
	/*
	** 17801, "Usage: sp_serveroption [server, optname, {true | false}]"
	*/
	exec sp_getmessage 17801, @msg output
	print @msg
	return (1)
end

/*
**  Use @optname and try to find the right option.
**  If there isn't just one, print appropriate diagnostics and return.
*/
select @optcount = count(*)
 	   from spt_values
		where name like "%" + @optname + "%" and type = "A"
			and number not in (-1, 1)

/*
**  If no option, show the user what the options are.
*/
if @optcount = 0
begin
	/*
	** 17802, "Server option doesn't exist or can't be set by user."
	*/
	exec sp_getmessage 17802, @msg output
	print @msg
	/*
	** 17803, "Run sp_serveroption with no parameters to see options."
	*/
	exec sp_getmessage 17803, @msg output
	print @msg
	return (1)
end

/*
**  If more than one option like @optname, show the duplicates and return.
*/
if @optcount > 1
begin
	/*
	** 17804, "Server option is not unique."
	*/
	exec sp_getmessage 17804, @msg output
	print @msg

	select duplicate_option = name
		from spt_values
			where name like "%" + @optname + "%"
				and type = "A"
				and number not in (-1, 1)

	return (1)
end

/*
**  Only the SA or the dbo of @dbnbame can execute the update part
**  of this procedure so check.  Also the sproc must be executed in the master
**  database.
*/
if suser_id() != 1
begin
	/*
	** 17805, "Only the System Administrator (SA) may set server options."
	*/
	exec sp_getmessage 17805, @msg output
	print @msg
	return (1)
end

/*
**  Currently there is only one option that can be set -- no timeouts --
**  and it only applies to remote servers.  If the current server is
**  local then reject it.
*/
if @srvid = 0
begin
	/*
	** 17806, "Option can be set for remote servers only -- not the local server."
	*/
	exec sp_getmessage 17806, @msg output
	print @msg
	return (1)
end


/*
**  If we're in a transaction, disallow this since it might make recovery
**  impossible.
*/
if @@trancount > 0
begin
	/* 
	** 17260, "Can't run %1! from within a transaction." 
	*/
	exec sp_getmessage 17260, @msg output
	print @msg, "sp_serveroption"
	return (1)
end
/*
**  Get the number which is the bit value to set
*/
select @statvalue = number
 	   from spt_values
		where name like "%" + @optname + "%" and type = "A"
			and number > 0


/*
**  Now update sysservers.
**  The timeouts option is handled a little strangely since the default
**  is timeouts.  Therefore timeouts = true means to clear the bit
**  and timeouts = false means to set the bit.
*/
if lower(@optvalue) in ("true", @true)
begin
	update sysservers
		set srvstatus = srvstatus & ~@statvalue
			where srvid = @srvid
end

/*
**  We want to turn it off.
*/
else
begin
	update sysservers
		set srvstatus = srvstatus | @statvalue
			where srvid = @srvid
end

return (0)
 
go

go
if exists (select * from sysobjects 
where name = "sp_setreplicate")
begin
	drop proc sp_setreplicate
end
go

/* Sccsid = "@(#) generic/sproc/setreplicate 52.1 8/12/92" */
/*
** Messages for "sp_setreplicate"	17960
**
** 17230, "Only the System Administrator (SA) or the Database Owner
**	   (dbo) may execute this stored procedure."
** 17460, "Object must be in the current database."
** 17461, "Object does not exist in this database."
** 17431, "true"
** 17432, "false"
** 17960, "Replication Server support is not enabled.  Replication
**	   Server support must be enabled before you can change the
**	   replication status of '%1!'."
** 17961, "Usage: sp_setreplicate object_name, {true | false}"
** 17962, "The replication status for '%1!' is already set to %2!.
	   Replication status for '%3!' does not change."
** 17963, "An object with the same name, but owned by a different user
**	   is already being replicated.  The object '%1!' cannot be
**	   replicated."
** 17964, "The replication status for '%1!' is set to %2!."
*/
create procedure sp_setreplicate
@replicate_name	varchar(92),	/* proc or table we want to mark as replicate */
@setflag 	varchar(5)	/* set or unset the replicate status. */
as

declare @current_status	smallint /* current sysstat value for the object. */
declare @new_status	smallint /* new sysstat value for the object. */
declare @rep_constant 	smallint /* bit which indicates a replicated object. */
declare @db		varchar(30) 	/* db of object. */
declare @owner		varchar(30) 	/* owner of object. */
declare @object		varchar(30)	/* object's name. */
declare @true		varchar(10)
declare @false		varchar(10)
declare @msg 		varchar(200)

select @rep_constant = -32768

/*
**  You must be SA or the dbo to execute this sproc.
*/
if ((suser_id() != 1) and (user_id() != 1))
begin
	/*
	** 17230, "Only the System Administrator (SA) or the Database Owner (dbo) may execute this stored procedure."
	*/
	exec sp_getmessage 17230, @msg output
	print @msg
	return (1)
end

/*
** Crack the name into its corresponding pieces.
*/
execute sp_namecrack 	@replicate_name, 
			@db = @db output, 
			@owner = @owner output,
			@object = @object output

/*
** Make sure that the object is in the current database.
*/
if (@db != NULL and @db != db_name())
begin
	/*
	** 17460, "Object must be in the current database."
	*/
        exec sp_getmessage 17460, @msg output
        print @msg
	return (1)
end

/*
**  Make sure that the object actually exists.
*/
if (object_id(@replicate_name) = NULL)
begin
	/*
	** 17461, "Object does not exist in this database."
	*/
	exec sp_getmessage 17461, @msg output
	print @msg
	return (1)
end

/*
** Make sure that replication is enabled on this server.
*/

dbcc is_replication_enabled
if @@error != 0
begin
	/*
	** 17960 "Replication Server support is not enabled.  Replication
	**	  Server support must be enabled before you can change
	**	  the replication status of '%1!'."
	*/
	exec sp_getmessage 17960, @msg output
	print @msg, @replicate_name
	return (1)
end

/*
** Check for a valid setname parameter
*/
/* 17431, "true" */
exec sp_getmessage 17431, @true out
/* 17432, "false" */
exec sp_getmessage 17432, @false out
if (lower(@setflag) not in ("true", "false", @true, @false))
begin
	/*
	** 17961 "Usage: sp_setreplicate object_name, {true | false}"
	*/
	exec sp_getmessage 17961, @msg output
	print @msg
	return (1)
end

/*
** Get the object's current status. Hold a read lock on sysobjects so that 
**	the status cannot be changed until we're done.
*/
select @current_status = sysstat 
	from sysobjects holdlock
		where id = object_id(@replicate_name)

/*
** Perform the requested operation on the object.
*/
if lower(@setflag) in ("false", @false)
begin
	/*
	** Is the replicate status bit even set?
	*/
	if (@current_status & @rep_constant) = 0
	begin
		/*
		** 17962 "The replication status for '%1!' is already
		**	  set to %2!.  Replication status for '%3!'
		**	  does not change."
		*/
		exec sp_getmessage 17962, @msg output
		print @msg, @replicate_name, @setflag, @replicate_name
		return(1)
	end

	/*
	** Update the sysstat column to not include the rep_constant bit.
	*/
	update sysobjects
		set sysstat = sysstat & ~@rep_constant
			where id = object_id(@replicate_name)

	/*
	** Update the object's status in cache.
	*/
	dbcc setreplicate(@replicate_name, 0)
end
else
begin
	/*
	** Is the replicate status bit already set?
	*/
	if (@current_status & @rep_constant) != 0
	begin
		/*
		** 17962 "The replication status for '%1!' is already
		**	  set to %2!.  Replication status for '%3!'
		**	  does not change."
		*/
		exec sp_getmessage 17962, @msg output
		print @msg, @replicate_name, @setflag, @replicate_name
		return(1)
	end

	/*
	** Make sure that no like object with the same name, but a
	** different owner, exists.  We need to do this because
	** the SQL Server does not send owner information along
	** with the object to the Replication Server.  This
	** restriction may be lifted in future versions.
	*/
	if exists (select * from sysobjects
			where name = @object
			and (
				(type = "U ") /* user table */
			or
				(type = "P ") /* stored procedure */
			)
			and sysstat & @rep_constant != 0)
	begin
		/*
		** 17963 "An object with the same name, but owned by a
		**	  different user is already being replicated.
		**	  The object '%1!' cannot be replicated."
		*/
		exec sp_getmessage 17963, @msg output
		print @msg, @replicate_name
		return(1)
	end

	/*
	** Update the sysstat column to include the rep_constant bit.
	*/
	update sysobjects
		set sysstat = sysstat | @rep_constant
			from sysobjects
				where id = object_id(@replicate_name)

	/*
	** Update the object's status in cache.
	*/
	dbcc setreplicate(@replicate_name, 1)
end

/*
** 17964 "The replication status for '%1!' is set to %2!."
*/
exec sp_getmessage 17964, @msg output
print @msg, @replicate_name, @setflag
return(0)
                                                                                       
go

go
if exists (select * from sysobjects 
where name = "sp_spaceused")
begin
	drop proc sp_spaceused
end
go

/* Sccsid = "@(#) generic/sproc/spaceused 52.1 8/12/92" */
/*	4.8	1.1	06/14/90	sproc/src/spaceused */
 
/*
** Messages for "sp_spaceused"          17830
**
** 17460, "Object must be in the current database." 
** 17461, "Object does not exist in this database."
** 17830, "Object is stored in 'sysprocedures' and
** 	   has no space allocated directly."
** 17831, "Views don't have space allocated."
** 17832, "Not avail."
*/


/*
** IMPORTANT NOTE:
** This stored procedure uses the built-in function object_id() in the
** where clause of a select query. If you intend to change this query
** or use the object_id() or db_id() builtin in this procedure, please read the
** READ.ME file in the $DBMS/generic/sproc directory to ensure that the rules
** pertaining to object-id's and db-id's outlined there, are followed.
*/

create procedure sp_spaceused
@objname varchar(92) = null		/* the object we want size on */
as

declare @type	smallint		/* the object type */
declare @msg	varchar(250)		/* message output */
declare @dbname varchar(30)             /* database name */
declare @tabname varchar(30)            /* table name */
declare @length	int

/*
**  Check to see that the objname is local.
*/
if @objname != null
begin
	/*
        ** Get the dbname and ensure that the object is in the
        ** current database. Also get the table name - this is later
        ** needed to see if information is being requested for syslogs.
        */
        execute sp_namecrack @objname,
                             @db = @dbname output,
                             @object = @tabname output
        if @dbname != NULL
	begin
		/*
		** 17460, "Object must be in the current database." 
		*/
		if (@dbname != db_name())
		begin
			exec sp_getmessage 17460, @msg output
			print @msg
			return (1)
		end
	end

	/*
	**  Does the object exist?
	*/
	if not exists (select *
                        from sysobjects
                                where id = object_id(@objname))
	begin
		/*
		** 17461, "Object does not exist in this database."
		*/
		exec sp_getmessage 17461, @msg output
	        print @msg
		return (1)
	end

	/* Get the object type */
        select @type = sysstat & 7
                from sysobjects
                        where id = object_id(@objname)
	/*
	**  See if it's a space object.
	**  types are:
	**	0 - trigger
	**	1 - system table
	**	2 - view
	**	3 - user table
	**	4 - sproc
	**	6 - default
	**	7 - rule
	*/
	if not exists (select *
			from sysindexes
				where id = object_id(@objname)
					and indid < 2)
	begin
		if @type in (0, 4, 6, 7)
		begin
			/*
			** 17830, "Object is stored in 'sysprocedures' and
			** 	   has no space allocated directly."
			*/
			exec sp_getmessage 17830, @msg output
		        print @msg
			return (1)
		end

		if @type = 2
		begin
			/*
			** 17831, "Views don't have space allocated."
			*/
			exec sp_getmessage 17831, @msg output
		        print @msg
			return (1)
		end
	end

end

/*
**  If @objname is null, then we want summary data.
*/
set nocount on
if @objname = null
begin
	declare @slog_res_pgs int,  	/* number of reserved pgs. in syslogs */
		@slog_dpgs int, 	/* number of data pages in syslogs */
		@slog_unused int    	/* number of unused pages in syslogs */
	
	select distinct database_name = db_name(), database_size =
		convert(char(20), convert(varchar(10), (sum(size) * d.low) / 1048576)
			+ " " + "MB")
		from master.dbo.sysusages, master.dbo.spt_values d
			where dbid = db_id()
				and d.number = 1
				and d.type = "E"
			having dbid = db_id()
				and d.number = 1
				and d.type = "E"

	/*
	** Obtain the page count for syslogs table. 
	*/
	select @slog_res_pgs = reserved_pgs(id, doampg),
		@slog_dpgs = data_pgs(id, doampg),
		@slog_unused = ((reserved_pgs(id, doampg) +
			   reserved_pgs(id, ioampg)) - 
			   (data_pgs(id, doampg) + data_pgs(id, ioampg)))
	from sysindexes where id = 8

	/*
	** Obtain the page count for all the objects in the current
	** database; except for 'syslogs' (id = 8). Store the results
	** in a temp. table (#pgcounts).
	*/
	select distinct
		sysindexes.name,
		res_pgs = (reserved_pgs(id, doampg) + reserved_pgs(id, ioampg)),
		low = d.low,
		dpgs = data_pgs(id, doampg),
		ipgs = data_pgs(id, ioampg), 
		unused = ((reserved_pgs(id, doampg) +
			   reserved_pgs(id, ioampg)) - 
			   (data_pgs(id, doampg) + data_pgs(id, ioampg)))
	into #pgcounts 
	from sysindexes, master.dbo.spt_values d
		where sysindexes.id != 8
			and d.number = 1 
			and d.type = "E" 
		having d.number = 1
			and d.type = "E"
	
	/*
	** Compute the summary results by adding page counts from
	** individual data objects. Add to the count the count of 
	** pages for 'syslogs'.  Convert the total pages to space
	** used in Kilo bytes.
	*/
	select distinct reserved = convert(char(15), convert(varchar(11),
		((sum(res_pgs) + @slog_res_pgs) * low) / 1024) + " " + "KB"),
		data = convert(char(15), convert(varchar(11),
		((sum(dpgs) + @slog_dpgs) * low) / 1024) + " " + "KB"),
		index_size = convert(char(15), convert(varchar(11),
		(sum(ipgs) * low) / 1024) + " " + "KB"),
		unused = convert(char(15), convert(varchar(11),
		((sum(unused) + @slog_unused) * low) / 1024) + " " + "KB")
	from #pgcounts
end

/*
**  We want a particular object.
*/
else
begin
	if (@tabname = "syslogs") /* syslogs */
	begin
		/*
		** 17832, "Not avail."
		*/
		exec sp_getmessage 17832, @msg output

		select @length = max(datalength(o.name))
		    from sysobjects o, sysindexes i
			where i.id = object_id(@objname)
				and o.id = object_id(@objname)

		if (@length > 20)
		    select name = o.name,
			rows = convert(char(11), @msg),
			reserved = convert(char(10), convert(varchar(11),
			(reserved_pgs(i.id, i.doampg) * d.low) / 1024) + 
				" " + "KB"),
			data = convert(char(10), convert(varchar(11),
			((data_pgs(i.id, i.doampg) * d.low) / 1024)) 
				+ " " + "KB"),
			index_size = convert(char(10), convert(varchar(11), 0) 
				+ " " + "KB"),
			unused = convert(char(10), convert(varchar(11),
			(((reserved_pgs(i.id, i.doampg) +
			   reserved_pgs(i.id, i.ioampg))
			   - (data_pgs(i.id, i.doampg) +
			      data_pgs(i.id, i.ioampg))) 
				* d.low) / 1024) + 
				" " + "KB")
			from sysobjects o, sysindexes i,
			     master.dbo.spt_values d
				where i.id = object_id(@objname)
					and o.id = object_id(@objname)
					and d.number = 1
					and d.type = "E"
		else
		    select name = convert(char(20), o.name),
			rows = convert(char(11), @msg),
			reserved = convert(char(10), convert(varchar(11),
			(reserved_pgs(i.id, i.doampg) * d.low) / 1024) + 
				" " + "KB"),
			data = convert(char(10), convert(varchar(11),
			((data_pgs(i.id, i.doampg) * d.low) / 1024)) 
				+ " " + "KB"),
			index_size = convert(char(10), convert(varchar(11), 0) 
				+ " " + "KB"),
			unused = convert(char(10), convert(varchar(11),
			(((reserved_pgs(i.id, i.doampg) +
			   reserved_pgs(i.id, i.ioampg))
			   - (data_pgs(i.id, i.doampg) +
			      data_pgs(i.id, i.ioampg))) 
				* d.low) / 1024) + 
				" " + "KB")
			from sysobjects o, sysindexes i,
			     master.dbo.spt_values d
				where i.id = object_id(@objname)
					and o.id = object_id(@objname)
					and d.number = 1
					and d.type = "E"

	end
	else
	begin
		select name = o.name,
			rows = rowcnt(i.doampg),
			reserved = 
			(reserved_pgs(i.id, i.doampg) +
			 reserved_pgs(i.id, i.ioampg)) * d.low,
			data = data_pgs(i.id, i.doampg) *d.low,
			index_size = data_pgs(i.id, i.ioampg) *d.low,
			unused = 
			((reserved_pgs(i.id, i.doampg)
			   + reserved_pgs(i.id, i.ioampg))
			   - (data_pgs(i.id, i.doampg) +
			      data_pgs(i.id, i.ioampg))) * d.low
		into #pagecounts
		from sysobjects o, sysindexes i, master.dbo.spt_values d
				where i.id = object_id(@objname)
					and o.id = object_id(@objname)
					and d.number = 1
					and d.type = "E"

	    select @length = max(datalength(name))
		from #pagecounts

	    if (@length > 20)
	        select distinct name,
		    rows = convert(char(11), sum(rows)),
		    reserved = convert(char(10), convert(varchar(11),
		    sum(reserved) / 1024) + " " + "KB"),
		    data = convert(char(10), convert(varchar(11),
		    sum(data) / 1024) + " " + "KB"),
		    index_size = convert(char(10), convert(varchar(11),
		    sum(index_size) / 1024) + " " + "KB"),
		    unused = convert(char(10), convert(varchar(11),
		    sum(unused) / 1024) + " " + "KB")
	        from #pagecounts
	    else
	        select distinct name = convert(char(20), name),
		    rows = convert(char(11), sum(rows)),
		    reserved = convert(char(10), convert(varchar(11),
		    sum(reserved) / 1024) + " " + "KB"),
		    data = convert(char(10), convert(varchar(11),
		    sum(data) / 1024) + " " + "KB"),
		    index_size = convert(char(10), convert(varchar(11),
		    sum(index_size) / 1024) + " " + "KB"),
		    unused = convert(char(10), convert(varchar(11),
		    sum(unused) / 1024) + " " + "KB")
	        from #pagecounts
	end
end
return (0)
    
go

go
if exists (select * from sysobjects 
where name = "sp_unbindefault")
begin
	drop proc sp_unbindefault
end
go

/* Sccsid = "@(#) generic/sproc/src/unbindefault 52.1 8/12/92" */
/*	4.8	1.1	06/14/90	sproc/src/serveroption */
 
/*
** Messages for "sp_unbindefault"       17840
** 17840, "Column or usertype must be in 'current' database."
** 17841, "Default unbound from table column."
** 17842, "The specified column has no default."
** 17843, "You do not own a table with a column of that name."
** 17844, "You do not own a user datatype of that name."
** 17845, "The specified user datatype has no default."
** 17846, "Default unbound from datatype."
** 17847, "Columns of the user datatype specified had their defaults unbound."
*/

create procedure sp_unbindefault
@objname varchar(61),			/* table/column or datatype name */
@futureonly varchar(15) = NULL		/* flag to indicate extent of binding */
as

declare @futurevalue varchar(15)	/* the value of @futureonly that causes
					** the binding to be limited */
declare @msg varchar(250)

select @futurevalue = "futureonly"	/* initialize @futurevalue */

/*
**  When a default or rule is bound to a user-defined datatype, it is also
**  bound, by default, to any columns of the user datatype that are currently
**  using the existing default or rule as their default or rule.  This default
**  action may be overridden by setting @futureonly = @futurevalue when the
**  procedure is invoked.  In this case existing columns with the user
**  datatype won't have their existing default or rule changed.
*/

/*
**  Check to see that the object names are local to the current database.
*/
if @objname like "%.%.%"
begin
	/*
	** 17840, "Column or usertype must be in 'current' database."
	*/
	exec sp_getmessage 17840, @msg output
	print @msg
	return (1)
end

/*
**  If @objname is of the form tab.col then we are unbinding a column.
**  Otherwise its a datatype.  In the column case, we need to extract
**  and verify the table and column names and make sure the user owns
**  the table that is getting the default unbound.
*/
if @objname like "%.%"
begin
	declare @tabname varchar(30)		/* name of table */
	declare @colname varchar(30)		/* name of column */

	/*
	**  Get the table name out.
	*/
	select @tabname = substring(@objname, 1, charindex(".", @objname) - 1)
	select @colname = substring(@objname, charindex(".", @objname) + 1, 61)

	/*
	**  Find it and unbind it.
	*/
	if exists (select *
			from syscolumns, sysobjects
		where syscolumns.id = object_id(@tabname)
			and syscolumns.name = @colname
			and sysobjects.id = object_id(@tabname)
			and uid = user_id()
			and sysobjects.sysstat & 7 = 3)      /* user table */
	begin
		/*
		**  Is there something bound to it?
		*/
		if exists (select *
			from syscolumns, sysobjects
		where syscolumns.id = object_id(@tabname)
			and syscolumns.name = @colname
			and sysobjects.id = object_id(@tabname)
			and uid = user_id()
			and sysobjects.sysstat & 7 = 3      /* user table */
			and cdefault != 0)
		begin
			update syscolumns
				set cdefault = 0
					from syscolumns, sysobjects
				where syscolumns.id = object_id(@tabname)
					and syscolumns.name = @colname
					and sysobjects.id = object_id(@tabname)
					and uid = user_id()
					and sysobjects.sysstat & 7 = 3

			/*
			**  Since binding a default is a schema change,
			**  update schema count
			**  for the object in the sysobjects table.
			*/
			update sysobjects
				set schema = schema + 1
					from sysobjects
						where id = object_id(@tabname)
							and uid = user_id()
                                                        and schema_inc(object_id(@tabname)) is NULL

			/*
			** 17841, "Default unbound from table column."
			*/
			exec sp_getmessage 17841, @msg output
		        print @msg
			return (0)
		end

		else
		begin
			/*
			** 17842, "The specified column has no default."
			*/
			exec sp_getmessage 17842, @msg output
        		print @msg
			return (1)
		end
	end

	/*
	**  If we got here, there was no such object.
	*/
	/*
	** 17843, "You do not own a table with a column of that name."
	*/
	exec sp_getmessage 17843, @msg output
        print @msg
	return (1)

end
else
begin
	/*
	**  We're unbinding to a user type.  In this case, the @objname
	**  is really the name of the user datatype.
	**  When we unbind to a user type, any existing columns get changed
	**  to the new binding unless their current binding is not equal
	**  to the current binding for the usertype or if they set the
	**  @futureonly parameter to @futurevalue.
	*/
	declare @olddefault int			/* current default for type */

	/*
	**  Get the current default for the datatype.
	*/
	select @olddefault = tdefault
		from systypes
	where name = @objname
		and uid = user_id()
		and usertype > 100

	if @olddefault = null
	begin
		/*
		** 17844, "You do not own a user datatype of that name."
		*/
		exec sp_getmessage 17844, @msg output
	        print @msg
		return (1)
	end

	if @olddefault = 0
	begin
		/*
		** 17845, "The specified user datatype has no default."
		*/
		exec sp_getmessage 17845, @msg output
	        print @msg
		return (1)
	end

	update systypes
		set tdefault = 0
			from systypes
		where name = @objname
			and uid = user_id()
			and usertype > 100

	/*
	** 17846, "Default unbound from datatype."
	*/
	exec sp_getmessage 17846, @msg output
        print @msg

	/*
	**  Now see if there are any columns with the usertype that
	**  need the new binding.
	*/
	if isnull(@futureonly, "") != @futurevalue
		and exists (select *
			from syscolumns, systypes
				where syscolumns.usertype = systypes.usertype
					and systypes.name = @objname
					and systypes.usertype > 100
					and systypes.uid = user_id()
					and syscolumns.cdefault = @olddefault)
	begin
		/*
		**  Update the table schema to indicate that something
		**  has changed in the table's schema.
		*/
		update sysobjects
			set schema = schema + 1
				from sysobjects, syscolumns, systypes
			where sysobjects.id = syscolumns.id
				and syscolumns.usertype = systypes.usertype
				and systypes.name = @objname
				and systypes.usertype > 100
				and systypes.uid = user_id()
				and syscolumns.cdefault = @olddefault
                                and sysobjects.id in
                                        (select s.id from sysobjects s
                                        where schema_inc(s.id) is NULL)

		/*
		**  Update syscolumns with new binding.
		*/
		update syscolumns
			set cdefault = systypes.tdefault
				from syscolumns, systypes
			where syscolumns.usertype = systypes.usertype
				and systypes.name = @objname
				and systypes.usertype > 100
				and systypes.uid = user_id()
				and syscolumns.cdefault = @olddefault

		/*
		** 17847, "Columns of the user datatype specified had 
		** their defaults unbound."
		*/
		exec sp_getmessage 17847, @msg output
	        print @msg

	end
end

return (0)

                                                                                                                     
go

go
if exists (select * from sysobjects 
where name = "sp_unbindrule")
begin
	drop proc sp_unbindrule
end
go

/* Sccsid = "@(#) generic/sproc/src/unbindrule 52.1 8/12/92" */
/*	4.8	1.1	06/14/90	sproc/src/serveroption */
 
/*
** Messages for "sp_unbindrule"         17850
**
** 17840, "Column or usertype must be in 'current' database."
** 17843, "You do not own a table with a column of that name."
** 17844, "You do not own a user datatype of that name." 
** 17850, "Rule unbound from table column."
** 17851, "The specified column has no rule."
** 17852, "The specified user datatype has no rule."
** 17853, "Rule unbound from datatype."
** 17854, "Columns of the user datatype specified had their rules unbound."
*/

create procedure sp_unbindrule
@objname varchar(61),			/* table/column or datatype name */
@futureonly varchar(15) = NULL		/* flag to indicate extent of binding */
as

declare @futurevalue varchar(15)	/* the value of @futureonly that causes
					** the binding to be limited */
declare @msg varchar(250)

select @futurevalue = "futureonly"	/* initialize @futurevalue */

/*
**  When a default or rule is bound to a user-defined datatype, it is also
**  bound, by default, to any columns of the user datatype that are currently
**  using the existing default or rule as their default or rule.  This default
**  action may be overridden by setting @futureonly = @futurevalue when the
**  procedure is invoked.  In this case existing columns with the user
**  datatype won't have their existing default or rule changed.
*/

/*
**  Check to see that the object names are local to the current database.
*/
if @objname like "%.%.%"
begin
	/*
	** 17840, "Column or usertype must be in 'current' database."
	*/
	exec sp_getmessage 17840, @msg output
	print @msg
	return (1)
end

/*
**  If @objname is of the form tab.col then we are unbinding a column.
**  Otherwise its a datatype.  In the column case, we need to extract
**  and verify the table and column names and make sure the user owns
**  the table that is getting the default unbound.
*/
if @objname like "%.%"
begin
	declare @tabname varchar(30)		/* name of table */
	declare @colname varchar(30)		/* name of column */

	/*
	**  Get the table name out.
	*/
	select @tabname = substring(@objname, 1, charindex(".", @objname) - 1)
	select @colname = substring(@objname, charindex(".", @objname) + 1, 61)

	/*
	**  Find it and unbind it.
	*/
	if exists (select *
			from syscolumns, sysobjects
		where syscolumns.id = object_id(@tabname)
			and syscolumns.name = @colname
			and sysobjects.id = object_id(@tabname)
			and uid = user_id()
			and sysobjects.sysstat & 7 = 3)      /* user table */
	begin
		/*
		**  Is there something bound to it?
		*/
		if exists (select *
			from syscolumns, sysobjects
		where syscolumns.id = object_id(@tabname)
			and syscolumns.name = @colname
			and sysobjects.id = object_id(@tabname)
			and uid = user_id()
			and sysobjects.sysstat & 7 = 3      /* user table */
			and domain != 0)
		begin
			update syscolumns
				set domain = 0
					from syscolumns, sysobjects
				where syscolumns.id = object_id(@tabname)
					and syscolumns.name = @colname
					and sysobjects.id = object_id(@tabname)
					and uid = user_id()
					and sysobjects.sysstat & 7 = 3

			/*
			**  Since binding a rule is a schema change,
			**  update schema count
			**  for the object in the sysobjects table.
			*/
			update sysobjects
				set schema = schema + 1
					from sysobjects
						where id = object_id(@tabname)
							and uid = user_id()
                                                        and schema_inc(object_id(@tabname)) is NULL

			/*
			** 17850, "Rule unbound from table column."
			*/
			exec sp_getmessage 17850, @msg output
        		print @msg  
			return (0)
		end

		else
		begin
			/*
			** 17851, "The specified column has no rule."
			*/
			exec sp_getmessage 17851, @msg output
        		print @msg  
			return (1)
		end
	end

	/*
	**  If we got here, there was no such object.
	*/
	/*
	** 17843, "You do not own a table with a column of that name."
	*/
	exec sp_getmessage 17843, @msg output
        print @msg  
	return (1)

end
else
begin
	/*
	**  We're unbinding to a user type.  In this case, the @objname
	**  is really the name of the user datatype.
	**  When we unbind to a user type, any existing columns get changed
	**  to the new binding unless their current binding is not equal
	**  to the current binding for the usertype or if they set the
	**  @futureonly parameter to @futurevalue.
	*/
	declare @oldrule int			/* current rule for type */

	/*
	**  Get the current rule for the datatype.
	*/
	select @oldrule = domain
		from systypes
	where name = @objname
		and uid = user_id()
		and usertype > 100

	if @oldrule = null
	begin
		/*
		** 17844, "You do not own a user datatype of that name." 
		*/
		exec sp_getmessage 17844, @msg output
        	print @msg  
		return (1)
	end

	if @oldrule = 0
	begin
		/*
		** 17852, "The specified user datatype has no rule."
		*/
		exec sp_getmessage 17852, @msg output
        	print @msg  
		return (1)
	end

	update systypes
		set domain = 0
			from systypes
		where name = @objname
			and uid = user_id()
			and usertype > 100

	/*
	** 17853, "Rule unbound from datatype."
	*/
	exec sp_getmessage 17853, @msg output
        print @msg  

	/*
	**  Now see if there are any columns with the usertype that
	**  need the new binding.
	*/
	if isnull(@futureonly, "") != @futurevalue
		and exists (select *
			from syscolumns, systypes
				where syscolumns.usertype = systypes.usertype
					and systypes.name = @objname
					and systypes.usertype > 100
					and systypes.uid = user_id()
					and syscolumns.domain = @oldrule)
	begin
		/*
		**  Update the table schema to indicate that something
		**  has changed in the table's schema.
		*/
		update sysobjects
			set schema = schema + 1
				from sysobjects, syscolumns, systypes
			where sysobjects.id = syscolumns.id
				and syscolumns.usertype = systypes.usertype
				and systypes.name = @objname
				and systypes.usertype > 100
				and systypes.uid = user_id()
				and syscolumns.domain = @oldrule
                                and sysobjects.id in
                                        (select s.id from sysobjects s
                                        where schema_inc(s.id) is NULL)

		/*
		**  Update syscolumns with new binding.
		*/
		update syscolumns
			set domain = systypes.domain
				from syscolumns, systypes
			where syscolumns.usertype = systypes.usertype
				and systypes.name = @objname
				and systypes.usertype > 100
				and systypes.uid = user_id()
				and syscolumns.domain = @oldrule

		/*
		** 17854, "Columns of the user datatype specified 
		** had their rules unbound."
		*/
		exec sp_getmessage 17854, @msg output
        	print @msg  

	end
end

return (0)

                                                                                                                                                                                    
go

go
if exists (select * from sysobjects 
where name = "sp_who")
begin
	drop proc sp_who
end
go

/* Sccsid = "@(#) generic/sproc/who 52.1 8/12/92" */
/*	4.8	1.1	06/14/90	sproc/src/serveroption */

/*
** Messages for "sp_who"		17nnn
** 
** 17231, "No login with the specified name exists." 
*/

create procedure sp_who @loginame varchar(30) = NULL as

declare @low int
declare @high int
declare @spidlow int
declare @spidhigh int
declare @msg varchar(250)
declare @len1 int, @len2 int

select @low = 0, @high = 32767, @spidlow = 0, @spidhigh = 32767

if @loginame is not NULL
begin
	select @low = suser_id(@loginame), @high = suser_id(@loginame)
	if @low is NULL
	begin
		if @loginame like "[0-9]%"
		begin
			select @spidlow = convert(int, @loginame),
			     @spidhigh = convert(int, @loginame),
			     @low = 0, @high = 32767
		end
		else
		begin
			/*
			** 17231, "No login with the specified name exists." 
			*/
			exec sp_getmessage 17231, @msg output
			print @msg
			return (1)
		end
	end
end

select @len1 = max(datalength(suser_name(suid))),
       @len2 = max(datalength(db_name(dbid)))
	from sysprocesses
	where suid >= @low and suid <= @high and
	      spid >= @spidlow and spid <= @spidhigh

if (@len1 > 12 or @len2 > 10)
    begin
	select spid,status,loginame=suser_name(suid),
	   hostname,blk=convert(char(3),blocked),
	   dbname=db_name(dbid),cmd
	from sysprocesses
	where suid >= @low and suid <= @high
	and spid >= @spidlow and spid <= @spidhigh
    end
else
    begin
	select spid,status,loginame=convert(char(12), suser_name(suid)),
	   hostname,blk=convert(char(3),blocked),
	   dbname=convert(char(10), db_name(dbid)),cmd
	from sysprocesses
	where suid >= @low and suid <= @high
	and spid >= @spidlow and spid <= @spidhigh
    end

return (0)

                                                                                                               
go

					/****   end of stored procedures ****/ 

					/**** start of triggers ****/ 

print "creating triggers"
go

					/****   end of triggers ****/ 

					/**** start of object permissions ****/ 

print "creating object permissions"
go

Grant Select on sprojects to public
Grant Select on spt_monitor to public
Grant Select on spt_values to public
Grant Select on teloffice to public
Grant Execute on sp_abort_xact to public
Grant Execute on sp_addalias to public
Grant Execute on sp_addgroup to public
Grant Execute on sp_addmessage to public
Grant Execute on sp_addsegment to public
Grant Execute on sp_addtype to public
Grant Execute on sp_adduser to public
Grant Execute on sp_bindefault to public
Grant Execute on sp_bindrule to public
Grant Execute on sp_changegroup to public
Grant Execute on sp_checknames to public
Grant Execute on sp_commit_xact to public
Grant Execute on sp_commonkey to public
Grant Execute on sp_configure to public
Grant Execute on sp_dboption to public
Grant Execute on sp_defaultdb to public
Grant Execute on sp_defaultlanguage to public
Grant Execute on sp_depends to public
Grant Execute on sp_dropalias to public
Grant Execute on sp_dropgroup to public
Grant Execute on sp_dropkey to public
Grant Execute on sp_dropmessage to public
Grant Execute on sp_dropsegment to public
Grant Execute on sp_droptype to public
Grant Execute on sp_dropuser to public
Grant Execute on sp_extendsegment to public
Grant Execute on sp_foreignkey to public
Grant Execute on sp_getmessage to public
Grant Execute on sp_help to public
Grant Execute on sp_helpdb to public
Grant Execute on sp_helpdevice to public
Grant Execute on sp_helpgroup to public
Grant Execute on sp_helpindex to public
Grant Execute on sp_helpjoins to public
Grant Execute on sp_helpkey to public
Grant Execute on sp_helplanguage to public
Grant Execute on sp_helplog to public
Grant Execute on sp_helpremotelogin to public
Grant Execute on sp_helprotect to public
Grant Execute on sp_helpsegment to public
Grant Execute on sp_helpserver to public
Grant Execute on sp_helpsort to public
Grant Execute on sp_helptext to public
Grant Execute on sp_helpuser to public
Grant Execute on sp_indsuspect to public
Grant Execute on sp_lock to public
Grant Execute on sp_logdevice to public
Grant Execute on sp_lookup to public
Grant Execute on sp_markreport to public
Grant Execute on sp_namecrack to public
Grant Execute on sp_objectsegment to public
Grant Execute on sp_password to public
Grant Execute on sp_placeobject to public
Grant Execute on sp_primarykey to public
Grant Execute on sp_probe_xact to public
Grant Execute on sp_recompile to public
Grant Execute on sp_remoteoption to public
Grant Execute on sp_remove_xact to public
Grant Execute on sp_rename to public
Grant Execute on sp_scan_xact to public
Grant Execute on sp_serverinfo to public
Grant Execute on sp_serveroption to public
Grant Execute on sp_setreplicate to public
Grant Execute on sp_spaceused to public
Grant Execute on sp_start_xact to public
Grant Execute on sp_stat_xact to public
Grant Execute on sp_unbindefault to public
Grant Execute on sp_unbindrule to public
Grant Execute on sp_validaltlang to public
Grant Execute on sp_validlang to public
Grant Execute on sp_who to public
go

					/****   end of object permissions ****/ 

					/**** start of keys ****/ 

print "creating keys"
go

execute sp_primarykey teloffice, toid
go

execute sp_primarykey sprojects, sprid
go

dump tran master with truncate_only

go

					/**** end of script ****/ 
