# $Id: xmodify.tcl,v 1.1.1.1 1996/11/20 19:19:22 de Exp $
#
# simple Tk version of xmodify

proc xmodify {{minuss -s} {service dcs} args} {
    ktl open $service
    foreach v $args {
	global $v.write
	set $v.write 0
	ktl link $service $v
	frame .$v
	label .$v.label -text "$v" -width 15 -background yellow \
		-relief groove -cursor pirate
	entry .$v.entry -textvariable $v -width 15 \
		-background lightblue -relief sunken
	bind .$v.entry <Enter>  "xmodify.enter  $v"
	bind .$v.entry <Return> "xmodify.return $v"
	bind .$v.entry <Leave>  "xmodify.leave  $v"
	ktl monitor $v "xmodify.monitor $v"
	pack .$v.label .$v.entry -side left
	pack .$v
    }
    button .quit -text Quit -command exit -background red -foreground white
    pack .quit -fill x
}

proc xmodify.enter v {
    global $v.write $v.entry $v
    set $v.write 0
    set $v.entry [set $v]
    .$v.entry configure -textvariable $v.entry -background white
    focus .$v.entry
}

proc xmodify.return v {
    global $v.write $v $v.entry
    set $v.write 1
    ktl write $v [set $v.entry]
    .$v.entry configure -background lightpink
}

proc xmodify.leave v {
    global $v.write
    if {[set $v.write] == 0} {
	.$v.entry configure -background lightblue
    } else {
	set $v.write 2
    }
    .$v.entry configure -textvariable $v
    focus none
}

proc xmodify.monitor v {
    global $v.write
    if {[set $v.write] == 2} {
	.$v.entry configure -background lightblue
	set $v.write 0
    }
}
