#!/opt0/tcl/bin/sytcl
#------------------------ Global Variables ---------------------------
#
set tclroot /opt0/share/tcl
loadlibindex $tclroot/lib/ucodb/ucodb.tlib
#
#---------------------------------------------------------------------------
# MAIN CODE
#---------------------------------------------------------------------------
# Code to stuff the meme table with incomplete entries for all
# fields in a given table.
# Input:  server name and FQ table name
# Output: inserts data into Memes and Mbundles tables
#
# Handy Dandy Global Vars
#
global dbpipe1 dbpipe2 dbpipe3 dbpipe4 dbpipe5
global sybmsg
global server
global uname
global table
set memtbl "keck.dbo.Memes"
set mebtbl "keck.dbo.Mbundles"
set uname "sa"
set pass "NOYB"
set ctxt "DataBase"
#
#--------------------------------------------------------PROCS
proc getCols {db usr tbl} {
 
        global sybmsg cols colnames types sizes nulls indices index keys
 
        echo "get col types and sizes"

        set sqlcmd "select a.name, c.name, a.length, a.status from \
$db.dbo.syscolumns a, $db.dbo.sysobjects b, $db.dbo.systypes c where \
a.id = b.id and b.name = '$tbl' and b.uid = user_id('$usr') and \
a.usertype = c.usertype"
 
        set sqt "syscolumns/sysobjects"
        set res [doSQL 1]
 
        if {[lindex $res 0] == "ERROR"} {
                echo "Something went wrong here:"
                echo "$sqlcmd\n$sybmsg(msgno): $sybmsg(msgtext)"
                exit 1
        }
 
        while {1 == 1} {
                set line [sybNext 1]
                if {$line == ""} {break}
                lassign $line c ct cs cn
                set types($c) $ct
                set nulls($c) $cn
                set sizes($c) $cs
                set index($c) 0
                lappend cols $c
        }
 
        set sqlcmd "sp_helpindex $tbl"
        set sqt "sp_helpindex"
        set res [doSQL 1]
 
        if {[lindex $res 0] == "ERROR"} {
                echo "Something went wrong here:"
                echo "$sqlcmd\n$sybmsg(msgno): $sybmsg(msgtext)"
                exit 1
        }
 
        while {1} {
                set line [sybNext 1]
                if {$line == ""} {break}
                lassign $line ind_name junk ind_col
                set ind_col [string trim $ind_col]
                lappend indices $ind_col
                set index($ind_col) 1
        }

	set pks [SYBgetPkeys $db.$usr.$tbl]
	foreach k $pks {
		if {$k > 0} {
                        set c [lindex $cols [expr {$k - 1}]]
                        lappend keys $c
                }
	}
	puts stderr "KEYS $keys"
}
#
#--------------------------------------------------------MAIN

if {[llength $argv] < 2} {
	echo "Usage:  stm Server Base.Owner.Table \[Base.Owner.Table,...\]"
	exit 1
}

	set server [lvarpop argv]
#	puts stderr "server is $server, argv is $argv"

        foreach fqtable $argv  {

	set t [split $fqtable .]

	if {[llength $t] < 3} {
		echo "$fqtable is not an base.owner.object table specification."
		echo "Please provide the tablename in the FQ form."
		exit 1
	}

	puts stderr "TABLE $fqtable...\n"

	lassign $t base owner table

	set dbpipe1 [sybOpen $base $uname $pass $server]
	set sqlcmd "select * from $memtbl where alt_name = '$fqtable'"
#	puts stderr "do $sqlcmd"
	set sqt $memtbl
	doSQL 1
	set tcols [sybCols 1]

	set memcount 0
	set exists "$fqtable already exists:\n"
	while {1} {
		set line [sybNext 1]
		if {$line == ""} {break}
		eval lassign \$line $tcols
		incr memcount
		puts stderr "$exists  $memcount\t$context $mid $name $syty $alt_name"
		keylset tmemes($mid) name $name context $context syty $syty
		set exists ""
	}

	puts stderr "Count of Memes entries for $base.$owner.$table is $memcount"

	getCols $base $owner $table

	set nct 0
	foreach c $cols {

		if {[lsearch $keys $c] >= 0} {
			lappend tkeys 1
		} else {
			lappend tkeys 0
		}

		puts stderr "\nCOLUMN $c type $types($c) size $sizes($c)"
		set sqlcmd "select * from $memtbl where name = '$c'"
		set sqt $memtbl
		doSQL 1
		set scols [sybCols 1]
		set ct 0
		set exists "  $c already exists:\n"
		while {1} {
			set line [sybNext 1]
			if {$line == ""} {break}
			eval lassign \$line $scols
			puts stderr "$exists  $context $mid $name $syty\n\t[join [strFold $semantics 40] "\n\t"]"
			set exists ""
			keylset $context mid $mid name $name syty $syty
			incr ct
		}
		if {$ct} {
		if {$ct==1} {
			puts stderr "??? is this a reinstantiation of that col \[YES\]?"
			gets stdin answer
			if {$answer == ""} {
				lappend emids $mid
				continue
			}
		}
		if {$ct > 1} {
			puts stderr "??? which one (MID) do you want, N for new?"
			gets stdin answer
			if {$answer != "N"} {
				lappend emids $answer
				continue
			} 
		}
		}
#	If this is a new name or we deny its being a reinstantiation,
#	go on...
		
		set syty $types($c)
		case $syty in {
		{float} {
			set ffmt E20.12
			set cfmt %.12e
		}
		{real} {
			set ffmt E13.6
			set cfmt %.6e
		}
		{tinyint} {
			set ffmt I3
			set cfmt %d
		}
		{smallint} {
			set ffmt I6
			set cfmt %d
		}
		{int} {
			set ffmt I11
			set cfmt %d
		}
		{char varchar} {
			set ffmt A$sizes($c)
			set cfmt %s
			set syty ${syty}($sizes($c))
		}
		{smalldatetime} {
			set ffmt A12
			set cfmt %s
		}
		}

		if {$memcount == 0} {
			set sqlcmd "insert into $memtbl (mid,name,context,ffmt,syty,semantics) values (-1,'$c','$ctxt','$ffmt','$syty','UNKNOWN')"
#			puts stderr "  $sqlcmd"
			incr nct
#			puts stderr "  STORE NEW meme $c mid NEW$nct syty $syty ffmt $ffmt"
#			set res "MID$nct is the new meme number"
			set sqt $memtbl
			set res [doSQL 1]
			set text $sybmsg(msgtext)
#			puts stderr "msg is $text"
			set newm [lindex $text 0]
			puts stderr "  New mid is $newm for $c $syty $ffmt"
			lappend emids $newm		
		} else {
			puts stderr "$fqtable already defined but without $c?"
			puts stderr "I fear this attempt is ill-advised."
			puts stderr "Bailing... no changes to db."
			exit 1
		}
	}

	puts stderr "List of emids for this table is\n  $emids"
	puts stderr "Now store new meme for table bundle:"

	if {$memcount==0} {

	set sqlcmd "insert into $memtbl (mid,name,context,ffmt,syty,alt_name,semantics) values (-1,'$table','$ctxt','table','table','$fqtable','UNKNOWN')"
	set sqt $memtbl
	set res [doSQL 1]
	set text $sybmsg(msgtext)
	puts stderr "msg was $text"
	set tmid [lindex $text 0]
	puts stderr "$tmid $sqlcmd"

	} else {

	set ct 0
	foreach m [lsort -integer [array names tmemes]] {
		set mn [keylget tmemes($m) name]
		set mc [keylget tmemes($m) context]
		set mt [keylget tmemes($m) syty]
		puts stderr "$mc : $mn $m $mt"
		incr ct
	}
	if {$ct == 1} {
		set tmid $m
	} else {
		puts stderr "Which of these do you think is the right tmid?"
		gets stdin tmid
	}

	}
		
	set sqlcmd "select count(*) from $mebtbl where tmid = $tmid"
	set sqt $mebtbl
	doSQL 1
	set tc [sybNext 1]
	if {$tc} {
		puts stderr "Sorry, there are already Bundle records for tmid $tmid."
		puts stderr "You will have to sort this one out by hand."
		exit 1
	"
	}

	set ct 1
	foreach e $emids {
		set k [lvarpop tkeys]
		if {$k} {
		set sqlcmd "insert into $mebtbl (mbid,tmid,emid,eordr,einkey) values (-1,$tmid,$e,$ct,'P')"
		} else {
		set sqlcmd "insert into $mebtbl (mbid,tmid,emid,eordr) values (-1,$tmid,$e,$ct)"
		}
		set sqt $mebtbl
		doSQL 1
		puts stderr "  $sqlcmd"
		incr ct
	}
	}

	sybClose 1
	exit 0
