#
package require printer
package require gdi

# Now build a screen....
button .b -text OK -font { Times 12 } -command exit
label  .x -text "Now is the time for all good men to come to the aid of their country" \
          -font { Times 12 bold } -wraplength 100

# Build an output window
toplevel .output
text .output.text
pack .output.text -fill both -expand true

.output.text insert end "Printer package version [printer version]\n"
.output.text insert end "GDI package version [gdi version]\n"

pack .b .x

# Ensure everything is ready
update

wm deiconify .
raise .

set x [printer dialog select]

if { [lindex $x 1] != 1 } {
  # Printing was cancelled!
  .output.text insert end "Cancelled printing."
} else {
  # get just the HDC part
  set x [ lindex $x 0 ]

  .output.text insert end "Selected printer with GDI context $x\n"

  # Allow a repaint
  update

  catch { set result [printer job start $x] } result

  .output.text insert end "Started printer job: $result\n"

  wm deiconify .
  raise .
  update

  catch { set result [gdi copybits $x -destination "100 100 1000 800" ] } result

  .output.text insert end "Copied window using StretchBlt: $result\n"

  catch { set result [printer job end $x] } result

  .output.text insert end "Completed job: $result\n"

  catch { set result [printer close] } result

  .output.text insert end "Closed printer: $result\n"

}

.output.text insert end "\nTest complete. Press OK to exit\n"

