


source FindnReplace.tcl


package require BWidget

wm	title	. "Tcl Editor"

global GotSelect
set GotSelect 0
frame .fr -width 10c -height 10c ;#main window

pack .fr
#configure menubar on top

frame .menubar -relief raised -bd 2
pack .menubar -in .fr -fill x

frame	.imgbtn -relief raised -bd 2
pack .imgbtn -in .fr -after .menubar -fill x

frame .editorf
#put a text widget with scroll bars
text .editor -width 80 -height 40 -bg white \
        -yscrollcommand ".ys set"
scrollbar .ys -command ".editor yview"
pack .editor .ys -in .editorf -side left -fill y
scrollbar .xs -orient horizontal
pack .editorf .xs -in .fr -after .imgbtn -fill x

#fill the  top menu
menubutton .menubar.file -text File -underline 0 -menu .menubar.file.menu
#menubutton .menubar.editorit -text Edit -underline 0 -menu .menubar.editorit.menu
menubutton .menubar.find -text Find -underline 0 -menu .menubar.find.menu
pack .menubar.file .menubar.find -side left
#pack .menubar.file .menubar.editorit .menubar.find -side left
#menubutton .menubar.help -text Help -underline 0
#pack .menubar.help -side right

menu .menubar.file.menu
.menubar.file.menu add command -label New -command NewFile
.menubar.file.menu add command -label Open -command OpenFile
.menubar.file.menu add command -label Save -command SaveFile
.menubar.file.menu add command -label "Save As" -command SaveAsFile
.menubar.file.menu add command -label Quit -command exit

#menu .menubar.editorit.menu
#.menubar.editorit.menu add command -label Cut -command CutSelection
#.menubar.editorit.menu add command -label Paste -command PasteSelection
#.menubar.editorit.menu add command -label Copy -command CopySelection
#.menubar.editorit.menu add command -label Clear -command {.editor delete 1.0 end}

#Find menu
menu .menubar.find.menu
.menubar.find.menu add command -label "Find" -command Find
#.menubar.find.menu add cascade -label "Find" \
#        -menu .menubar.find.menu.fmenu
.menubar.find.menu add command -label "Find & Replace" -command FindnReplace
#.menubar.find.menu add command -label "Find Selection and Tag" \
#                               -command TagSelection

set appdir {.}
#menu .image.photo.menu
image create photo newimg -file [file join $appdir images text.gif] 
image create photo openimg -file [file join $appdir images open_file.gif] 
image create photo saveimg -file [file join $appdir images save_file.gif]
image create photo saveasimg -file [file join $appdir images save_as.gif]
image create photo findimg -file [file join $appdir images finding.gif]
image create photo preimg -file [file join $appdir images prev.gif]
image create photo nextimg -file [file join $appdir images next.gif]

button .imgbtn.newbtn -image newimg -command {NewFile}
button .imgbtn.openbtn -image openimg -command {OpenFile}
button .imgbtn.savebtn -image saveimg -command {SaveFile}
button .imgbtn.saveasbtn -image saveasimg -command {SaveAsFile}
button .imgbtn.findbtn -image findimg -command {FindnReplace}
button .imgbtn.prebtn -image preimg -command {SaveAsFile}
button .imgbtn.nextbtn -image nextimg -command {FindPopup}

pack .imgbtn.newbtn -side left
pack .imgbtn.openbtn -side left
pack .imgbtn.savebtn -side left
pack .imgbtn.saveasbtn -side left
pack .imgbtn.findbtn -side left
pack .imgbtn.prebtn -side left
pack .imgbtn.nextbtn -side left

DynamicHelp::add .imgbtn.newbtn -text "New"
DynamicHelp::add .imgbtn.openbtn -text "Open"
DynamicHelp::add .imgbtn.savebtn -text "Save"
DynamicHelp::add .imgbtn.saveasbtn -text "Save As"
DynamicHelp::add .imgbtn.findbtn -text "Find & Replace"
DynamicHelp::add .imgbtn.prebtn -text "Previous"
DynamicHelp::add .imgbtn.nextbtn -text "Next"

proc NewFile {} {
	.editor delete 1.0 end
}

proc OpenFile {} {
	global ofname
	set types {
		 {{TCL Scripts} {.tcl}} {{Text Files} {.txt}} {{C Source Files} {.c} TEXT}
	}
	
	set ofname [tk_getOpenFile -filetypes $types]
	if {$ofname == ""} {
		return
	} else {
		set ::fname	$ofname
	}
	.editor delete 1.0 end
	set f [open $::fname r]
	
	while {![eof $f]} {
		.editor insert end [read $f 1000]
	    }
	
	close $f
	.editor mark set insert 1.0
}

proc SaveFile {} {
	global fileselect
	set sts [catch {set f [open $fileselect (selectedfile) w]} \
        errormessage]
	if {$sts == 0} {
   	puts $f [.editor get 1.0 end]
  	} else {
   	set ok [ShowMessage "No File name given"]
     	}
}

proc SaveAsFile {} {
	global fileselect
	global ofname
	
	set types {
		 {{TCL Scripts} {.tcl}} {{Text Files} {.txt}} {{C Source Files} {.c} TEXT}
	}
	set fileselect [tk_getSaveFile -filetypes $types]
	
	if {$fileselect == ""} {
		set ok [ShowMessage "No File Name Given"]
		return
	} 
	if {[string compare $fileselect $ofname] == 0} {
		set ok [ShowMessage "File over written"]
		tkwait window .msgpop
		if {$ok == 0} {
			SaveFile
		} 
	} else {
		set openf $fileselect
		set f [open $openf w]
		after 5
		puts $f [.editor get 1.0 end]
	}

	

}

proc FindWord {replacetxt findtxt} {
	global found
	set l1 [string length $findtxt]
	scan [.editor index end] %d nl
	scan [.editor index insert] %d cl
	if {[string compare $replacetxt "-forwards"] == 0 } {
	
		set curpos [.editor index "insert + $l1 chars"]
	
		for {set i $cl} {$i < $nl} {incr i} {

   		.editor mark set last  $i.end 
			set lpos [.editor index last]
	     	set curpos [.editor search $replacetxt -exact $findtxt $curpos $lpos]
	     	if {$curpos != ""} {
         	selection clear .editor
           	.editor mark set insert "$curpos + $l1 chars "
           	.editor see $curpos
           	set found 1
           	break
        	} else {
         	set curpos $lpos
           	set found 0
                        }
		}
	} else {
    	set curpos [.editor index insert]
     	set i $cl
     	.editor mark set first $i.0
     	while  {$i >= 1} {
			set fpos [.editor index first]
       	set i [expr $i-1]

        	set curpos [.editor search $replacetxt -exact $findtxt $curpos $fpos]
        	if {$curpos != ""} {
         	selection clear .editor
           	.editor mark set insert $curpos
           	.editor see $curpos
           	set found 1
           	break
        	} else {
         	.editor mark set first $i.0
           	.editor mark set last "first lineend"
           	set curpos [.editor index last]
           	set found 0
                     	}
		}
	}
}

proc FindSelection {replacetxt} {
	global findtxt GotSelect
	if {$GotSelect == 0} {
		set findtxt [selection get STRING]
	  	set GotSelect 1		
	}
	FindWord $replacetxt $findtxt
}

proc FindValue {} {

	FindPopup
}
	
proc TagSelection {} {
	global findtxt GotSelect
	if {$GotSelect == 0} {
		set findtxt [selection get STRING]
		set GotSelect 1
	 }
	TagAll
}

proc ShowMessage {msg} {
	toplevel .msgpop -width 10c -height 4c
	grab .msgpop
	wm title .msgpop "Message box"
	message .msgpop.msg -relief raised -bd 2 -text $msg
	
	button .msgpop.okb -text OK \
		-command {destory .msgpop ; return 0} 
	pack .msgpop.msg .msgpop.okb -side top
}


