proc FindnReplace {} {
	
	global findtxt repltxt
	
	toplevel .frpopup -width 10c -height 4c
	
	grab .frpopup
	wm title .frpopup "Find Text"
	
	
	label .frpopup.lab1 -text "Find :           "
	place .frpopup.lab1 -in .frpopup -x 2 -y 6
	entry .frpopup.en1 -width 20 -relief sunken -textvariable findtxt
	place .frpopup.en1 -in .frpopup -x 100  -y 6
	
	label .frpopup.lab2 -text "Replace with :        "
	place .frpopup.lab2 -in .frpopup -x 2 -y 50
	entry .frpopup.en2 -width 20 -relief sunken -textvariable repltxt
	place .frpopup.en2 -in .frpopup -x 100 -y 50
	
	button .frpopup.repall -text "Replace All" -command {ReplaceAll}
	place .frpopup.repall -in .frpopup -x 140 -y 90

	button .frpopup.tagall -text "Find All" -command {FindAll}
	place .frpopup.tagall -in .frpopup -x 60 -y 90
	
	button .frpopup.dismis -text Close -command {destroy .frpopup}
	place .frpopup.dismis -in .frpopup -x 240 -y 90
	
	focus .frpopup.en1
}
	
proc ReplaceSelection {replacetxt} {
	global repltxt findtxt found
	set l1 [string length $findtxt]
	FindWord $replacetxt $findtxt
	if {$found == 1} {
		.editor delete insert "insert + $l1 chars"
	 	.editor insert insert $repltxt
	}
}
	
proc ReplaceAll {} {
	global findtxt repltxt
	set l1 [string length $findtxt]
	set l2 [string length $repltxt]
	scan [.editor index end] %d nl
	set curpos [.editor index 1.0]
	for {set i 1} {$i < $nl} {incr i} {
	   .editor mark set last $i.end
		set lpos [.editor index last]
	  	set curpos [.editor search -forwards -exact $findtxt $curpos $lpos]
		
		if {$curpos != ""} {
	  		.editor mark set insert $curpos
	     	.editor delete insert "insert + $l1 chars"
	     	.editor insert insert $repltxt
	     	.editor mark set insert "insert + $l2 chars"
	     	set curpos [.editor index insert]
	     	} else {
	     		set curpos $lpos
	              	}
	}
}

proc FindAll {} {
	global findtxt
	set l1 [string length $findtxt]
	scan [.editor index end] %d nl
	set curpos [.editor index insert]
	for {set i 1} {$i < $nl} {incr i} {
		.editor mark set last $i.end
	  	set lpos [.editor index last]
	  	set curpos [.editor search -forwards -exact $findtxt $curpos $lpos]
	  	if {$curpos != ""} {
	  		.editor mark set insert $curpos
	     	scan [.editor index "insert + $l1 chars"] %f pos
	     	.editor tag add $findtxt $curpos $pos
	     	.editor tag configure $findtxt -background yellow
	     	.editor mark set insert "insert + $l1 chars"
	     	set curpos $pos
	  	} else {
	   	set curpos $lpos
	      	 }
	}
}			
