# Glyphs-demo
#
# Demo for Glyphs-package
#

lappend auto_path [file join [file dirname [file normalize [info script]]] lib]     

catch {console show}

package require tile
package require zoom-canvas
package require Glyphs

set ::FONTFILE ""
set ::FONTFILE_SHORT ""
set G_IDX ""

# --- control panel
tk::panedwindow .w -orient horizontal
pack .w -expand 1 -fill both

ttk::frame .panel -relief raised -pad {10 10 10 10}     
    set row 0

    ttk::label .panel.fontName -textvariable ::FONTFILE_SHORT -relief sunken
    ttk::button .panel.openFile -text "Font" -command ChooseFontFile
    grid .panel.fontName .panel.openFile
    grid configure .panel.fontName -sticky ew
    incr row

    ttk::label .panel.numglyphs -textvariable ::MSG_NUMGLYPHS
    grid .panel.numglyphs -
    incr row
    
    ttk::label .panel.l_idx -text "Glyph Idx" -justify right
    ttk::entry .panel.idx
    grid .panel.idx .panel.l_idx
    grid configure .panel.idx -sticky e
    grid configure .panel.l_idx -sticky w
    
    incr row

    ttk::label .panel.help -text "* Use MouseWheel for zooming\n* Press Left-Button for panning" \
        -relief ridge
    grid .panel.help - -row [incr row]
    incr row
    
    set ::SHOW(POINT) 1
    set ::SHOW(CSEGMENT) 1    
    set ::SHOW(BOX)  1
    set ::SHOW(CURVE) 1

    ttk::checkbutton .panel.showp -text "Control Points" -variable ::SHOW(POINT) -command {OnShow .c POINT}
    ttk::checkbutton .panel.shows -text "Control Segments" -variable ::SHOW(CSEGMENT) -command {OnShow .c CSEGMENT}
    ttk::checkbutton .panel.showb -text Boxes  -variable ::SHOW(BOX) -command {OnShow .c BOX}
    ttk::checkbutton .panel.showc -text Curves -variable ::SHOW(CURVE) -command {OnShow .c CURVE}
    grid .panel.showp - -sticky w -row [incr row]
    grid .panel.shows - -sticky w -row [incr row]
    grid .panel.showb - -sticky w -row [incr row]
    grid .panel.showc - -sticky w -row [incr row]
    
    ttk::label .panel.segtitle -text "Uniform Segmentation" \
    	-relief solid -anchor center
    
	incr row
	grid .panel.segtitle - -sticky ew -row [incr row]
	incr row

    set ::SEGLEN 110
	
    ttk::button .panel.update -text "Update" -command { updateUniformPoints .c}
    ttk::label .panel.labelscale -text "Segment Length: "
    ttk::scale .panel.seglen -from 10 -to 200
    .panel.seglen set $::SEGLEN
    .panel.seglen configure -command [list OnScaleLen ::SEGLEN]
    ttk::label .panel.seglenlabel -textvariable ::SEGLEN

    grid .panel.seglen .panel.update -row [incr row]
    grid configure .panel.seglen -sticky ew
    grid .panel.labelscale .panel.seglenlabel  -row [incr row]
    grid configure .panel.labelscale -sticky e
    grid configure .panel.seglenlabel -sticky w
    
    set ::SEGLEN 100
    set ::SHOW(UPOINT) 0
    set ::SHOW(UTGT)   0    
    set ::SHOW(UNORMAL) 0

    set ::NEED_UPDATE(UPOINT) true
    set ::NEED_UPDATE(UTGT) true
    set ::NEED_UPDATE(UNORMAL) true

    ttk::checkbutton .panel.showup -text Points -variable ::SHOW(UPOINT) -command {OnShow .c UPOINT}
    ttk::checkbutton .panel.showut -text Tangents -variable ::SHOW(UTGT) -command {OnShow .c UTGT}
    ttk::checkbutton .panel.showun -text Normals -variable ::SHOW(UNORMAL) -command {OnShow .c UNORMAL}
    grid .panel.showup - -sticky w -row [incr row]
    grid .panel.showut - -sticky w -row [incr row]
    grid .panel.showun - -sticky w -row [incr row]
    

    incr row
    
    ttk::button .panel.bestFit -text "Best Zoom" -command {.c zoomfit xy}
    grid .panel.bestFit - -sticky ew -row [incr row]
    incr row

    lassign [grid size .panel] cols rows
    for {set i 0} { $i < $rows} {incr i} {
        grid rowconfigure .panel $i -minsize 30
    }
    grid columnconfigure . all -pad 4
	grid columnconfigure .panel 0 -weight 2    
	grid columnconfigure .panel 1 -weight 1    
.w add .panel


# -- panel for zoom-canvas and status bar
ttk::frame .cvspanel

    zoom-canvas .c -highlightthickness 0

    ttk::frame .status
    ttk::label .status.zoom -textvariable ::ZOOMSTATUS
    ttk::label .status.xy -textvariable ::XYSTATUS
    pack .status.xy -side right
    pack .status.zoom   -side left

    pack .c      -in .cvspanel -expand 1 -fill both 
    pack .status -in .cvspanel -side bottom -fill x

.w add .cvspanel

# === control panel logic =====================================================

proc OnShow {cvs what} {
	global SHOW
	global NEED_UPDATE
	
    if { $what in {UPOINT UTGT UNORMAL} } {
		if { $SHOW($what) &&  $NEED_UPDATE($what) } {
		    update_$what $cvs $::glyphOBJ $::SEGLEN
		}
    }
    set wstate [expr {$SHOW($what) ? "normal" : "hidden"}]
	switch -- $what {
		BOX { set tags "BBOX||AXIS" }
		default { set tags $what}
	}
    $cvs itemconfigure $tags -state $wstate             
}


proc ChooseFontFile {} {
    set fName [tk_getOpenFile -title "Choose a font" \
        -initialdir [file dirname $::FONTFILE] \
        -filetypes {{OpenType {.ttf .otf}}} ]
    if { $fName != {} } {
        set ::FONTFILE $fName
    }
}

set ::fontOBJ {}
trace add variable FONTFILE write OnFontFile
proc OnFontFile {args} {
    global fontOBJ
    global FONTFILE
    global FONTFILE_SHORT
    global MSG_NUMGLYPHS
    global glyphOBJ
    global G_IDX
    
    if { [catch {set newFontOBJ [Glyphs::new $FONTFILE]} errMsg ] } {
        tk_messageBox -icon error -message $errMsg
        return
    }
    if { $fontOBJ != {} } { $fontOBJ destroy }
    set fontOBJ $newFontOBJ
    set FONTFILE_SHORT [file tail $FONTFILE]
    set MSG_NUMGLYPHS "[$fontOBJ get numGlyphs] glyphs found."
    
    .panel.idx configure -state normal
    
    ClearG_IDX .panel.idx
}

bind .panel.idx <Key-Return> [list OnGlyphIdx %W]
bind .panel.idx <FocusOut>   [list OnGlyphIdx %W]

proc ClearG_IDX {w} {
    global G_IDX
    $w delete 0 end
    set G_IDX ""
    .c delete all

    .panel.update configure -state disabled
    set ::NEED_UPDATE(UPOINT) true
    set ::NEED_UPDATE(UTGT) true
    set ::NEED_UPDATE(UNORMAL) false
     # ?? are you sure ??
	.panel.showup configure -state disabled
    .panel.showut configure -state disabled
    .panel.showun configure -state disabled    
}

 # side effects:
 #  * set G_IDX  (if newvalue is OK)
proc OnGlyphIdx {w} {
    global G_IDX
    global glyphOBJ
    global fontOBJ
    
    set newIdx [$w get]
    if { $newIdx == $G_IDX } return
    if { [catch {
        set glyphOBJ [$fontOBJ glyph $newIdx ]
        } errMsg ] } {
         # warning: reset widget value before error message, or OnGlyphIdx
         #  will be called again
        $w delete 0 end ; $w insert 0 $G_IDX        
        tk_messageBox -icon error -message $errMsg

        return        
    }
    set G_IDX $newIdx
    
    .c delete all

    .panel.update configure -state disabled
     # Warning: you should set NEED_UPDATE() before DRAW ...
    set ::NEED_UPDATE(UPOINT) true
    set ::NEED_UPDATE(UTGT)   true
    set ::NEED_UPDATE(UNORMAL) true
    .panel.showup configure -state normal
    .panel.showut configure -state normal
    .panel.showun configure -state normal


    DRAW .c  [$glyphOBJ get points] CURVE
    .c zoomfit xy
    .c rzoom -1
}


 # handler of ttk::scale widget
proc OnScaleLen { varname value } {
    upvar #0 $varname var
    
    set var [format %.1f $value]
     # re-enable update button
    .panel.update configure -state normal
    set ::NEED_UPDATE(UPOINT) true
    set ::NEED_UPDATE(UTGT) true
    set ::NEED_UPDATE(UNORMAL) true
    
    .panel.showup configure -state disabled
    .panel.showut configure -state disabled
    .panel.showun configure -state disabled
}

bind .c <<Zoom>> { ZoomStatus %d }
proc ZoomStatus { z } {
    set ::ZOOMSTATUS "Zoom: [format %.2f $z]"
}
bind .c <Motion> { XYStatus %W %x %y }
proc XYStatus { zc x y } {
    set ::XYSTATUS [format "(%.2f,%.2f)" {*}[$zc V2W $x $y]]
}


## ----------------------------------------------------------------------------
  
proc DrawAxisAndBBox {zc fObj gObj} {  
     # Font BBOX
    set fBBox [$fObj get bbox]
    $zc create rectangle [$zc W2C $fBBox] -fill gray90 -tags BBOX
    $zc lower BBOX
        
     # Glyph BBOX     
    set gBBox [$gObj get bbox]
    $zc create rectangle [$zc W2C $gBBox] -outline red -dash {0x5} -tags BBOX    

     # compute a bbox 5% larger, higher ..
    set wideBox {}
    foreach c $fBBox {
        lappend wideBox [expr $c*1.05]
    } 
    lassign $wideBox xmin ymin xmax ymax
    
     # Font Ascender, Descender  (if any ?)
        
    set y [$fObj get Ascender]
    $zc create line [$zc W2C $xmin $y $xmax $y] -fill red -dash {0x5} -tags BBOX 
    set y [$fObj get Descender]
    $zc create line [$zc W2C $xmin $y $xmax $y] -fill red -dash {0x5} -tags BBOX 
    
    
    # draw axis
    $zc create line [$zc W2C 0 $ymin 0 $ymax] -fill blue -tags { AXIS X }
    $zc create line [$zc W2C $xmin 0 $xmax 0] -fill blue -tags { AXIS Y }
}

proc drawPoint { zcvs x y isOnCurve} {
    if { $isOnCurve } {
        set color red
    } else {
        set color gray
    }
    $zcvs create point [$zcvs W2C $x $y] -foreground $color -tags POINT
}

 # -- draw control points ...
 # TO DO: add a text a.b  (a=contour-index, b=point-index)
 #  ? use dotte-lines ...
proc DrawControlPoints {zcvs gPoints} {
    foreach contour $gPoints {
        set C {}
        foreach {x y isOnCurve} $contour {
            drawPoint $zcvs $x $y $isOnCurve
            lappend C $x $y
        }
        $zcvs create line [$zcvs W2C $C] -tags CSEGMENT 
    }
}

 # specific translation of CommandPaths for zoom-canvas widget
proc Paths2ZoomCanvas { zc paths tags } {
    foreach path $paths {
         # first command should be MOVETO
        foreach pCmd $path {
            set newPoints [lassign $pCmd cmd]
            switch -- $cmd {
                M {
                    ;
                }
                L {
                     # some optimizations: consecutive LINES should be concatenated
                     # as a single polyline
                    if { $lastCmd != $cmd } {
                         # create new polyline
                        set points [$zc W2C $lastX $lastY {*}$newPoints]
                         # be careful: "points" are canvas-coords, whilst "newPoints" are World-coords
                        set lastItem [$zc create line $points -tags $tags]
                    } else {
                        # join this segment with previos polyline
                        lappend points {*}[$zc W2C $newPoints]
                        $zc coords $lastItem $points 
                    }
                }
                Q {
                     # ? I don't know how to concatenate Quadratic Bezier curves ..
                    $zc create line [$zc W2C $lastX $lastY {*}$newPoints] -smooth true -tags $tags
                }
                default { error "unrecognized path command \"$cmd\"" }            
            }
            set lastCmd $cmd
            set lastX [lindex $newPoints end-1]
            set lastY [lindex $newPoints end]            
        }
    }
}


proc DRAW {zc gPoints tags} {
    global fontOBJ
    global glyphOBJ
    
    DrawAxisAndBBox $zc  $fontOBJ  $glyphOBJ
    DrawControlPoints $zc $gPoints
    Paths2ZoomCanvas $zc [$glyphOBJ get paths] $tags

    foreach what {POINT CSEGMENT BOX CURVE UPOINT UTGT UNORMAL} {
		OnShow $zc $what	
	}
}

#---- some rework needed ....
# -- separate control logic from gui


  # scrivi meglio; separa logica da GUI
proc updateUniformPoints {zc} {
	if { $::glyphOBJ == {} } return

	.panel.update configure -state disabled 

    if { $::SHOW(UPOINT) } { update_UPOINT $zc $::glyphOBJ $::SEGLEN }
    if { $::SHOW(UTGT) }   { update_UTGT $zc $::glyphOBJ $::SEGLEN }
    if { $::SHOW(UNORMAL) } { update_UNORMAL $zc $::glyphOBJ $::SEGLEN }

    .panel.showup configure -state normal
    .panel.showut configure -state normal
    .panel.showun configure -state normal
}

proc update_UPOINT {zcvs gObj dL} {
    $zcvs delete UPOINT
    foreach contour [$gObj onUniformDistance $dL "at"] {
        foreach P $contour {
            $zcvs create point [$zcvs W2C $P] -foreground orange -tags UPOINT        
        }
    }
    set ::NEED_UPDATE(UPOINT) false
}


proc update_UTGT {zcvs gObj dL} {
    $zcvs delete UTGT
    foreach contour [$gObj onUniformDistance $dL "vtangent_at"] {
        foreach SEG $contour {
            lassign $SEG P0 P1
            $zcvs create line [$zcvs W2C {*}$P0 {*}$P1] -fill blue -arrow last -tags UTGT        
        }
    }
    set ::NEED_UPDATE(UTGT) false
}

proc update_UNORMAL {zcvs gObj dL} {
    $zcvs delete UNORMAL
    foreach contour [$gObj onUniformDistance $dL "vnormal_at"] {
        foreach SEG $contour {
            lassign $SEG P0 P1
            $zcvs create line [$zcvs W2C {*}$P0 {*}$P1] -fill green -arrow last -tags UNORMAL        
        }
    }
    set ::NEED_UPDATE(UNORMAL) false
}


# --- init
 # ... some rework needed ...

set ::fontOBJ ""
set ::glyphOBJ ""
 

.panel.idx   configure -state disabled

ClearG_IDX .panel.idx
