# HelloWorld.tcl

catch {console show}


 set thisDir [file normalize [file dirname [info script]]]

  # just for stand-alone demo, provide a link for the required packages
  # NOTE: for regular use, it is assumed they are already
  #       installed under one of the $auto_path directories.
 lappend auto_path [file join $thisDir ..]

package require AggTk


. configure -bg orange
wm geometry . 700x700

 ## create a new AggTk widget
set gWin [AggTk .agg]
pack $gWin -expand 1 -fill both -padx 20 -pady 20
update

 ## get an handle for for the new widget; this handle should be used for 
 ##  issuing all the AntiGrain commands
set g [$gWin getAggHandle]

 ## draw something ; note that the window won't be updated until Tcl enters
 ##  the idle loop. If you need to refresh the window during a long procedure,
 ##  you should do an "update"
$g resetTransformations

$g clear green
$g configure -fillcolor cyan,80
$g ellipse 250 250 100 100
$g configure -fillcolor magenta,80
$g ellipse 350 250 100 100
$g configure -fillcolor yellow,80
$g ellipse 300 350 100 100

 $g translate 300 300
 $g scale 4.0 4.0
 
 $g configure -linewidth 3.0 -fillcolor blue,80 -linecolor red,80
 ## Text
 $g configure -textflip true ;#  NOTE: this should be cabled in initializer ...
 
 $g configure -textalignx Agg::AlignCenter 
 $g configure -textaligny Agg::AlignCenter 
  # bold=false italic=false rotated 30  (Note: text rotation only works with VectorFontCache)
 $g font "Kidprint" 100.0 false false Agg::VectorFontCache 30 
 $g text 0 0 "Hello"

 

