# AggTk-demo-01.tcl

catch {console show}


 set thisDir [file normalize [file dirname [info script]]]

  # just for stand-alone demo, provide a link for the required packages
  # NOTE: for regular use, it is assumed they are already
  #       installed under one of the $auto_path directories.
 lappend auto_path [file join $thisDir ..]


package require Img
package require AggTk


. configure -bg orange
wm geometry . 700x700

 ## create a new AggTk widget
set gWin [AggTk .agg]
pack $gWin -expand 1 -fill both -padx 20 -pady 20
update

 ## get an handle for for the new widget; this handle should be used for 
 ##  issuing all the AntiGrain commands
set g [$gWin getAggHandle]

 ## set a new coord-system: from (-1000,1000) to (1000,-1000)
 ## NOTE: origin is centered, Y-axis is upward
$g viewport -1000 -1000 1000 1000 0 0 [$g width] [$g height]
$g clear lightblue
$g configure -linewidth 2 -linecolor black,9F
$g line -900 0 900 0
$g line 0 -900 0 900

 # save coord-sys
set oldCoordSys [$g cget -transformations] 

$g configure -linecolor black,9F
$g configure -fillcolor yellow,B0
$g ellipse 0 0 200 200
$g configure -fillcolor pink,A0
for { set angle 0} {$angle < 360} { incr angle 30 } {
	$g rotate 30
	$g ellipse 0 400 200 280
}
 

 # restore coord-sys
$g configure -transformations $oldCoordSys 


proc spiral { g } {
set i 0
while { $i < 30} {
	$g ellipse 0 0 100 100
	$g rotate 20
	$g scale 0.9 0.9
	$g translate 170  0
	incr i
	}
}

$g configure -transformations $oldCoordSys 
$g configure -fillcolor green,80
$g translate 0 -500
spiral $g

$g configure -transformations $oldCoordSys 

