# AggTk-demo-00.tcl

catch {console show}


 set thisDir [file normalize [file dirname [info script]]]

  # just for stand-alone demo, provide a link for the required packages
  # NOTE: for regular use, it is assumed they are already
  #       installed under one of the $auto_path directories.
 lappend auto_path [file join $thisDir ..]


package require Img
package require AggTk


. configure -bg orange
wm geometry . 700x700

 ## create a new AggTk widget
set gWin [AggTk .agg]
pack $gWin -expand 1 -fill both -padx 20 -pady 20
update

 ## get an handle for for the new widget; this handle should be used for 
 ##  issuing all the AntiGrain commands
set g [$gWin getAggHandle]

 ## draw something ; note that the window won't be updated until Tcl enters
 ##  the idle loop. If you need to refresh the window during a long procedure,
 ##  you should do an "update"
$g clear lightblue
$g configure -fillcolor red
$g ellipse 250 250 100 80

 ## darken the whole area (note the alfa (hex) value)
$g clear black,80  

 ## load a jpg (Note: you need the Img package for this job )
 ## Note that this task requires:
 ##  1  ( Create an AggImage 'container' )
 ##  2  ( load the jpg in this container
 ##  2a ( get the 'internal 'image-handle' .. to be passed to the agg-handle )
set im [AggPixmap %AUTO%]
set internalIm [$im load [file join $thisDir images MCE-Bird-Fish.jpg]]
set w [$internalIm width]
set h [$internalIm height]
 ## paint the image at (50,100) rotated, with reduced size
$g translate 100 50; $g rotate 5
 ## Note : we take all the source image, and draw it in a reduced area
$g paintImage $internalIm 0 0 $w $h   0 0 [expr $w*0.8] [expr $h*0.8]
 ## free memory
$im destroy

 ## reet the transformation matrix ..
$g resetTransformations


 # .. un sacco di roba da fare ... filters, transformpath , ....

  ## draw another image with semitransparency
$g configure -masteralpha 0.8
set im [AggPixmap %AUTO%]
set internalIm [$im load [file join $thisDir images vitruvian.jpg]]
$g translate 40 40 ; $g rotate 20
$g paintImage $internalIm 0 0 500 500
$g resetTransformations
$im destroy
$g configure -masteralpha 1.0

  ## draw a path  ( yellow triangle )
$g configure -fillcolor yellow
$g resetPath
$g moveTo 100 100
$g lineTo 200 300
$g lineTo 300 100
$g closePolygon
$g drawPath

 # redraw the same path translated and rotated
$g configure -fillcolor green,a0 ;# note: semitransparency
$g translate 40 20 ; $g rotate -20
$g drawPath

 ## Text
 $g configure -textflip true ;#  NOTE: this should be cabled in initiaizer ...
 
 $g configure -textalignx Agg::AlignCenter 
 $g configure -textaligny Agg::AlignCenter 
  # bold=false italic=false rotated 30  (Note: text rotation only works with VectorFontCache)
 $g font "Verdana" 40.0 false false Agg::VectorFontCache 30 
 $g text 200 200 "Hello World !"

$g resetPath
$g configure -fillcolor #A1A100,A1
$g moveTo 50 50
$g lineTo 69 200
$g lineTo 39 400
$g lineTo 339 100
$g closePolygon
$g addEllipse 200 200 200 110 Agg::CCW
$g drawPath



proc spiral { g } {
set i 0
while { $i < 30} {
	$g ellipse 0 0 50 50
	$g rotate 20
	$g scale 0.9 0.9
	$g translate 90  0
	incr i
	}
}
$g resetTransformations
$g translate 200 200
spiral $g

# ? come fai a capire una distanza ?  (0 1)

proc spir {g} {
	if {[$g worldToScreen 50] > 2 } {
		$g ellipse 0 0 50 50
		$g rotate 20
		$g scale 0.9 0.9
		$g translate 90  0
		
		spir $g	
	}
}

